/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;
import javax.microedition.lcdui.game.Sprite;
import javax.microedition.lcdui.game.TiledLayer;

class ColorBD
extends GameCanvas
implements CommandListener,
Runnable {
    private static final boolean DEBUG = false;
    private static final boolean LANDSCAPE = false;
    public static MyGameBase midlet;
    private Command exitCmd;
    private Command continueCmd;
    private Command restartlevelCmd;
    private Command nextlevelCmd;
    private Command prevlevelCmd;
    private Command titlescreenCmd;
    private static boolean readyToPaint;
    private static boolean taskUpdatePlayfield;
    private static boolean taskLoadLevel;
    private static Graphics buffer;
    private static LayerManager GraphicsManager;
    private static TiledLayer Land;
    private static Sprite gemsD1;
    private static Sprite gemsD2;
    private static Sprite gemsS;
    private static Sprite gemsD3;
    private static Sprite gemsD4;
    private static Sprite timeS;
    private static Sprite timeT;
    private static Sprite timeH;
    private static Sprite sprP5;
    private static Sprite sprP4;
    private static Sprite sprP3;
    private static Sprite sprP2;
    private static Sprite sprP1;
    private static Sprite amoebaI;
    private static Sprite sprPaused;
    private static Sprite sprTime;
    private static Sprite sprButton;
    private static boolean running;
    private static boolean paused;
    private static boolean rfMoving;
    private static boolean rfLeft;
    private static int rfLastSeen;
    private static boolean rfBorn;
    private static int LevelNo;
    private static int LevelDiff;
    public static int caveTimer;
    public static int caveWTimer;
    public static int caveGemVal;
    public static int caveXGemVal;
    public static int caveGems;
    public static int caveTime;
    public static int caveT;
    public static boolean Bonus;
    private static byte anim;
    private static int AnimGem;
    private static int AnimFly;
    private static int AnimGhost;
    private static int AnimAmoeba;
    private static int AnimBrick;
    private static int AnimFlashBox;
    private static int AnimRockford;
    private static int AnimBlinds;
    private static final int TileSteel = 2;
    private static final int TileDirt = 1;
    private static final int TileBrick = 4;
    private static final int TileStone = 49;
    private static final int TileSpace = 52;
    private static final int TileExp1 = 14;
    private static final int TileExp2 = 15;
    private static final int TileExp3 = 16;
    private static final int TileGExp1 = 10;
    private static final int TileGExp2 = 11;
    private static final int TileGExp3 = 12;
    private static final int TileGExp4 = 13;
    public static int posX;
    public static int posY;
    private static int scrollCX;
    private static int scrollCY;
    private static int scrollDX;
    private static int scrollDY;
    private static int JoyPos;
    private static boolean JoyFire;
    private static boolean JoyFireDown;
    private static boolean JoyFireLock;
    public static byte[] Cave;
    private static boolean amoebaCanGrow;
    private static boolean amoebaSuffocated;
    private static byte wallState;
    private static int amoebaNum;
    private static boolean amoebaTooBig;
    private static int amoebaRate;
    private static int gemNum;
    private static boolean gemEnough;
    private static int score;
    private static short uncovering;
    private static long timeStart;
    private static int step;
    private static int tileX;
    private static int tileY;
    private static int rndSeed;
    private static int[] rndBuf;
    private static int rndNext;
    private static boolean SPACE;
    private static boolean YIELD;
    private static boolean BIGTILES;
    private static int charx;
    private static int tiledim;
    public static LoadBD Level;
    private static String strInfo;
    static int[] dirs;

    public ColorBD(MyGameBase midlet) {
        super(false);
        ColorBD.midlet = midlet;
        SPACE = MyGameBase.SPACE;
        YIELD = midlet.yield;
        BIGTILES = midlet.BIGtiles;
        tiledim = BIGTILES ? 16 : 8;
        this.setFullScreenMode(true);
        this.continueCmd = new Command("continue", 2, 0);
        this.restartlevelCmd = new Command("restart level", 1, 1);
        this.nextlevelCmd = new Command("next level", 1, 2);
        this.prevlevelCmd = new Command("previous level", 1, 3);
        this.titlescreenCmd = new Command("title screen", 1, 4);
        this.exitCmd = new Command("exit", 7, 10);
        this.addCommand(this.continueCmd);
        this.addCommand(this.restartlevelCmd);
        this.addCommand(this.nextlevelCmd);
        this.addCommand(this.prevlevelCmd);
        this.addCommand(this.titlescreenCmd);
        this.addCommand(this.exitCmd);
        this.setCommandListener(this);
        buffer = this.getGraphics();
        GraphicsManager = new LayerManager();
        Cave = new byte[1000];
        for (int i = 0; i < 1000; ++i) {
            ColorBD.Cave[i] = 1;
        }
        posX = 0;
        posY = 0;
        scrollCX = 0;
        scrollCY = 0;
        scrollDX = 0;
        scrollDY = 0;
        LevelNo = midlet.level;
        rndBuf = new int[512];
        ColorBD.randomize();
        Level = new LoadBD(this);
        if (BIGTILES) {
            if (SPACE) {
                Level.ReadImage("BD-space_16x16.png");
            } else {
                Level.ReadImage("BD-classic_16x16.png");
            }
        } else if (SPACE) {
            Level.ReadImage("BD-space.png");
        } else {
            Level.ReadImage("BD-classic.png");
        }
        try {
            Land = ColorBD.CreatePlayfield();
            gemsD1 = charx == 10 ? this.AddAnimatedSprite("charset_10x18yel.png", 10, 18) : this.AddAnimatedSprite("charset.png", 5, 7);
            gemsD2 = this.AddCopySprite(gemsD1);
            gemsS = this.AddCopySprite(gemsD1);
            gemsD3 = this.AddCopySprite(gemsD1);
            gemsD4 = this.AddCopySprite(gemsD1);
            timeS = this.AddCopySprite(gemsD1);
            timeT = this.AddCopySprite(gemsD1);
            timeH = this.AddCopySprite(gemsD1);
            sprP1 = this.AddCopySprite(gemsD1);
            sprP2 = this.AddCopySprite(gemsD1);
            sprP3 = this.AddCopySprite(gemsD1);
            sprP4 = this.AddCopySprite(gemsD1);
            sprP5 = this.AddCopySprite(gemsD1);
            amoebaI = this.AddAnimatedSprite("amoeba.png", 6, 6);
            gemsD1.setPosition(0, 0);
            gemsD2.setPosition(charx * 1, 0);
            gemsS.setPosition(charx * 2, 0);
            gemsD3.setPosition(charx * 3, 0);
            gemsD4.setPosition(charx * 4, 0);
            timeH.setPosition(charx * 7, 0);
            timeT.setPosition(charx * 8, 0);
            timeS.setPosition(charx * 9, 0);
            amoebaI.setPosition(charx * 10, 3);
            amoebaI.setVisible(false);
            sprP5.setPosition(charx * 12, 0);
            sprP4.setPosition(charx * 13, 0);
            sprP3.setPosition(charx * 14, 0);
            sprP2.setPosition(charx * 15, 0);
            sprP1.setPosition(charx * 16, 0);
            gemsS.setFrame(10);
            sprPaused = this.AddAnimatedSprite("paused2.png", 70, 30);
            sprPaused.setVisible(false);
            sprPaused.setPosition((this.getWidth() - sprPaused.getWidth()) / 2, (this.getHeight() - sprPaused.getHeight()) / 2);
            GraphicsManager.remove((Layer)sprPaused);
            sprTime = this.AddAnimatedSprite("time.png", 70, 30);
            sprTime.setVisible(true);
            sprTime.setPosition((this.getWidth() - sprTime.getWidth()) / 2, (this.getHeight() - sprTime.getHeight()) / 2);
            GraphicsManager.remove((Layer)sprTime);
            sprButton = this.AddAnimatedSprite("button.png", 6, 6);
            sprButton.setVisible(false);
            sprButton.setPosition(charx * 5, 3);
            GraphicsManager.append((Layer)Land);
        }
        catch (Exception e) {
            System.out.println("ColorBD.Init: " + e);
        }
        anim = 0;
        try {
            Thread.currentThread().setPriority(10);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        buffer.setFont(Font.getFont((int)0, (int)0, (int)8));
        readyToPaint = true;
        taskUpdatePlayfield = false;
        taskLoadLevel = true;
    }

    public void Dispose() {
        readyToPaint = false;
        GraphicsManager = null;
        buffer = null;
        Cave = null;
        Land = null;
        gemsD1 = null;
        gemsD2 = null;
        gemsS = null;
        gemsD3 = null;
        gemsD4 = null;
        timeH = null;
        timeT = null;
        timeS = null;
        amoebaI = null;
        sprP1 = null;
        sprP2 = null;
        sprP3 = null;
        sprP4 = null;
        sprP5 = null;
        sprPaused = null;
        sprTime = null;
        this.continueCmd = null;
        this.restartlevelCmd = null;
        this.nextlevelCmd = null;
        this.prevlevelCmd = null;
        this.titlescreenCmd = null;
        this.exitCmd = null;
        strInfo = null;
        midlet = null;
        Level = null;
        rndBuf = null;
    }

    public void commandAction(Command c, Displayable s) {
        if (c == this.exitCmd) {
            midlet.quit();
        } else if (c == this.restartlevelCmd) {
            taskLoadLevel = true;
        } else if (c == this.nextlevelCmd) {
            if (++LevelNo > 19) {
                LevelNo = 0;
                if (++LevelDiff > 4) {
                    LevelDiff = 0;
                }
            }
            taskLoadLevel = true;
        } else if (c == this.prevlevelCmd) {
            if (--LevelNo < 0) {
                LevelNo = 19;
                if (--LevelDiff < 0) {
                    LevelDiff = 0;
                }
            }
            taskLoadLevel = true;
        } else if (c == this.titlescreenCmd) {
            running = false;
        }
    }

    private Sprite AddAnimatedSprite(String ImageFile, int FrameWidth, int FrameHeight) {
        try {
            Image SpriteImage = Image.createImage((String)("/res_bd/" + ImageFile));
            Sprite sprite = new Sprite(SpriteImage, FrameWidth, FrameHeight);
            sprite.setVisible(true);
            GraphicsManager.append((Layer)sprite);
            return sprite;
        }
        catch (Exception e) {
            System.out.println("AddAnimatedSprite(): " + e);
            return null;
        }
    }

    private Sprite AddCopySprite(Sprite spr) {
        try {
            Sprite sprite = new Sprite(spr);
            sprite.setVisible(true);
            GraphicsManager.append((Layer)sprite);
            return sprite;
        }
        catch (Exception e) {
            System.out.println("AddCopySprite(): " + e);
            return null;
        }
    }

    private static TiledLayer memAddTL(int x, int y, int MapWidth, int MapHeight, int TileWidth, int TileHeight) {
        try {
            Image TiledLayerImage = Image.createImage((byte[])ColorBD.Level.imgData, (int)0, (int)ColorBD.Level.imgLength);
            TiledLayer NewTiledLayer = new TiledLayer(MapWidth, MapHeight, TiledLayerImage, TileWidth, TileHeight);
            NewTiledLayer.setPosition(x, y);
            GraphicsManager.append((Layer)NewTiledLayer);
            return NewTiledLayer;
        }
        catch (Exception e) {
            System.out.println("memAddTL(): " + e);
            return null;
        }
    }

    private static void memChangeTL(int TileWidth, int TileHeight) {
        try {
            Image TiledLayerImage = Image.createImage((byte[])ColorBD.Level.imgData, (int)0, (int)ColorBD.Level.imgLength);
            Land.setStaticTileSet(TiledLayerImage, TileWidth, TileHeight);
        }
        catch (Exception e) {
            System.out.println("memChangeTL(): " + e + TileWidth + TileHeight);
        }
    }

    private static TiledLayer CreatePlayfield() {
        TiledLayer TLayer = ColorBD.memAddTL(0, 0, 40, 25, tiledim, tiledim);
        AnimGem = TLayer.createAnimatedTile(17);
        AnimFly = TLayer.createAnimatedTile(25);
        AnimGhost = TLayer.createAnimatedTile(33);
        AnimAmoeba = TLayer.createAnimatedTile(41);
        AnimBrick = TLayer.createAnimatedTile(5);
        AnimFlashBox = TLayer.createAnimatedTile(1);
        AnimRockford = TLayer.createAnimatedTile(50);
        AnimBlinds = TLayer.createAnimatedTile(57);
        TLayer.fillCells(0, 0, 40, 25, 2);
        return TLayer;
    }

    private boolean LoadLevel() {
        int l = LevelNo;
        int d = LevelDiff;
        buffer.setColor(0);
        buffer.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.flushGraphics();
        readyToPaint = false;
        Level.LoadLevel(MyGameBase.GAMEFILES[ColorBD.midlet.GameList[l]], l, d);
        Level.SetImagePalette(l);
        ColorBD.memChangeTL(tiledim, tiledim);
        amoebaCanGrow = true;
        amoebaSuffocated = false;
        amoebaTooBig = false;
        amoebaNum = 0;
        amoebaRate = 4;
        gemEnough = false;
        gemNum = 0;
        wallState = 0;
        rfMoving = false;
        rfLeft = false;
        rfLastSeen = 0;
        rfBorn = false;
        caveT = caveTime;
        strInfo = new String("Cave " + ColorBD.midlet.GameList[l] + "/" + MyGameBase.CAVENAMES.substring(l, l + 1) + "/" + (d + 1));
        while (caveGems > 99) {
            caveGems -= 100;
        }
        Bonus = l == 4 || l == 9 || l == 14 || l == 19;
        gemsD1.setFrame(0);
        gemsD2.setFrame(0);
        gemsD3.setFrame(caveGems / 10);
        gemsD4.setFrame(caveGems % 10);
        timeH.setFrame(caveTime / 100 % 10);
        timeT.setFrame(caveTime / 10 % 10);
        timeS.setFrame(caveTime % 10);
        int s = score;
        sprP1.setFrame(s % 10);
        sprP2.setFrame((s /= 10) % 10);
        sprP3.setFrame((s /= 10) % 10);
        sprP4.setFrame((s /= 10) % 10);
        sprP5.setFrame((s /= 10) % 10);
        amoebaI.setVisible(false);
        Land.fillCells(0, 0, 40, 22, AnimBlinds);
        uncovering = (short)40;
        step = 0;
        paused = false;
        sprPaused.setVisible(false);
        readyToPaint = true;
        taskLoadLevel = false;
        JoyFire = false;
        JoyFireDown = false;
        JoyFireLock = false;
        if (Bonus) {
            GraphicsManager.setViewWindow(0, 0, tiledim * 20, tiledim * 12);
        } else {
            GraphicsManager.setViewWindow(0, 0, tiledim * 40, tiledim * 22);
        }
        return true;
    }

    private static void randomize() {
        long ctm = System.currentTimeMillis();
        while ((ctm & 1L) == 0L) {
            ctm >>= 1;
        }
        int s = (int)ctm;
        for (int i = 0; i < 512; ++i) {
            s = (int)(22695477L * (long)s + 1L >> 16);
            ColorBD.rndBuf[i] = s & Integer.MAX_VALUE;
        }
        rndSeed = s;
        rndNext = 0;
    }

    private static void ExplodeSpace(int c) {
        byte[] cave = Cave;
        if (cave[c - 41] != 4) {
            cave[c - 41] = 33;
            Land.setCell(tileX - 1, tileY - 1, 15);
        }
        if (cave[c - 40] != 4) {
            cave[c - 40] = 33;
            Land.setCell(tileX, tileY - 1, 15);
        }
        if (cave[c - 39] != 4) {
            cave[c - 39] = 33;
            Land.setCell(tileX + 1, tileY - 1, 15);
        }
        if (cave[c - 1] != 4) {
            cave[c - 1] = 33;
            Land.setCell(tileX - 1, tileY, 15);
        }
        if (cave[c] != 4) {
            cave[c] = 33;
            Land.setCell(tileX, tileY, 15);
        }
        if (cave[c + 1] != 4) {
            cave[c + 1] = 32;
        }
        if (cave[c + 39] != 4) {
            cave[c + 39] = 32;
        }
        if (cave[c + 40] != 4) {
            cave[c + 40] = 32;
        }
        if (cave[c + 41] != 4) {
            cave[c + 41] = 32;
        }
    }

    private static void ExplodeSpaceF(int c) {
        byte[] cave = Cave;
        if (cave[c - 41] != 4) {
            cave[c - 41] = 33;
            Land.setCell(tileX - 1, tileY - 1, 15);
        }
        if (cave[c - 40] != 4) {
            cave[c - 40] = 33;
            Land.setCell(tileX, tileY - 1, 15);
        }
        if (cave[c - 39] != 4) {
            cave[c - 39] = 32;
        }
        if (cave[c - 1] != 4) {
            cave[c - 1] = 32;
        }
        if (cave[c] != 4) {
            cave[c] = 32;
        }
        if (cave[c + 1] != 4) {
            cave[c + 1] = 32;
        }
        if (cave[c + 39] != 4) {
            cave[c + 39] = 32;
        }
        if (cave[c + 40] != 4) {
            cave[c + 40] = 32;
        }
        if (cave[c + 41] != 4) {
            cave[c + 41] = 32;
        }
    }

    private static void ExplodeGem(int c) {
        byte[] cave = Cave;
        if (cave[c - 41] != 4) {
            cave[c - 41] = 41;
            Land.setCell(tileX - 1, tileY - 1, 10);
        }
        if (cave[c - 40] != 4) {
            cave[c - 40] = 41;
            Land.setCell(tileX, tileY - 1, 10);
        }
        if (cave[c - 39] != 4) {
            cave[c - 39] = 41;
            Land.setCell(tileX + 1, tileY - 1, 10);
        }
        if (cave[c - 1] != 4) {
            cave[c - 1] = 41;
            Land.setCell(tileX - 1, tileY, 10);
        }
        if (cave[c] != 4) {
            cave[c] = 41;
            Land.setCell(tileX, tileY, 10);
        }
        if (cave[c + 1] != 4) {
            cave[c + 1] = 40;
        }
        if (cave[c + 39] != 4) {
            cave[c + 39] = 40;
        }
        if (cave[c + 40] != 4) {
            cave[c + 40] = 40;
        }
        if (cave[c + 41] != 4) {
            cave[c + 41] = 40;
        }
    }

    private static void ExplodeGemF(int c) {
        byte[] cave = Cave;
        if (cave[c - 41] != 4) {
            cave[c - 41] = 41;
            Land.setCell(tileX - 1, tileY - 1, 10);
        }
        if (cave[c - 40] != 4) {
            cave[c - 40] = 41;
            Land.setCell(tileX, tileY - 1, 10);
        }
        if (cave[c - 39] != 4) {
            cave[c - 39] = 40;
        }
        if (cave[c - 1] != 4) {
            cave[c - 1] = 40;
        }
        if (cave[c] != 4) {
            cave[c] = 40;
        }
        if (cave[c + 1] != 4) {
            cave[c + 1] = 40;
        }
        if (cave[c + 39] != 4) {
            cave[c + 39] = 40;
        }
        if (cave[c + 40] != 4) {
            cave[c + 40] = 40;
        }
        if (cave[c + 41] != 4) {
            cave[c + 41] = 40;
        }
    }

    private static void StepStone(int c, int obj) {
        byte[] cave = Cave;
        if ((obj & 1) == 0) {
            byte u = cave[c + 40];
            if (u == 0) {
                cave[c + 40] = -103;
                cave[c] = 0;
                Land.setCell(tileX, tileY, 52);
                Land.setCell(tileX, tileY + 1, 49);
            } else if ((u & 0x40) != 0) {
                if (cave[c - 1] == 0 && cave[c + 39] == 0) {
                    cave[c - 1] = 25;
                    cave[c] = 0;
                    Land.setCell(tileX, tileY, 52);
                    Land.setCell(tileX - 1, tileY, 49);
                } else if (cave[c + 1] == 0 && cave[c + 41] == 0) {
                    cave[c + 1] = -103;
                    cave[c] = 0;
                    Land.setCell(tileX, tileY, 52);
                    Land.setCell(tileX + 1, tileY, 49);
                }
            }
        } else {
            byte u = cave[c + 40];
            if (u == 0) {
                cave[c + 40] = -103;
                cave[c] = 0;
                Land.setCell(tileX, tileY, 52);
                Land.setCell(tileX, tileY + 1, 49);
            } else if (u == 3) {
                if (wallState == 0) {
                    wallState = 1;
                    amoebaSuffocated = true;
                }
                if (wallState == 1 && cave[c + 80] == 0) {
                    cave[c + 80] = -79;
                    Land.setCell(tileX, tileY + 2, AnimGem);
                }
                Land.setCell(tileX, tileY, 52);
                cave[c] = 0;
            } else if ((u & 0x40) != 0) {
                if (cave[c - 1] == 0 && cave[c + 39] == 0) {
                    cave[c - 1] = 25;
                    cave[c] = 0;
                    Land.setCell(tileX, tileY, 52);
                    Land.setCell(tileX - 1, tileY, 49);
                } else if (cave[c + 1] == 0 && cave[c + 41] == 0) {
                    cave[c + 1] = -103;
                    cave[c] = 0;
                    Land.setCell(tileX, tileY, 52);
                    Land.setCell(tileX + 1, tileY, 49);
                } else {
                    cave[c] = 88;
                }
            } else if ((u & 0x38) == 8 || u == 63) {
                ++tileY;
                if ((u & 0x3C) == 12) {
                    ColorBD.ExplodeGemF(c + 40);
                } else {
                    ColorBD.ExplodeSpaceF(c + 40);
                }
                --tileY;
            } else {
                cave[c] = 88;
            }
        }
    }

    private static void StepGem(int c, int obj) {
        byte[] cave = Cave;
        if ((obj & 1) == 0) {
            byte u = cave[c + 40];
            if (u == 0) {
                cave[c + 40] = -79;
                cave[c] = 0;
                Land.setCell(tileX, tileY, 52);
                Land.setCell(tileX, tileY + 1, AnimGem);
            } else if ((u & 0x40) != 0) {
                if (cave[c - 1] == 0 && cave[c + 39] == 0) {
                    cave[c - 1] = 49;
                    cave[c] = 0;
                    Land.setCell(tileX, tileY, 52);
                    Land.setCell(tileX - 1, tileY, AnimGem);
                } else if (cave[c + 1] == 0 && cave[c + 41] == 0) {
                    cave[c + 1] = -79;
                    cave[c] = 0;
                    Land.setCell(tileX, tileY, 52);
                    Land.setCell(tileX + 1, tileY, AnimGem);
                }
            }
        } else {
            byte u = cave[c + 40];
            if (u == 0) {
                cave[c + 40] = -79;
                cave[c] = 0;
                Land.setCell(tileX, tileY, 52);
                Land.setCell(tileX, tileY + 1, AnimGem);
            } else if (u == 3) {
                if (wallState == 0) {
                    wallState = 1;
                    amoebaSuffocated = true;
                }
                if (wallState == 1 && cave[c + 80] == 0) {
                    cave[c + 80] = -103;
                    Land.setCell(tileX, tileY + 2, 49);
                }
                Land.setCell(tileX, tileY, 52);
                cave[c] = 0;
            } else if ((u & 0x40) != 0) {
                if (cave[c - 1] == 0 && cave[c + 39] == 0) {
                    cave[c - 1] = 49;
                    cave[c] = 0;
                    Land.setCell(tileX, tileY, 52);
                    Land.setCell(tileX - 1, tileY, AnimGem);
                } else if (cave[c + 1] == 0 && cave[c + 41] == 0) {
                    cave[c + 1] = -79;
                    cave[c] = 0;
                    Land.setCell(tileX, tileY, 52);
                    Land.setCell(tileX + 1, tileY, AnimGem);
                } else {
                    cave[c] = 112;
                }
            } else if ((u & 0x38) == 8 || u == 63) {
                ++tileY;
                if ((u & 0x3C) == 12) {
                    ColorBD.ExplodeGemF(c + 40);
                } else {
                    ColorBD.ExplodeSpaceF(c + 40);
                }
                --tileY;
            } else {
                cave[c] = 112;
            }
        }
    }

    private static boolean CheckFly(int c) {
        byte[] cave = Cave;
        byte obj = cave[c - 40];
        if (obj == 16 || obj == 63) {
            return true;
        }
        obj = cave[c - 1];
        if (obj == 16 || obj == 63) {
            return true;
        }
        obj = cave[c + 1];
        if (obj == 16 || obj == 63) {
            return true;
        }
        obj = cave[c + 40];
        return obj == 16 || obj == 63;
    }

    private static void StepFireFly(int c, int obj) {
        if (ColorBD.CheckFly(c)) {
            ColorBD.ExplodeSpace(c);
            return;
        }
        byte[] cave = Cave;
        int dir = obj & 3;
        int dirleft = dir + 3 & 3;
        int cnp = c + dirs[dirleft];
        if (cave[cnp] == 0) {
            cave[c] = 0;
            Land.setCell(tileX, tileY, 52);
            cave[cnp] = (byte)(8 + dirleft + ((dirleft & 2) << 6));
            switch (dirleft) {
                case 0: {
                    Land.setCell(tileX - 1, tileY, AnimGhost);
                    break;
                }
                case 1: {
                    Land.setCell(tileX, tileY - 1, AnimGhost);
                    break;
                }
                case 2: {
                    Land.setCell(tileX + 1, tileY, AnimGhost);
                    break;
                }
                case 3: {
                    Land.setCell(tileX, tileY + 1, AnimGhost);
                }
            }
        } else {
            cnp = c + dirs[dir];
            if (Cave[cnp] == 0) {
                cave[c] = 0;
                Land.setCell(tileX, tileY, 52);
                cave[cnp] = (byte)(8 + dir + ((dir & 2) << 6));
                switch (dir) {
                    case 0: {
                        Land.setCell(tileX - 1, tileY, AnimGhost);
                        break;
                    }
                    case 1: {
                        Land.setCell(tileX, tileY - 1, AnimGhost);
                        break;
                    }
                    case 2: {
                        Land.setCell(tileX + 1, tileY, AnimGhost);
                        break;
                    }
                    case 3: {
                        Land.setCell(tileX, tileY + 1, AnimGhost);
                    }
                }
            } else {
                int dirright = dir + 1 & 3;
                cave[c] = (byte)(8 + dirright);
            }
        }
    }

    private static void StepButterFly(int c, int obj) {
        if (ColorBD.CheckFly(c)) {
            ColorBD.ExplodeGem(c);
            return;
        }
        byte[] cave = Cave;
        int dir = obj & 3;
        int dirright = dir + 1 & 3;
        int cnp = c + dirs[dirright];
        if (cave[cnp] == 0) {
            cave[c] = 0;
            Land.setCell(tileX, tileY, 52);
            cave[cnp] = (byte)(12 + dirright + ((dirright & 2) << 6));
            switch (dirright) {
                case 0: {
                    Land.setCell(tileX - 1, tileY, AnimFly);
                    break;
                }
                case 1: {
                    Land.setCell(tileX, tileY - 1, AnimFly);
                    break;
                }
                case 2: {
                    Land.setCell(tileX + 1, tileY, AnimFly);
                    break;
                }
                case 3: {
                    Land.setCell(tileX, tileY + 1, AnimFly);
                }
            }
        } else {
            cnp = c + dirs[dir];
            if (Cave[cnp] == 0) {
                cave[c] = 0;
                Land.setCell(tileX, tileY, 52);
                cave[cnp] = (byte)(12 + dir + ((dir & 2) << 6));
                switch (dir) {
                    case 0: {
                        Land.setCell(tileX - 1, tileY, AnimFly);
                        break;
                    }
                    case 1: {
                        Land.setCell(tileX, tileY - 1, AnimFly);
                        break;
                    }
                    case 2: {
                        Land.setCell(tileX + 1, tileY, AnimFly);
                        break;
                    }
                    case 3: {
                        Land.setCell(tileX, tileY + 1, AnimFly);
                    }
                }
            } else {
                int dirleft = dir + 3 & 3;
                cave[c] = (byte)(12 + dirleft);
            }
        }
    }

    private static void StepAmoeba(int c) {
        byte[] cave = Cave;
        ++amoebaNum;
        if (amoebaTooBig) {
            cave[c] = 88;
            Land.setCell(tileX, tileY, 49);
        } else if (amoebaSuffocated) {
            cave[c] = 112;
            Land.setCell(tileX, tileY, AnimGem);
        } else {
            int rnd;
            if (!(amoebaCanGrow || (cave[c - 40] & 0xFE) != 0 && (cave[c + 40] & 0xFE) != 0 && (cave[c - 1] & 0xFE) != 0 && (cave[c + 1] & 0xFE) != 0)) {
                amoebaCanGrow = true;
            }
            if (((rnd = (rndSeed = 20021 * rndSeed + 1 >> 8)) & 0x7F) < amoebaRate) {
                rnd = rndSeed = 20021 * rndSeed + 1 >> 8;
                switch (rnd &= 3) {
                    case 0: {
                        if ((cave[c - 40] & 0xFE) != 0) break;
                        cave[c - 40] = 16;
                        Land.setCell(tileX, tileY - 1, AnimAmoeba);
                        break;
                    }
                    case 1: {
                        if ((cave[c + 40] & 0xFE) != 0) break;
                        cave[c + 40] = -112;
                        Land.setCell(tileX, tileY + 1, AnimAmoeba);
                        break;
                    }
                    case 2: {
                        if ((cave[c - 1] & 0xFE) != 0) break;
                        cave[c - 1] = 16;
                        Land.setCell(tileX - 1, tileY, AnimAmoeba);
                        break;
                    }
                    case 3: {
                        if ((cave[c + 1] & 0xFE) != 0) break;
                        cave[c + 1] = -112;
                        Land.setCell(tileX + 1, tileY, AnimAmoeba);
                    }
                }
            }
        }
    }

    private static void StepExplode(int c, int obj) {
        if ((obj & 8) == 0) {
            if (obj == 36) {
                ColorBD.Cave[c] = 0;
                Land.setCell(tileX, tileY, 52);
                return;
            }
            ColorBD.Cave[c] = (byte)(++obj);
            if (obj == 33) {
                Land.setCell(tileX, tileY, 15);
            } else if (obj == 34) {
                Land.setCell(tileX, tileY, 16);
            } else if (obj == 35) {
                Land.setCell(tileX, tileY, 15);
            } else if (obj == 36) {
                Land.setCell(tileX, tileY, 14);
            }
        } else {
            if (obj == 44) {
                ColorBD.Cave[c] = 112;
                Land.setCell(tileX, tileY, AnimGem);
                return;
            }
            ColorBD.Cave[c] = (byte)(++obj);
            if (obj == 41) {
                Land.setCell(tileX, tileY, 10);
            } else if (obj == 42) {
                Land.setCell(tileX, tileY, 11);
            } else if (obj == 43) {
                Land.setCell(tileX, tileY, 12);
            } else if (obj == 44) {
                Land.setCell(tileX, tileY, 13);
            }
        }
    }

    private static void StepPreRockford(int c, int obj) {
        rfLastSeen = 0;
        if (obj == 56) {
            if (step > 15) {
                ColorBD.Cave[c] = 57;
                Land.setCell(tileX, tileY, 14);
            }
        } else if (obj == 57) {
            ColorBD.Cave[c] = 58;
            Land.setCell(tileX, tileY, 15);
        } else if (obj == 58) {
            ColorBD.Cave[c] = 59;
            Land.setCell(tileX, tileY, 16);
        } else if (obj == 59) {
            ColorBD.Cave[c] = 63;
            Land.setCell(tileX, tileY, AnimRockford);
            rfBorn = true;
        }
    }

    private static void StepPreOutbox(int c) {
        if (gemEnough) {
            ColorBD.Cave[c] = 5;
            Land.setCell(tileX, tileY, AnimFlashBox);
        }
    }

    private static void StepRockford(int c) {
        rfLastSeen = 0;
        if (JoyPos == 2) {
            rfMoving = true;
            rfLeft = true;
            ColorBD.StepRf2(c, c - 1, 63, tileX - 1, tileY);
        } else if (JoyPos == 5) {
            rfMoving = true;
            rfLeft = false;
            ColorBD.StepRf2(c, c + 1, 191, tileX + 1, tileY);
        } else if (JoyPos == 1) {
            rfMoving = true;
            ColorBD.StepRf2(c, c - 40, 63, tileX, tileY - 1);
        } else if (JoyPos == 6) {
            rfMoving = true;
            ColorBD.StepRf2(c, c + 40, 191, tileX, tileY + 1);
        } else {
            rfMoving = false;
        }
    }

    private static void StepRf2(int c, int cnp, int rf, int npx, int npy) {
        if (ColorBD.StepRf3(cnp, npx, npy)) {
            if (JoyFire || JoyFireLock) {
                ColorBD.Cave[cnp] = 0;
                Land.setCell(npx, npy, 52);
                JoyFire = false;
            } else {
                ColorBD.Cave[c] = 0;
                Land.setCell(tileX, tileY, 52);
                ColorBD.Cave[cnp] = (byte)rf;
                Land.setCell(npx, npy, AnimRockford);
                posX = npx;
                posY = npy;
            }
        }
    }

    private static boolean StepRf3(int cnp, int npx, int npy) {
        switch (Cave[cnp]) {
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
            case -16: 
            case 112: {
                ColorBD.PickupGem();
                return true;
            }
            case 5: {
                if (!taskLoadLevel) {
                    if (++LevelNo > 19) {
                        LevelNo = 0;
                        if (++LevelDiff > 4) {
                            LevelDiff = 0;
                        }
                    }
                    if (caveTime > 0) {
                        score += caveTime;
                    }
                    taskLoadLevel = true;
                }
                return true;
            }
            case -40: 
            case 88: {
                if (JoyPos == 2) {
                    if (Cave[cnp - 1] == 0) {
                        return ColorBD.PushBoulder(cnp - 1, 88, npx - 1, npy);
                    }
                } else if (JoyPos == 5 && Cave[cnp + 1] == 0) {
                    return ColorBD.PushBoulder(cnp + 1, 216, npx + 1, npy);
                }
                return false;
            }
        }
        return false;
    }

    private static boolean PushBoulder(int cnp, int s, int npx, int npy) {
        int rnd = rndSeed = 20021 * rndSeed + 1 >> 8;
        if ((rnd & 7) == 0) {
            ColorBD.Cave[cnp] = (byte)s;
            Land.setCell(npx, npy, 49);
            return true;
        }
        return false;
    }

    private static void PickupGem() {
        int g = ++gemNum;
        gemsD2.setFrame(g % 10);
        gemsD1.setFrame((g /= 10) % 10);
        score = gemEnough ? (score += caveXGemVal) : (score += caveGemVal);
        int s = score;
        sprP1.setFrame(s % 10);
        sprP2.setFrame((s /= 10) % 10);
        sprP3.setFrame((s /= 10) % 10);
        sprP4.setFrame((s /= 10) % 10);
        sprP5.setFrame((s /= 10) % 10);
        if (gemNum == caveGems) {
            gemEnough = true;
        }
    }

    private static void StepCave() {
        amoebaNum = 0;
        amoebaCanGrow = false;
        int c = 120;
        byte[] cave = Cave;
        for (int y = 1; y < 22; ++y) {
            tileY = y;
            for (int x = 0; x < 40; ++x) {
                tileX = x;
                byte obj = cave[c];
                int o = obj & 0x38;
                if (o == 0) {
                    ++c;
                    continue;
                }
                if ((obj & 0x80) == 128) {
                    cave[c++] = (byte)(obj & 0x7F);
                    continue;
                }
                if (o == 24) {
                    ColorBD.StepStone(c, obj);
                } else if (o == 48) {
                    ColorBD.StepGem(c, obj);
                } else if (o == 8) {
                    if ((obj & 4) == 0) {
                        ColorBD.StepFireFly(c, obj);
                    } else {
                        ColorBD.StepButterFly(c, obj);
                    }
                } else if (o == 16) {
                    ColorBD.StepAmoeba(c);
                } else if (o == 32) {
                    ColorBD.StepExplode(c, obj);
                } else if (o == 40) {
                    ColorBD.StepExplode(c, obj);
                } else if (o == 56) {
                    if ((obj & 4) == 0) {
                        ColorBD.StepPreRockford(c, obj);
                    } else if (obj == 63) {
                        ColorBD.StepRockford(c);
                    } else if (obj == 61) {
                        ColorBD.StepPreOutbox(c);
                    }
                }
                ++c;
            }
        }
        if (amoebaNum > 0) {
            amoebaI.setVisible(true);
            if (amoebaNum > 200) {
                amoebaTooBig = true;
            }
        } else {
            amoebaI.setVisible(false);
        }
        if (!amoebaCanGrow) {
            amoebaSuffocated = true;
        }
    }

    private static void UpdatePlayfield() {
        int c = 80;
        byte[] cave = Cave;
        for (int y = 0; y < 22; ++y) {
            for (int x = 0; x < 40; ++x) {
                int obj = cave[c++] & 0x7F;
                Land.setCell(x, y, ColorBD.getObjectTile(obj));
            }
        }
        taskUpdatePlayfield = false;
    }

    private static void Animate() {
        int n = anim;
        anim = (byte)(n + 1);
        int a = n;
        Land.setAnimatedTile(AnimFly, 25 + (a &= 7));
        if (SPACE) {
            Land.setAnimatedTile(AnimAmoeba, 41 + a);
        }
        if (BIGTILES) {
            Land.setAnimatedTile(AnimBlinds, 57 + a);
        }
        if (BIGTILES) {
            if (rfMoving) {
                Land.setAnimatedTile(AnimRockford, rfLeft ? 73 + a : 65 + a);
            } else {
                Land.setAnimatedTile(AnimRockford, 50);
            }
        }
        if (BIGTILES) {
            Land.setAnimatedTile(AnimGem, 17 + a);
        }
        a &= 3;
        if (!BIGTILES) {
            Land.setAnimatedTile(AnimGem, 17 + a);
        }
        if (wallState == 1) {
            Land.setAnimatedTile(AnimBrick, 5 + a);
        } else {
            Land.setAnimatedTile(AnimBrick, 4);
        }
        Land.setAnimatedTile(AnimGhost, 33 + a);
        if (!SPACE) {
            Land.setAnimatedTile(AnimAmoeba, 41 + a);
        }
        if (!BIGTILES) {
            Land.setAnimatedTile(AnimBlinds, 57 + a);
        }
        if (!BIGTILES) {
            if (rfMoving) {
                Land.setAnimatedTile(AnimRockford, rfLeft ? 73 + a : 65 + a);
            } else {
                Land.setAnimatedTile(AnimRockford, 50);
            }
        }
        Land.setAnimatedTile(AnimFlashBox, 2 + (a & 1));
        amoebaI.nextFrame();
    }

    private void updateSprites() {
        int wy;
        int wx;
        ColorBD.Animate();
        scrollDX = -(posX - 6) * tiledim;
        scrollDY = -(posY - 5) * tiledim;
        if (Bonus) {
            wx = tiledim * 20 - this.getWidth();
            wy = tiledim * 12 - this.getHeight();
            if (scrollDX < -wx) {
                scrollDX = -wx;
            }
            if (scrollDX > 0) {
                scrollDX = 0;
            }
            if (scrollDY < -wy) {
                scrollDY = -wy;
            }
            if (scrollDY > 0) {
                scrollDY = 0;
            }
        } else {
            wx = tiledim * 40 - this.getWidth();
            wy = tiledim * 22 - this.getHeight();
            if (scrollDX < -wx) {
                scrollDX = -wx;
            }
            if (scrollDX > 0) {
                scrollDX = 0;
            }
            if (scrollDY < -wy) {
                scrollDY = -wy;
            }
            if (scrollDY > 0) {
                scrollDY = 0;
            }
        }
        if (scrollCX != scrollDX) {
            int x = scrollDX - scrollCX;
            int dx = 3;
            if (x > 42 || x < -42) {
                dx = tiledim * 6 / 7;
            } else if (x > 24 || x < -24) {
                dx = tiledim * 6 / 9;
            } else if (x < 3 && x > -3) {
                dx = 1;
            }
            if (scrollCX < scrollDX) {
                scrollCX += dx;
            }
            if (scrollCX > scrollDX) {
                scrollCX -= dx;
            }
        }
        if (scrollCY != scrollDY) {
            int y = scrollDY - scrollCY;
            int dy = 3;
            if (y > 32 || y < -32) {
                dy = tiledim * 6 / 7;
            } else if (y > 18 || y < -18) {
                dy = tiledim * 6 / 9;
            } else if (y < 3 && y > -3) {
                dy = 1;
            }
            if (scrollCY < scrollDY) {
                scrollCY += dy;
            }
            if (scrollCY > scrollDY) {
                scrollCY -= dy;
            }
        }
        Land.setPosition(scrollCX, scrollCY);
    }

    public int getReturnValue() {
        return 0;
    }

    protected void keyPressed(int keyCode) {
        if (keyCode == 48) {
            if (ColorBD.midlet.mode != 0) {
                running = false;
            } else {
                paused = !paused;
                sprPaused.setVisible(paused);
            }
        } else if (keyCode == 49) {
            JoyFireLock = !JoyFireLock;
        } else if (keyCode == 51) {
            if (caveTime < 0) {
                caveTime = caveT;
            }
            ColorBD.Cave[80 + 40 * ColorBD.posY + ColorBD.posX] = 63;
            Land.setCell(posX, posY, AnimRockford);
        } else if (keyCode == 42) {
            if (--LevelNo < 0) {
                LevelNo = 19;
                if (--LevelDiff < 0) {
                    LevelDiff = 0;
                }
            }
            taskLoadLevel = true;
        } else if (keyCode == 35) {
            if (++LevelNo > 19) {
                LevelNo = 0;
                if (++LevelDiff > 4) {
                    LevelDiff = 0;
                }
            }
            taskLoadLevel = true;
        } else {
            int ga = this.getGameAction(keyCode);
            if (ga == 5 || ga == 2 || ga == 6 || ga == 1) {
                JoyPos = ga;
            } else if (ga == 8) {
                JoyFire = true;
                JoyFireDown = true;
                JoyFireLock = false;
            }
        }
    }

    protected void keyReleased(int keyCode) {
        int ga = this.getGameAction(keyCode);
        if (ga == 5 || ga == 2 || ga == 6 || ga == 1) {
            JoyPos = -1;
        } else if (ga == 8) {
            JoyFireDown = false;
        }
    }

    protected static int getObjectTile(int obj) {
        int ID = 2;
        int o = obj & 0x38;
        if (obj == 0) {
            ID = 52;
        } else if (obj == 1) {
            ID = 1;
        } else if (obj == 66) {
            ID = 4;
        } else if (obj == 3) {
            ID = AnimBrick;
        } else if (obj == 4) {
            ID = 2;
        } else if (o == 24) {
            ID = 49;
        } else if (o == 48) {
            ID = AnimGem;
        } else if (o == 8) {
            ID = (obj & 4) == 0 ? AnimGhost : AnimFly;
        } else if (obj == 5 || obj == 56) {
            ID = AnimFlashBox;
        } else if (o == 16) {
            ID = AnimAmoeba;
        } else if (obj == 57) {
            ID = 14;
        } else if (obj == 58) {
            ID = 15;
        } else if (obj == 59) {
            ID = 16;
        }
        return ID;
    }

    public void run() {
        long totalt;
        long startt;
        running = true;
        paused = false;
        score = 0;
        long frames = 0L;
        JoyPos = -1;
        LevelDiff = 0;
        long elapsed = startt = System.currentTimeMillis();
        if (ColorBD.midlet.mode == 0) {
            while (running) {
                if (++rfLastSeen > 3 && JoyFireDown && uncovering < 0) {
                    taskLoadLevel = true;
                    JoyFireDown = false;
                }
                if (taskLoadLevel) {
                    this.LoadLevel();
                    continue;
                }
                if (taskUpdatePlayfield) {
                    ColorBD.UpdatePlayfield();
                    readyToPaint = true;
                }
                if (!paused) {
                    if (rfBorn) {
                        long t = System.currentTimeMillis();
                        if (t - elapsed > 1200L) {
                            long ctm = t;
                            while ((ctm & 1L) == 0L) {
                                ctm >>= 1;
                            }
                            rndNext = rndNext + (int)ctm & 0x1FF;
                            --caveTime;
                            if (--caveTimer < 0) {
                                amoebaRate = 32;
                            }
                            if (caveTime < 0) {
                                timeH.setFrame(0);
                                timeT.setFrame(0);
                                timeS.setFrame(0);
                                if (JoyFireDown) {
                                    taskLoadLevel = true;
                                    JoyFireDown = false;
                                }
                            } else {
                                timeH.setFrame(caveTime / 100 % 10);
                                timeT.setFrame(caveTime / 10 % 10);
                                timeS.setFrame(caveTime % 10);
                            }
                            if (wallState == 1 && --caveWTimer < 0) {
                                wallState = (byte)2;
                            }
                            elapsed = t;
                        }
                    } else {
                        elapsed = System.currentTimeMillis();
                    }
                    if (YIELD) {
                        Thread.yield();
                    }
                    try {
                        if (Bonus) {
                            Thread.sleep(65L);
                        } else {
                            Thread.sleep(100L);
                        }
                    }
                    catch (InterruptedException e) {
                        System.out.println("Thread.sleep(): " + e);
                    }
                    if (uncovering >= 0) {
                        short s = uncovering;
                        uncovering = (short)(s - 1);
                        if (s == 0) {
                            taskUpdatePlayfield = true;
                            readyToPaint = false;
                        } else {
                            for (int y = 0; y < 22; ++y) {
                                int x = rndBuf[++rndNext & 0x1FF] % 40;
                                int obj = Cave[80 + y * 40 + x] & 0x7F;
                                Land.setCell(x, y, ColorBD.getObjectTile(obj));
                                x = rndBuf[++rndNext & 0x1FF] % 40;
                                obj = Cave[80 + y * 40 + x] & 0x7F;
                                Land.setCell(x, y, ColorBD.getObjectTile(obj));
                            }
                        }
                        this.updateSprites();
                        readyToPaint = true;
                    } else {
                        if (caveTime >= 0) {
                            ColorBD.StepCave();
                            ++step;
                        }
                        this.updateSprites();
                        readyToPaint = true;
                    }
                } else {
                    this.updateSprites();
                    readyToPaint = true;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        System.out.println("Thread.sleep(): " + e);
                    }
                }
                if (!readyToPaint) continue;
                try {
                    if (JoyFire || JoyFireLock) {
                        sprButton.setVisible(true);
                    } else {
                        sprButton.setVisible(false);
                    }
                    GraphicsManager.paint(buffer, 0, 0);
                    if (uncovering > 0) {
                        buffer.setColor(0, 0, 0);
                        buffer.drawString(strInfo, 50, 35, 17);
                        buffer.drawString(strInfo, 49, 36, 17);
                        buffer.drawString(strInfo, 51, 36, 17);
                        buffer.drawString(strInfo, 50, 37, 17);
                        buffer.setColor(255, 255, 255);
                        buffer.drawString(strInfo, 50, 36, 17);
                    }
                    if (paused) {
                        sprPaused.paint(buffer);
                    } else if (caveTime < 0) {
                        sprTime.paint(buffer);
                    }
                    this.flushGraphics();
                    ++frames;
                }
                catch (Exception e) {
                    System.out.println("paint(): " + e);
                }
            }
        } else if (ColorBD.midlet.mode == 1) {
            while (running) {
                if (taskLoadLevel) {
                    this.LoadLevel();
                    continue;
                }
                if (taskUpdatePlayfield) {
                    ColorBD.UpdatePlayfield();
                    readyToPaint = true;
                    continue;
                }
                if (rfBorn) {
                    long t = System.currentTimeMillis();
                    if (t - elapsed > 1200L) {
                        --caveTime;
                        if (--caveTimer < 0) {
                            amoebaRate = 32;
                        }
                        if (caveTime < 0) {
                            timeH.setFrame(0);
                            timeT.setFrame(0);
                            timeS.setFrame(0);
                        } else {
                            timeH.setFrame(caveTime / 100 % 10);
                            timeT.setFrame(caveTime / 10 % 10);
                            timeS.setFrame(caveTime % 10);
                        }
                        if (wallState == 1 && --caveWTimer < 0) {
                            wallState = (byte)2;
                        }
                        elapsed = t;
                    }
                } else {
                    elapsed = System.currentTimeMillis();
                }
                if (uncovering >= 0) {
                    short s = uncovering;
                    uncovering = (short)(s - 1);
                    if (s == 0) {
                        taskUpdatePlayfield = true;
                    } else {
                        for (int y = 0; y < 22; ++y) {
                            int x = rndBuf[++rndNext & 0x1FF] % 40;
                            int obj = Cave[80 + y * 40 + x] & 0x7F;
                            Land.setCell(x, y, ColorBD.getObjectTile(obj));
                            x = rndBuf[++rndNext & 0x1FF] % 40;
                            obj = Cave[80 + y * 40 + x] & 0x7F;
                            Land.setCell(x, y, ColorBD.getObjectTile(obj));
                        }
                    }
                    this.updateSprites();
                    readyToPaint = true;
                } else {
                    ColorBD.StepCave();
                    ++step;
                    this.updateSprites();
                    readyToPaint = true;
                }
                if (readyToPaint) {
                    try {
                        GraphicsManager.paint(buffer, 0, 0);
                        this.flushGraphics();
                        ++frames;
                    }
                    catch (Exception e) {
                        System.out.println("GraphicsManager.paint(): " + e);
                    }
                }
                if (frames > 250L) {
                    running = false;
                }
                if (!YIELD) continue;
                Thread.yield();
            }
        } else if (ColorBD.midlet.mode == 2) {
            while (running) {
                if (taskLoadLevel) {
                    this.LoadLevel();
                    continue;
                }
                if (taskUpdatePlayfield) {
                    ColorBD.UpdatePlayfield();
                    readyToPaint = true;
                    continue;
                }
                if (rfBorn) {
                    long t = System.currentTimeMillis();
                    if (t - elapsed > 1200L) {
                        long ctm = t;
                        while ((ctm & 1L) == 0L) {
                            ctm >>= 1;
                        }
                        rndNext = rndNext + (int)ctm & 0x1FF;
                        --caveTime;
                        if (--caveTimer < 0) {
                            amoebaRate = 32;
                        }
                        if (wallState == 1 && --caveWTimer < 0) {
                            wallState = (byte)2;
                        }
                        elapsed = t;
                    }
                } else {
                    elapsed = System.currentTimeMillis();
                }
                ColorBD.StepCave();
                ++step;
                if (++frames <= 500L) continue;
                running = false;
            }
        }
        long endt = System.currentTimeMillis();
        ColorBD.midlet.time = totalt = endt - startt;
        ColorBD.midlet.frames = frames;
        ColorBD.midlet.fps = frames * 1000L / totalt;
    }

    static {
        readyToPaint = false;
        LevelNo = 0;
        LevelDiff = 0;
        JoyPos = -1;
        JoyFire = false;
        JoyFireDown = false;
        JoyFireLock = false;
        rndSeed = 1;
        charx = 10;
        dirs = new int[]{-1, -40, 1, 40};
    }
}

