/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.util;

import java.util.Timer;
import java.util.TimerTask;

public class LCDLightUtil {
    private static Timer timerService = new Timer();
    private TimerTask backlightTask = null;

    public synchronized boolean backlight(int n, int n2) {
        if (n2 > 0) {
            this.setBacklightTimer(n, n2);
            return this.backlight0(n, true);
        }
        if (n2 == 0) {
            this.cancelBacklightTimer();
            return this.backlight0(n, false);
        }
        throw new IllegalArgumentException("Negative timeout value");
    }

    private void setBacklightTimer(int n, int n2) {
        this.cancelBacklightTimer();
        try {
            this.backlightTask = new BacklightTimerClient(n);
            timerService.schedule(this.backlightTask, n2 * 1000);
        }
        catch (IllegalStateException illegalStateException) {
            this.cancelBacklightTimer();
        }
    }

    private void cancelBacklightTimer() {
        if (this.backlightTask != null) {
            this.backlightTask.cancel();
            this.backlightTask = null;
        }
    }

    private boolean backlight0(int n, boolean bl) {
        System.out.println("[LCDLightUtil] backlight0 called");
        return false;
    }

    class BacklightTimerClient
    extends TimerTask {
        private int suiteId;

        BacklightTimerClient(int n) {
            this.suiteId = n;
        }

        public final void run() {
            LCDLightUtil.this.backlight0(this.suiteId, false);
            this.cancel();
        }
    }
}

