/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.webcam;

import com.github.sarxos.webcam.Webcam;
import com.github.sarxos.webcam.WebcamException;
import com.github.sarxos.webcam.WebcamLockException;
import com.github.sarxos.webcam.f;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebcamLock {
    private static final Logger LOG = LoggerFactory.getLogger(WebcamLock.class);
    private final Webcam webcam;
    private Thread updater = null;
    private final AtomicBoolean locked = new AtomicBoolean(false);
    private final AtomicBoolean disabled = new AtomicBoolean(false);
    private final File lock;

    protected WebcamLock(Webcam webcam) {
        this.webcam = webcam;
        this.lock = new File(System.getProperty("java.io.tmpdir"), this.getLockName());
        this.lock.deleteOnExit();
    }

    private String getLockName() {
        return String.format(".webcam-lock-%d", Math.abs(this.webcam.getName().hashCode()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(long l2) {
        if (this.disabled.get()) {
            return;
        }
        String string = this.getLockName();
        File file = null;
        FilterOutputStream filterOutputStream = null;
        try {
            file = File.createTempFile(String.format("%s-tmp", string), "");
            file.deleteOnExit();
            filterOutputStream = new DataOutputStream(new FileOutputStream(file));
            ((DataOutputStream)filterOutputStream).writeLong(l2);
            ((DataOutputStream)filterOutputStream).flush();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        finally {
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
        }
        if (!this.locked.get()) {
            return;
        }
        if (file.renameTo(this.lock)) {
            return;
        }
        if (!this.lock.exists()) {
            try {
                if (!this.lock.createNewFile()) {
                    throw new RuntimeException("Not able to create file " + this.lock);
                }
                LOG.info("Lock file {} for {} has been created", this.lock, this.webcam);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        FileOutputStream fileOutputStream = null;
        FileInputStream fileInputStream = null;
        int n2 = 0;
        int n3 = -1;
        byte[] byArray = new byte[8];
        boolean bl2 = false;
        Webcam webcam = this.webcam;
        synchronized (webcam) {
            do {
                try {
                    fileOutputStream = new FileOutputStream(this.lock);
                    fileInputStream = new FileInputStream(file);
                    while ((n3 = fileInputStream.read(byArray)) != -1) {
                        fileOutputStream.write(byArray, 0, n3);
                    }
                    bl2 = true;
                }
                catch (IOException iOException) {
                    LOG.debug("Not able to rewrite lock file", iOException);
                }
                finally {
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (IOException iOException) {
                            throw new RuntimeException(iOException);
                        }
                    }
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (IOException iOException) {
                            throw new RuntimeException(iOException);
                        }
                    }
                }
            } while (!bl2 && n2++ < 5);
        }
        if (!bl2) {
            throw new WebcamException("Not able to write lock file");
        }
        if (!file.delete()) {
            file.deleteOnExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long read() {
        if (this.disabled.get()) {
            return -1L;
        }
        FilterInputStream filterInputStream = null;
        long l2 = -1L;
        boolean bl2 = false;
        Webcam webcam = this.webcam;
        synchronized (webcam) {
            try {
                filterInputStream = new DataInputStream(new FileInputStream(this.lock));
                l2 = ((DataInputStream)filterInputStream).readLong();
            }
            catch (EOFException eOFException) {
                LOG.debug("Webcam lock is broken - EOF when reading long variable from stream", eOFException);
                bl2 = true;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            finally {
                if (filterInputStream != null) {
                    try {
                        filterInputStream.close();
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(iOException);
                    }
                }
            }
            if (bl2) {
                LOG.warn("Lock file {} for {} is broken - recreating it", (Object)this.lock, (Object)this.webcam);
                this.write(-1L);
            }
        }
        return l2;
    }

    private void update() {
        if (this.disabled.get()) {
            return;
        }
        this.write(System.currentTimeMillis());
    }

    public void lock() {
        if (this.disabled.get()) {
            return;
        }
        if (this.isLocked()) {
            throw new WebcamLockException(String.format("Webcam %s has already been locked", this.webcam.getName()));
        }
        if (!this.locked.compareAndSet(false, true)) {
            return;
        }
        LOG.debug("Lock {}", this.webcam);
        this.update();
        this.updater = new f(this);
        this.updater.start();
    }

    public void unlock() {
        if (this.disabled.get()) {
            return;
        }
        if (!this.locked.compareAndSet(true, false)) {
            return;
        }
        LOG.debug("Unlock {}", this.webcam);
        this.updater.interrupt();
        this.write(-1L);
        if (!this.lock.delete()) {
            this.lock.deleteOnExit();
        }
    }

    public boolean isLocked() {
        if (this.disabled.get()) {
            return false;
        }
        if (this.locked.get()) {
            return true;
        }
        if (!this.lock.exists()) {
            return false;
        }
        long l2 = System.currentTimeMillis();
        long l3 = this.read();
        LOG.trace("Lock timestamp {} now {} for {}", l3, l2, this.webcam);
        return l3 > l2 - 4000L;
    }

    static /* synthetic */ Webcam access$000(WebcamLock webcamLock) {
        return webcamLock.webcam;
    }

    static /* synthetic */ AtomicBoolean access$100(WebcamLock webcamLock) {
        return webcamLock.disabled;
    }

    static /* synthetic */ void access$200(WebcamLock webcamLock) {
        webcamLock.update();
    }

    static /* synthetic */ Logger access$300() {
        return LOG;
    }

    static /* synthetic */ AtomicBoolean access$400(WebcamLock webcamLock) {
        return webcamLock.locked;
    }
}

