/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.webcam.ds.buildin;

import com.github.sarxos.webcam.WebcamDevice;
import com.github.sarxos.webcam.WebcamDevice$FPSSource;
import com.github.sarxos.webcam.WebcamException;
import com.github.sarxos.webcam.WebcamExceptionHandler;
import com.github.sarxos.webcam.WebcamResolution;
import com.github.sarxos.webcam.ds.buildin.a;
import com.github.sarxos.webcam.ds.buildin.natives.Device;
import com.github.sarxos.webcam.ds.buildin.natives.DeviceList;
import com.github.sarxos.webcam.ds.buildin.natives.OpenIMAJGrabber;
import java.awt.Dimension;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bridj.Pointer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebcamDefaultDevice
implements WebcamDevice,
WebcamDevice$FPSSource,
Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(WebcamDefaultDevice.class);
    private static final Dimension[] DIMENSIONS = new Dimension[]{WebcamResolution.QQVGA.getSize(), WebcamResolution.QVGA.getSize(), WebcamResolution.VGA.getSize()};
    private static final int[] BAND_OFFSETS = new int[]{0, 1, 2};
    private static final int[] BITS = new int[]{8, 8, 8};
    private static final int[] OFFSET = new int[]{0};
    private static final ColorSpace COLOR_SPACE = ColorSpace.getInstance(1000);
    private int timeout = 5000;
    private OpenIMAJGrabber grabber = null;
    private Device device = null;
    private Dimension size = null;
    private ComponentSampleModel smodel = null;
    private ColorModel cmodel = null;
    private boolean failOnSizeMismatch = false;
    private final AtomicBoolean disposed = new AtomicBoolean(false);
    private final AtomicBoolean open = new AtomicBoolean(false);
    private final AtomicBoolean fresh = new AtomicBoolean(false);
    private Thread refresher = null;
    private String name = null;
    private String id = null;
    private String fullname = null;
    private long t1 = -1L;
    private long t2 = -1L;
    private volatile double fps = 0.0;

    protected WebcamDefaultDevice(Device device) {
        this.device = device;
        this.name = device.getNameStr();
        this.id = device.getIdentifierStr();
        this.fullname = String.format("%s %s", this.name, this.id);
    }

    @Override
    public String getName() {
        return this.fullname;
    }

    @Override
    public Dimension[] getResolutions() {
        return DIMENSIONS;
    }

    @Override
    public Dimension getResolution() {
        if (this.size == null) {
            this.size = this.getResolutions()[0];
        }
        return this.size;
    }

    @Override
    public void setResolution(Dimension dimension) {
        if (dimension == null) {
            throw new IllegalArgumentException("Size cannot be null");
        }
        if (this.open.get()) {
            throw new IllegalStateException("Cannot change resolution when webcam is open, please close it first");
        }
        this.size = dimension;
    }

    public ByteBuffer getImageBytes() {
        if (this.disposed.get()) {
            LOG.debug("Webcam is disposed, image will be null");
            return null;
        }
        if (!this.open.get()) {
            LOG.debug("Webcam is closed, image will be null");
            return null;
        }
        if (this.fresh.compareAndSet(false, true)) {
            this.updateFrameBuffer();
        }
        LOG.trace("Webcam grabber get image pointer");
        Pointer pointer = this.grabber.getImage();
        this.fresh.set(false);
        if (pointer == null) {
            LOG.warn("Null array pointer found instead of image");
            return null;
        }
        int n2 = this.size.width * this.size.height * 3;
        LOG.trace("Webcam device get buffer, read {} bytes", (Object)n2);
        return pointer.getByteBuffer(n2);
    }

    @Override
    public BufferedImage getImage() {
        ByteBuffer byteBuffer = this.getImageBytes();
        if (byteBuffer == null) {
            LOG.error("Images bytes buffer is null!");
            return null;
        }
        byte[] byArray = new byte[this.size.width * this.size.height * 3];
        byte[][] byArrayArray = new byte[][]{byArray};
        byteBuffer.get(byArray);
        DataBufferByte dataBufferByte = new DataBufferByte(byArrayArray, byArray.length, OFFSET);
        WritableRaster writableRaster = Raster.createWritableRaster(this.smodel, dataBufferByte, null);
        BufferedImage bufferedImage = new BufferedImage(this.cmodel, writableRaster, false, null);
        bufferedImage.flush();
        return bufferedImage;
    }

    @Override
    public void open() {
        Object object2;
        if (this.disposed.get()) {
            return;
        }
        LOG.debug("Opening webcam device {}", this.getName());
        if (this.size == null) {
            this.size = this.getResolutions()[0];
        }
        if (this.size == null) {
            throw new RuntimeException("The resolution size cannot be null");
        }
        LOG.debug("Webcam device {} starting session, size {}", this.device.getIdentifierStr(), this.size);
        this.grabber = new OpenIMAJGrabber();
        DeviceList deviceList = (DeviceList)this.grabber.getVideoDevices().get();
        for (Object object2 : deviceList.asArrayList()) {
            ((Device)object2).getNameStr();
            ((Device)object2).getIdentifierStr();
        }
        boolean bl2 = this.grabber.startSession(this.size.width, this.size.height, 50.0, Pointer.pointerTo(this.device));
        if (!bl2) {
            throw new WebcamException("Cannot start native grabber!");
        }
        this.grabber.setTimeout(this.timeout);
        LOG.debug("Webcam device session started");
        object2 = new Dimension(this.grabber.getWidth(), this.grabber.getHeight());
        int n2 = this.size.width;
        int n3 = ((Dimension)object2).width;
        int n4 = this.size.height;
        int n5 = ((Dimension)object2).height;
        if (n2 != n3 || n4 != n5) {
            if (this.failOnSizeMismatch) {
                throw new WebcamException(String.format("Different size obtained vs requested - [%dx%d] vs [%dx%d]", n2, n4, n3, n5));
            }
            Object[] objectArray = new Object[]{n2, n4, n3, n5, n3, n5};
            LOG.warn("Different size obtained vs requested - [{}x{}] vs [{}x{}]. Setting correct one. New size is [{}x{}]", objectArray);
            this.size = new Dimension(n3, n5);
        }
        this.smodel = new ComponentSampleModel(0, this.size.width, this.size.height, 3, this.size.width * 3, BAND_OFFSETS);
        this.cmodel = new ComponentColorModel(COLOR_SPACE, BITS, false, false, 1, 0);
        LOG.debug("Clear memory buffer");
        this.clearMemoryBuffer();
        LOG.debug("Webcam device {} is now open", this);
        this.open.set(true);
        this.refresher = this.startFramesRefresher();
    }

    private void clearMemoryBuffer() {
        for (int i2 = 0; i2 < 5; ++i2) {
            this.grabber.nextFrame();
        }
    }

    private Thread startFramesRefresher() {
        Thread thread = new Thread((Runnable)this, String.format("frames-refresher-[%s]", this.id));
        thread.setUncaughtExceptionHandler(WebcamExceptionHandler.getInstance());
        thread.setDaemon(true);
        thread.start();
        return thread;
    }

    @Override
    public void close() {
        if (!this.open.compareAndSet(true, false)) {
            return;
        }
        LOG.debug("Closing webcam device");
        this.grabber.stopSession();
    }

    @Override
    public void dispose() {
        if (!this.disposed.compareAndSet(false, true)) {
            return;
        }
        LOG.debug("Disposing webcam device {}", this.getName());
        this.close();
    }

    @Override
    public boolean isOpen() {
        return this.open.get();
    }

    private void updateFrameBuffer() {
        LOG.trace("Next frame");
        if (this.t1 == -1L || this.t2 == -1L) {
            this.t1 = System.currentTimeMillis();
            this.t2 = System.currentTimeMillis();
        }
        int n2 = new a(this, (WebcamDevice)this).a();
        this.t1 = this.t2;
        this.t2 = System.currentTimeMillis();
        this.fps = (4.0 * this.fps + (double)(1000L / (this.t2 - this.t1 + 1L))) / 5.0;
        if (n2 == -1) {
            LOG.error("Timeout when requesting image!");
        } else if (n2 < -1) {
            LOG.error("Error requesting new frame!");
        }
    }

    @Override
    public void run() {
        do {
            if (Thread.interrupted()) {
                LOG.debug("Refresher has been interrupted");
                return;
            }
            if (!this.open.get()) {
                LOG.debug("Cancelling refresher");
                return;
            }
            this.updateFrameBuffer();
        } while (this.open.get());
    }

    @Override
    public double getFPS() {
        return this.fps;
    }

    static /* synthetic */ Logger access$000() {
        return LOG;
    }

    static /* synthetic */ OpenIMAJGrabber access$100(WebcamDefaultDevice webcamDefaultDevice) {
        return webcamDefaultDevice.grabber;
    }

    static /* synthetic */ AtomicBoolean access$200(WebcamDefaultDevice webcamDefaultDevice) {
        return webcamDefaultDevice.fresh;
    }
}

