/*
 * Decompiled with CFR 0.152.
 */
package emulator.graphics3D;

public final class Vector4f {
    public static final Vector4f X_AXIS = new Vector4f(1.0f, 0.0f, 0.0f, 0.0f);
    public static final Vector4f Y_AXIS = new Vector4f(0.0f, 1.0f, 0.0f, 0.0f);
    public static final Vector4f Z_AXIS = new Vector4f(0.0f, 0.0f, 1.0f, 0.0f);
    public static final Vector4f ORIGIN = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
    public float x;
    public float y;
    public float z;
    public float w;

    public Vector4f() {
    }

    public Vector4f(float f2, float f3, float f4, float f5) {
        this.x = f2;
        this.y = f3;
        this.z = f4;
        this.w = f5;
    }

    public Vector4f(Vector4f vector4f) {
        this.x = vector4f.x;
        this.y = vector4f.y;
        this.z = vector4f.z;
        this.w = vector4f.w;
    }

    public Vector4f(float[] fArray) {
        this.x = fArray[0];
        this.y = fArray[1];
        this.z = fArray[2];
        this.w = fArray[3];
    }

    public final void set(float f2, float f3, float f4, float f5) {
        this.x = f2;
        this.y = f3;
        this.z = f4;
        this.w = f5;
    }

    public final void set(Vector4f vector4f) {
        this.x = vector4f.x;
        this.y = vector4f.y;
        this.z = vector4f.z;
        this.w = vector4f.w;
    }

    public final float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public final void mul(float f2) {
        this.x *= f2;
        this.y *= f2;
        this.z *= f2;
        this.w *= f2;
    }

    public final void add(Vector4f vector4f) {
        this.x += vector4f.x;
        this.y += vector4f.y;
        this.z += vector4f.z;
        this.w += vector4f.w;
    }

    public final void sub(Vector4f vector4f) {
        this.x -= vector4f.x;
        this.y -= vector4f.y;
        this.z -= vector4f.z;
        this.w -= vector4f.w;
    }

    public final void sub(Vector4f vector4f, Vector4f vector4f2) {
        this.x = vector4f.x - vector4f2.x;
        this.y = vector4f.y - vector4f2.y;
        this.z = vector4f.z - vector4f2.z;
        this.w = vector4f.w - vector4f2.w;
    }

    public final float dot(Vector4f vector4f) {
        return this.x * vector4f.x + this.y * vector4f.y + this.z * vector4f.z + this.w * vector4f.w;
    }

    public final void cross(Vector4f vector4f, Vector4f vector4f2) {
        this.x = vector4f.y * vector4f2.z - vector4f.z * vector4f2.y;
        this.y = vector4f.z * vector4f2.x - vector4f.x * vector4f2.z;
        this.z = vector4f.x * vector4f2.y - vector4f.y * vector4f2.x;
        this.w = 0.0f;
    }

    public final boolean normalize() {
        float f2 = this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
        if (f2 < 1.0E-5f) {
            return false;
        }
        float f3 = 1.0f / (float)Math.sqrt(f2);
        this.x *= f3;
        this.y *= f3;
        this.z *= f3;
        this.w *= f3;
        return true;
    }

    public static void mul(float[] fArray, float f2) {
        fArray[0] = fArray[0] * f2;
        fArray[1] = fArray[1] * f2;
        fArray[2] = fArray[2] * f2;
        fArray[3] = fArray[3] * f2;
    }

    public static void sub(float[] fArray, float[] fArray2) {
        fArray[0] = fArray[0] - fArray2[0];
        fArray[1] = fArray[1] - fArray2[1];
        fArray[2] = fArray[2] - fArray2[2];
        fArray[3] = fArray[3] - fArray2[3];
    }

    public static void add(float[] fArray, float[] fArray2) {
        fArray[0] = fArray[0] + fArray2[0];
        fArray[1] = fArray[1] + fArray2[1];
        fArray[2] = fArray[2] + fArray2[2];
        fArray[3] = fArray[3] + fArray2[3];
    }

    public static float length(float[] fArray) {
        return (float)Math.sqrt(fArray[0] * fArray[0] + fArray[1] * fArray[1] + fArray[2] * fArray[2]);
    }
}

