/*
 * Decompiled with CFR 0.152.
 */
package org.bridj;

import java.util.AbstractList;
import java.util.Collection;
import java.util.RandomAccess;
import org.bridj.NativeList;
import org.bridj.Pointer;
import org.bridj.Pointer$ListType;
import org.bridj.PointerIO;

class DefaultNativeList
extends AbstractList
implements RandomAccess,
NativeList {
    final Pointer$ListType type;
    final PointerIO io;
    volatile Pointer pointer;
    volatile long size;

    @Override
    public Pointer getPointer() {
        return this.pointer;
    }

    DefaultNativeList(Pointer pointer, Pointer$ListType pointer$ListType) {
        if (pointer == null || pointer$ListType == null) {
            throw new IllegalArgumentException("Cannot build a " + this.getClass().getSimpleName() + " with " + pointer + " and " + (Object)((Object)pointer$ListType));
        }
        this.io = pointer.getIO("Cannot create a list out of untyped pointer " + pointer);
        this.type = pointer$ListType;
        this.size = pointer.getValidElements();
        this.pointer = pointer;
    }

    protected void checkModifiable() {
        if (this.type == Pointer$ListType.Unmodifiable) {
            throw new UnsupportedOperationException("This list is unmodifiable");
        }
    }

    protected int safelyCastLongToInt(long l2, String string) {
        if (l2 > Integer.MAX_VALUE) {
            throw new RuntimeException(string + " is bigger than Java int's maximum value : " + l2);
        }
        return (int)l2;
    }

    @Override
    public int size() {
        return this.safelyCastLongToInt(this.size, "Size of the native list");
    }

    @Override
    public void clear() {
        this.checkModifiable();
        this.size = 0L;
    }

    public Object get(int n2) {
        if ((long)n2 >= this.size || n2 < 0) {
            throw new IndexOutOfBoundsException("Invalid index : " + n2 + " (list has size " + this.size + ")");
        }
        return this.pointer.get(n2);
    }

    public Object set(int n2, Object object) {
        this.checkModifiable();
        if ((long)n2 >= this.size || n2 < 0) {
            throw new IndexOutOfBoundsException("Invalid index : " + n2 + " (list has size " + this.size + ")");
        }
        Object object2 = this.pointer.get(n2);
        this.pointer.set(n2, object);
        return object2;
    }

    void add(long l2, Object object) {
        this.checkModifiable();
        if (l2 > this.size || l2 < 0L) {
            throw new IndexOutOfBoundsException("Invalid index : " + l2 + " (list has size " + this.size + ")");
        }
        this.requireSize(this.size + 1L);
        if (l2 < this.size) {
            this.pointer.moveBytesAtOffsetTo(l2, this.pointer, l2 + 1L, this.size - l2);
        }
        this.pointer.set(l2, object);
        ++this.size;
    }

    public void add(int n2, Object object) {
        this.add((long)n2, object);
    }

    protected void requireSize(long l2) {
        if (l2 > this.pointer.getValidElements()) {
            switch (this.type) {
                case Dynamic: {
                    long l3 = l2 < 5L ? l2 + 1L : (long)((double)l2 * 1.6);
                    Pointer pointer = Pointer.allocateArray(this.io, l3);
                    this.pointer.copyTo(pointer);
                    this.pointer = pointer;
                    break;
                }
                case FixedCapacity: {
                    throw new UnsupportedOperationException("This list has a fixed capacity, cannot grow its storage");
                }
                case Unmodifiable: {
                    this.checkModifiable();
                }
            }
        }
    }

    Object remove(long l2) {
        this.checkModifiable();
        if (l2 >= this.size || l2 < 0L) {
            throw new IndexOutOfBoundsException("Invalid index : " + l2 + " (list has size " + this.size + ")");
        }
        Object object = this.pointer.get(l2);
        long l3 = this.io.getTargetSize();
        this.pointer.moveBytesAtOffsetTo((l2 + 1L) * l3, this.pointer, l2 * l3, l3);
        --this.size;
        return object;
    }

    public Object remove(int n2) {
        return this.remove((long)n2);
    }

    @Override
    public boolean remove(Object object) {
        this.checkModifiable();
        long l2 = this.indexOf(object, true, 0);
        if (l2 < 0L) {
            return false;
        }
        this.remove(l2);
        return true;
    }

    long indexOf(Object object, boolean bl2, int n2) {
        Pointer pointer;
        Pointer pointer2 = this.pointer;
        assert (n2 >= 0 && (bl2 || n2 > 0));
        if (n2 > 0) {
            pointer2 = pointer2.next(n2);
        }
        Pointer pointer3 = Pointer.allocate(this.io);
        pointer3.set(object);
        Pointer pointer4 = pointer = bl2 ? pointer2.findLast(pointer3) : pointer2.find(pointer3);
        if (pointer == null) {
            return -1L;
        }
        return pointer.getPeer() - pointer2.getPeer();
    }

    @Override
    public int indexOf(Object object) {
        return this.safelyCastLongToInt(this.indexOf(object, false, 0), "Index of the object");
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.safelyCastLongToInt(this.indexOf(object, true, 0), "Last index of the object");
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) >= 0;
    }

    public boolean addAll(int n2, Collection collection) {
        if (n2 >= 0 && (long)n2 < this.size) {
            this.requireSize(this.size + (long)collection.size());
        }
        return super.addAll(n2, collection);
    }

    @Override
    public Object[] toArray() {
        return this.pointer.validElements(this.size).toArray();
    }

    @Override
    public Object[] toArray(Object[] objectArray) {
        return this.pointer.validElements(this.size).toArray(objectArray);
    }
}

