/*
 * Decompiled with CFR 0.152.
 */
package org.bridj;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.bridj.BridJ;
import org.bridj.NativeObject;
import org.bridj.Platform;
import org.bridj.Pointer;
import org.bridj.PointerIO;
import org.bridj.SolidRanges;
import org.bridj.SolidRanges$Builder;
import org.bridj.StructCustomizer;
import org.bridj.StructDescription;
import org.bridj.StructFieldDeclaration;
import org.bridj.StructFieldDescription;
import org.bridj.StructIO;
import org.bridj.StructObject;
import org.bridj.StructUtils$1;
import org.bridj.ann.Alignment;
import org.bridj.ann.Struct;
import org.bridj.util.Pair;
import org.bridj.util.Utils;

class StructUtils {
    StructUtils() {
    }

    static long alignSize(long l2, long l3) {
        long l4;
        if (l3 > 1L && (l4 = l2 % l3) != 0L) {
            l2 += l3 - l4;
        }
        return l2;
    }

    static void orderFields(List list2) {
        Collections.sort(list2, new StructUtils$1());
    }

    static long primTypeAlignment(Class clazz, long l2) {
        if (StructUtils.isDouble(clazz) && !BridJ.alignDoubles && Platform.isLinux() && !Platform.is64Bits()) {
            return 4L;
        }
        return l2;
    }

    static boolean isDouble(Class clazz) {
        return clazz == Double.class || clazz == Double.TYPE;
    }

    static int primTypeLength(Class clazz) {
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return 4;
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            return 8;
        }
        if (clazz == Short.class || clazz == Short.TYPE) {
            return 2;
        }
        if (clazz == Byte.class || clazz == Byte.TYPE) {
            return 1;
        }
        if (clazz == Character.class || clazz == Character.TYPE) {
            return 2;
        }
        if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            return 1;
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            return 4;
        }
        if (StructUtils.isDouble(clazz)) {
            return 8;
        }
        if (Pointer.class.isAssignableFrom(clazz)) {
            return Pointer.SIZE;
        }
        throw new UnsupportedOperationException("Field type " + clazz.getName() + " not supported yet");
    }

    static long alignmentOf(Type type) {
        Class clazz = PointerIO.getClass(type);
        if (StructObject.class.isAssignableFrom(clazz)) {
            return StructIO.getInstance((Type)clazz).desc.getStructAlignment();
        }
        return BridJ.sizeOf(type);
    }

    static int compare(StructObject structObject, StructObject structObject2, SolidRanges solidRanges) {
        Pointer pointer = Pointer.getPointer(structObject);
        Pointer pointer2 = Pointer.getPointer(structObject2);
        if (pointer == null || pointer2 == null) {
            return pointer != null ? 1 : (pointer2 != null ? -1 : 0);
        }
        long[] lArray = solidRanges.offsets;
        long[] lArray2 = solidRanges.lengths;
        int n2 = lArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            long l2 = lArray[i2];
            long l3 = lArray2[i2];
            int n3 = pointer.compareBytesAtOffset(l2, pointer2, l2, l3);
            if (n3 == 0) continue;
            return n3;
        }
        return 0;
    }

    static String describe(StructObject structObject, Type type, StructFieldDescription[] structFieldDescriptionArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(StructUtils.describe(type)).append(" { ");
        for (StructFieldDescription structFieldDescription : structFieldDescriptionArray) {
            stringBuilder.append("\n\t").append(structFieldDescription.name).append(" = ");
            try {
                Object object = structFieldDescription.getter != null ? structFieldDescription.getter.invoke((Object)structObject, new Object[0]) : structFieldDescription.field.get(structObject);
                if (object instanceof String) {
                    stringBuilder.append('\"').append(object.toString().replaceAll("\"", "\\\"")).append('\"');
                } else if (object instanceof Character) {
                    stringBuilder.append('\'').append(object).append('\'');
                } else if (object instanceof NativeObject) {
                    String string = BridJ.describe((NativeObject)object);
                    stringBuilder.append(string.replaceAll("\n", "\n\t"));
                } else {
                    stringBuilder.append(object);
                }
            }
            catch (Throwable throwable) {
                if (BridJ.debug) {
                    throwable.printStackTrace();
                }
                stringBuilder.append("?");
            }
            stringBuilder.append("; ");
        }
        stringBuilder.append("\n}");
        return stringBuilder.toString();
    }

    static String describe(Type type) {
        if (type == null) {
            return "?";
        }
        if (type instanceof Class) {
            return ((Class)type).getSimpleName();
        }
        return type.toString().replaceAll("\\bjava\\.lang\\.", "").replaceAll("\\borg\\.bridj\\.cpp\\.com\\.", "").replaceAll("\\borg\\.bridj\\.Pointer\\b", "Pointer");
    }

    static Pointer fixIntegralTypeIOToMatchLength(Pointer pointer, long l2, long l3) {
        long l4 = pointer.getTargetSize();
        if (l4 * l3 == l2) {
            return pointer;
        }
        Type type = pointer.getTargetType();
        if (!Utils.isSignedIntegral(type)) {
            return pointer;
        }
        switch ((int)l2) {
            case 1: {
                return pointer.as(Byte.TYPE);
            }
            case 2: {
                return pointer.as(Short.TYPE);
            }
            case 4: {
                return pointer.as(Integer.TYPE);
            }
            case 8: {
                return pointer.as(Long.TYPE);
            }
        }
        return pointer;
    }

    protected static void computeStructLayout(StructDescription structDescription, StructCustomizer structCustomizer) {
        Object object4;
        ArrayList<Object> arrayList;
        Object object2;
        Object object32;
        List list2 = StructFieldDeclaration.listFields(structDescription.structClass);
        StructUtils.orderFields(list2);
        structCustomizer.beforeAggregation(structDescription, list2);
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (Object object32 : list2) {
            if (((StructFieldDeclaration)object32).index < 0L) {
                throw new RuntimeException("Negative field index not allowed for field " + ((StructFieldDeclaration)object32).desc.name);
            }
            long l2 = ((StructFieldDeclaration)object32).unionWith >= 0L ? ((StructFieldDeclaration)object32).unionWith : ((StructFieldDeclaration)object32).index;
            object2 = new Pair(((StructFieldDeclaration)object32).declaringClass, l2);
            arrayList = (ArrayList<Object>)linkedHashMap.get(object2);
            if (arrayList == null) {
                arrayList = new ArrayList<Object>();
                linkedHashMap.put(object2, arrayList);
            }
            arrayList.add(object32);
        }
        Alignment alignment = structDescription.structClass.getAnnotation(Alignment.class);
        structDescription.structAlignment = alignment != null ? (long)alignment.value() : 1L;
        object32 = new ArrayList();
        for (Object object4 : linkedHashMap.values()) {
            object2 = StructFieldDescription.aggregateDeclarations(structDescription.structType, (List)object4);
            if (object2 == null) continue;
            object32.add(object2);
        }
        structDescription.setAggregatedFields((List)object32);
        structCustomizer.beforeLayout(structDescription, (List)object32);
        StructUtils.performLayout(structDescription, (Iterable)object32);
        structCustomizer.afterLayout(structDescription, (List)object32);
        ArrayList arrayList2 = new ArrayList();
        object4 = new SolidRanges$Builder();
        object2 = object32.iterator();
        while (object2.hasNext()) {
            arrayList = (StructFieldDescription)object2.next();
            for (StructFieldDeclaration structFieldDeclaration : ((StructFieldDescription)((Object)arrayList)).aggregatedFields) {
                StructFieldDescription structFieldDescription = structFieldDeclaration.desc;
                structFieldDescription.byteOffset = ((StructFieldDescription)((Object)arrayList)).byteOffset;
                if (structFieldDescription.byteLength < 0L || structFieldDescription.byteLength > ((StructFieldDescription)((Object)arrayList)).byteLength) {
                    structFieldDescription.byteLength = ((StructFieldDescription)((Object)arrayList)).byteLength;
                }
                structFieldDescription.bitOffset = ((StructFieldDescription)((Object)arrayList)).bitOffset;
                structFieldDescription.bitMask = ((StructFieldDescription)((Object)arrayList)).bitMask;
                arrayList2.add(structFieldDescription);
                ((SolidRanges$Builder)object4).add(structFieldDescription);
                structDescription.hasFieldFields = structDescription.hasFieldFields || structFieldDescription.field != null;
            }
        }
        structDescription.solidRanges = ((SolidRanges$Builder)object4).toSolidRanges();
        structDescription.fields = arrayList2.toArray(new StructFieldDescription[arrayList2.size()]);
    }

    static void performLayout(StructDescription structDescription, Iterable iterable) {
        int n2;
        long l2 = 0L;
        long l3 = -1L;
        Struct struct = structDescription.structClass.getAnnotation(Struct.class);
        int n3 = n2 = struct != null ? struct.pack() : -1;
        if (structDescription.isVirtual()) {
            l2 += (long)Pointer.SIZE;
            if ((long)Pointer.SIZE >= l3) {
                l3 = Pointer.SIZE;
            }
        }
        int n4 = 0;
        for (StructFieldDescription structFieldDescription : iterable) {
            l3 = Math.max(l3, structFieldDescription.alignment);
            if (structFieldDescription.bitLength < 0L) {
                if (n4 != 0) {
                    n4 = 0;
                    ++l2;
                }
                l2 = StructUtils.alignSize(l2, n2 > 0 ? (long)n2 : structFieldDescription.alignment);
            }
            long l4 = l2;
            long l5 = n4;
            if (structFieldDescription.bitLength >= 0L) {
                n4 = (int)((long)n4 + structFieldDescription.bitLength);
                l2 += (long)(n4 >>> 3);
                n4 &= 7;
            } else {
                l2 += structFieldDescription.byteLength;
            }
            structFieldDescription.byteOffset = l4;
            structFieldDescription.bitOffset = l5;
            structFieldDescription.computeBitMask();
        }
        if (n4 > 0) {
            l2 = StructUtils.alignSize(l2 + 1L, l3);
        } else if (l2 > 0L) {
            l2 = StructUtils.alignSize(l2, n2 > 0 ? (long)n2 : l3);
        }
        structDescription.structSize = l2;
        structDescription.structAlignment = l3;
    }
}

