/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.Relation$1;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.COMObject;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.win32.OS;

class Relation {
    Accessible accessible;
    COMObject objIAccessibleRelation;
    int refCount;
    int type;
    Accessible[] targets;
    static final String[] relationTypeString = new String[]{"controlledBy", "controllerFor", "describedBy", "descriptionFor", "embeddedBy", "embeds", "flowsFrom", "flowsTo", "labelFor", "labelledBy", "memberOf", "nodeChildOf", "parentWindowOf", "popupFor", "subwindowOf"};
    static final String[] localizedRelationTypeString = new String[]{SWT.getMessage("SWT_Controlled_By"), SWT.getMessage("SWT_Controller_For"), SWT.getMessage("SWT_Described_By"), SWT.getMessage("SWT_Description_For"), SWT.getMessage("SWT_Embedded_By"), SWT.getMessage("SWT_Embeds"), SWT.getMessage("SWT_Flows_From"), SWT.getMessage("SWT_Flows_To"), SWT.getMessage("SWT_Label_For"), SWT.getMessage("SWT_Labelled_By"), SWT.getMessage("SWT_Member_Of"), SWT.getMessage("SWT_Node_Child_Of"), SWT.getMessage("SWT_Parent_Window_Of"), SWT.getMessage("SWT_Popup_For"), SWT.getMessage("SWT_Subwindow_Of")};

    Relation(Accessible accessible, int n2) {
        this.accessible = accessible;
        this.type = n2;
        this.targets = new Accessible[0];
        this.AddRef();
    }

    int getAddress() {
        if (this.objIAccessibleRelation == null) {
            this.createIAccessibleRelation();
        }
        return this.objIAccessibleRelation.getAddress();
    }

    void createIAccessibleRelation() {
        this.objIAccessibleRelation = new Relation$1(this, new int[]{2, 0, 0, 1, 1, 1, 2, 3});
    }

    int QueryInterface(int n2, int n3) {
        GUID gUID = new GUID();
        COM.MoveMemory(gUID, n2, GUID.sizeof);
        if (COM.IsEqualGUID(gUID, COM.IIDIUnknown) || COM.IsEqualGUID(gUID, COM.IIDIAccessibleRelation)) {
            COM.MoveMemory(n3, new int[]{this.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        return -2147467262;
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            if (this.objIAccessibleRelation != null) {
                this.objIAccessibleRelation.dispose();
            }
            this.objIAccessibleRelation = null;
        }
        return this.refCount;
    }

    int get_relationType(int n2) {
        this.setString(n2, relationTypeString[this.type]);
        return 0;
    }

    int get_localizedRelationType(int n2) {
        this.setString(n2, localizedRelationTypeString[this.type]);
        return 0;
    }

    int get_nTargets(int n2) {
        COM.MoveMemory(n2, new int[]{this.targets.length}, 4);
        return 0;
    }

    int get_target(int n2, int n3) {
        if (n2 < 0 || n2 >= this.targets.length) {
            return -2147024809;
        }
        Accessible accessible = this.targets[n2];
        accessible.AddRef();
        COM.MoveMemory(n3, new int[]{accessible.getAddress()}, OS.PTR_SIZEOF);
        return 0;
    }

    int get_targets(int n2, int n3, int n4) {
        int n5 = Math.min(this.targets.length, n2);
        for (int i2 = 0; i2 < n5; ++i2) {
            Accessible accessible = this.targets[i2];
            accessible.AddRef();
            COM.MoveMemory(n3 + i2 * OS.PTR_SIZEOF, new int[]{accessible.getAddress()}, OS.PTR_SIZEOF);
        }
        COM.MoveMemory(n4, new int[]{n5}, 4);
        return 0;
    }

    void addTarget(Accessible accessible) {
        if (this.containsTarget(accessible)) {
            return;
        }
        Accessible[] accessibleArray = new Accessible[this.targets.length + 1];
        System.arraycopy(this.targets, 0, accessibleArray, 0, this.targets.length);
        accessibleArray[this.targets.length] = accessible;
        this.targets = accessibleArray;
    }

    boolean containsTarget(Accessible accessible) {
        for (int i2 = 0; i2 < this.targets.length; ++i2) {
            if (this.targets[i2] != accessible) continue;
            return true;
        }
        return false;
    }

    void removeTarget(Accessible accessible) {
        if (!this.containsTarget(accessible)) {
            return;
        }
        Accessible[] accessibleArray = new Accessible[this.targets.length - 1];
        int n2 = 0;
        for (int i2 = 0; i2 < this.targets.length; ++i2) {
            if (this.targets[i2] == accessible) continue;
            accessibleArray[n2++] = this.targets[i2];
        }
        this.targets = accessibleArray;
    }

    boolean hasTargets() {
        return this.targets.length > 0;
    }

    void setString(int n2, String string) {
        char[] cArray = (string + "\u0000").toCharArray();
        int n3 = COM.SysAllocString(cArray);
        COM.MoveMemory(n2, new int[]{n3}, OS.PTR_SIZEOF);
    }
}

