/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.util.ArrayList;
import org.eclipse.swt.browser.AppFileLocProvider$1;
import org.eclipse.swt.browser.AppFileLocProvider$2;
import org.eclipse.swt.browser.AppFileLocProvider$3;
import org.eclipse.swt.browser.Mozilla;
import org.eclipse.swt.browser.MozillaDelegate;
import org.eclipse.swt.browser.SimpleEnumerator;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.mozilla.IIDStore;
import org.eclipse.swt.internal.mozilla.MozillaVersion;
import org.eclipse.swt.internal.mozilla.XPCOM;
import org.eclipse.swt.internal.mozilla.XPCOMObject;
import org.eclipse.swt.internal.mozilla.nsEmbedString;
import org.eclipse.swt.internal.mozilla.nsID;
import org.eclipse.swt.internal.mozilla.nsIFile;
import org.eclipse.swt.internal.mozilla.nsILocalFile;
import org.eclipse.swt.internal.mozilla.nsISupports;

class AppFileLocProvider {
    XPCOMObject supports;
    XPCOMObject directoryServiceProvider;
    XPCOMObject directoryServiceProvider2;
    int refCount = 0;
    String mozillaPath;
    String profilePath;
    String cacheParentPath;
    String[] pluginDirs;
    boolean isXULRunner;
    static final String SEPARATOR_OS = System.getProperty("file.separator");
    static final String CHROME_DIR = "chrome";
    static final String COMPONENTS_DIR = "components";
    static final String HISTORY_FILE = "history.dat";
    static final String LOCALSTORE_FILE = "localstore.rdf";
    static final String MIMETYPES_FILE = "mimeTypes.rdf";
    static final String MOZILLA_PLUGIN_PATH = "MOZ_PLUGIN_PATH";
    static final String PLUGINS_DIR = "plugins";
    static final String USER_PLUGINS_DIR = ".mozilla" + SEPARATOR_OS + "plugins";
    static final String PREFERENCES_FILE = "prefs.js";
    static boolean IsSparc;

    AppFileLocProvider(String string, String string2, String string3, boolean bl2) {
        this.mozillaPath = string + SEPARATOR_OS;
        this.profilePath = string2 + SEPARATOR_OS;
        this.cacheParentPath = string3;
        this.isXULRunner = bl2;
        if (!Compatibility.fileExists(string2, "")) {
            int[] nArray = new int[1];
            nsEmbedString nsEmbedString2 = new nsEmbedString(string2);
            int n2 = XPCOM.NS_NewLocalFile(nsEmbedString2.getAddress(), 1, nArray);
            if (n2 != 0) {
                Mozilla.error(n2);
            }
            if (nArray[0] == 0) {
                Mozilla.error(-2147467261);
            }
            nsEmbedString2.dispose();
            nsILocalFile nsILocalFile2 = new nsILocalFile(nArray[0]);
            n2 = nsILocalFile2.Create(1, 448);
            if (n2 != 0) {
                Mozilla.error(n2);
            }
            nsILocalFile2.Release();
        }
        this.createCOMInterfaces();
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    void createCOMInterfaces() {
        this.supports = new AppFileLocProvider$1(this, new int[]{2, 0, 0});
        this.directoryServiceProvider = new AppFileLocProvider$2(this, new int[]{2, 0, 0, 3});
        this.directoryServiceProvider2 = new AppFileLocProvider$3(this, new int[]{2, 0, 0, 3, 2});
    }

    void disposeCOMInterfaces() {
        if (this.supports != null) {
            this.supports.dispose();
            this.supports = null;
        }
        if (this.directoryServiceProvider != null) {
            this.directoryServiceProvider.dispose();
            this.directoryServiceProvider = null;
        }
        if (this.directoryServiceProvider2 != null) {
            this.directoryServiceProvider2.dispose();
            this.directoryServiceProvider2 = null;
        }
    }

    int getAddress() {
        return this.directoryServiceProvider.getAddress();
    }

    int QueryInterface(int n2, int n3) {
        if (n2 == 0 || n3 == 0) {
            return -2147467262;
        }
        nsID nsID2 = new nsID();
        XPCOM.memmove(nsID2, n2, 16);
        if (nsID2.Equals(XPCOM.NS_ISUPPORTS_IID)) {
            XPCOM.memmove(n3, new int[]{this.supports.getAddress()}, C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (nsID2.Equals(XPCOM.NS_IDIRECTORYSERVICEPROVIDER_IID)) {
            XPCOM.memmove(n3, new int[]{this.directoryServiceProvider.getAddress()}, C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (nsID2.Equals(XPCOM.NS_IDIRECTORYSERVICEPROVIDER2_IID)) {
            XPCOM.memmove(n3, new int[]{this.directoryServiceProvider2.getAddress()}, C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        XPCOM.memmove(n3, new int[]{0}, C.PTR_SIZEOF);
        return -2147467262;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    int getFiles(int n2, int n3) {
        Object object;
        Object object2;
        int n4;
        int n5 = XPCOM.strlen(n2);
        byte[] byArray = new byte[n5];
        XPCOM.memmove(byArray, n2, n5);
        String string = new String(MozillaDelegate.mbcsToWcs(null, byArray));
        String[] stringArray = null;
        if (string.equals("APluginsDL")) {
            if (this.pluginDirs == null) {
                int n6 = 0;
                int n7 = C.getenv(MozillaDelegate.wcsToMbcs(null, MOZILLA_PLUGIN_PATH, true));
                if (n7 != 0) {
                    n4 = C.strlen(n7);
                    byte[] byArray2 = new byte[n4];
                    C.memmove(byArray2, n7, n4);
                    object2 = new String(MozillaDelegate.mbcsToWcs(null, byArray2));
                    if (((String)object2).length() > 0) {
                        String string2 = System.getProperty("path.separator");
                        object = new ArrayList();
                        int n8 = -1;
                        do {
                            int n9;
                            String string3;
                            if ((string3 = (n8 = ((String)object2).indexOf(string2, n9 = n8 + 1)) == -1 ? ((String)object2).substring(n9) : ((String)object2).substring(n9, n8)).length() <= 0) continue;
                            object.add(string3);
                        } while (n8 != -1);
                        int n10 = object.size();
                        this.pluginDirs = new String[n10 + (IsSparc ? 1 : 2)];
                        for (n6 = 0; n6 < n10; ++n6) {
                            this.pluginDirs[n6] = (String)object.get(n6);
                        }
                    }
                }
                if (this.pluginDirs == null) {
                    this.pluginDirs = new String[IsSparc ? 1 : 2];
                }
                if (!IsSparc) {
                    this.pluginDirs[n6++] = this.mozillaPath + PLUGINS_DIR;
                }
                this.pluginDirs[n6++] = System.getProperty("user.home") + SEPARATOR_OS + USER_PLUGINS_DIR;
            }
            stringArray = this.pluginDirs;
        }
        XPCOM.memmove(n3, new int[]{0}, C.PTR_SIZEOF);
        if (stringArray != null) {
            int[] nArray = new int[1];
            nsISupports[] nsISupportsArray = new nsISupports[stringArray.length];
            n4 = 0;
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                object2 = new nsEmbedString(stringArray[i2]);
                int n11 = XPCOM.NS_NewLocalFile(((nsEmbedString)object2).getAddress(), 1, nArray);
                if (n11 != -2142109695) {
                    if (n11 != 0) {
                        Mozilla.error(n11);
                    }
                    if (nArray[0] == 0) {
                        Mozilla.error(-2147467261);
                    }
                    object = new nsILocalFile(nArray[0]);
                    nArray[0] = 0;
                    n11 = ((nsISupports)object).QueryInterface(IIDStore.GetIID(nsIFile.class), nArray);
                    if (n11 != 0) {
                        Mozilla.error(n11);
                    }
                    if (nArray[0] == 0) {
                        Mozilla.error(-2147467262);
                    }
                    ((nsISupports)object).Release();
                    nsIFile nsIFile2 = new nsIFile(nArray[0]);
                    nsISupportsArray[n4++] = nsIFile2;
                }
                ((nsEmbedString)object2).dispose();
                nArray[0] = 0;
            }
            if (n4 < stringArray.length) {
                nsISupports[] nsISupportsArray2 = new nsISupports[n4];
                System.arraycopy(nsISupportsArray, 0, nsISupportsArray2, 0, n4);
                nsISupportsArray = nsISupportsArray2;
            }
            SimpleEnumerator simpleEnumerator = new SimpleEnumerator(nsISupportsArray);
            simpleEnumerator.AddRef();
            XPCOM.memmove(n3, new int[]{simpleEnumerator.getAddress()}, C.PTR_SIZEOF);
            return 0;
        }
        return -2147467259;
    }

    int getFile(int n2, int n3, int n4) {
        int n5 = XPCOM.strlen(n2);
        byte[] byArray = new byte[n5];
        XPCOM.memmove(byArray, n2, n5);
        String string = new String(MozillaDelegate.mbcsToWcs(null, byArray));
        String string2 = null;
        if (string.equals("UHist")) {
            string2 = this.profilePath + HISTORY_FILE;
        } else if (string.equals("UMimTyp")) {
            string2 = this.profilePath + MIMETYPES_FILE;
        } else if (string.equals("PrefF")) {
            string2 = this.profilePath + PREFERENCES_FILE;
        } else if (string.equals("PrefD")) {
            string2 = this.profilePath;
        } else if (string.equals("UChrm")) {
            string2 = this.profilePath + CHROME_DIR;
        } else if (string.equals("ProfD")) {
            string2 = this.profilePath;
        } else if (string.equals("LclSt")) {
            string2 = this.profilePath + LOCALSTORE_FILE;
        } else if (string.equals("cachePDir")) {
            string2 = this.cacheParentPath;
        } else if (string.equals("Home")) {
            string2 = System.getProperty("user.home");
        } else if (string.equals("TmpD")) {
            string2 = System.getProperty("java.io.tmpdir");
        } else if (string.equals("GreD")) {
            string2 = this.mozillaPath;
        } else if (string.equals("GreComsD")) {
            string2 = MozillaVersion.CheckVersion(6, false) ? this.mozillaPath + COMPONENTS_DIR : this.profilePath + COMPONENTS_DIR;
        } else if (string.equals("MozBinD")) {
            string2 = this.mozillaPath;
        } else if (string.equals("CurProcD")) {
            string2 = this.mozillaPath;
        } else if (string.equals("ComsD")) {
            string2 = MozillaVersion.CheckVersion(6, false) ? this.profilePath + COMPONENTS_DIR : this.mozillaPath + COMPONENTS_DIR;
        } else if (string.equals("XCurProcD")) {
            string2 = MozillaVersion.CheckVersion(6, false) ? this.profilePath : this.mozillaPath;
        } else if (string.equals("PrfDef") && this.isXULRunner) {
            string2 = this.profilePath;
        }
        XPCOM.memmove(n3, new boolean[]{true});
        XPCOM.memmove(n4, new int[]{0}, C.PTR_SIZEOF);
        if (string2 != null && string2.length() > 0) {
            int[] nArray = new int[1];
            nsEmbedString nsEmbedString2 = new nsEmbedString(string2);
            int n6 = XPCOM.NS_NewLocalFile(nsEmbedString2.getAddress(), 1, nArray);
            if (n6 != 0) {
                Mozilla.error(n6);
            }
            if (nArray[0] == 0) {
                Mozilla.error(-2147467261);
            }
            nsEmbedString2.dispose();
            nsILocalFile nsILocalFile2 = new nsILocalFile(nArray[0]);
            nArray[0] = 0;
            n6 = nsILocalFile2.QueryInterface(IIDStore.GetIID(nsIFile.class), nArray);
            if (n6 != 0) {
                Mozilla.error(n6);
            }
            if (nArray[0] == 0) {
                Mozilla.error(-2147467262);
            }
            XPCOM.memmove(n4, new int[]{nArray[0]}, C.PTR_SIZEOF);
            nsILocalFile2.Release();
            return 0;
        }
        return -2147467259;
    }

    static {
        String string = System.getProperty("os.name").toLowerCase();
        String string2 = System.getProperty("os.arch").toLowerCase();
        IsSparc = (string.startsWith("sunos") || string.startsWith("solaris")) && string2.startsWith("sparc");
    }
}

