/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.FilePicker$1;
import org.eclipse.swt.browser.FilePicker$2;
import org.eclipse.swt.browser.Mozilla;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.mozilla.IIDStore;
import org.eclipse.swt.internal.mozilla.XPCOM;
import org.eclipse.swt.internal.mozilla.XPCOMObject;
import org.eclipse.swt.internal.mozilla.nsEmbedString;
import org.eclipse.swt.internal.mozilla.nsID;
import org.eclipse.swt.internal.mozilla.nsIFilePicker;
import org.eclipse.swt.internal.mozilla.nsILocalFile;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

class FilePicker {
    XPCOMObject supports;
    XPCOMObject filePicker;
    int refCount = 0;
    short mode;
    int parentHandle;
    String[] files;
    String[] masks;
    String defaultFilename;
    String directory;
    String title;
    static final String SEPARATOR = System.getProperty("file.separator");

    FilePicker() {
        this.createCOMInterfaces();
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    void createCOMInterfaces() {
        this.supports = new FilePicker$1(this, new int[]{2, 0, 0});
        this.filePicker = new FilePicker$2(this, new int[]{2, 0, 0, 3, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1});
    }

    void disposeCOMInterfaces() {
        if (this.supports != null) {
            this.supports.dispose();
            this.supports = null;
        }
        if (this.filePicker != null) {
            this.filePicker.dispose();
            this.filePicker = null;
        }
    }

    int getAddress() {
        return this.filePicker.getAddress();
    }

    int QueryInterface(int n2, int n3) {
        if (n2 == 0 || n3 == 0) {
            return -2147467262;
        }
        nsID nsID2 = new nsID();
        XPCOM.memmove(nsID2, n2, 16);
        if (nsID2.Equals(XPCOM.NS_ISUPPORTS_IID)) {
            XPCOM.memmove(n3, new int[]{this.supports.getAddress()}, C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (nsID2.Equals(IIDStore.GetIID(nsIFilePicker.class))) {
            XPCOM.memmove(n3, new int[]{this.filePicker.getAddress()}, C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        XPCOM.memmove(n3, new int[]{0}, C.PTR_SIZEOF);
        return -2147467262;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    Browser getBrowser(int n2) {
        if (n2 == 0) {
            return null;
        }
        return Mozilla.getBrowser(n2);
    }

    String parseAString(int n2) {
        return null;
    }

    int Init(int n2, int n3, short s2) {
        this.parentHandle = n2;
        this.mode = s2;
        this.title = this.parseAString(n3);
        return 0;
    }

    int Show(int n2) {
        int n3;
        if (this.mode == 2) {
            int n4 = this.showDirectoryPicker();
            XPCOM.memmove(n2, new short[]{(short)n4}, 2);
            return 0;
        }
        int n5 = n3 = this.mode == 1 ? 8192 : 4096;
        if (this.mode == 3) {
            n3 |= 2;
        }
        Browser browser = this.getBrowser(this.parentHandle);
        Shell shell = null;
        shell = browser != null ? browser.getShell() : new Shell();
        FileDialog fileDialog = new FileDialog(shell, n3);
        if (this.title != null) {
            fileDialog.setText(this.title);
        }
        if (this.directory != null) {
            fileDialog.setFilterPath(this.directory);
        }
        if (this.masks != null) {
            fileDialog.setFilterExtensions(this.masks);
        }
        if (this.defaultFilename != null) {
            fileDialog.setFileName(this.defaultFilename);
        }
        String string = fileDialog.open();
        this.files = fileDialog.getFileNames();
        this.directory = fileDialog.getFilterPath();
        this.defaultFilename = null;
        this.title = null;
        this.masks = null;
        boolean bl2 = string == null;
        XPCOM.memmove(n2, new short[]{(short)(bl2 ? 1 : 0)}, 2);
        return 0;
    }

    int showDirectoryPicker() {
        Browser browser = this.getBrowser(this.parentHandle);
        Shell shell = null;
        shell = browser != null ? browser.getShell() : new Shell();
        DirectoryDialog directoryDialog = new DirectoryDialog(shell, 0);
        if (this.title != null) {
            directoryDialog.setText(this.title);
        }
        if (this.directory != null) {
            directoryDialog.setFilterPath(this.directory);
        }
        this.directory = directoryDialog.open();
        this.defaultFilename = null;
        this.title = null;
        this.masks = null;
        this.files = null;
        return this.directory == null ? 1 : 0;
    }

    int GetFiles(int n2) {
        return -2147467263;
    }

    int GetFileURL(int n2) {
        return -2147467263;
    }

    int GetFile(int n2) {
        String string = "";
        if (this.directory != null) {
            string = string + this.directory + SEPARATOR;
        }
        if (this.files != null && this.files.length > 0) {
            string = string + this.files[0];
        }
        nsEmbedString nsEmbedString2 = new nsEmbedString(string);
        int[] nArray = new int[1];
        int n3 = XPCOM.NS_NewLocalFile(nsEmbedString2.getAddress(), 1, nArray);
        nsEmbedString2.dispose();
        if (n3 != 0) {
            Mozilla.error(n3);
        }
        if (nArray[0] == 0) {
            Mozilla.error(-2147467261);
        }
        XPCOM.memmove(n2, nArray, C.PTR_SIZEOF);
        return 0;
    }

    int SetDisplayDirectory(int n2) {
        if (n2 == 0) {
            return 0;
        }
        nsILocalFile nsILocalFile2 = new nsILocalFile(n2);
        nsEmbedString nsEmbedString2 = new nsEmbedString();
        int n3 = nsILocalFile2.GetPath(nsEmbedString2.getAddress());
        if (n3 != 0) {
            Mozilla.error(n3);
        }
        this.directory = nsEmbedString2.toString();
        nsEmbedString2.dispose();
        return 0;
    }

    int GetDisplayDirectory(int n2) {
        String string = this.directory != null ? this.directory : "";
        nsEmbedString nsEmbedString2 = new nsEmbedString(string);
        int[] nArray = new int[1];
        int n3 = XPCOM.NS_NewLocalFile(nsEmbedString2.getAddress(), 1, nArray);
        nsEmbedString2.dispose();
        if (n3 != 0) {
            Mozilla.error(n3);
        }
        if (nArray[0] == 0) {
            Mozilla.error(-2147467261);
        }
        XPCOM.memmove(n2, nArray, C.PTR_SIZEOF);
        return 0;
    }

    int SetFilterIndex(int n2) {
        return -2147467263;
    }

    int GetFilterIndex(int n2) {
        return -2147467263;
    }

    int SetDefaultExtension(int n2) {
        return -2147467263;
    }

    int GetDefaultExtension(int n2) {
        return -2147467263;
    }

    int SetDefaultString(int n2) {
        this.defaultFilename = this.parseAString(n2);
        return 0;
    }

    int GetDefaultString(int n2) {
        return -2147467263;
    }

    int AppendFilter(int n2, int n3) {
        return -2147467263;
    }

    int AppendFilters(int n2) {
        String[] stringArray = null;
        switch (n2) {
            case 1: 
            case 64: {
                this.masks = null;
                break;
            }
            case 2: {
                stringArray = new String[]{"*.htm;*.html"};
                break;
            }
            case 8: {
                stringArray = new String[]{"*.gif;*.jpeg;*.jpg;*.png"};
                break;
            }
            case 4: {
                stringArray = new String[]{"*.txt"};
                break;
            }
            case 16: {
                stringArray = new String[]{"*.xml"};
                break;
            }
            case 32: {
                stringArray = new String[]{"*.xul"};
            }
        }
        if (this.masks == null) {
            this.masks = stringArray;
        } else if (stringArray != null) {
            String[] stringArray2 = new String[this.masks.length + stringArray.length];
            System.arraycopy(this.masks, 0, stringArray2, 0, this.masks.length);
            System.arraycopy(stringArray, 0, stringArray2, this.masks.length, stringArray.length);
            this.masks = stringArray2;
        }
        return 0;
    }
}

