/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.accessibility.AccessibleTextEvent;
import org.eclipse.swt.accessibility.AccessibleTextExtendedAdapter;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

class StyledText$7
extends AccessibleTextExtendedAdapter {
    final /* synthetic */ StyledText this$0;

    StyledText$7(StyledText styledText) {
        this.this$0 = styledText;
    }

    @Override
    public void getCaretOffset(AccessibleTextEvent accessibleTextEvent) {
        accessibleTextEvent.offset = this.this$0.getCaretOffset();
    }

    @Override
    public void setCaretOffset(AccessibleTextEvent accessibleTextEvent) {
        this.this$0.setCaretOffset(accessibleTextEvent.offset);
        accessibleTextEvent.result = "OK";
    }

    @Override
    public void getSelectionRange(AccessibleTextEvent accessibleTextEvent) {
        Point point = this.this$0.getSelectionRange();
        accessibleTextEvent.offset = point.x;
        accessibleTextEvent.length = point.y;
    }

    @Override
    public void addSelection(AccessibleTextEvent accessibleTextEvent) {
        StyledText styledText = this.this$0;
        Point point = styledText.getSelection();
        if (point.x == point.y) {
            int n2 = accessibleTextEvent.end;
            if (n2 == -1) {
                n2 = styledText.getCharCount();
            }
            styledText.setSelection(accessibleTextEvent.start, n2);
            accessibleTextEvent.result = "OK";
        }
    }

    @Override
    public void getSelection(AccessibleTextEvent accessibleTextEvent) {
        StyledText styledText = this.this$0;
        if (styledText.blockSelection && styledText.blockXLocation != -1) {
            Rectangle rectangle = styledText.getBlockSelectionPosition();
            int n2 = rectangle.y + accessibleTextEvent.index;
            int n3 = styledText.getLinePixel(n2);
            accessibleTextEvent.ranges = this.getRanges(rectangle.x, n3, rectangle.width, n3);
            if (accessibleTextEvent.ranges.length > 0) {
                accessibleTextEvent.start = accessibleTextEvent.ranges[0];
                accessibleTextEvent.end = accessibleTextEvent.ranges[accessibleTextEvent.ranges.length - 1];
            }
        } else if (accessibleTextEvent.index == 0) {
            Point point = styledText.getSelection();
            accessibleTextEvent.start = point.x;
            accessibleTextEvent.end = point.y;
            if (accessibleTextEvent.start > accessibleTextEvent.end) {
                int n4 = accessibleTextEvent.start;
                accessibleTextEvent.start = accessibleTextEvent.end;
                accessibleTextEvent.end = n4;
            }
        }
    }

    @Override
    public void getSelectionCount(AccessibleTextEvent accessibleTextEvent) {
        StyledText styledText = this.this$0;
        if (styledText.blockSelection && styledText.blockXLocation != -1) {
            Rectangle rectangle = styledText.getBlockSelectionPosition();
            accessibleTextEvent.count = rectangle.height - rectangle.y + 1;
        } else {
            Point point = styledText.getSelection();
            accessibleTextEvent.count = point.x == point.y ? 0 : 1;
        }
    }

    @Override
    public void removeSelection(AccessibleTextEvent accessibleTextEvent) {
        StyledText styledText = this.this$0;
        if (accessibleTextEvent.index == 0) {
            if (styledText.blockSelection) {
                styledText.clearBlockSelection(true, false);
            } else {
                styledText.clearSelection(false);
            }
            accessibleTextEvent.result = "OK";
        }
    }

    @Override
    public void setSelection(AccessibleTextEvent accessibleTextEvent) {
        if (accessibleTextEvent.index != 0) {
            return;
        }
        StyledText styledText = this.this$0;
        Point point = styledText.getSelection();
        if (point.x == point.y) {
            return;
        }
        int n2 = accessibleTextEvent.end;
        if (n2 == -1) {
            n2 = styledText.getCharCount();
        }
        styledText.setSelection(accessibleTextEvent.start, n2);
        accessibleTextEvent.result = "OK";
    }

    @Override
    public void getCharacterCount(AccessibleTextEvent accessibleTextEvent) {
        accessibleTextEvent.count = this.this$0.getCharCount();
    }

    @Override
    public void getOffsetAtPoint(AccessibleTextEvent accessibleTextEvent) {
        StyledText styledText = this.this$0;
        Point point = new Point(accessibleTextEvent.x, accessibleTextEvent.y);
        Display display = styledText.getDisplay();
        point = display.map(null, (Control)styledText, point);
        accessibleTextEvent.offset = styledText.getOffsetAtPoint(point.x, point.y, null, true);
    }

    @Override
    public void getTextBounds(AccessibleTextEvent accessibleTextEvent) {
        int n2;
        StyledText styledText = this.this$0;
        int n3 = accessibleTextEvent.start;
        int n4 = accessibleTextEvent.end;
        int n5 = styledText.getCharCount();
        if ((n3 = Math.max(0, Math.min(n3, n5))) > (n4 = Math.max(0, Math.min(n4, n5)))) {
            n2 = n3;
            n3 = n4;
            n4 = n2;
        }
        n2 = styledText.getLineAtOffset(n3);
        int n6 = styledText.getLineAtOffset(n4);
        Rectangle[] rectangleArray = new Rectangle[n6 - n2 + 1];
        Rectangle rectangle = null;
        int n7 = 0;
        Display display = styledText.getDisplay();
        for (int i2 = n2; i2 <= n6; ++i2) {
            Rectangle rectangle2 = new Rectangle(0, 0, 0, 0);
            rectangle2.y = styledText.getLinePixel(i2);
            rectangle2.height = styledText.renderer.getLineHeight(i2);
            rectangle2.x = i2 == n2 ? styledText.getPointAtOffset((int)n3).x : styledText.leftMargin - styledText.horizontalScrollOffset;
            if (i2 == n6) {
                rectangle2.width = styledText.getPointAtOffset((int)n4).x - rectangle2.x;
            } else {
                TextLayout textLayout = styledText.renderer.getTextLayout(i2);
                rectangle2.width = textLayout.getBounds().width - rectangle2.x;
                styledText.renderer.disposeTextLayout(textLayout);
            }
            rectangleArray[n7++] = rectangle2 = display.map((Control)styledText, null, rectangle2);
            if (rectangle == null) {
                rectangle = new Rectangle(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                continue;
            }
            rectangle.add(rectangle2);
        }
        accessibleTextEvent.rectangles = rectangleArray;
        if (rectangle != null) {
            accessibleTextEvent.x = rectangle.x;
            accessibleTextEvent.y = rectangle.y;
            accessibleTextEvent.width = rectangle.width;
            accessibleTextEvent.height = rectangle.height;
        }
    }

    int[] getRanges(int n2, int n3, int n4, int n5) {
        StyledText styledText = this.this$0;
        int n6 = styledText.getLineIndex(n3);
        int n7 = styledText.getLineIndex(n5);
        int n8 = n7 - n6 + 1;
        int[] nArray = new int[n8 * 2];
        int n9 = 0;
        for (int i2 = n6; i2 <= n7; ++i2) {
            int[] nArray2;
            int n10;
            String string = styledText.content.getLine(i2);
            int n11 = styledText.content.getOffsetAtLine(i2);
            int n12 = n11 + string.length();
            int n13 = styledText.getLinePixel(i2);
            int n14 = styledText.getOffsetAtPoint(n2, n13, null, true);
            if (n14 == -1) {
                int n15 = n14 = n2 < styledText.leftMargin ? n11 : n12;
            }
            n10 = (n10 = styledText.getOffsetAtPoint(n4, n13, nArray2 = new int[1], true)) == -1 ? (n4 < styledText.leftMargin ? n11 : n12) : (n10 += nArray2[0]);
            if (n14 > n10) {
                int n16 = n14;
                n14 = n10;
                n10 = n16;
            }
            nArray[n9++] = n14;
            nArray[n9++] = n10;
        }
        return nArray;
    }

    @Override
    public void getRanges(AccessibleTextEvent accessibleTextEvent) {
        StyledText styledText = this.this$0;
        Point point = new Point(accessibleTextEvent.x, accessibleTextEvent.y);
        Display display = styledText.getDisplay();
        point = display.map(null, (Control)styledText, point);
        accessibleTextEvent.ranges = this.getRanges(point.x, point.y, point.x + accessibleTextEvent.width, point.y + accessibleTextEvent.height);
        if (accessibleTextEvent.ranges.length > 0) {
            accessibleTextEvent.start = accessibleTextEvent.ranges[0];
            accessibleTextEvent.end = accessibleTextEvent.ranges[accessibleTextEvent.ranges.length - 1];
        }
    }

    @Override
    public void getText(AccessibleTextEvent accessibleTextEvent) {
        int n2;
        StyledText styledText = this.this$0;
        int n3 = accessibleTextEvent.start;
        int n4 = accessibleTextEvent.end;
        int n5 = styledText.getCharCount();
        if (n4 == -1) {
            n4 = n5;
        }
        if ((n3 = Math.max(0, Math.min(n3, n5))) > (n4 = Math.max(0, Math.min(n4, n5)))) {
            n2 = n3;
            n3 = n4;
            n4 = n2;
        }
        n2 = accessibleTextEvent.count;
        switch (accessibleTextEvent.type) {
            case 5: {
                break;
            }
            case 0: {
                int n6 = 0;
                if (n2 > 0) {
                    int n7;
                    while (n2-- > 0 && (n7 = styledText.getWordNext(n4, 2)) != n5 && n7 != n4) {
                        n4 = n7;
                        ++n6;
                    }
                    n3 = n4;
                    n4 = styledText.getWordNext(n4, 2);
                } else {
                    int n8;
                    while (n2++ < 0 && (n8 = styledText.getWordPrevious(n3, 2)) != n3) {
                        n3 = n8;
                        --n6;
                    }
                    n4 = styledText.getWordNext(n3, 2);
                }
                n2 = n6;
                break;
            }
            case 1: {
                int n9 = 0;
                if (n2 > 0) {
                    int n10;
                    while (n2-- > 0 && (n10 = styledText.getWordNext(n4, 16, true)) != n4) {
                        ++n9;
                        n4 = n10;
                    }
                    n3 = n4;
                    n4 = styledText.getWordNext(n3, 8, true);
                } else {
                    int n11;
                    if (styledText.getWordPrevious(Math.min(n3 + 1, n5), 16, true) == n3) {
                        ++n2;
                    }
                    while (n2 <= 0 && (n11 = styledText.getWordPrevious(n3, 16, true)) != n3) {
                        n3 = n11;
                        if (++n2 == 0) continue;
                        --n9;
                    }
                    n4 = n2 <= 0 && n3 == 0 ? n3 : styledText.getWordNext(n3, 8, true);
                }
                n2 = n9;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                int n12 = n2 > 0 ? n4 : n3;
                int n13 = styledText.getLineAtOffset(n12) + n2;
                n13 = Math.max(0, Math.min(n13, styledText.getLineCount() - 1));
                n3 = styledText.getOffsetAtLine(n13);
                String string = styledText.getLine(n13);
                n4 = n3 + string.length();
                n2 = n13 - styledText.getLineAtOffset(n12);
                break;
            }
        }
        accessibleTextEvent.start = n3;
        accessibleTextEvent.end = n4;
        accessibleTextEvent.count = n2;
        accessibleTextEvent.result = styledText.content.getTextRange(n3, n4 - n3);
    }

    @Override
    public void getVisibleRanges(AccessibleTextEvent accessibleTextEvent) {
        accessibleTextEvent.ranges = this.getRanges(this.this$0.leftMargin, this.this$0.topMargin, this.this$0.clientAreaWidth - this.this$0.rightMargin, this.this$0.clientAreaHeight - this.this$0.bottomMargin);
        if (accessibleTextEvent.ranges.length > 0) {
            accessibleTextEvent.start = accessibleTextEvent.ranges[0];
            accessibleTextEvent.end = accessibleTextEvent.ranges[accessibleTextEvent.ranges.length - 1];
        }
    }

    @Override
    public void scrollText(AccessibleTextEvent accessibleTextEvent) {
        StyledText styledText = this.this$0;
        int n2 = this.this$0.getTopPixel();
        int n3 = styledText.getHorizontalPixel();
        switch (accessibleTextEvent.type) {
            case 0: 
            case 2: 
            case 4: 
            case 6: {
                Rectangle rectangle = styledText.getBoundsAtOffset(accessibleTextEvent.start);
                if (accessibleTextEvent.type != 2) {
                    n3 = n3 + rectangle.x - styledText.leftMargin;
                }
                if (accessibleTextEvent.type == 4) break;
                n2 = n2 + rectangle.y - styledText.topMargin;
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                Rectangle rectangle = styledText.getBoundsAtOffset(accessibleTextEvent.end - 1);
                if (accessibleTextEvent.type != 3) {
                    n3 = n3 - styledText.clientAreaWidth + rectangle.x + rectangle.width + styledText.rightMargin;
                }
                if (accessibleTextEvent.type == 5) break;
                n2 = n2 - styledText.clientAreaHeight + rectangle.y + rectangle.height + styledText.bottomMargin;
                break;
            }
            case 7: {
                Point point = new Point(accessibleTextEvent.x, accessibleTextEvent.y);
                Display display = styledText.getDisplay();
                point = display.map(null, (Control)styledText, point);
                Rectangle rectangle = styledText.getBoundsAtOffset(accessibleTextEvent.start);
                n2 = n2 - point.y + rectangle.y;
                n3 = n3 - point.x + rectangle.x;
                break;
            }
        }
        styledText.setTopPixel(n2);
        styledText.setHorizontalPixel(n3);
        accessibleTextEvent.result = "OK";
    }
}

