/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.TableTreeEditor$1;
import org.eclipse.swt.custom.TableTreeEditor$2;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class TableTreeEditor
extends ControlEditor {
    TableTree tableTree;
    TableTreeItem item;
    int column = -1;
    ControlListener columnListener;
    TreeListener treeListener;

    public TableTreeEditor(TableTree tableTree) {
        super(tableTree.getTable());
        this.tableTree = tableTree;
        this.treeListener = new TableTreeEditor$1(this);
        tableTree.addTreeListener(this.treeListener);
        this.columnListener = new TableTreeEditor$2(this);
        this.grabVertical = true;
    }

    @Override
    Rectangle computeBounds() {
        if (this.item == null || this.column == -1 || this.item.isDisposed() || this.item.tableItem == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rectangle rectangle = this.item.getBounds(this.column);
        Rectangle rectangle2 = this.tableTree.getClientArea();
        if (rectangle.x < rectangle2.x + rectangle2.width && rectangle.x + rectangle.width > rectangle2.x + rectangle2.width) {
            rectangle.width = rectangle2.x + rectangle2.width - rectangle.x;
        }
        Rectangle rectangle3 = new Rectangle(rectangle.x, rectangle.y, this.minimumWidth, this.minimumHeight);
        if (this.grabHorizontal) {
            rectangle3.width = Math.max(rectangle.width, this.minimumWidth);
        }
        if (this.grabVertical) {
            rectangle3.height = Math.max(rectangle.height, this.minimumHeight);
        }
        if (this.horizontalAlignment == 131072) {
            rectangle3.x += rectangle.width - rectangle3.width;
        } else if (this.horizontalAlignment != 16384) {
            rectangle3.x += (rectangle.width - rectangle3.width) / 2;
        }
        if (this.verticalAlignment == 1024) {
            rectangle3.y += rectangle.height - rectangle3.height;
        } else if (this.verticalAlignment != 128) {
            rectangle3.y += (rectangle.height - rectangle3.height) / 2;
        }
        return rectangle3;
    }

    @Override
    public void dispose() {
        if (this.tableTree != null && !this.tableTree.isDisposed()) {
            Table table = this.tableTree.getTable();
            if (table != null && !table.isDisposed() && this.column > -1 && this.column < table.getColumnCount()) {
                TableColumn tableColumn = table.getColumn(this.column);
                tableColumn.removeControlListener(this.columnListener);
            }
            if (this.treeListener != null) {
                this.tableTree.removeTreeListener(this.treeListener);
            }
        }
        this.treeListener = null;
        this.columnListener = null;
        this.tableTree = null;
        this.item = null;
        this.column = -1;
        super.dispose();
    }

    public int getColumn() {
        return this.column;
    }

    public TableTreeItem getItem() {
        return this.item;
    }

    public void setColumn(int n2) {
        TableColumn tableColumn;
        Table table = this.tableTree.getTable();
        int n3 = table.getColumnCount();
        if (n3 == 0) {
            this.column = n2 == 0 ? 0 : -1;
            this.layout();
            return;
        }
        if (this.column > -1 && this.column < n3) {
            tableColumn = table.getColumn(this.column);
            tableColumn.removeControlListener(this.columnListener);
            this.column = -1;
        }
        if (n2 < 0 || n2 >= table.getColumnCount()) {
            return;
        }
        this.column = n2;
        tableColumn = table.getColumn(this.column);
        tableColumn.addControlListener(this.columnListener);
        this.layout();
    }

    public void setItem(TableTreeItem tableTreeItem) {
        this.item = tableTreeItem;
        this.layout();
    }

    public void setEditor(Control control, TableTreeItem tableTreeItem, int n2) {
        this.setItem(tableTreeItem);
        this.setColumn(n2);
        this.setEditor(control);
    }

    @Override
    public void layout() {
        if (this.tableTree == null || this.tableTree.isDisposed()) {
            return;
        }
        if (this.item == null || this.item.isDisposed()) {
            return;
        }
        Table table = this.tableTree.getTable();
        int n2 = table.getColumnCount();
        if (n2 == 0 && this.column != 0) {
            return;
        }
        if (n2 > 0 && (this.column < 0 || this.column >= n2)) {
            return;
        }
        super.layout();
    }
}

