/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DNDEvent;
import org.eclipse.swt.dnd.DNDListener;
import org.eclipse.swt.dnd.DragSource$1;
import org.eclipse.swt.dnd.DragSource$2;
import org.eclipse.swt.dnd.DragSourceEffect;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.OleEnumFORMATETC;
import org.eclipse.swt.dnd.TableDragSourceEffect;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.dnd.TreeDragSourceEffect;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.COMObject;
import org.eclipse.swt.internal.ole.win32.FORMATETC;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.STGMEDIUM;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class DragSource
extends Widget {
    Control control;
    Listener controlListener;
    Transfer[] transferAgents = new Transfer[0];
    DragSourceEffect dragEffect;
    Composite topControl;
    int hwndDrag;
    COMObject iDropSource;
    COMObject iDataObject;
    int refCount;
    int dataEffect = 0;
    static final String DEFAULT_DRAG_SOURCE_EFFECT = "DEFAULT_DRAG_SOURCE_EFFECT";
    static final int CFSTR_PERFORMEDDROPEFFECT = Transfer.registerType("Performed DropEffect");
    static final TCHAR WindowClass = new TCHAR(0, "#32770", true);

    public DragSource(Control control, int n2) {
        super(control, DragSource.checkStyle(n2));
        this.control = control;
        if (control.getData("DragSource") != null) {
            DND.error(2000);
        }
        control.setData("DragSource", this);
        this.createCOMInterfaces();
        this.AddRef();
        this.controlListener = event -> {
            if (event.type == 12 && !this.isDisposed()) {
                this.dispose();
            }
            if (event.type == 29 && !this.isDisposed()) {
                this.drag(event);
            }
        };
        control.addListener(12, this.controlListener);
        control.addListener(29, this.controlListener);
        this.addListener(12, event -> this.onDispose());
        Object object = control.getData(DEFAULT_DRAG_SOURCE_EFFECT);
        if (object instanceof DragSourceEffect) {
            this.dragEffect = (DragSourceEffect)object;
        } else if (control instanceof Tree) {
            this.dragEffect = new TreeDragSourceEffect((Tree)control);
        } else if (control instanceof Table) {
            this.dragEffect = new TableDragSourceEffect((Table)control);
        }
    }

    static int checkStyle(int n2) {
        if (n2 == 0) {
            return 2;
        }
        return n2;
    }

    public void addDragListener(DragSourceListener dragSourceListener) {
        if (dragSourceListener == null) {
            DND.error(4);
        }
        DNDListener dNDListener = new DNDListener(dragSourceListener);
        dNDListener.dndWidget = this;
        this.addListener(2008, dNDListener);
        this.addListener(2001, dNDListener);
        this.addListener(2000, dNDListener);
    }

    private int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    private void createCOMInterfaces() {
        this.iDropSource = new DragSource$1(this, new int[]{2, 0, 0, 2, 1});
        this.iDataObject = new DragSource$2(this, new int[]{2, 0, 0, 2, 2, 1, 2, 3, 2, 4, 1, 1});
    }

    @Override
    protected void checkSubclass() {
        String string = this.getClass().getName();
        String string2 = DragSource.class.getName();
        if (!string2.equals(string)) {
            DND.error(43);
        }
    }

    private void disposeCOMInterfaces() {
        if (this.iDropSource != null) {
            this.iDropSource.dispose();
        }
        this.iDropSource = null;
        if (this.iDataObject != null) {
            this.iDataObject.dispose();
        }
        this.iDataObject = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drag(Event event) {
        int n2;
        DNDEvent dNDEvent = new DNDEvent();
        dNDEvent.widget = this;
        dNDEvent.x = event.x;
        dNDEvent.y = event.y;
        dNDEvent.time = OS.GetMessageTime();
        dNDEvent.doit = true;
        this.notifyListeners(2008, dNDEvent);
        if (!dNDEvent.doit || this.transferAgents == null || this.transferAgents.length == 0) {
            return;
        }
        int[] nArray = new int[1];
        int n3 = this.opToOs(this.getStyle());
        Display display = this.control.getDisplay();
        String string = "org.eclipse.swt.internal.win32.runMessagesInIdle";
        Object object = display.getData(string);
        display.setData(string, Boolean.TRUE);
        ImageList imageList = null;
        Image image = dNDEvent.image;
        this.hwndDrag = 0;
        this.topControl = null;
        if (image != null) {
            Object object2;
            imageList = new ImageList(0);
            imageList.add(image);
            this.topControl = this.control.getShell();
            n2 = dNDEvent.offsetX;
            this.hwndDrag = this.topControl.handle;
            if ((this.topControl.getStyle() & 0x4000000) != 0) {
                n2 = image.getBoundsInPixels().width - n2;
                object2 = new RECT();
                OS.GetClientRect(this.topControl.handle, (RECT)object2);
                this.hwndDrag = OS.CreateWindowEx(0x100020, WindowClass, null, 0x44000000, 0, 0, ((RECT)object2).right - ((RECT)object2).left, ((RECT)object2).bottom - ((RECT)object2).top, this.topControl.handle, 0, OS.GetModuleHandle(null), null);
                OS.ShowWindow(this.hwndDrag, 5);
            }
            OS.ImageList_BeginDrag(imageList.getHandle(), 0, n2, dNDEvent.offsetY);
            if (OS.IsWinCE) {
                OS.UpdateWindow(this.topControl.handle);
            } else {
                int n4 = 384;
                OS.RedrawWindow(this.topControl.handle, null, 0, n4);
            }
            object2 = new POINT();
            ((POINT)object2).x = DPIUtil.autoScaleUp(event.x);
            ((POINT)object2).y = DPIUtil.autoScaleUp(event.y);
            OS.MapWindowPoints(this.control.handle, 0, (POINT)object2, 1);
            RECT rECT = new RECT();
            OS.GetWindowRect(this.hwndDrag, rECT);
            OS.ImageList_DragEnter(this.hwndDrag, ((POINT)object2).x - rECT.left, ((POINT)object2).y - rECT.top);
        }
        n2 = 262401;
        try {
            n2 = COM.DoDragDrop(this.iDataObject.getAddress(), this.iDropSource.getAddress(), n3, nArray);
        }
        finally {
            if (this.hwndDrag != 0) {
                OS.ImageList_DragLeave(this.hwndDrag);
                OS.ImageList_EndDrag();
                imageList.dispose();
                if (this.hwndDrag != this.topControl.handle) {
                    OS.DestroyWindow(this.hwndDrag);
                }
                this.hwndDrag = 0;
                this.topControl = null;
            }
            display.setData(string, object);
        }
        int n5 = this.osToOp(nArray[0]);
        if (this.dataEffect == 2) {
            n5 = n5 == 0 || n5 == 1 ? 8 : 2;
        } else if (this.dataEffect != 0) {
            n5 = this.dataEffect;
        }
        dNDEvent = new DNDEvent();
        dNDEvent.widget = this;
        dNDEvent.time = OS.GetMessageTime();
        dNDEvent.doit = n2 == 262400;
        dNDEvent.detail = n5;
        this.notifyListeners(2000, dNDEvent);
        this.dataEffect = 0;
    }

    private int EnumFormatEtc(int n2, int n3) {
        FORMATETC[] fORMATETCArray;
        if (n2 == 2) {
            return -2147467263;
        }
        TransferData[] transferDataArray = new TransferData[]{};
        for (int i2 = 0; i2 < this.transferAgents.length; ++i2) {
            fORMATETCArray = this.transferAgents[i2];
            if (fORMATETCArray == null) continue;
            TransferData[] transferDataArray2 = fORMATETCArray.getSupportedTypes();
            TransferData[] transferDataArray3 = new TransferData[transferDataArray.length + transferDataArray2.length];
            System.arraycopy(transferDataArray, 0, transferDataArray3, 0, transferDataArray.length);
            System.arraycopy(transferDataArray2, 0, transferDataArray3, transferDataArray.length, transferDataArray2.length);
            transferDataArray = transferDataArray3;
        }
        OleEnumFORMATETC oleEnumFORMATETC = new OleEnumFORMATETC();
        oleEnumFORMATETC.AddRef();
        fORMATETCArray = new FORMATETC[transferDataArray.length];
        for (int i3 = 0; i3 < fORMATETCArray.length; ++i3) {
            fORMATETCArray[i3] = transferDataArray[i3].formatetc;
        }
        oleEnumFORMATETC.setFormats(fORMATETCArray);
        OS.MoveMemory(n3, new int[]{oleEnumFORMATETC.getAddress()}, OS.PTR_SIZEOF);
        return 0;
    }

    public Control getControl() {
        return this.control;
    }

    private int GetData(int n2, int n3) {
        if (n2 == 0 || n3 == 0) {
            return -2147024809;
        }
        if (this.QueryGetData(n2) != 0) {
            return -2147221404;
        }
        TransferData transferData = new TransferData();
        transferData.formatetc = new FORMATETC();
        COM.MoveMemory(transferData.formatetc, n2, FORMATETC.sizeof);
        transferData.type = transferData.formatetc.cfFormat;
        transferData.stgmedium = new STGMEDIUM();
        transferData.result = -2147467259;
        DNDEvent dNDEvent = new DNDEvent();
        dNDEvent.widget = this;
        dNDEvent.time = OS.GetMessageTime();
        dNDEvent.dataType = transferData;
        this.notifyListeners(2001, dNDEvent);
        if (!dNDEvent.doit) {
            return -2147467259;
        }
        Transfer transfer = null;
        for (int i2 = 0; i2 < this.transferAgents.length; ++i2) {
            Transfer transfer2 = this.transferAgents[i2];
            if (transfer2 == null || !transfer2.isSupportedType(transferData)) continue;
            transfer = transfer2;
            break;
        }
        if (transfer == null) {
            return -2147221404;
        }
        transfer.javaToNative(dNDEvent.data, transferData);
        if (transferData.result != 0) {
            return transferData.result;
        }
        COM.MoveMemory(n3, transferData.stgmedium, STGMEDIUM.sizeof);
        return transferData.result;
    }

    public DragSourceListener[] getDragListeners() {
        Listener[] listenerArray = this.getListeners(2008);
        int n2 = listenerArray.length;
        DragSourceListener[] dragSourceListenerArray = new DragSourceListener[n2];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            Listener listener = listenerArray[i2];
            if (!(listener instanceof DNDListener)) continue;
            dragSourceListenerArray[n3] = (DragSourceListener)((DNDListener)listener).getEventListener();
            ++n3;
        }
        if (n3 == n2) {
            return dragSourceListenerArray;
        }
        DragSourceListener[] dragSourceListenerArray2 = new DragSourceListener[n3];
        System.arraycopy(dragSourceListenerArray, 0, dragSourceListenerArray2, 0, n3);
        return dragSourceListenerArray2;
    }

    public DragSourceEffect getDragSourceEffect() {
        return this.dragEffect;
    }

    public Transfer[] getTransfer() {
        return this.transferAgents;
    }

    private int GiveFeedback(int n2) {
        return 262402;
    }

    private int QueryContinueDrag(int n2, int n3) {
        if (this.topControl != null && this.topControl.isDisposed()) {
            return 262401;
        }
        if (n2 != 0) {
            if (this.hwndDrag != 0) {
                OS.ImageList_DragLeave(this.hwndDrag);
            }
            return 262401;
        }
        int n4 = 19;
        if ((n3 & n4) == 0) {
            if (this.hwndDrag != 0) {
                OS.ImageList_DragLeave(this.hwndDrag);
            }
            return 262400;
        }
        if (this.hwndDrag != 0) {
            POINT pOINT = new POINT();
            OS.GetCursorPos(pOINT);
            RECT rECT = new RECT();
            OS.GetWindowRect(this.hwndDrag, rECT);
            OS.ImageList_DragMove(pOINT.x - rECT.left, pOINT.y - rECT.top);
        }
        return 0;
    }

    private void onDispose() {
        if (this.control == null) {
            return;
        }
        this.Release();
        if (this.controlListener != null) {
            this.control.removeListener(12, this.controlListener);
            this.control.removeListener(29, this.controlListener);
        }
        this.controlListener = null;
        this.control.setData("DragSource", null);
        this.control = null;
        this.transferAgents = null;
    }

    private int opToOs(int n2) {
        int n3 = 0;
        if ((n2 & 1) != 0) {
            n3 |= 1;
        }
        if ((n2 & 4) != 0) {
            n3 |= 4;
        }
        if ((n2 & 2) != 0) {
            n3 |= 2;
        }
        return n3;
    }

    private int osToOp(int n2) {
        int n3 = 0;
        if ((n2 & 1) != 0) {
            n3 |= 1;
        }
        if ((n2 & 4) != 0) {
            n3 |= 4;
        }
        if ((n2 & 2) != 0) {
            n3 |= 2;
        }
        return n3;
    }

    private int QueryGetData(int n2) {
        if (this.transferAgents == null) {
            return -2147467259;
        }
        TransferData transferData = new TransferData();
        transferData.formatetc = new FORMATETC();
        COM.MoveMemory(transferData.formatetc, n2, FORMATETC.sizeof);
        transferData.type = transferData.formatetc.cfFormat;
        for (int i2 = 0; i2 < this.transferAgents.length; ++i2) {
            Transfer transfer = this.transferAgents[i2];
            if (transfer == null || !transfer.isSupportedType(transferData)) continue;
            return 0;
        }
        return -2147221404;
    }

    private int QueryInterface(int n2, int n3) {
        if (n2 == 0 || n3 == 0) {
            return -2147024809;
        }
        GUID gUID = new GUID();
        COM.MoveMemory(gUID, n2, GUID.sizeof);
        if (COM.IsEqualGUID(gUID, COM.IIDIUnknown) || COM.IsEqualGUID(gUID, COM.IIDIDropSource)) {
            OS.MoveMemory(n3, new int[]{this.iDropSource.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (COM.IsEqualGUID(gUID, COM.IIDIDataObject)) {
            OS.MoveMemory(n3, new int[]{this.iDataObject.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        OS.MoveMemory(n3, new int[]{0}, OS.PTR_SIZEOF);
        return -2147467262;
    }

    private int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
            if (COM.FreeUnusedLibraries) {
                COM.CoFreeUnusedLibraries();
            }
        }
        return this.refCount;
    }

    public void removeDragListener(DragSourceListener dragSourceListener) {
        if (dragSourceListener == null) {
            DND.error(4);
        }
        this.removeListener(2008, dragSourceListener);
        this.removeListener(2001, dragSourceListener);
        this.removeListener(2000, dragSourceListener);
    }

    private int SetData(int n2, int n3, int n4) {
        if (n2 == 0 || n3 == 0) {
            return -2147024809;
        }
        FORMATETC fORMATETC = new FORMATETC();
        COM.MoveMemory(fORMATETC, n2, FORMATETC.sizeof);
        if (fORMATETC.cfFormat == CFSTR_PERFORMEDDROPEFFECT && fORMATETC.tymed == 1) {
            STGMEDIUM sTGMEDIUM = new STGMEDIUM();
            COM.MoveMemory(sTGMEDIUM, n3, STGMEDIUM.sizeof);
            int[] nArray = new int[1];
            OS.MoveMemory(nArray, sTGMEDIUM.unionField, OS.PTR_SIZEOF);
            int[] nArray2 = new int[1];
            OS.MoveMemory(nArray2, nArray[0], 4);
            this.dataEffect = this.osToOp(nArray2[0]);
        }
        if (n4 == 1) {
            COM.ReleaseStgMedium(n3);
        }
        return 0;
    }

    public void setDragSourceEffect(DragSourceEffect dragSourceEffect) {
        this.dragEffect = dragSourceEffect;
    }

    public void setTransfer(Transfer ... transferArray) {
        this.transferAgents = transferArray;
    }

    static /* synthetic */ int access$000(DragSource dragSource, int n2, int n3) {
        return dragSource.QueryInterface(n2, n3);
    }

    static /* synthetic */ int access$100(DragSource dragSource) {
        return dragSource.AddRef();
    }

    static /* synthetic */ int access$200(DragSource dragSource) {
        return dragSource.Release();
    }

    static /* synthetic */ int access$300(DragSource dragSource, int n2, int n3) {
        return dragSource.QueryContinueDrag(n2, n3);
    }

    static /* synthetic */ int access$400(DragSource dragSource, int n2) {
        return dragSource.GiveFeedback(n2);
    }

    static /* synthetic */ int access$500(DragSource dragSource, int n2, int n3) {
        return dragSource.GetData(n2, n3);
    }

    static /* synthetic */ int access$600(DragSource dragSource, int n2) {
        return dragSource.QueryGetData(n2);
    }

    static /* synthetic */ int access$700(DragSource dragSource, int n2, int n3, int n4) {
        return dragSource.SetData(n2, n3, n4);
    }

    static /* synthetic */ int access$800(DragSource dragSource, int n2, int n3) {
        return dragSource.EnumFormatEtc(n2, n3);
    }
}

