/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DNDEvent;
import org.eclipse.swt.dnd.DNDListener;
import org.eclipse.swt.dnd.DropTarget$1;
import org.eclipse.swt.dnd.DropTargetEffect;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TableDropTargetEffect;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.dnd.TreeDropTargetEffect;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.COMObject;
import org.eclipse.swt.internal.ole.win32.FORMATETC;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IDataObject;
import org.eclipse.swt.internal.ole.win32.IEnumFORMATETC;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class DropTarget
extends Widget {
    Control control;
    Listener controlListener;
    Transfer[] transferAgents = new Transfer[0];
    DropTargetEffect dropEffect;
    TransferData selectedDataType;
    int selectedOperation;
    int keyOperation = -1;
    IDataObject iDataObject;
    COMObject iDropTarget;
    int refCount;
    static final String DEFAULT_DROP_TARGET_EFFECT = "DEFAULT_DROP_TARGET_EFFECT";

    public DropTarget(Control control, int n2) {
        super(control, DropTarget.checkStyle(n2));
        this.control = control;
        if (control.getData("DropTarget") != null) {
            DND.error(2001);
        }
        control.setData("DropTarget", this);
        this.createCOMInterfaces();
        this.AddRef();
        if (COM.CoLockObjectExternal(this.iDropTarget.getAddress(), true, true) != 0) {
            DND.error(2001);
        }
        if (COM.RegisterDragDrop(control.handle, this.iDropTarget.getAddress()) != 0) {
            DND.error(2001);
        }
        this.controlListener = event -> {
            if (!this.isDisposed()) {
                this.dispose();
            }
        };
        control.addListener(12, this.controlListener);
        this.addListener(12, event -> this.onDispose());
        Object object = control.getData(DEFAULT_DROP_TARGET_EFFECT);
        if (object instanceof DropTargetEffect) {
            this.dropEffect = (DropTargetEffect)object;
        } else if (control instanceof Table) {
            this.dropEffect = new TableDropTargetEffect((Table)control);
        } else if (control instanceof Tree) {
            this.dropEffect = new TreeDropTargetEffect((Tree)control);
        }
    }

    static int checkStyle(int n2) {
        if (n2 == 0) {
            return 2;
        }
        return n2;
    }

    public void addDropListener(DropTargetListener dropTargetListener) {
        if (dropTargetListener == null) {
            DND.error(4);
        }
        DNDListener dNDListener = new DNDListener(dropTargetListener);
        dNDListener.dndWidget = this;
        this.addListener(2002, dNDListener);
        this.addListener(2003, dNDListener);
        this.addListener(2004, dNDListener);
        this.addListener(2005, dNDListener);
        this.addListener(2006, dNDListener);
        this.addListener(2007, dNDListener);
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    @Override
    protected void checkSubclass() {
        String string = this.getClass().getName();
        String string2 = DropTarget.class.getName();
        if (!string2.equals(string)) {
            DND.error(43);
        }
    }

    void createCOMInterfaces() {
        boolean bl2 = C.PTR_SIZEOF == 4;
        this.iDropTarget = new DropTarget$1(this, new int[]{2, 0, 0, bl2 ? 5 : 4, bl2 ? 4 : 3, 0, bl2 ? 5 : 4});
    }

    void disposeCOMInterfaces() {
        if (this.iDropTarget != null) {
            this.iDropTarget.dispose();
        }
        this.iDropTarget = null;
    }

    int DragEnter_64(int n2, int n3, long l2, int n4) {
        POINT pOINT = new POINT();
        OS.MoveMemory(pOINT, new long[]{l2}, 8);
        return this.DragEnter(n2, n3, pOINT.x, pOINT.y, n4);
    }

    int DragEnter(int n2, int n3, int n4, int n5, int n6) {
        n4 = DPIUtil.autoScaleDown(n4);
        n5 = DPIUtil.autoScaleDown(n5);
        this.selectedDataType = null;
        this.selectedOperation = 0;
        if (this.iDataObject != null) {
            this.iDataObject.Release();
        }
        this.iDataObject = null;
        DNDEvent dNDEvent = new DNDEvent();
        if (!this.setEventData(dNDEvent, n2, n3, n4, n5, n6)) {
            OS.MoveMemory(n6, new int[]{0}, 4);
            return 1;
        }
        this.iDataObject = new IDataObject(n2);
        this.iDataObject.AddRef();
        int n7 = dNDEvent.operations;
        TransferData[] transferDataArray = new TransferData[dNDEvent.dataTypes.length];
        System.arraycopy(dNDEvent.dataTypes, 0, transferDataArray, 0, transferDataArray.length);
        this.notifyListeners(2002, dNDEvent);
        this.refresh();
        if (dNDEvent.detail == 16) {
            dNDEvent.detail = (n7 & 2) != 0 ? 2 : 0;
        }
        this.selectedDataType = null;
        for (int i2 = 0; i2 < transferDataArray.length; ++i2) {
            if (!TransferData.sameType(transferDataArray[i2], dNDEvent.dataType)) continue;
            this.selectedDataType = transferDataArray[i2];
            break;
        }
        this.selectedOperation = 0;
        if (this.selectedDataType != null && (n7 & dNDEvent.detail) != 0) {
            this.selectedOperation = dNDEvent.detail;
        }
        OS.MoveMemory(n6, new int[]{this.opToOs(this.selectedOperation)}, 4);
        return 0;
    }

    int DragLeave() {
        this.keyOperation = -1;
        if (this.iDataObject == null) {
            return 1;
        }
        DNDEvent dNDEvent = new DNDEvent();
        dNDEvent.widget = this;
        dNDEvent.time = OS.GetMessageTime();
        dNDEvent.detail = 0;
        this.notifyListeners(2003, dNDEvent);
        this.refresh();
        this.iDataObject.Release();
        this.iDataObject = null;
        return 0;
    }

    int DragOver_64(int n2, long l2, int n3) {
        POINT pOINT = new POINT();
        OS.MoveMemory(pOINT, new long[]{l2}, 8);
        return this.DragOver(n2, pOINT.x, pOINT.y, n3);
    }

    int DragOver(int n2, int n3, int n4, int n5) {
        n3 = DPIUtil.autoScaleDown(n3);
        n4 = DPIUtil.autoScaleDown(n4);
        if (this.iDataObject == null) {
            return 1;
        }
        int n6 = this.keyOperation;
        DNDEvent dNDEvent = new DNDEvent();
        if (!this.setEventData(dNDEvent, this.iDataObject.getAddress(), n2, n3, n4, n5)) {
            this.keyOperation = -1;
            OS.MoveMemory(n5, new int[]{0}, 4);
            return 1;
        }
        int n7 = dNDEvent.operations;
        TransferData[] transferDataArray = new TransferData[dNDEvent.dataTypes.length];
        System.arraycopy(dNDEvent.dataTypes, 0, transferDataArray, 0, transferDataArray.length);
        if (this.keyOperation == n6) {
            dNDEvent.type = 2004;
            dNDEvent.dataType = this.selectedDataType;
            dNDEvent.detail = this.selectedOperation;
        } else {
            dNDEvent.type = 2005;
            dNDEvent.dataType = this.selectedDataType;
        }
        this.notifyListeners(dNDEvent.type, dNDEvent);
        this.refresh();
        if (dNDEvent.detail == 16) {
            dNDEvent.detail = (n7 & 2) != 0 ? 2 : 0;
        }
        this.selectedDataType = null;
        for (int i2 = 0; i2 < transferDataArray.length; ++i2) {
            if (!TransferData.sameType(transferDataArray[i2], dNDEvent.dataType)) continue;
            this.selectedDataType = transferDataArray[i2];
            break;
        }
        this.selectedOperation = 0;
        if (this.selectedDataType != null && (n7 & dNDEvent.detail) == dNDEvent.detail) {
            this.selectedOperation = dNDEvent.detail;
        }
        OS.MoveMemory(n5, new int[]{this.opToOs(this.selectedOperation)}, 4);
        return 0;
    }

    int Drop_64(int n2, int n3, long l2, int n4) {
        POINT pOINT = new POINT();
        OS.MoveMemory(pOINT, new long[]{l2}, 8);
        return this.Drop(n2, n3, pOINT.x, pOINT.y, n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int Drop(int n2, int n3, int n4, int n5, int n6) {
        n4 = DPIUtil.autoScaleDown(n4);
        n5 = DPIUtil.autoScaleDown(n5);
        DNDEvent dNDEvent = new DNDEvent();
        dNDEvent.widget = this;
        dNDEvent.time = OS.GetMessageTime();
        if (this.dropEffect != null) {
            dNDEvent.item = this.dropEffect.getItem(n4, n5);
        }
        dNDEvent.detail = 0;
        this.notifyListeners(2003, dNDEvent);
        this.refresh();
        dNDEvent = new DNDEvent();
        if (!this.setEventData(dNDEvent, n2, n3, n4, n5, n6)) {
            this.keyOperation = -1;
            OS.MoveMemory(n6, new int[]{0}, 4);
            return 1;
        }
        this.keyOperation = -1;
        int n7 = dNDEvent.operations;
        TransferData[] transferDataArray = new TransferData[dNDEvent.dataTypes.length];
        System.arraycopy(dNDEvent.dataTypes, 0, transferDataArray, 0, transferDataArray.length);
        dNDEvent.dataType = this.selectedDataType;
        dNDEvent.detail = this.selectedOperation;
        this.notifyListeners(2007, dNDEvent);
        this.refresh();
        this.selectedDataType = null;
        for (int i2 = 0; i2 < transferDataArray.length; ++i2) {
            if (!TransferData.sameType(transferDataArray[i2], dNDEvent.dataType)) continue;
            this.selectedDataType = transferDataArray[i2];
            break;
        }
        this.selectedOperation = 0;
        if (this.selectedDataType != null && (n7 & dNDEvent.detail) == dNDEvent.detail) {
            this.selectedOperation = dNDEvent.detail;
        }
        if (this.selectedOperation == 0) {
            OS.MoveMemory(n6, new int[]{0}, 4);
            return 0;
        }
        Object object = null;
        for (int i3 = 0; i3 < this.transferAgents.length; ++i3) {
            Transfer transfer = this.transferAgents[i3];
            if (transfer == null || !transfer.isSupportedType(this.selectedDataType)) continue;
            object = transfer.nativeToJava(this.selectedDataType);
            break;
        }
        if (object == null) {
            this.selectedOperation = 0;
        }
        dNDEvent.detail = this.selectedOperation;
        dNDEvent.dataType = this.selectedDataType;
        dNDEvent.data = object;
        OS.ImageList_DragShowNolock(false);
        try {
            this.notifyListeners(2006, dNDEvent);
        }
        finally {
            OS.ImageList_DragShowNolock(true);
        }
        this.refresh();
        this.selectedOperation = 0;
        if ((n7 & dNDEvent.detail) == dNDEvent.detail) {
            this.selectedOperation = dNDEvent.detail;
        }
        OS.MoveMemory(n6, new int[]{this.opToOs(this.selectedOperation)}, 4);
        return 0;
    }

    public Control getControl() {
        return this.control;
    }

    public DropTargetListener[] getDropListeners() {
        Listener[] listenerArray = this.getListeners(2002);
        int n2 = listenerArray.length;
        DropTargetListener[] dropTargetListenerArray = new DropTargetListener[n2];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            Listener listener = listenerArray[i2];
            if (!(listener instanceof DNDListener)) continue;
            dropTargetListenerArray[n3] = (DropTargetListener)((DNDListener)listener).getEventListener();
            ++n3;
        }
        if (n3 == n2) {
            return dropTargetListenerArray;
        }
        DropTargetListener[] dropTargetListenerArray2 = new DropTargetListener[n3];
        System.arraycopy(dropTargetListenerArray, 0, dropTargetListenerArray2, 0, n3);
        return dropTargetListenerArray2;
    }

    public DropTargetEffect getDropTargetEffect() {
        return this.dropEffect;
    }

    int getOperationFromKeyState(int n2) {
        boolean bl2;
        boolean bl3 = (n2 & 8) != 0;
        boolean bl4 = (n2 & 4) != 0;
        boolean bl5 = bl2 = (n2 & 0x20) != 0;
        if (bl2) {
            if (bl3 || bl4) {
                return 16;
            }
            return 4;
        }
        if (bl3 && bl4) {
            return 4;
        }
        if (bl3) {
            return 1;
        }
        if (bl4) {
            return 2;
        }
        return 16;
    }

    public Transfer[] getTransfer() {
        return this.transferAgents;
    }

    void onDispose() {
        if (this.control == null) {
            return;
        }
        COM.RevokeDragDrop(this.control.handle);
        if (this.controlListener != null) {
            this.control.removeListener(12, this.controlListener);
        }
        this.controlListener = null;
        this.control.setData("DropTarget", null);
        this.transferAgents = null;
        this.control = null;
        COM.CoLockObjectExternal(this.iDropTarget.getAddress(), false, true);
        this.Release();
        if (this.iDataObject != null) {
            this.iDataObject.Release();
        }
        this.iDataObject = null;
        if (COM.FreeUnusedLibraries) {
            COM.CoFreeUnusedLibraries();
        }
    }

    int opToOs(int n2) {
        int n3 = 0;
        if ((n2 & 1) != 0) {
            n3 |= 1;
        }
        if ((n2 & 4) != 0) {
            n3 |= 4;
        }
        if ((n2 & 2) != 0) {
            n3 |= 2;
        }
        return n3;
    }

    int osToOp(int n2) {
        int n3 = 0;
        if ((n2 & 1) != 0) {
            n3 |= 1;
        }
        if ((n2 & 4) != 0) {
            n3 |= 4;
        }
        if ((n2 & 2) != 0) {
            n3 |= 2;
        }
        return n3;
    }

    int QueryInterface(int n2, int n3) {
        if (n2 == 0 || n3 == 0) {
            return -2147024809;
        }
        GUID gUID = new GUID();
        COM.MoveMemory(gUID, n2, GUID.sizeof);
        if (COM.IsEqualGUID(gUID, COM.IIDIUnknown) || COM.IsEqualGUID(gUID, COM.IIDIDropTarget)) {
            COM.MoveMemory(n3, new int[]{this.iDropTarget.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        COM.MoveMemory(n3, new int[]{0}, OS.PTR_SIZEOF);
        return -2147467262;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
            if (COM.FreeUnusedLibraries) {
                COM.CoFreeUnusedLibraries();
            }
        }
        return this.refCount;
    }

    void refresh() {
        if (this.control == null || this.control.isDisposed()) {
            return;
        }
        int n2 = this.control.handle;
        RECT rECT = new RECT();
        if (OS.GetUpdateRect(n2, rECT, false)) {
            OS.ImageList_DragShowNolock(false);
            OS.RedrawWindow(n2, rECT, 0, 257);
            OS.ImageList_DragShowNolock(true);
        }
    }

    public void removeDropListener(DropTargetListener dropTargetListener) {
        if (dropTargetListener == null) {
            DND.error(4);
        }
        this.removeListener(2002, dropTargetListener);
        this.removeListener(2003, dropTargetListener);
        this.removeListener(2004, dropTargetListener);
        this.removeListener(2005, dropTargetListener);
        this.removeListener(2006, dropTargetListener);
        this.removeListener(2007, dropTargetListener);
    }

    public void setDropTargetEffect(DropTargetEffect dropTargetEffect) {
        this.dropEffect = dropTargetEffect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setEventData(DNDEvent dNDEvent, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        if (n2 == 0 || n6 == 0) {
            return false;
        }
        int n8 = this.getStyle();
        int[] nArray = new int[1];
        OS.MoveMemory(nArray, n6, 4);
        nArray[0] = this.osToOp(nArray[0]) & n8;
        if (nArray[0] == 0) {
            return false;
        }
        this.keyOperation = n7 = this.getOperationFromKeyState(n3);
        if (n7 == 16) {
            if ((n8 & 0x10) == 0) {
                n7 = (nArray[0] & 2) != 0 ? 2 : 0;
            }
        } else if ((n7 & nArray[0]) == 0) {
            n7 = 0;
        }
        TransferData[] transferDataArray = new TransferData[]{};
        IDataObject iDataObject = new IDataObject(n2);
        iDataObject.AddRef();
        try {
            int[] nArray2 = new int[1];
            if (iDataObject.EnumFormatEtc(1, nArray2) != 0) {
                boolean bl2 = false;
                return bl2;
            }
            IEnumFORMATETC iEnumFORMATETC = new IEnumFORMATETC(nArray2[0]);
            try {
                int n9 = OS.GlobalAlloc(64, FORMATETC.sizeof);
                try {
                    int[] nArray3 = new int[1];
                    iEnumFORMATETC.Reset();
                    block10: while (iEnumFORMATETC.Next(1, n9, nArray3) == 0 && nArray3[0] == 1) {
                        TransferData transferData = new TransferData();
                        transferData.formatetc = new FORMATETC();
                        COM.MoveMemory(transferData.formatetc, n9, FORMATETC.sizeof);
                        transferData.type = transferData.formatetc.cfFormat;
                        transferData.pIDataObject = n2;
                        for (int i2 = 0; i2 < this.transferAgents.length; ++i2) {
                            Transfer transfer = this.transferAgents[i2];
                            if (transfer == null || !transfer.isSupportedType(transferData)) continue;
                            TransferData[] transferDataArray2 = new TransferData[transferDataArray.length + 1];
                            System.arraycopy(transferDataArray, 0, transferDataArray2, 0, transferDataArray.length);
                            transferDataArray2[transferDataArray.length] = transferData;
                            transferDataArray = transferDataArray2;
                            continue block10;
                        }
                    }
                }
                finally {
                    OS.GlobalFree(n9);
                }
            }
            finally {
                iEnumFORMATETC.Release();
            }
        }
        finally {
            iDataObject.Release();
        }
        if (transferDataArray.length == 0) {
            return false;
        }
        dNDEvent.widget = this;
        dNDEvent.x = n4;
        dNDEvent.y = n5;
        dNDEvent.time = OS.GetMessageTime();
        dNDEvent.feedback = 1;
        dNDEvent.dataTypes = transferDataArray;
        dNDEvent.dataType = transferDataArray[0];
        if (this.dropEffect != null) {
            dNDEvent.item = this.dropEffect.getItem(n4, n5);
        }
        dNDEvent.operations = nArray[0];
        dNDEvent.detail = n7;
        return true;
    }

    public void setTransfer(Transfer ... transferArray) {
        if (transferArray == null) {
            DND.error(4);
        }
        this.transferAgents = transferArray;
    }
}

