/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.ole.win32.FORMATETC;
import org.eclipse.swt.internal.ole.win32.IDataObject;
import org.eclipse.swt.internal.ole.win32.STGMEDIUM;
import org.eclipse.swt.internal.win32.OS;

public class HTMLTransfer
extends ByteArrayTransfer {
    static HTMLTransfer _instance = new HTMLTransfer();
    static final String HTML_FORMAT = "HTML Format";
    static final int HTML_FORMATID = HTMLTransfer.registerType("HTML Format");
    static final String NUMBER = "00000000";
    static final String HEADER = "Version:0.9\r\nStartHTML:00000000\r\nEndHTML:00000000\r\nStartFragment:00000000\r\nEndFragment:00000000\r\n";
    static final String PREFIX = "<html><body><!--StartFragment-->";
    static final String SUFFIX = "<!--EndFragment--></body></html>";
    static final String StartFragment = "StartFragment:";
    static final String EndFragment = "EndFragment:";

    private HTMLTransfer() {
    }

    public static HTMLTransfer getInstance() {
        return _instance;
    }

    @Override
    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkHTML(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        String string = (String)object;
        int n2 = string.length();
        char[] cArray = new char[n2 + 1];
        string.getChars(0, n2, cArray, 0);
        int n3 = OS.WideCharToMultiByte(65001, 0, cArray, -1, null, 0, null, null);
        if (n3 == 0) {
            transferData.stgmedium = new STGMEDIUM();
            transferData.result = -2147221402;
            return;
        }
        int n4 = HEADER.length();
        int n5 = n4 + PREFIX.length();
        int n6 = n5 + n3 - 1;
        int n7 = n6 + SUFFIX.length();
        StringBuffer stringBuffer = new StringBuffer(HEADER);
        int n8 = NUMBER.length();
        int n9 = stringBuffer.toString().indexOf(NUMBER);
        String string2 = Integer.toString(n4);
        stringBuffer.replace(n9 + n8 - string2.length(), n9 + n8, string2);
        n9 = stringBuffer.toString().indexOf(NUMBER, n9);
        string2 = Integer.toString(n7);
        stringBuffer.replace(n9 + n8 - string2.length(), n9 + n8, string2);
        n9 = stringBuffer.toString().indexOf(NUMBER, n9);
        string2 = Integer.toString(n5);
        stringBuffer.replace(n9 + n8 - string2.length(), n9 + n8, string2);
        n9 = stringBuffer.toString().indexOf(NUMBER, n9);
        string2 = Integer.toString(n6);
        stringBuffer.replace(n9 + n8 - string2.length(), n9 + n8, string2);
        stringBuffer.append(PREFIX);
        stringBuffer.append(string);
        stringBuffer.append(SUFFIX);
        n2 = stringBuffer.length();
        cArray = new char[n2 + 1];
        stringBuffer.getChars(0, n2, cArray, 0);
        n3 = OS.WideCharToMultiByte(65001, 0, cArray, -1, null, 0, null, null);
        int n10 = OS.GlobalAlloc(64, n3);
        OS.WideCharToMultiByte(65001, 0, cArray, -1, n10, n3, null, null);
        transferData.stgmedium = new STGMEDIUM();
        transferData.stgmedium.tymed = 1;
        transferData.stgmedium.unionField = n10;
        transferData.stgmedium.pUnkForRelease = 0;
        transferData.result = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.pIDataObject == 0) {
            return null;
        }
        IDataObject iDataObject = new IDataObject(transferData.pIDataObject);
        iDataObject.AddRef();
        STGMEDIUM sTGMEDIUM = new STGMEDIUM();
        FORMATETC fORMATETC = transferData.formatetc;
        sTGMEDIUM.tymed = 1;
        transferData.result = this.getData(iDataObject, fORMATETC, sTGMEDIUM);
        iDataObject.Release();
        if (transferData.result != 0) {
            return null;
        }
        int n2 = sTGMEDIUM.unionField;
        try {
            String string;
            char[] cArray;
            int n3;
            block25: {
                int n4;
                int n5;
                int n6;
                block24: {
                    block23: {
                        n6 = OS.GlobalLock(n2);
                        if (n6 == 0) {
                            Object var7_7 = null;
                            return var7_7;
                        }
                        n3 = OS.MultiByteToWideChar(65001, 0, n6, -1, null, 0);
                        if (n3 != 0) break block23;
                        Object var8_9 = null;
                        OS.GlobalUnlock(n2);
                        return var8_9;
                    }
                    try {
                        int n7;
                        cArray = new char[n3 - 1];
                        OS.MultiByteToWideChar(65001, 0, n6, -1, cArray, cArray.length);
                        String string2 = new String(cArray);
                        n5 = 0;
                        n4 = 0;
                        int n8 = string2.indexOf(StartFragment) + StartFragment.length();
                        for (n7 = n8 + 1; n7 < string2.length(); ++n7) {
                            string = string2.substring(n8, n7);
                            try {
                                n5 = Integer.parseInt(string);
                                continue;
                            }
                            catch (NumberFormatException numberFormatException) {
                                break;
                            }
                        }
                        n8 = string2.indexOf(EndFragment) + EndFragment.length();
                        for (n7 = n8 + 1; n7 < string2.length(); ++n7) {
                            string = string2.substring(n8, n7);
                            try {
                                n4 = Integer.parseInt(string);
                                continue;
                            }
                            catch (NumberFormatException numberFormatException) {
                                break;
                            }
                        }
                        if (n4 > n5 && n4 <= OS.strlen(n6)) break block24;
                        string = null;
                    }
                    catch (Throwable throwable) {
                        OS.GlobalUnlock(n2);
                        throw throwable;
                    }
                    OS.GlobalUnlock(n2);
                    return string;
                }
                n3 = OS.MultiByteToWideChar(65001, 0, n6 + n5, n4 - n5, cArray, cArray.length);
                if (n3 != 0) break block25;
                string = null;
                OS.GlobalUnlock(n2);
                return string;
            }
            string = new String(cArray, 0, n3);
            String string3 = "<!--StartFragment -->\r\n";
            int n9 = string.indexOf(string3);
            if (n9 != -1) {
                string = string.substring(n9 += string3.length());
            }
            String string4 = string;
            OS.GlobalUnlock(n2);
            return string4;
        }
        finally {
            OS.GlobalFree(n2);
        }
    }

    @Override
    protected int[] getTypeIds() {
        return new int[]{HTML_FORMATID};
    }

    @Override
    protected String[] getTypeNames() {
        return new String[]{HTML_FORMAT};
    }

    boolean checkHTML(Object object) {
        return object != null && object instanceof String && ((String)object).length() > 0;
    }

    @Override
    protected boolean validate(Object object) {
        return this.checkHTML(object);
    }
}

