/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.Serializable;
import org.eclipse.swt.SWT;

public final class RGB
implements Serializable {
    public int red;
    public int green;
    public int blue;
    static final long serialVersionUID = 3258415023461249074L;

    public RGB(int n2, int n3, int n4) {
        if (n2 > 255 || n2 < 0 || n3 > 255 || n3 < 0 || n4 > 255 || n4 < 0) {
            SWT.error(5);
        }
        this.red = n2;
        this.green = n3;
        this.blue = n4;
    }

    public RGB(float f2, float f3, float f4) {
        float f5;
        float f6;
        float f7;
        if (f2 < 0.0f || f2 > 360.0f || f3 < 0.0f || f3 > 1.0f || f4 < 0.0f || f4 > 1.0f) {
            SWT.error(5);
        }
        if (f3 == 0.0f) {
            f6 = f7 = f4;
            f5 = f7;
        } else {
            if (f2 == 360.0f) {
                f2 = 0.0f;
            }
            int n2 = (int)(f2 /= 60.0f);
            float f8 = f2 - (float)n2;
            float f9 = f4 * (1.0f - f3);
            float f10 = f4 * (1.0f - f3 * f8);
            float f11 = f4 * (1.0f - f3 * (1.0f - f8));
            switch (n2) {
                case 0: {
                    f5 = f4;
                    f6 = f11;
                    f7 = f9;
                    break;
                }
                case 1: {
                    f5 = f10;
                    f6 = f4;
                    f7 = f9;
                    break;
                }
                case 2: {
                    f5 = f9;
                    f6 = f4;
                    f7 = f11;
                    break;
                }
                case 3: {
                    f5 = f9;
                    f6 = f10;
                    f7 = f4;
                    break;
                }
                case 4: {
                    f5 = f11;
                    f6 = f9;
                    f7 = f4;
                    break;
                }
                default: {
                    f5 = f4;
                    f6 = f9;
                    f7 = f10;
                }
            }
        }
        this.red = (int)((double)(f5 * 255.0f) + 0.5);
        this.green = (int)((double)(f6 * 255.0f) + 0.5);
        this.blue = (int)((double)(f7 * 255.0f) + 0.5);
    }

    public float[] getHSB() {
        float f2;
        float f3 = (float)this.red / 255.0f;
        float f4 = (float)this.green / 255.0f;
        float f5 = (float)this.blue / 255.0f;
        float f6 = Math.max(Math.max(f3, f4), f5);
        float f7 = Math.min(Math.min(f3, f4), f5);
        float f8 = f6 - f7;
        float f9 = 0.0f;
        float f10 = f6;
        float f11 = f2 = f6 == 0.0f ? 0.0f : (f6 - f7) / f6;
        if (f8 != 0.0f) {
            f9 = f3 == f6 ? (f4 - f5) / f8 : (f4 == f6 ? 2.0f + (f5 - f3) / f8 : 4.0f + (f3 - f4) / f8);
            if ((f9 *= 60.0f) < 0.0f) {
                f9 += 360.0f;
            }
        }
        return new float[]{f9, f2, f10};
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof RGB)) {
            return false;
        }
        RGB rGB = (RGB)object;
        return rGB.red == this.red && rGB.green == this.green && rGB.blue == this.blue;
    }

    public int hashCode() {
        return this.blue << 16 | this.green << 8 | this.red;
    }

    public String toString() {
        return "RGB {" + this.red + ", " + this.green + ", " + this.blue + "}";
    }
}

