/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.swt.internal.image.PngChunk;
import org.eclipse.swt.internal.image.PngChunkReader;
import org.eclipse.swt.internal.image.PngIdatChunk;

public class PngInputStream
extends InputStream {
    PngChunkReader reader;
    PngChunk chunk;
    int offset;
    int length;
    static final int DATA_OFFSET = 8;

    public PngInputStream(PngIdatChunk pngIdatChunk, PngChunkReader pngChunkReader) {
        this.chunk = pngIdatChunk;
        this.reader = pngChunkReader;
        this.length = pngIdatChunk.getLength();
        this.offset = 0;
    }

    private boolean checkChunk() {
        while (this.offset == this.length) {
            this.chunk = this.reader.readNextChunk();
            if (this.chunk == null) {
                throw new IOException();
            }
            if (this.chunk.getChunkType() == 3) {
                return false;
            }
            if (this.chunk.getChunkType() != 2) {
                throw new IOException();
            }
            this.length = this.chunk.getLength();
            this.offset = 0;
        }
        return true;
    }

    @Override
    public void close() {
        this.chunk = null;
    }

    @Override
    public int read() {
        if (this.chunk == null) {
            throw new IOException();
        }
        if (this.offset == this.length && !this.checkChunk()) {
            return -1;
        }
        int n2 = this.chunk.reference[8 + this.offset] & 0xFF;
        ++this.offset;
        return n2;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        if (this.chunk == null) {
            throw new IOException();
        }
        if (this.offset == this.length && !this.checkChunk()) {
            return -1;
        }
        n3 = Math.min(n3, this.length - this.offset);
        System.arraycopy(this.chunk.reference, 8 + this.offset, byArray, n2, n3);
        this.offset += n3;
        return n3;
    }
}

