/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import java.io.IOException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.internal.image.FileFormat;
import org.eclipse.swt.internal.image.LEDataInputStream;
import org.eclipse.swt.internal.image.WinBMPFileFormat;

public final class WinICOFileFormat
extends FileFormat {
    byte[] bitInvertData(byte[] byArray, int n2, int n3) {
        for (int i2 = n2; i2 < n3; ++i2) {
            byArray[i2] = (byte)(255 - byArray[i2 - n2]);
        }
        return byArray;
    }

    static final byte[] convertPad(byte[] byArray, int n2, int n3, int n4, int n5, int n6) {
        if (n5 == n6) {
            return byArray;
        }
        int n7 = (n2 * n4 + 7) / 8;
        int n8 = (n7 + (n5 - 1)) / n5 * n5;
        int n9 = (n7 + (n6 - 1)) / n6 * n6;
        byte[] byArray2 = new byte[n3 * n9];
        int n10 = 0;
        int n11 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            System.arraycopy(byArray, n10, byArray2, n11, n9);
            n10 += n8;
            n11 += n9;
        }
        return byArray2;
    }

    int iconSize(ImageData imageData) {
        int n2 = (imageData.width * imageData.depth + 31) / 32 * 4;
        int n3 = (imageData.width + 31) / 32 * 4;
        int n4 = (n2 + n3) * imageData.height;
        int n5 = imageData.palette.colors != null ? imageData.palette.colors.length * 4 : 0;
        return 40 + n5 + n4;
    }

    @Override
    boolean isFileFormat(LEDataInputStream lEDataInputStream) {
        try {
            byte[] byArray = new byte[4];
            lEDataInputStream.read(byArray);
            lEDataInputStream.unread(byArray);
            return byArray[0] == 0 && byArray[1] == 0 && byArray[2] == 1 && byArray[3] == 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    boolean isValidIcon(ImageData imageData) {
        switch (imageData.depth) {
            case 1: 
            case 4: 
            case 8: {
                if (imageData.palette.isDirect) {
                    return false;
                }
                int n2 = imageData.palette.colors.length;
                return n2 == 2 || n2 == 16 || n2 == 32 || n2 == 256;
            }
            case 24: 
            case 32: {
                return imageData.palette.isDirect;
            }
        }
        return false;
    }

    int loadFileHeader(LEDataInputStream lEDataInputStream) {
        int n2;
        int[] nArray = new int[3];
        try {
            nArray[0] = lEDataInputStream.readShort();
            nArray[1] = lEDataInputStream.readShort();
            nArray[2] = lEDataInputStream.readShort();
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
        if (nArray[0] != 0 || nArray[1] != 1) {
            SWT.error(40);
        }
        if ((n2 = nArray[2]) <= 0) {
            SWT.error(40);
        }
        return n2;
    }

    int loadFileHeader(LEDataInputStream lEDataInputStream, boolean bl2) {
        int n2;
        int[] nArray = new int[3];
        try {
            if (bl2) {
                nArray[0] = lEDataInputStream.readShort();
                nArray[1] = lEDataInputStream.readShort();
            } else {
                nArray[0] = 0;
                nArray[1] = 1;
            }
            nArray[2] = lEDataInputStream.readShort();
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
        if (nArray[0] != 0 || nArray[1] != 1) {
            SWT.error(40);
        }
        if ((n2 = nArray[2]) <= 0) {
            SWT.error(40);
        }
        return n2;
    }

    @Override
    ImageData[] loadFromByteStream() {
        int n2 = this.loadFileHeader(this.inputStream);
        int[][] nArray = this.loadIconHeaders(n2);
        ImageData[] imageDataArray = new ImageData[nArray.length];
        for (int i2 = 0; i2 < imageDataArray.length; ++i2) {
            imageDataArray[i2] = this.loadIcon(nArray[i2]);
        }
        return imageDataArray;
    }

    ImageData loadIcon(int[] nArray) {
        Object object;
        try {
            object = WinICOFileFormat.getFileFormat(this.inputStream, "PNG");
            if (object != null) {
                ((FileFormat)object).loader = this.loader;
                return ((FileFormat)object).loadFromStream(this.inputStream)[0];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = this.loadInfoHeader(nArray);
        WinBMPFileFormat winBMPFileFormat = new WinBMPFileFormat();
        winBMPFileFormat.inputStream = this.inputStream;
        PaletteData paletteData = winBMPFileFormat.loadPalette((byte[])object);
        byte[] byArray = winBMPFileFormat.loadData((byte[])object);
        int n2 = object[4] & 0xFF | (object[5] & 0xFF) << 8 | (object[6] & 0xFF) << 16 | (object[7] & 0xFF) << 24;
        int n3 = object[8] & 0xFF | (object[9] & 0xFF) << 8 | (object[10] & 0xFF) << 16 | (object[11] & 0xFF) << 24;
        if (n3 < 0) {
            n3 = -n3;
        }
        int n4 = object[14] & 0xFF | (object[15] & 0xFF) << 8;
        object[14] = true;
        object[15] = false;
        byte[] byArray2 = winBMPFileFormat.loadData((byte[])object);
        byArray2 = WinICOFileFormat.convertPad(byArray2, n2, n3, 1, 4, 2);
        this.bitInvertData(byArray2, 0, byArray2.length);
        return ImageData.internal_new(n2, n3, n4, paletteData, 4, byArray, 2, byArray2, null, -1, -1, 3, 0, 0, 0, 0);
    }

    int[][] loadIconHeaders(int n2) {
        int[][] nArray = new int[n2][7];
        try {
            for (int i2 = 0; i2 < n2; ++i2) {
                nArray[i2][0] = this.inputStream.read();
                nArray[i2][1] = this.inputStream.read();
                nArray[i2][2] = this.inputStream.readShort();
                nArray[i2][3] = this.inputStream.readShort();
                nArray[i2][4] = this.inputStream.readShort();
                nArray[i2][5] = this.inputStream.readInt();
                nArray[i2][6] = this.inputStream.readInt();
            }
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
        return nArray;
    }

    byte[] loadInfoHeader(int[] nArray) {
        int n2 = nArray[0];
        int n3 = nArray[1];
        int n4 = nArray[2];
        if (n4 == 0) {
            n4 = 256;
        }
        if (n4 != 2 && n4 != 8 && n4 != 16 && n4 != 32 && n4 != 256) {
            SWT.error(40);
        }
        if (this.inputStream.getPosition() < nArray[6]) {
            try {
                this.inputStream.skip(nArray[6] - this.inputStream.getPosition());
            }
            catch (IOException iOException) {
                SWT.error(39, iOException);
                return null;
            }
        }
        byte[] byArray = new byte[40];
        try {
            this.inputStream.read(byArray);
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
        if ((byArray[12] & 0xFF | (byArray[13] & 0xFF) << 8) != 1) {
            SWT.error(40);
        }
        int n5 = byArray[4] & 0xFF | (byArray[5] & 0xFF) << 8 | (byArray[6] & 0xFF) << 16 | (byArray[7] & 0xFF) << 24;
        int n6 = byArray[8] & 0xFF | (byArray[9] & 0xFF) << 8 | (byArray[10] & 0xFF) << 16 | (byArray[11] & 0xFF) << 24;
        int n7 = byArray[14] & 0xFF | (byArray[15] & 0xFF) << 8;
        if (n2 == 0) {
            n2 = n5;
        }
        if (n3 == 0) {
            n3 = n6 / 2;
        }
        if (n3 == n6 && n7 == 1) {
            n3 /= 2;
        }
        if (n2 != n5 || n3 * 2 != n6 || n7 != 1 && n7 != 4 && n7 != 8 && n7 != 24 && n7 != 32) {
            SWT.error(40);
        }
        byArray[8] = (byte)(n3 & 0xFF);
        byArray[9] = (byte)(n3 >> 8 & 0xFF);
        byArray[10] = (byte)(n3 >> 16 & 0xFF);
        byArray[11] = (byte)(n3 >> 24 & 0xFF);
        return byArray;
    }

    void unloadIcon(ImageData imageData) {
        int n2 = ((imageData.width * imageData.depth + 31) / 32 * 4 + (imageData.width + 31) / 32 * 4) * imageData.height;
        try {
            this.outputStream.writeInt(40);
            this.outputStream.writeInt(imageData.width);
            this.outputStream.writeInt(imageData.height * 2);
            this.outputStream.writeShort(1);
            this.outputStream.writeShort((short)imageData.depth);
            this.outputStream.writeInt(0);
            this.outputStream.writeInt(n2);
            this.outputStream.writeInt(0);
            this.outputStream.writeInt(0);
            this.outputStream.writeInt(imageData.palette.colors != null ? imageData.palette.colors.length : 0);
            this.outputStream.writeInt(0);
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
        byte[] byArray = WinBMPFileFormat.paletteToBytes(imageData.palette);
        try {
            this.outputStream.write(byArray);
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
        this.unloadShapeData(imageData);
        this.unloadMaskData(imageData);
    }

    void unloadIconHeader(ImageData imageData) {
        int n2 = 16;
        int n3 = n2 + 6;
        int n4 = this.iconSize(imageData);
        try {
            this.outputStream.write(imageData.width);
            this.outputStream.write(imageData.height);
            this.outputStream.writeShort(imageData.palette.colors != null ? imageData.palette.colors.length : 0);
            this.outputStream.writeShort(0);
            this.outputStream.writeShort(0);
            this.outputStream.writeInt(n4);
            this.outputStream.writeInt(n3);
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
    }

    @Override
    void unloadIntoByteStream(ImageLoader imageLoader) {
        ImageData imageData = imageLoader.data[0];
        if (!this.isValidIcon(imageData)) {
            SWT.error(40);
        }
        try {
            this.outputStream.writeShort(0);
            this.outputStream.writeShort(1);
            this.outputStream.writeShort(1);
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
        this.unloadIconHeader(imageData);
        this.unloadIcon(imageData);
    }

    void unloadMaskData(ImageData imageData) {
        ImageData imageData2 = imageData.getTransparencyMask();
        int n2 = (imageData.width + 7) / 8;
        int n3 = imageData2.scanlinePad;
        int n4 = (n2 + n3 - 1) / n3 * n3;
        int n5 = (n2 + 3) / 4 * 4;
        byte[] byArray = new byte[n5];
        int n6 = (imageData.height - 1) * n4;
        byte[] byArray2 = imageData2.data;
        try {
            for (int i2 = 0; i2 < imageData.height; ++i2) {
                System.arraycopy(byArray2, n6, byArray, 0, n2);
                this.bitInvertData(byArray, 0, n2);
                this.outputStream.write(byArray, 0, n5);
                n6 -= n4;
            }
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
    }

    void unloadShapeData(ImageData imageData) {
        int n2 = (imageData.width * imageData.depth + 7) / 8;
        int n3 = imageData.scanlinePad;
        int n4 = (n2 + n3 - 1) / n3 * n3;
        int n5 = (n2 + 3) / 4 * 4;
        byte[] byArray = new byte[n5];
        int n6 = (imageData.height - 1) * n4;
        byte[] byArray2 = imageData.data;
        try {
            for (int i2 = 0; i2 < imageData.height; ++i2) {
                System.arraycopy(byArray2, n6, byArray, 0, n2);
                this.outputStream.write(byArray, 0, n5);
                n6 -= n4;
            }
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
    }
}

