/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.ole.win32;

import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.COMObject;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IConnectionPoint;
import org.eclipse.swt.internal.ole.win32.IConnectionPointContainer;
import org.eclipse.swt.internal.ole.win32.IUnknown;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.ole.win32.OLE;
import org.eclipse.swt.ole.win32.OleControlSite;
import org.eclipse.swt.ole.win32.OleEvent;
import org.eclipse.swt.ole.win32.OleEventTable;
import org.eclipse.swt.ole.win32.OleListener;
import org.eclipse.swt.ole.win32.OlePropertyChangeSink$1;
import org.eclipse.swt.ole.win32.OlePropertyChangeSink$2;

final class OlePropertyChangeSink {
    private OleControlSite controlSite;
    private COMObject iUnknown;
    private COMObject iPropertyNotifySink;
    private int refCount;
    private int propertyCookie;
    private OleEventTable eventTable;

    OlePropertyChangeSink(OleControlSite oleControlSite) {
        this.controlSite = oleControlSite;
        this.createCOMInterfaces();
    }

    void addListener(int n2, OleListener oleListener) {
        if (oleListener == null) {
            OLE.error(4);
        }
        if (this.eventTable == null) {
            this.eventTable = new OleEventTable();
        }
        this.eventTable.hook(n2, oleListener);
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    void connect(IUnknown iUnknown) {
        int[] nArray = new int[1];
        if (iUnknown.QueryInterface(COM.IIDIConnectionPointContainer, nArray) == 0) {
            IConnectionPointContainer iConnectionPointContainer = new IConnectionPointContainer(nArray[0]);
            if (iConnectionPointContainer.FindConnectionPoint(COM.IIDIPropertyNotifySink, nArray) == 0) {
                IConnectionPoint iConnectionPoint = new IConnectionPoint(nArray[0]);
                int[] nArray2 = new int[1];
                if (iConnectionPoint.Advise(this.iPropertyNotifySink.getAddress(), nArray2) == 0) {
                    this.propertyCookie = nArray2[0];
                }
                iConnectionPoint.Release();
            }
            iConnectionPointContainer.Release();
        }
    }

    private void createCOMInterfaces() {
        this.iUnknown = new OlePropertyChangeSink$1(this, new int[]{2, 0, 0});
        this.iPropertyNotifySink = new OlePropertyChangeSink$2(this, new int[]{2, 0, 0, 1, 1});
    }

    void disconnect(IUnknown iUnknown) {
        int[] nArray;
        if (this.propertyCookie != 0 && iUnknown != null && iUnknown.QueryInterface(COM.IIDIConnectionPointContainer, nArray = new int[1]) == 0) {
            IConnectionPointContainer iConnectionPointContainer = new IConnectionPointContainer(nArray[0]);
            if (iConnectionPointContainer.FindConnectionPoint(COM.IIDIPropertyNotifySink, nArray) == 0) {
                IConnectionPoint iConnectionPoint = new IConnectionPoint(nArray[0]);
                if (iConnectionPoint.Unadvise(this.propertyCookie) == 0) {
                    this.propertyCookie = 0;
                }
                iConnectionPoint.Release();
            }
            iConnectionPointContainer.Release();
        }
    }

    private void disposeCOMInterfaces() {
        if (this.iUnknown != null) {
            this.iUnknown.dispose();
        }
        this.iUnknown = null;
        if (this.iPropertyNotifySink != null) {
            this.iPropertyNotifySink.dispose();
        }
        this.iPropertyNotifySink = null;
    }

    private void notifyListener(int n2, OleEvent oleEvent) {
        if (oleEvent == null) {
            OLE.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        oleEvent.type = n2;
        oleEvent.widget = this.controlSite;
        this.eventTable.sendEvent(oleEvent);
    }

    private int OnChanged(int n2) {
        if (this.eventTable == null || !this.eventTable.hooks(n2)) {
            return 0;
        }
        OleEvent oleEvent = new OleEvent();
        oleEvent.detail = 1;
        this.notifyListener(n2, oleEvent);
        return 0;
    }

    private int OnRequestEdit(int n2) {
        if (this.eventTable == null || !this.eventTable.hooks(n2)) {
            return 0;
        }
        OleEvent oleEvent = new OleEvent();
        oleEvent.doit = true;
        oleEvent.detail = 0;
        this.notifyListener(n2, oleEvent);
        return oleEvent.doit ? 0 : 1;
    }

    private int QueryInterface(int n2, int n3) {
        if (n2 == 0 || n3 == 0) {
            return -2147024809;
        }
        GUID gUID = new GUID();
        COM.MoveMemory(gUID, n2, GUID.sizeof);
        if (COM.IsEqualGUID(gUID, COM.IIDIUnknown)) {
            COM.MoveMemory(n3, new int[]{this.iUnknown.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (COM.IsEqualGUID(gUID, COM.IIDIPropertyNotifySink)) {
            COM.MoveMemory(n3, new int[]{this.iPropertyNotifySink.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        COM.MoveMemory(n3, new int[]{0}, OS.PTR_SIZEOF);
        return -2147467262;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    void removeListener(int n2, OleListener oleListener) {
        if (oleListener == null) {
            OLE.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(n2, oleListener);
    }

    static /* synthetic */ int access$000(OlePropertyChangeSink olePropertyChangeSink, int n2, int n3) {
        return olePropertyChangeSink.QueryInterface(n2, n3);
    }

    static /* synthetic */ int access$100(OlePropertyChangeSink olePropertyChangeSink, int n2) {
        return olePropertyChangeSink.OnChanged(n2);
    }

    static /* synthetic */ int access$200(OlePropertyChangeSink olePropertyChangeSink, int n2) {
        return olePropertyChangeSink.OnRequestEdit(n2);
    }
}

