/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.win32.CHOOSECOLOR;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ColorDialog
extends Dialog {
    static final int CUSTOM_COLOR_COUNT = 16;
    Display display;
    int width;
    int height;
    RGB rgb;
    RGB[] rgbs;
    int[] colors = new int[16];

    public ColorDialog(Shell shell) {
        this(shell, 65536);
    }

    public ColorDialog(Shell shell, int n2) {
        super(shell, ColorDialog.checkStyle(shell, n2));
        this.checkSubclass();
    }

    int CCHookProc(int n2, int n3, int n4, int n5) {
        switch (n3) {
            case 272: {
                RECT rECT = new RECT();
                OS.GetWindowRect(n2, rECT);
                this.width = rECT.right - rECT.left;
                this.height = rECT.bottom - rECT.top;
                if (this.title == null || this.title.length() == 0) break;
                TCHAR tCHAR = new TCHAR(0, this.title, true);
                OS.SetWindowText(n2, tCHAR);
                break;
            }
            case 2: {
                RECT rECT = new RECT();
                OS.GetWindowRect(n2, rECT);
                int n6 = rECT.right - rECT.left;
                int n7 = rECT.bottom - rECT.top;
                if (n6 < this.width || n7 < this.height || n6 > this.width || n7 <= this.height) break;
                break;
            }
        }
        return 0;
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public RGB[] getRGBs() {
        return this.rgbs;
    }

    public RGB open() {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        Callback callback;
        int n7;
        int n8;
        int n9;
        int n10 = this.parent.handle;
        int n11 = this.parent.handle;
        boolean bl2 = false;
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(4, 10) && (n9 = this.style & 0x6000000) != (n8 = this.parent.style & 0x6000000)) {
            n7 = 0x100000;
            if (n9 == 0x4000000) {
                n7 |= 0x400000;
            }
            n10 = OS.CreateWindowEx(n7, Shell.DialogClass, null, 0, Integer.MIN_VALUE, 0, Integer.MIN_VALUE, 0, n11, 0, OS.GetModuleHandle(null), null);
            bl2 = OS.IsWindowEnabled(n11);
            if (bl2) {
                OS.EnableWindow(n11, false);
            }
        }
        if ((n8 = (callback = new Callback(this, "CCHookProc", 4)).getAddress()) == 0) {
            this.error(3);
        }
        this.display = this.parent.display;
        if (this.display.lpCustColors == 0) {
            n7 = OS.GetProcessHeap();
            this.display.lpCustColors = OS.HeapAlloc(n7, 8, 64);
            for (n6 = 0; n6 < 16; ++n6) {
                this.colors[n6] = 0xFFFFFF;
            }
            OS.MoveMemory(this.display.lpCustColors, this.colors, 64);
        }
        if (this.rgbs != null) {
            n7 = this.rgbs.length > 16 ? 16 : this.rgbs.length;
            for (n6 = 0; n6 < n7; ++n6) {
                RGB rGB = this.rgbs[n6];
                n5 = rGB.red & 0xFF;
                n4 = rGB.green << 8 & 0xFF00;
                n3 = rGB.blue << 16 & 0xFF0000;
                this.colors[n6] = n5 | n4 | n3;
            }
            for (n6 = n7; n6 < 16; ++n6) {
                this.colors[n6] = 0xFFFFFF;
            }
            OS.MoveMemory(this.display.lpCustColors, this.colors, 64);
        }
        CHOOSECOLOR cHOOSECOLOR = new CHOOSECOLOR();
        cHOOSECOLOR.lStructSize = CHOOSECOLOR.sizeof;
        cHOOSECOLOR.Flags = 272;
        cHOOSECOLOR.lpfnHook = n8;
        cHOOSECOLOR.hwndOwner = n10;
        cHOOSECOLOR.lpCustColors = this.display.lpCustColors;
        if (this.rgb != null) {
            cHOOSECOLOR.Flags |= 1;
            n6 = this.rgb.red & 0xFF;
            int n12 = this.rgb.green << 8 & 0xFF00;
            n5 = this.rgb.blue << 16 & 0xFF0000;
            cHOOSECOLOR.rgbResult = n6 | n12 | n5;
        }
        Dialog dialog = null;
        if ((this.style & 0x30000) != 0) {
            dialog = this.display.getModalDialog();
            this.display.setModalDialog(this);
        }
        this.display.sendPreExternalEventDispatchEvent();
        boolean bl3 = OS.ChooseColor(cHOOSECOLOR);
        this.display.sendPostExternalEventDispatchEvent();
        if ((this.style & 0x30000) != 0) {
            this.display.setModalDialog(dialog);
        }
        n5 = 0;
        OS.MoveMemory(this.colors, this.display.lpCustColors, this.colors.length * 4);
        for (n4 = 0; n4 < this.colors.length; ++n4) {
            if (this.colors[n4] == 0xFFFFFF) continue;
            n5 = 1;
            break;
        }
        if (n5 != 0) {
            this.rgbs = new RGB[16];
            for (n4 = 0; n4 < this.colors.length; ++n4) {
                n3 = this.colors[n4];
                n2 = n3 & 0xFF;
                int n13 = n3 >> 8 & 0xFF;
                int n14 = n3 >> 16 & 0xFF;
                this.rgbs[n4] = new RGB(n2, n13, n14);
            }
        }
        if (bl3) {
            n4 = cHOOSECOLOR.rgbResult & 0xFF;
            n3 = cHOOSECOLOR.rgbResult >> 8 & 0xFF;
            n2 = cHOOSECOLOR.rgbResult >> 16 & 0xFF;
            this.rgb = new RGB(n4, n3, n2);
        }
        callback.dispose();
        if (n11 != n10) {
            if (bl2) {
                OS.EnableWindow(n11, true);
            }
            OS.SetActiveWindow(n11);
            OS.DestroyWindow(n10);
        }
        this.display = null;
        if (!bl3) {
            return null;
        }
        return this.rgb;
    }

    public void setRGB(RGB rGB) {
        this.rgb = rGB;
    }

    public void setRGBs(RGB[] rGBArray) {
        if (rGBArray != null) {
            for (int i2 = 0; i2 < rGBArray.length; ++i2) {
                if (rGBArray[i2] != null) continue;
                this.error(5);
            }
        }
        this.rgbs = rGBArray;
    }
}

