/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.win32.CHOOSEFONT;
import org.eclipse.swt.internal.win32.LOGFONT;
import org.eclipse.swt.internal.win32.LOGFONTA;
import org.eclipse.swt.internal.win32.LOGFONTW;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FontDialog
extends Dialog {
    FontData fontData;
    RGB rgb;
    boolean effectsVisible = true;

    public FontDialog(Shell shell) {
        this(shell, 65536);
    }

    public FontDialog(Shell shell, int n2) {
        super(shell, FontDialog.checkStyle(shell, n2));
        this.checkSubclass();
    }

    public boolean getEffectsVisible() {
        return this.effectsVisible;
    }

    public FontData getFontData() {
        return this.fontData;
    }

    public FontData[] getFontList() {
        if (this.fontData == null) {
            return null;
        }
        FontData[] fontDataArray = new FontData[]{this.fontData};
        return fontDataArray;
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public FontData open() {
        int n2;
        int n3;
        Object object;
        int n4;
        int n5;
        int n6;
        if (OS.IsWinCE) {
            this.error(20);
        }
        int n7 = this.parent.handle;
        int n8 = this.parent.handle;
        boolean bl2 = false;
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(4, 10) && (n6 = this.style & 0x6000000) != (n5 = this.parent.style & 0x6000000)) {
            n4 = 0x100000;
            if (n6 == 0x4000000) {
                n4 |= 0x400000;
            }
            n7 = OS.CreateWindowEx(n4, Shell.DialogClass, null, 0, Integer.MIN_VALUE, 0, Integer.MIN_VALUE, 0, n8, 0, OS.GetModuleHandle(null), null);
            bl2 = OS.IsWindowEnabled(n8);
            if (bl2) {
                OS.EnableWindow(n8, false);
            }
        }
        n6 = OS.GetProcessHeap();
        CHOOSEFONT cHOOSEFONT = new CHOOSEFONT();
        cHOOSEFONT.lStructSize = CHOOSEFONT.sizeof;
        cHOOSEFONT.hwndOwner = n7;
        cHOOSEFONT.Flags = 1;
        if (this.effectsVisible) {
            cHOOSEFONT.Flags |= 0x100;
        }
        n4 = OS.HeapAlloc(n6, 8, LOGFONT.sizeof);
        if (this.fontData != null && this.fontData.data != null) {
            object = this.fontData.data;
            n3 = ((LOGFONT)object).lfHeight;
            n2 = OS.GetDC(0);
            int n9 = -((int)(0.5f + this.fontData.height * (float)OS.GetDeviceCaps(n2, 90) / 72.0f));
            OS.ReleaseDC(0, n2);
            ((LOGFONT)object).lfHeight = n9;
            cHOOSEFONT.Flags |= 0x40;
            OS.MoveMemory(n4, (LOGFONT)object, LOGFONT.sizeof);
            ((LOGFONT)object).lfHeight = n3;
        }
        cHOOSEFONT.lpLogFont = n4;
        if (this.rgb != null) {
            int n10 = this.rgb.red & 0xFF;
            n3 = this.rgb.green << 8 & 0xFF00;
            n2 = this.rgb.blue << 16 & 0xFF0000;
            cHOOSEFONT.rgbColors = n10 | n3 | n2;
        }
        object = null;
        Display display = this.parent.getDisplay();
        if ((this.style & 0x30000) != 0) {
            object = display.getModalDialog();
            display.setModalDialog(this);
        }
        display.sendPreExternalEventDispatchEvent();
        n2 = OS.ChooseFont(cHOOSEFONT) ? 1 : 0;
        display.sendPostExternalEventDispatchEvent();
        if ((this.style & 0x30000) != 0) {
            display.setModalDialog((Dialog)object);
        }
        if (n2 != 0) {
            int n11;
            LOGFONT lOGFONT = OS.IsUnicode ? new LOGFONTW() : new LOGFONTA();
            OS.MoveMemory(lOGFONT, n4, LOGFONT.sizeof);
            int n12 = OS.GetDC(0);
            int n13 = OS.GetDeviceCaps(n12, 90);
            int n14 = 0;
            if (lOGFONT.lfHeight > 0) {
                int n15 = OS.CreateFontIndirect(lOGFONT);
                n11 = OS.SelectObject(n12, n15);
                TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
                OS.GetTextMetrics(n12, tEXTMETRIC);
                OS.SelectObject(n12, n11);
                OS.DeleteObject(n15);
                n14 = lOGFONT.lfHeight - tEXTMETRIC.tmInternalLeading;
            } else {
                n14 = -lOGFONT.lfHeight;
            }
            OS.ReleaseDC(0, n12);
            float f2 = (float)n14 * 72.0f / (float)n13;
            this.fontData = FontData.win32_new(lOGFONT, f2);
            if (this.effectsVisible) {
                n11 = cHOOSEFONT.rgbColors & 0xFF;
                int n16 = cHOOSEFONT.rgbColors >> 8 & 0xFF;
                int n17 = cHOOSEFONT.rgbColors >> 16 & 0xFF;
                this.rgb = new RGB(n11, n16, n17);
            }
        }
        if (n4 != 0) {
            OS.HeapFree(n6, 0, n4);
        }
        if (n8 != n7) {
            if (bl2) {
                OS.EnableWindow(n8, true);
            }
            OS.SetActiveWindow(n8);
            OS.DestroyWindow(n7);
        }
        if (n2 == 0) {
            return null;
        }
        return this.fontData;
    }

    public void setEffectsVisible(boolean bl2) {
        this.effectsVisible = bl2;
    }

    public void setFontData(FontData fontData) {
        this.fontData = fontData;
    }

    public void setFontList(FontData[] fontDataArray) {
        this.fontData = fontDataArray != null && fontDataArray.length > 0 ? fontDataArray[0] : null;
    }

    public void setRGB(RGB rGB) {
        this.rgb = rGB;
    }
}

