/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.regex.Pattern;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SCROLLBARINFO;
import org.eclipse.swt.internal.win32.SCROLLINFO;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ScrollBar;

public abstract class Scrollable
extends Control {
    ScrollBar horizontalBar;
    ScrollBar verticalBar;
    static final Pattern CTRL_BS_PATTERN = Pattern.compile("\\r?\\n\\z|[\\p{Punct}]+[\\t ]*\\z|[^\\p{Punct}\\s\\n\\r]*[\\t ]*\\z");

    Scrollable() {
    }

    public Scrollable(Composite composite, int n2) {
        super(composite, n2);
    }

    @Override
    int callWindowProc(int n2, int n3, int n4, int n5) {
        if (this.handle == 0) {
            return 0;
        }
        return OS.DefWindowProc(n2, n3, n4, n5);
    }

    public Rectangle computeTrim(int n2, int n3, int n4, int n5) {
        this.checkWidget();
        n2 = DPIUtil.autoScaleUp(n2);
        n3 = DPIUtil.autoScaleUp(n3);
        n4 = DPIUtil.autoScaleUp(n4);
        n5 = DPIUtil.autoScaleUp(n5);
        return DPIUtil.autoScaleDown(this.computeTrimInPixels(n2, n3, n4, n5));
    }

    Rectangle computeTrimInPixels(int n2, int n3, int n4, int n5) {
        int n6 = this.scrolledHandle();
        RECT rECT = new RECT();
        OS.SetRect(rECT, n2, n3, n2 + n4, n3 + n5);
        int n7 = OS.GetWindowLong(n6, -16);
        int n8 = OS.GetWindowLong(n6, -20);
        OS.AdjustWindowRectEx(rECT, n7, false, n8);
        if (this.horizontalBar != null) {
            rECT.bottom += OS.GetSystemMetrics(3);
        }
        if (this.verticalBar != null) {
            rECT.right += OS.GetSystemMetrics(2);
        }
        int n9 = rECT.right - rECT.left;
        int n10 = rECT.bottom - rECT.top;
        return new Rectangle(rECT.left, rECT.top, n9, n10);
    }

    ScrollBar createScrollBar(int n2) {
        ScrollBar scrollBar = new ScrollBar(this, n2);
        if ((this.state & 2) != 0) {
            scrollBar.setMaximum(100);
            scrollBar.setThumb(10);
        }
        return scrollBar;
    }

    @Override
    void createWidget() {
        super.createWidget();
        if ((this.style & 0x100) != 0) {
            this.horizontalBar = this.createScrollBar(256);
        }
        if ((this.style & 0x200) != 0) {
            this.verticalBar = this.createScrollBar(512);
        }
    }

    @Override
    void updateBackgroundColor() {
        switch (this.applyThemeBackground()) {
            case 0: {
                this.state &= 0xFFFFFEFF;
                break;
            }
            case 1: {
                this.state |= 0x100;
                break;
            }
        }
        super.updateBackgroundColor();
    }

    int applyThemeBackground() {
        return this.backgroundAlpha == 0 ? 1 : 0;
    }

    void destroyScrollBar(int n2) {
        int n3 = this.scrolledHandle();
        int n4 = OS.GetWindowLong(n3, -16);
        if ((n2 & 0x100) != 0) {
            this.style &= 0xFFFFFEFF;
            n4 &= 0xFFEFFFFF;
        }
        if ((n2 & 0x200) != 0) {
            this.style &= 0xFFFFFDFF;
            n4 &= 0xFFDFFFFF;
        }
        OS.SetWindowLong(n3, -16, n4);
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getClientAreaInPixels());
    }

    Rectangle getClientAreaInPixels() {
        this.forceResize();
        RECT rECT = new RECT();
        int n2 = this.scrolledHandle();
        OS.GetClientRect(n2, rECT);
        int n3 = rECT.left;
        int n4 = rECT.top;
        int n5 = rECT.right - rECT.left;
        int n6 = rECT.bottom - rECT.top;
        if (n2 != this.handle) {
            OS.GetClientRect(this.handle, rECT);
            OS.MapWindowPoints(this.handle, n2, rECT, 2);
            n3 = -rECT.left;
            n4 = -rECT.top;
        }
        return new Rectangle(n3, n4, n5, n6);
    }

    public ScrollBar getHorizontalBar() {
        this.checkWidget();
        return this.horizontalBar;
    }

    public int getScrollbarsMode() {
        this.checkWidget();
        return 0;
    }

    public ScrollBar getVerticalBar() {
        this.checkWidget();
        return this.verticalBar;
    }

    @Override
    void releaseChildren(boolean bl2) {
        if (this.horizontalBar != null) {
            this.horizontalBar.release(false);
            this.horizontalBar = null;
        }
        if (this.verticalBar != null) {
            this.verticalBar.release(false);
            this.verticalBar = null;
        }
        super.releaseChildren(bl2);
    }

    @Override
    void reskinChildren(int n2) {
        if (this.horizontalBar != null) {
            this.horizontalBar.reskin(n2);
        }
        if (this.verticalBar != null) {
            this.verticalBar.reskin(n2);
        }
        super.reskinChildren(n2);
    }

    int scrolledHandle() {
        return this.handle;
    }

    @Override
    int widgetExtStyle() {
        return super.widgetExtStyle();
    }

    @Override
    int widgetStyle() {
        int n2 = super.widgetStyle() | 0x10000;
        if ((this.style & 0x100) != 0) {
            n2 |= 0x100000;
        }
        if ((this.style & 0x200) != 0) {
            n2 |= 0x200000;
        }
        return n2;
    }

    @Override
    TCHAR windowClass() {
        return this.display.windowClass;
    }

    @Override
    int windowProc() {
        return this.display.windowProc;
    }

    @Override
    LRESULT WM_HSCROLL(int n2, int n3) {
        LRESULT lRESULT = super.WM_HSCROLL(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (this.horizontalBar != null && (n3 == 0 || n3 == this.handle)) {
            return this.wmScroll(this.horizontalBar, (this.state & 2) != 0, this.handle, 276, n2, n3);
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_MOUSEWHEEL(int n2, int n3) {
        return this.wmScrollWheel((this.state & 2) != 0, n2, n3);
    }

    @Override
    LRESULT WM_SIZE(int n2, int n3) {
        int n4 = this.callWindowProc(this.handle, 5, n2, n3);
        super.WM_SIZE(n2, n3);
        if (n4 == 0) {
            return LRESULT.ZERO;
        }
        return new LRESULT(n4);
    }

    @Override
    LRESULT WM_VSCROLL(int n2, int n3) {
        LRESULT lRESULT = super.WM_VSCROLL(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (this.verticalBar != null && (n3 == 0 || n3 == this.handle)) {
            return this.wmScroll(this.verticalBar, (this.state & 2) != 0, this.handle, 277, n2, n3);
        }
        return lRESULT;
    }

    @Override
    LRESULT wmNCPaint(int n2, int n3, int n4) {
        int n5;
        LRESULT lRESULT = super.wmNCPaint(n2, n3, n4);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() && !OS.IsWinCE && OS.WIN32_VERSION < OS.VERSION(6, 0) && ((n5 = OS.GetWindowLong(n2, -16)) & 0x300000) != 0) {
            RECT rECT = new RECT();
            OS.GetWindowRect(n2, rECT);
            RECT rECT2 = new RECT();
            int n6 = OS.GetWindowLong(n2, -20);
            OS.AdjustWindowRectEx(rECT2, n5, false, n6);
            boolean bl2 = false;
            boolean bl3 = false;
            SCROLLBARINFO sCROLLBARINFO = new SCROLLBARINFO();
            sCROLLBARINFO.cbSize = SCROLLBARINFO.sizeof;
            if (OS.GetScrollBarInfo(n2, -6, sCROLLBARINFO)) {
                boolean bl4 = bl2 = (sCROLLBARINFO.rgstate[0] & 0x8000) == 0;
            }
            if (OS.GetScrollBarInfo(n2, -5, sCROLLBARINFO)) {
                bl3 = (sCROLLBARINFO.rgstate[0] & 0x8000) == 0;
            }
            RECT rECT3 = new RECT();
            rECT3.bottom = rECT.bottom - rECT.top - rECT2.bottom;
            rECT3.top = rECT3.bottom - (bl3 ? OS.GetSystemMetrics(3) : 0);
            if ((n6 & 0x4000) != 0) {
                rECT3.left = rECT2.left;
                rECT3.right = rECT3.left + (bl2 ? OS.GetSystemMetrics(2) : 0);
            } else {
                rECT3.right = rECT.right - rECT.left - rECT2.right;
                rECT3.left = rECT3.right - (bl2 ? OS.GetSystemMetrics(2) : 0);
            }
            if (rECT3.left != rECT3.right && rECT3.top != rECT3.bottom) {
                int n7 = OS.GetWindowDC(n2);
                OS.FillRect(n7, rECT3, OS.COLOR_BTNFACE + 1);
                Decorations decorations = this.menuShell();
                if ((decorations.style & 0x10) != 0) {
                    boolean bl5;
                    int n8 = decorations.scrolledHandle();
                    boolean bl6 = bl5 = n2 == n8;
                    if (!bl5) {
                        RECT rECT4 = new RECT();
                        OS.GetClientRect(n8, rECT4);
                        OS.MapWindowPoints(n8, 0, rECT4, 2);
                        boolean bl7 = bl5 = rECT4.right == rECT.right && rECT4.bottom == rECT.bottom;
                    }
                    if (bl5) {
                        OS.DrawThemeBackground(this.display.hScrollBarTheme(), n7, 10, 0, rECT3, null);
                    }
                }
                OS.ReleaseDC(n2, n7);
            }
        }
        return lRESULT;
    }

    LRESULT wmScrollWheel(boolean bl2, int n2, int n3) {
        Event event;
        int n4;
        int n5 = this.display.scrollRemainder;
        LRESULT lRESULT = super.WM_MOUSEWHEEL(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (bl2) {
            boolean bl3;
            int n6;
            boolean bl4;
            if ((n2 & 0xC) != 0) {
                return lRESULT;
            }
            boolean bl5 = this.verticalBar != null && this.verticalBar.getEnabled();
            boolean bl6 = bl4 = this.horizontalBar != null && this.horizontalBar.getEnabled();
            int n7 = bl5 ? 277 : (n6 = bl4 ? 276 : 0);
            if (n6 == 0) {
                return lRESULT;
            }
            int[] nArray = new int[1];
            OS.SystemParametersInfo(104, 0, nArray, 0);
            int n8 = OS.GET_WHEEL_DELTA_WPARAM(n2);
            boolean bl7 = bl3 = nArray[0] == -1;
            if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(5, 1)) {
                ScrollBar scrollBar = bl5 ? this.verticalBar : this.horizontalBar;
                SCROLLINFO sCROLLINFO = new SCROLLINFO();
                sCROLLINFO.cbSize = SCROLLINFO.sizeof;
                sCROLLINFO.fMask = 4;
                OS.GetScrollInfo(this.handle, scrollBar.scrollBarType(), sCROLLINFO);
                if (bl5 && !bl3) {
                    n8 *= nArray[0];
                }
                int n9 = bl3 ? scrollBar.getPageIncrement() : scrollBar.getIncrement();
                sCROLLINFO.nPos -= n9 * n8 / 120;
                OS.SetScrollInfo(this.handle, scrollBar.scrollBarType(), sCROLLINFO, true);
                OS.SendMessage(this.handle, n6, 4, 0);
            } else {
                int n10 = 0;
                if (bl3) {
                    n10 = n8 < 0 ? 3 : 2;
                } else {
                    int n11 = n10 = n8 < 0 ? 1 : 0;
                    if (n6 == 277) {
                        n8 *= nArray[0];
                    }
                }
                if ((n8 ^ n5) >= 0) {
                    n8 += n5;
                }
                int n12 = Math.abs(n8) / 120;
                for (int i2 = 0; i2 < n12; ++i2) {
                    OS.SendMessage(this.handle, n6, n10, 0);
                }
            }
            return LRESULT.ZERO;
        }
        int n13 = this.verticalBar == null ? 0 : this.verticalBar.getSelection();
        int n14 = this.horizontalBar == null ? 0 : this.horizontalBar.getSelection();
        int n15 = this.callWindowProc(this.handle, 522, n2, n3);
        if (this.verticalBar != null && (n4 = this.verticalBar.getSelection()) != n13) {
            event = new Event();
            event.detail = n4 < n13 ? 0x1000005 : 0x1000006;
            this.verticalBar.sendSelectionEvent(13, event, true);
        }
        if (this.horizontalBar != null && (n4 = this.horizontalBar.getSelection()) != n14) {
            event = new Event();
            event.detail = n4 < n14 ? 0x1000005 : 0x1000006;
            this.horizontalBar.sendSelectionEvent(13, event, true);
        }
        return new LRESULT(n15);
    }

    LRESULT wmScroll(ScrollBar scrollBar, boolean bl2, int n2, int n3, int n4, int n5) {
        LRESULT lRESULT = null;
        if (bl2) {
            int n6 = n3 == 276 ? 0 : 1;
            SCROLLINFO sCROLLINFO = new SCROLLINFO();
            sCROLLINFO.cbSize = SCROLLINFO.sizeof;
            sCROLLINFO.fMask = 21;
            OS.GetScrollInfo(n2, n6, sCROLLINFO);
            sCROLLINFO.fMask = 4;
            int n7 = OS.LOWORD(n4);
            switch (n7) {
                case 8: {
                    return null;
                }
                case 4: 
                case 5: {
                    sCROLLINFO.nPos = sCROLLINFO.nTrackPos;
                    break;
                }
                case 6: {
                    sCROLLINFO.nPos = sCROLLINFO.nMin;
                    break;
                }
                case 7: {
                    sCROLLINFO.nPos = sCROLLINFO.nMax;
                    break;
                }
                case 1: {
                    sCROLLINFO.nPos += scrollBar.getIncrement();
                    break;
                }
                case 0: {
                    int n8 = scrollBar.getIncrement();
                    sCROLLINFO.nPos = Math.max(sCROLLINFO.nMin, sCROLLINFO.nPos - n8);
                    break;
                }
                case 3: {
                    sCROLLINFO.nPos += scrollBar.getPageIncrement();
                    break;
                }
                case 2: {
                    int n9 = scrollBar.getPageIncrement();
                    sCROLLINFO.nPos = Math.max(sCROLLINFO.nMin, sCROLLINFO.nPos - n9);
                }
            }
            OS.SetScrollInfo(n2, n6, sCROLLINFO, true);
        } else {
            int n10 = this.callWindowProc(n2, n3, n4, n5);
            lRESULT = n10 == 0 ? LRESULT.ZERO : new LRESULT(n10);
        }
        scrollBar.wmScrollChild(n4, n5);
        return lRESULT;
    }
}

