/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.PROPERTYKEY;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TaskItem;
import org.eclipse.swt.widgets.Widget;

public class TaskBar
extends Widget {
    int itemCount;
    TaskItem[] items = new TaskItem[4];
    int mTaskbarList3;
    static final char[] EXE_PATH;
    static final char[] ICO_DIR;
    static final PROPERTYKEY PKEY_Title;
    static final PROPERTYKEY PKEY_AppUserModel_IsDestListSeparator;
    static final String EXE_PATH_KEY = "org.eclipse.swt.win32.taskbar.executable";
    static final String EXE_ARGS_KEY = "org.eclipse.swt.win32.taskbar.arguments";
    static final String ICON_KEY = "org.eclipse.swt.win32.taskbar.icon";
    static final String ICON_INDEX_KEY = "org.eclipse.swt.win32.taskbar.icon.index";
    static final byte[] CLSID_TaskbarList;
    static final byte[] CLSID_DestinationList;
    static final byte[] CLSID_EnumerableObjectCollection;
    static final byte[] CLSID_ShellLink;
    static final byte[] CLSID_FileOperation;
    static final byte[] IID_ITaskbarList3;
    static final byte[] IID_ICustomDestinationList;
    static final byte[] IID_IObjectArray;
    static final byte[] IID_IObjectCollection;
    static final byte[] IID_IShellLinkW;
    static final byte[] IID_IPropertyStore;
    static final byte[] IID_IShellItem;
    static final byte[] IID_IFileOperation;
    static final byte[] FOLDERID_LocalAppData;

    TaskBar(Display display, int n2) {
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        this.display = display;
        this.createHandle();
        this.reskinWidget();
    }

    void createHandle() {
        int[] nArray = new int[1];
        int n2 = OS.CoCreateInstance(CLSID_TaskbarList, 0, 1, IID_ITaskbarList3, nArray);
        if (n2 != 0) {
            this.error(2);
        }
        this.mTaskbarList3 = nArray[0];
    }

    void createItem(TaskItem taskItem, int n2) {
        if (n2 == -1) {
            n2 = this.itemCount;
        }
        if (0 > n2 || n2 > this.itemCount) {
            this.error(6);
        }
        if (this.itemCount == this.items.length) {
            TaskItem[] taskItemArray = new TaskItem[this.items.length + 4];
            System.arraycopy(this.items, 0, taskItemArray, 0, this.items.length);
            this.items = taskItemArray;
        }
        System.arraycopy(this.items, n2, this.items, n2 + 1, this.itemCount++ - n2);
        this.items[n2] = taskItem;
    }

    void createItems() {
        Shell[] shellArray = this.display.getShells();
        for (int i2 = 0; i2 < shellArray.length; ++i2) {
            this.getItem(shellArray[i2]);
        }
        this.getItem(null);
    }

    int createShellLink(MenuItem menuItem, String string) {
        int n2;
        PROPERTYKEY pROPERTYKEY;
        int n3 = menuItem.getStyle();
        if ((n3 & 0x40) != 0) {
            return 0;
        }
        int[] nArray = new int[1];
        int n4 = OS.CoCreateInstance(CLSID_ShellLink, 0, 1, IID_IShellLinkW, nArray);
        if (n4 != 0) {
            this.error(2);
        }
        int n5 = nArray[0];
        int n6 = OS.GetProcessHeap();
        int n7 = OS.HeapAlloc(n6, 8, OS.PROPVARIANT_sizeof());
        int n8 = 0;
        if ((n3 & 2) != 0) {
            OS.MoveMemory(n7, new short[]{11}, 2);
            OS.MoveMemory(n7 + 8, new short[]{-1}, 2);
            pROPERTYKEY = PKEY_AppUserModel_IsDestListSeparator;
        } else {
            String string2 = menuItem.getText();
            int n9 = string2.length();
            char[] cArray = new char[n9 + 1];
            string2.getChars(0, n9, cArray, 0);
            n8 = OS.HeapAlloc(n6, 8, cArray.length * 2);
            OS.MoveMemory(n8, cArray, cArray.length * 2);
            OS.MoveMemory(n7, new short[]{31}, 2);
            OS.MoveMemory(n7 + 8, new int[]{n8}, OS.PTR_SIZEOF);
            pROPERTYKEY = PKEY_Title;
            String string3 = (String)menuItem.getData(EXE_PATH_KEY);
            if (string3 != null) {
                n9 = string3.length();
                cArray = new char[n9 + 1];
                string3.getChars(0, n9, cArray, 0);
            } else {
                cArray = EXE_PATH;
            }
            n4 = OS.VtblCall(20, n5, cArray);
            if (n4 != 0) {
                this.error(5);
            }
            if ((string2 = (String)menuItem.getData(EXE_ARGS_KEY)) == null) {
                string2 = "--launcher.openFile /SWTINTERNAL_ID" + menuItem.id;
            }
            n9 = string2.length();
            cArray = new char[n9 + 1];
            string2.getChars(0, n9, cArray, 0);
            n4 = OS.VtblCall(11, n5, cArray);
            if (n4 != 0) {
                this.error(5);
            }
            String string4 = (String)menuItem.getData(ICON_KEY);
            int n10 = 0;
            if (string4 != null) {
                string2 = (String)menuItem.getData(ICON_INDEX_KEY);
                if (string2 != null) {
                    n10 = Integer.parseInt(string2);
                }
            } else {
                Image image = menuItem.getImage();
                if (image != null && string != null) {
                    ImageData imageData;
                    Object object;
                    string4 = string + "\\menu" + menuItem.id + ".ico";
                    if (menuItem.hBitmap != 0) {
                        object = Image.win32_new(this.display, 0, menuItem.hBitmap);
                        imageData = ((Image)object).getImageData(DPIUtil.getDeviceZoom());
                    } else {
                        imageData = image.getImageData(DPIUtil.getDeviceZoom());
                    }
                    object = new ImageLoader();
                    ((ImageLoader)object).data = new ImageData[]{imageData};
                    ((ImageLoader)object).save(string4, 3);
                }
            }
            if (string4 != null) {
                n9 = string4.length();
                cArray = new char[n9 + 1];
                string4.getChars(0, n9, cArray, 0);
                n4 = OS.VtblCall(17, n5, cArray, n10);
                if (n4 != 0) {
                    this.error(5);
                }
            }
        }
        n4 = OS.VtblCall(0, n5, IID_IPropertyStore, nArray);
        if (n4 != 0) {
            this.error(2);
        }
        if ((n4 = OS.VtblCall(6, n2 = nArray[0], pROPERTYKEY, n7)) != 0) {
            this.error(5);
        }
        OS.VtblCall(7, n2);
        OS.VtblCall(2, n2);
        OS.HeapFree(n6, 0, n7);
        if (n8 != 0) {
            OS.HeapFree(n6, 0, n8);
        }
        return n5;
    }

    int createShellLinkArray(MenuItem[] menuItemArray, String string) {
        int n2;
        if (menuItemArray == null) {
            return 0;
        }
        if (menuItemArray.length == 0) {
            return 0;
        }
        int[] nArray = new int[1];
        int n3 = OS.CoCreateInstance(CLSID_EnumerableObjectCollection, 0, 1, IID_IObjectCollection, nArray);
        if (n3 != 0) {
            this.error(2);
        }
        int n4 = nArray[0];
        for (n2 = 0; n2 < menuItemArray.length; ++n2) {
            int n5 = this.createShellLink(menuItemArray[n2], string);
            if (n5 == 0) continue;
            n3 = OS.VtblCall(5, n4, n5);
            if (n3 != 0) {
                this.error(5);
            }
            OS.VtblCall(2, n5);
        }
        n3 = OS.VtblCall(0, n4, IID_IObjectArray, nArray);
        if (n3 != 0) {
            this.error(2);
        }
        n2 = nArray[0];
        OS.VtblCall(2, n4);
        return n2;
    }

    void destroyItem(TaskItem taskItem) {
        int n2;
        for (n2 = 0; n2 < this.itemCount && this.items[n2] != taskItem; ++n2) {
        }
        if (n2 == this.itemCount) {
            return;
        }
        System.arraycopy(this.items, n2 + 1, this.items, n2, --this.itemCount - n2);
        this.items[this.itemCount] = null;
    }

    String getDirectory(char[] cArray) {
        char[] cArray2 = new char[cArray.length];
        block3: for (int i2 = 0; i2 < cArray.length; ++i2) {
            char c2 = cArray[i2];
            switch (c2) {
                case '\"': 
                case '*': 
                case '/': 
                case ':': 
                case '<': 
                case '>': 
                case '?': 
                case '\\': 
                case '|': {
                    cArray2[i2] = 95;
                    continue block3;
                }
                default: {
                    cArray2[i2] = c2;
                }
            }
        }
        String string = null;
        int[] nArray = new int[1];
        int n2 = OS.SHCreateItemInKnownFolder(FOLDERID_LocalAppData, 0, null, IID_IShellItem, nArray);
        if (n2 == 0) {
            int n3 = nArray[0];
            n2 = OS.CoCreateInstance(CLSID_FileOperation, 0, 1, IID_IFileOperation, nArray);
            if (n2 == 0) {
                int n4;
                int n5 = nArray[0];
                n2 = OS.VtblCall(5, n5, 1556);
                if (n2 == 0 && (n4 = this.getDirectory(n3, n5, cArray2, false)) != 0) {
                    int n6 = this.getDirectory(n4, n5, ICO_DIR, true);
                    if (n6 != 0) {
                        n2 = OS.VtblCall(5, n6, -2147123200, nArray);
                        if (n2 == 0) {
                            int n7 = nArray[0];
                            int n8 = OS.wcslen(n7);
                            char[] cArray3 = new char[n8];
                            OS.MoveMemory(cArray3, n7, n8 * 2);
                            string = new String(cArray3);
                            OS.CoTaskMemFree(n7);
                        }
                        OS.VtblCall(2, n6);
                    }
                    OS.VtblCall(2, n4);
                }
                OS.VtblCall(2, n5);
            }
            OS.VtblCall(2, n3);
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int getDirectory(int n2, int n3, char[] cArray, boolean bl2) {
        int[] nArray = new int[1];
        int n4 = OS.SHCreateItemFromRelativeName(n2, cArray, 0, IID_IShellItem, nArray);
        if (n4 == 0) {
            if (!bl2) return nArray[0];
            n4 = OS.VtblCall(18, n3, nArray[0], 0);
            OS.VtblCall(2, nArray[0]);
            if (n4 != 0 || (n4 = OS.VtblCall(20, n3, n2, 16, cArray, null, 0)) != 0 || (n4 = OS.VtblCall(21, n3)) != 0 || (n4 = OS.SHCreateItemFromRelativeName(n2, cArray, 0, IID_IShellItem, nArray)) != 0) return 0;
            return nArray[0];
        }
        n4 = OS.VtblCall(20, n3, n2, 16, cArray, null, 0);
        if (n4 != 0 || (n4 = OS.VtblCall(21, n3)) != 0 || (n4 = OS.SHCreateItemFromRelativeName(n2, cArray, 0, IID_IShellItem, nArray)) != 0) return 0;
        return nArray[0];
    }

    public TaskItem getItem(int n2) {
        this.checkWidget();
        this.createItems();
        if (0 > n2 || n2 >= this.itemCount) {
            this.error(6);
        }
        return this.items[n2];
    }

    public TaskItem getItem(Shell shell) {
        this.checkWidget();
        for (int i2 = 0; i2 < this.items.length; ++i2) {
            if (this.items[i2] == null || this.items[i2].shell != shell) continue;
            return this.items[i2];
        }
        TaskItem taskItem = new TaskItem(this, 0);
        if (shell != null) {
            taskItem.setShell(shell);
        }
        return taskItem;
    }

    public int getItemCount() {
        this.checkWidget();
        this.createItems();
        return this.itemCount;
    }

    public TaskItem[] getItems() {
        this.checkWidget();
        this.createItems();
        TaskItem[] taskItemArray = new TaskItem[this.itemCount];
        System.arraycopy(this.items, 0, taskItemArray, 0, taskItemArray.length);
        return taskItemArray;
    }

    @Override
    void releaseChildren(boolean bl2) {
        if (this.items != null) {
            for (int i2 = 0; i2 < this.items.length; ++i2) {
                TaskItem taskItem = this.items[i2];
                if (taskItem == null || taskItem.isDisposed()) continue;
                taskItem.release(false);
            }
            this.items = null;
        }
        super.releaseChildren(bl2);
    }

    @Override
    void releaseParent() {
        super.releaseParent();
        if (this.display.taskBar == this) {
            this.display.taskBar = null;
        }
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.mTaskbarList3 != 0) {
            OS.VtblCall(2, this.mTaskbarList3);
            this.mTaskbarList3 = 0;
        }
    }

    @Override
    void reskinChildren(int n2) {
        if (this.items != null) {
            for (int i2 = 0; i2 < this.items.length; ++i2) {
                TaskItem taskItem = this.items[i2];
                if (taskItem == null) continue;
                taskItem.reskin(n2);
            }
        }
        super.reskinChildren(n2);
    }

    void setMenu(Menu menu) {
        int[] nArray = new int[1];
        int n2 = OS.CoCreateInstance(CLSID_DestinationList, 0, 1, IID_ICustomDestinationList, nArray);
        if (n2 != 0) {
            this.error(2);
        }
        int n3 = nArray[0];
        String string = Display.APP_NAME;
        char[] cArray = new char[]{'S', 'W', 'T', '\u0000'};
        if (string != null && string.length() > 0) {
            int n4 = string.length();
            cArray = new char[n4 + 1];
            string.getChars(0, n4, cArray, 0);
        }
        MenuItem[] menuItemArray = null;
        if (menu != null && (menuItemArray = menu.getItems()).length != 0) {
            Object object;
            int n5;
            String string2 = null;
            for (n5 = 0; n5 < menuItemArray.length; ++n5) {
                object = menuItemArray[n5];
                if (((Item)object).getImage() == null || ((Widget)object).getData(ICON_KEY) != null) continue;
                string2 = this.getDirectory(cArray);
                break;
            }
            if ((n5 = this.createShellLinkArray(menuItemArray, string2)) != 0) {
                n2 = OS.VtblCall(3, n3, cArray);
                if (n2 != 0) {
                    this.error(5);
                }
                object = new int[1];
                OS.VtblCall(4, n3, (int[])object, IID_IObjectArray, nArray);
                if (n2 != 0) {
                    this.error(5);
                }
                int n6 = nArray[0];
                int[] nArray2 = new int[1];
                OS.VtblCall(3, n5, nArray2);
                if (nArray2[0] != 0 && (n2 = OS.VtblCall(7, n3, n5)) != 0) {
                    this.error(5);
                }
                for (int i2 = 0; i2 < menuItemArray.length; ++i2) {
                    Object object2;
                    int n7;
                    Menu menu2;
                    MenuItem menuItem = menuItemArray[i2];
                    if ((menuItem.getStyle() & 0x40) == 0 || (menu2 = menuItem.getMenu()) == null) continue;
                    MenuItem[] menuItemArray2 = menu2.getItems();
                    if (string2 == null) {
                        for (n7 = 0; n7 < menuItemArray2.length; ++n7) {
                            object2 = menuItemArray2[n7];
                            if (((Item)object2).getImage() == null || ((Widget)object2).getData(ICON_KEY) != null) continue;
                            string2 = this.getDirectory(cArray);
                            break;
                        }
                    }
                    if ((n7 = this.createShellLinkArray(menuItemArray2, string2)) == 0) continue;
                    OS.VtblCall(3, n7, nArray2);
                    if (nArray2[0] != 0) {
                        object2 = menuItem.getText();
                        int n8 = ((String)object2).length();
                        char[] cArray2 = new char[n8 + 1];
                        ((String)object2).getChars(0, n8, cArray2, 0);
                        n2 = OS.VtblCall(5, n3, cArray2, n7);
                        if (n2 != 0) {
                            this.error(5);
                        }
                    }
                    OS.VtblCall(2, n7);
                }
                n2 = OS.VtblCall(8, n3);
                if (n2 != 0) {
                    this.error(5);
                }
                if (n6 != 0) {
                    OS.VtblCall(2, n6);
                }
                OS.VtblCall(2, n5);
            }
        } else {
            n2 = OS.VtblCall(10, n3, cArray);
            if (n2 != 0) {
                this.error(5);
            }
        }
        OS.VtblCall(2, n3);
    }

    static {
        ICO_DIR = new char[]{'i', 'c', 'o', '_', 'd', 'i', 'r', '\u0000'};
        PKEY_Title = new PROPERTYKEY();
        PKEY_AppUserModel_IsDestListSeparator = new PROPERTYKEY();
        CLSID_TaskbarList = new byte[16];
        CLSID_DestinationList = new byte[16];
        CLSID_EnumerableObjectCollection = new byte[16];
        CLSID_ShellLink = new byte[16];
        CLSID_FileOperation = new byte[16];
        IID_ITaskbarList3 = new byte[16];
        IID_ICustomDestinationList = new byte[16];
        IID_IObjectArray = new byte[16];
        IID_IObjectCollection = new byte[16];
        IID_IShellLinkW = new byte[16];
        IID_IPropertyStore = new byte[16];
        IID_IShellItem = new byte[16];
        IID_IFileOperation = new byte[16];
        FOLDERID_LocalAppData = new byte[16];
        OS.IIDFromString("{56FDF344-FD6D-11d0-958A-006097C9A090}\u0000".toCharArray(), CLSID_TaskbarList);
        OS.IIDFromString("{77f10cf0-3db5-4966-b520-b7c54fd35ed6}\u0000".toCharArray(), CLSID_DestinationList);
        OS.IIDFromString("{2d3468c1-36a7-43b6-ac24-d3f02fd9607a}\u0000".toCharArray(), CLSID_EnumerableObjectCollection);
        OS.IIDFromString("{00021401-0000-0000-C000-000000000046}\u0000".toCharArray(), CLSID_ShellLink);
        OS.IIDFromString("{3ad05575-8857-4850-9277-11b85bdb8e09}\u0000".toCharArray(), CLSID_FileOperation);
        OS.IIDFromString("{EA1AFB91-9E28-4B86-90E9-9E9F8A5EEFAF}\u0000".toCharArray(), IID_ITaskbarList3);
        OS.IIDFromString("{6332debf-87b5-4670-90c0-5e57b408a49e}\u0000".toCharArray(), IID_ICustomDestinationList);
        OS.IIDFromString("{92CA9DCD-5622-4bba-A805-5E9F541BD8C9}\u0000".toCharArray(), IID_IObjectArray);
        OS.IIDFromString("{5632b1a4-e38a-400a-928a-d4cd63230295}\u0000".toCharArray(), IID_IObjectCollection);
        OS.IIDFromString("{000214F9-0000-0000-C000-000000000046}\u0000".toCharArray(), IID_IShellLinkW);
        OS.IIDFromString("{886d8eeb-8cf2-4446-8d02-cdba1dbdcf99}\u0000".toCharArray(), IID_IPropertyStore);
        OS.IIDFromString("{43826d1e-e718-42ee-bc55-a1e261c37bfe}\u0000".toCharArray(), IID_IShellItem);
        OS.IIDFromString("{947aab5f-0a5c-4c13-b4d6-4bf7836fc9f8}\u0000".toCharArray(), IID_IFileOperation);
        OS.IIDFromString("{F1B32785-6FBA-4FCF-9D55-7B8E7F157091}\u0000".toCharArray(), FOLDERID_LocalAppData);
        OS.PSPropertyKeyFromString("{F29F85E0-4FF9-1068-AB91-08002B27B3D9} 2\u0000".toCharArray(), PKEY_Title);
        OS.PSPropertyKeyFromString("{9F4C2855-9F79-4B39-A8D0-E1D42DE1D5F3}, 6\u0000".toCharArray(), PKEY_AppUserModel_IsDestListSeparator);
        TCHAR tCHAR = new TCHAR(0, 260);
        while (OS.GetModuleFileName(0, tCHAR, tCHAR.length()) == tCHAR.length()) {
            tCHAR = new TCHAR(0, tCHAR.length() + 260);
        }
        int n2 = tCHAR.strlen();
        EXE_PATH = new char[n2 + 1];
        System.arraycopy(tCHAR.chars, 0, EXE_PATH, 0, n2);
    }
}

