/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.regex.Matcher;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SegmentListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.BidiUtil;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.win32.GUITHREADINFO;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.MSG;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.PAINTSTRUCT;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SHRGINFO;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;

public class Text
extends Scrollable {
    int tabs;
    int oldStart;
    int oldEnd;
    boolean doubleClick;
    boolean ignoreModify;
    boolean ignoreVerify;
    boolean ignoreCharacter;
    boolean allowPasswordChar;
    String message;
    int[] segments;
    int clearSegmentsCount = 0;
    static final char LTR_MARK = '\u200e';
    static final char RTL_MARK = '\u200f';
    public static final int LIMIT = OS.IsWinNT ? Integer.MAX_VALUE : Short.MAX_VALUE;
    public static final String DELIMITER = "\r\n";
    static final int EditProc;
    static final TCHAR EditClass;

    public Text(Composite composite, int n2) {
        super(composite, Text.checkStyle(n2));
    }

    @Override
    int callWindowProc(int n2, int n3, int n4, int n5) {
        int n6;
        if (this.handle == 0) {
            return 0;
        }
        boolean bl2 = false;
        switch (n3) {
            case 20: {
                if (this.findImageControl() == null) break;
                return 0;
            }
            case 276: 
            case 277: {
                boolean bl3 = bl2 = this.findImageControl() != null && this.getDrawing() && OS.IsWindowVisible(this.handle);
                if (!bl2) break;
                OS.DefWindowProc(this.handle, 11, 0, 0);
                break;
            }
            case 15: {
                n6 = this.findImageControl() != null ? 1 : 0;
                boolean bl4 = false;
                if ((this.style & 4) != 0 && this.message.length() > 0 && (!OS.IsWinCE && OS.WIN32_VERSION < OS.VERSION(6, 0) || (this.style & 8) != 0)) {
                    boolean bl5 = bl4 = n2 != OS.GetFocus() && OS.GetWindowTextLength(this.handle) == 0;
                }
                if (n6 == 0 && !bl4) break;
                int n7 = 0;
                PAINTSTRUCT pAINTSTRUCT = new PAINTSTRUCT();
                n7 = OS.BeginPaint(this.handle, pAINTSTRUCT);
                int n8 = pAINTSTRUCT.right - pAINTSTRUCT.left;
                int n9 = pAINTSTRUCT.bottom - pAINTSTRUCT.top;
                if (n8 != 0 && n9 != 0) {
                    RECT rECT;
                    int n10 = n7;
                    int n11 = 0;
                    int n12 = 0;
                    POINT pOINT = null;
                    POINT pOINT2 = null;
                    if (n6 != 0) {
                        n10 = OS.CreateCompatibleDC(n7);
                        pOINT = new POINT();
                        pOINT2 = new POINT();
                        OS.SetWindowOrgEx(n10, pAINTSTRUCT.left, pAINTSTRUCT.top, pOINT);
                        OS.SetBrushOrgEx(n10, pAINTSTRUCT.left, pAINTSTRUCT.top, pOINT2);
                        n11 = OS.CreateCompatibleBitmap(n7, n8, n9);
                        n12 = OS.SelectObject(n10, n11);
                        rECT = new RECT();
                        OS.SetRect(rECT, pAINTSTRUCT.left, pAINTSTRUCT.top, pAINTSTRUCT.right, pAINTSTRUCT.bottom);
                        this.drawBackground(n10, rECT);
                    }
                    OS.CallWindowProc(EditProc, n2, 15, n10, n5);
                    if (bl4) {
                        boolean bl6;
                        rECT = new RECT();
                        OS.GetClientRect(this.handle, rECT);
                        int n13 = OS.SendMessage(this.handle, 212, 0, 0);
                        rECT.left += OS.LOWORD(n13);
                        rECT.right -= OS.HIWORD(n13);
                        if ((this.style & 0x800) != 0) {
                            ++rECT.left;
                            ++rECT.top;
                            --rECT.right;
                            --rECT.bottom;
                        }
                        TCHAR tCHAR = new TCHAR(this.getCodePage(), this.message, false);
                        int n14 = 8192;
                        boolean bl7 = bl6 = (this.style & 0x4000000) != 0;
                        if (bl6) {
                            n14 |= 0x20000;
                        }
                        int n15 = this.style & 0x1024000;
                        switch (n15) {
                            case 16384: {
                                n14 |= bl6 ? 2 : 0;
                                break;
                            }
                            case 0x1000000: {
                                n14 |= 1;
                            }
                            case 131072: {
                                n14 |= bl6 ? 0 : 2;
                            }
                        }
                        int n16 = OS.SendMessage(n2, 49, 0, 0);
                        int n17 = OS.SelectObject(n10, n16);
                        OS.SetTextColor(n10, OS.GetSysColor(OS.COLOR_GRAYTEXT));
                        OS.SetBkMode(n10, 1);
                        OS.DrawText(n10, tCHAR, tCHAR.length(), rECT, n14);
                        OS.SelectObject(n10, n17);
                    }
                    if (n6 != 0) {
                        OS.SetWindowOrgEx(n10, pOINT.x, pOINT.y, null);
                        OS.SetBrushOrgEx(n10, pOINT2.x, pOINT2.y, null);
                        OS.BitBlt(n7, pAINTSTRUCT.left, pAINTSTRUCT.top, n8, n9, n10, 0, 0, 0xCC0020);
                        OS.SelectObject(n10, n12);
                        OS.DeleteObject(n11);
                        OS.DeleteObject(n10);
                    }
                }
                OS.EndPaint(this.handle, pAINTSTRUCT);
                return 0;
            }
        }
        n6 = OS.CallWindowProc(EditProc, n2, n3, n4, n5);
        switch (n3) {
            case 276: 
            case 277: {
                if (!bl2) break;
                OS.DefWindowProc(this.handle, 11, 1, 0);
                OS.InvalidateRect(this.handle, null, true);
            }
        }
        return n6;
    }

    @Override
    void createHandle() {
        super.createHandle();
        OS.SendMessage(this.handle, 197, 0, 0);
        if ((this.style & 8) != 0 && this.applyThemeBackground() == 1) {
            this.state |= 0x100;
        }
    }

    @Override
    int applyThemeBackground() {
        return this.backgroundAlpha == 0 || (this.style & 0xB00) == 0 ? 1 : 0;
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(modifyListener);
        this.addListener(24, typedListener);
    }

    public void addSegmentListener(SegmentListener segmentListener) {
        this.checkWidget();
        if (segmentListener == null) {
            this.error(4);
        }
        this.addListener(49, new TypedListener(segmentListener));
        this.clearSegments(true);
        this.applySegments();
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(verifyListener);
        this.addListener(25, typedListener);
    }

    public void append(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        string = Display.withCrLf(string);
        int n2 = OS.GetWindowTextLength(this.handle);
        if ((this.hooks(25) || this.filters(25)) && (string = this.verifyText(string, n2, n2, null)) == null) {
            return;
        }
        OS.SendMessage(this.handle, 177, n2, n2);
        this.clearSegments(true);
        TCHAR tCHAR = new TCHAR(this.getCodePage(), string, true);
        this.ignoreCharacter = true;
        OS.SendMessage(this.handle, 194, 0, tCHAR);
        this.ignoreCharacter = false;
        OS.SendMessage(this.handle, 183, 0, 0);
        if ((this.state & 0x400000) != 0) {
            super.updateTextDirection(0x6000000);
        }
        this.applySegments();
    }

    void applySegments() {
        int n2;
        int n3;
        int n4;
        char[] cArray;
        if (this.isDisposed() || --this.clearSegmentsCount != 0) {
            return;
        }
        if (!this.hooks(49) && !this.filters(49)) {
            return;
        }
        int n5 = OS.GetWindowTextLength(this.handle);
        int n6 = this.getCodePage();
        TCHAR tCHAR = new TCHAR(n6, n5 + 1);
        if (n5 > 0) {
            OS.GetWindowText(this.handle, tCHAR, n5 + 1);
        }
        String string = tCHAR.toString(0, n5);
        Event event = new Event();
        event.text = string;
        event.segments = this.segments;
        this.sendEvent(49, event);
        this.segments = event.segments;
        if (this.segments == null) {
            return;
        }
        int n7 = this.segments.length;
        if (n7 == 0) {
            return;
        }
        n5 = string == null ? 0 : string.length();
        for (int i2 = 1; i2 < n7; ++i2) {
            if (event.segments[i2] >= event.segments[i2 - 1] && event.segments[i2] <= n5) continue;
            this.error(5);
        }
        char[] cArray2 = event.segmentsChars;
        char[] cArray3 = cArray = cArray2 == null ? null : Display.withCrLf(cArray2);
        if (cArray2 != cArray) {
            int[] nArray = new int[n7 + Math.min(n7, cArray.length - cArray2.length)];
            n4 = 0;
            for (int i3 = 0; i3 < cArray2.length && i3 < n7; ++i3) {
                if (cArray2[i3] == '\n' && cArray[i3 + n4] == '\r') {
                    nArray[i3 + n4++] = this.segments[i3];
                }
                nArray[i3 + n4] = this.segments[i3];
            }
            this.segments = nArray;
            n7 = this.segments.length;
            cArray2 = cArray;
        }
        int n8 = OS.SendMessage(this.handle, 213, 0, 0) & Integer.MAX_VALUE;
        OS.SendMessage(this.handle, 197, n8 + Math.min(n7, LIMIT - n8), 0);
        char[] cArray4 = new char[(n5 += n7) + 1];
        n4 = 0;
        int n9 = 0;
        int n10 = n3 = this.getOrientation() == 0x4000000 ? 8207 : 8206;
        while (n4 < n5) {
            if (n9 < n7 && n4 - n9 == this.segments[n9]) {
                n2 = cArray2 != null && cArray2.length > n9 ? cArray2[n9] : n3;
                cArray4[n4++] = n2;
                ++n9;
                continue;
            }
            if (string == null) continue;
            cArray4[n4] = string.charAt(n4++ - n9);
        }
        while (n9 < n7) {
            this.segments[n9] = n4 - n9;
            n2 = cArray2 != null && cArray2.length > n9 ? cArray2[n9] : n3;
            cArray4[n4++] = n2;
            ++n9;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.SendMessage(this.handle, 176, nArray, nArray2);
        if (!OS.IsUnicode && OS.IsDBLocale) {
            nArray[0] = this.mbcsToWcsPos(nArray[0]);
            nArray2[0] = this.mbcsToWcsPos(nArray2[0]);
        }
        boolean bl2 = this.ignoreCharacter;
        boolean bl3 = this.ignoreModify;
        boolean bl4 = this.ignoreVerify;
        this.ignoreVerify = true;
        this.ignoreModify = true;
        this.ignoreCharacter = true;
        cArray4[n5] = '\u0000';
        tCHAR = new TCHAR(n6, cArray4, false);
        OS.SendMessage(this.handle, 177, 0, -1);
        int n11 = OS.SendMessage(this.handle, 198, 0, 0);
        OS.SendMessage(this.handle, 194, n11, tCHAR);
        nArray[0] = this.translateOffset(nArray[0]);
        nArray2[0] = this.translateOffset(nArray2[0]);
        if (!OS.IsUnicode && OS.IsDBLocale) {
            nArray[0] = this.wcsToMbcsPos(nArray[0]);
            nArray2[0] = this.wcsToMbcsPos(nArray2[0]);
        }
        OS.SendMessage(this.handle, 177, nArray[0], nArray2[0]);
        this.ignoreCharacter = bl2;
        this.ignoreModify = bl3;
        this.ignoreVerify = bl4;
    }

    static int checkStyle(int n2) {
        if ((n2 & 0x80) != 0) {
            n2 |= 0x804;
            n2 &= 0xFFBFFFFF;
        }
        if ((n2 & 4) != 0 && (n2 & 2) != 0) {
            n2 &= 0xFFFFFFFD;
        }
        if (((n2 = Text.checkBits(n2, 16384, 0x1000000, 131072, 0, 0, 0)) & 4) != 0) {
            n2 &= 0xFFFFFCBF;
        }
        if ((n2 & 0x40) != 0) {
            n2 |= 2;
            n2 &= 0xFFFFFEFF;
        }
        if ((n2 & 2) != 0) {
            n2 &= 0xFFBFFFFF;
        }
        if ((n2 & 6) != 0) {
            return n2;
        }
        if ((n2 & 0x300) != 0) {
            return n2 | 2;
        }
        return n2 | 4;
    }

    void clearSegments(boolean bl2) {
        if (this.clearSegmentsCount++ != 0) {
            return;
        }
        if (this.segments == null) {
            return;
        }
        int n2 = this.segments.length;
        if (n2 == 0) {
            return;
        }
        int n3 = OS.SendMessage(this.handle, 213, 0, 0) & Integer.MAX_VALUE;
        if (n3 < LIMIT) {
            OS.SendMessage(this.handle, 197, Math.max(1, n3 - n2), 0);
        }
        if (!bl2) {
            this.segments = null;
            return;
        }
        boolean bl3 = this.ignoreCharacter;
        boolean bl4 = this.ignoreModify;
        boolean bl5 = this.ignoreVerify;
        this.ignoreVerify = true;
        this.ignoreModify = true;
        this.ignoreCharacter = true;
        int n4 = OS.GetWindowTextLength(this.handle);
        int n5 = this.getCodePage();
        TCHAR tCHAR = new TCHAR(n5, n4 + 1);
        if (n4 > 0) {
            OS.GetWindowText(this.handle, tCHAR, n4 + 1);
        }
        tCHAR = this.deprocessText(tCHAR, 0, -1, true);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.SendMessage(this.handle, 176, nArray, nArray2);
        if (!OS.IsUnicode && OS.IsDBLocale) {
            nArray[0] = this.mbcsToWcsPos(nArray[0]);
            nArray2[0] = this.mbcsToWcsPos(nArray2[0]);
        }
        nArray[0] = this.untranslateOffset(nArray[0]);
        nArray2[0] = this.untranslateOffset(nArray2[0]);
        this.segments = null;
        OS.SendMessage(this.handle, 177, 0, -1);
        int n6 = OS.SendMessage(this.handle, 198, 0, 0);
        OS.SendMessage(this.handle, 194, n6, tCHAR);
        if (!OS.IsUnicode && OS.IsDBLocale) {
            nArray[0] = this.wcsToMbcsPos(nArray[0]);
            nArray2[0] = this.wcsToMbcsPos(nArray2[0]);
        }
        OS.SendMessage(this.handle, 177, nArray[0], nArray2[0]);
        this.ignoreCharacter = bl3;
        this.ignoreModify = bl4;
        this.ignoreVerify = bl5;
    }

    public void clearSelection() {
        this.checkWidget();
        if (OS.IsWinCE) {
            int[] nArray = new int[1];
            OS.SendMessage(this.handle, 176, (int[])null, nArray);
            OS.SendMessage(this.handle, 177, nArray[0], nArray[0]);
        } else {
            OS.SendMessage(this.handle, 177, -1, 0);
        }
    }

    @Override
    Point computeSizeInPixels(int n2, int n3, boolean bl2) {
        this.checkWidget();
        int n4 = 0;
        int n5 = 0;
        if (n2 == -1 || n3 == -1) {
            int n6;
            TCHAR tCHAR;
            int n7;
            boolean bl3;
            int n8 = 0;
            int n9 = OS.GetDC(this.handle);
            int n10 = OS.SendMessage(this.handle, 49, 0, 0);
            if (n10 != 0) {
                n8 = OS.SelectObject(n9, n10);
            }
            TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
            OS.GetTextMetrics(n9, tEXTMETRIC);
            int n11 = (this.style & 4) != 0 ? 1 : OS.SendMessage(this.handle, 186, 0, 0);
            n4 = n11 * tEXTMETRIC.tmHeight;
            RECT rECT = new RECT();
            int n12 = 11264;
            boolean bl4 = bl3 = (this.style & 2) != 0 && (this.style & 0x40) != 0;
            if (bl3 && n2 != -1) {
                n12 |= 0x10;
                rECT.right = n2;
            }
            if ((n7 = OS.GetWindowTextLength(this.handle)) != 0) {
                tCHAR = new TCHAR(this.getCodePage(), n7 + 1);
                OS.GetWindowText(this.handle, tCHAR, n7 + 1);
                OS.DrawText(n9, tCHAR, n7, rECT, n12);
                tCHAR.clear();
                n5 = rECT.right - rECT.left;
            }
            if (bl3 && n3 == -1 && (n6 = rECT.bottom - rECT.top) != 0) {
                n4 = n6;
            }
            if ((this.style & 4) != 0 && this.message.length() > 0) {
                OS.SetRect(rECT, 0, 0, 0, 0);
                tCHAR = new TCHAR(this.getCodePage(), this.message, false);
                OS.DrawText(n9, tCHAR, tCHAR.length(), rECT, n12);
                n5 = Math.max(n5, rECT.right - rECT.left);
            }
            if (n10 != 0) {
                OS.SelectObject(n9, n8);
            }
            OS.ReleaseDC(this.handle, n9);
        }
        if (n5 == 0) {
            n5 = 64;
        }
        if (n4 == 0) {
            n4 = 64;
        }
        if (n2 != -1) {
            n5 = n2;
        }
        if (n3 != -1) {
            n4 = n3;
        }
        Rectangle rectangle = this.computeTrimInPixels(0, 0, n5, n4);
        return new Point(rectangle.width, rectangle.height);
    }

    @Override
    Rectangle computeTrimInPixels(int n2, int n3, int n4, int n5) {
        this.checkWidget();
        Rectangle rectangle = super.computeTrimInPixels(n2, n3, n4, n5);
        int n6 = OS.SendMessage(this.handle, 212, 0, 0);
        rectangle.x -= OS.LOWORD(n6);
        rectangle.width += OS.LOWORD(n6) + OS.HIWORD(n6);
        if ((this.style & 0x100) != 0) {
            ++rectangle.width;
        }
        if ((this.style & 0x800) != 0) {
            --rectangle.x;
            --rectangle.y;
            rectangle.width += 2;
            rectangle.height += 2;
        }
        return rectangle;
    }

    public void copy() {
        this.checkWidget();
        OS.SendMessage(this.handle, 769, 0, 0);
    }

    @Override
    void createWidget() {
        super.createWidget();
        this.message = "";
        this.doubleClick = true;
        this.tabs = 8;
        this.setTabStops(8);
        this.fixAlignment();
    }

    public void cut() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        OS.SendMessage(this.handle, 768, 0, 0);
    }

    @Override
    int defaultBackground() {
        int n2 = OS.GetWindowLong(this.handle, -16);
        return OS.GetSysColor((n2 & 0x800) != 0 ? OS.COLOR_3DFACE : OS.COLOR_WINDOW);
    }

    TCHAR deprocessText(TCHAR tCHAR, int n2, int n3, boolean bl2) {
        int n4;
        char[] cArray;
        if (tCHAR == null) {
            return null;
        }
        int n5 = tCHAR.length();
        if (n2 < 0) {
            n2 = 0;
        }
        if (OS.IsUnicode) {
            cArray = tCHAR.chars;
            if (tCHAR.chars[n5 - 1] == '\u0000') {
                --n5;
            }
        } else {
            cArray = new char[n5];
            n5 = OS.MultiByteToWideChar(this.getCodePage(), 1, tCHAR.bytes, n5, cArray, n5);
        }
        if (n3 == -1) {
            n3 = n5;
        }
        if (this.segments != null && n3 > this.segments[0] && (n4 = this.segments.length) > 0 && n2 <= this.segments[n4 - 1]) {
            int n6 = 0;
            while (n2 - n6 > this.segments[n6]) {
                ++n6;
            }
            int n7 = n6;
            for (int i2 = n2; i2 < n3; ++i2) {
                if (n7 < n4 && i2 - n7 == this.segments[n7]) {
                    ++n7;
                    continue;
                }
                cArray[i2 - n7 + n6] = cArray[i2];
            }
            n5 = n3 - n2 - n7 + n6;
        }
        if (n2 != 0 || n3 != n5) {
            char[] cArray2 = new char[n5];
            System.arraycopy(cArray, n2, cArray2, 0, n5);
            return new TCHAR(this.getCodePage(), cArray2, bl2);
        }
        return tCHAR;
    }

    @Override
    boolean dragDetect(int n2, int n3, int n4, boolean bl2, boolean[] blArray, boolean[] blArray2) {
        if (bl2) {
            int n5;
            int n6;
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.SendMessage(this.handle, 176, nArray, nArray2);
            if (nArray[0] != nArray2[0] && nArray[0] <= (n6 = OS.LOWORD(OS.SendMessage(this.handle, 215, 0, n5 = OS.MAKELPARAM(n3, n4)))) && n6 < nArray2[0] && super.dragDetect(n2, n3, n4, bl2, blArray, blArray2)) {
                if (blArray2 != null) {
                    blArray2[0] = true;
                }
                return true;
            }
            return false;
        }
        return super.dragDetect(n2, n3, n4, bl2, blArray, blArray2);
    }

    void fixAlignment() {
        if ((this.style & 0x8000000) != 0) {
            return;
        }
        int n2 = OS.GetWindowLong(this.handle, -20);
        int n3 = OS.GetWindowLong(this.handle, -16);
        if ((this.style & 0x2000000) != 0) {
            n2 &= 0xFFFFBFFF;
            if ((this.style & 0x20000) != 0) {
                n2 |= 0x1000;
                n3 |= 2;
            }
            if ((this.style & 0x4000) != 0) {
                n2 &= 0xFFFFEFFF;
                n3 &= 0xFFFFFFFD;
            }
        } else {
            if ((this.style & 0x20000) != 0) {
                n2 &= 0xFFFFEFFF;
                n3 &= 0xFFFFFFFD;
            }
            if ((this.style & 0x4000) != 0) {
                n2 |= 0x1000;
                n3 |= 2;
            }
        }
        if ((this.style & 0x1000000) != 0) {
            n3 |= 1;
        }
        OS.SetWindowLong(this.handle, -20, n2);
        OS.SetWindowLong(this.handle, -16, n3);
    }

    @Override
    int getBorderWidthInPixels() {
        this.checkWidget();
        return super.getBorderWidthInPixels();
    }

    public int getCaretLineNumber() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 201, -1, 0);
    }

    public Point getCaretLocation() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getCaretLocationInPixels());
    }

    Point getCaretLocationInPixels() {
        int n2 = this.translateOffset(this.getCaretPosition());
        int n3 = OS.SendMessage(this.handle, 214, n2, 0);
        if (n3 == -1) {
            n3 = 0;
            if (n2 >= OS.GetWindowTextLength(this.handle)) {
                int n4 = this.getCodePage();
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                OS.SendMessage(this.handle, 176, nArray, nArray2);
                OS.SendMessage(this.handle, 177, n2, n2);
                this.ignoreModify = true;
                this.ignoreCharacter = true;
                OS.SendMessage(this.handle, 194, 0, new TCHAR(n4, " ", true));
                n3 = OS.SendMessage(this.handle, 214, n2, 0);
                OS.SendMessage(this.handle, 177, n2, n2 + 1);
                OS.SendMessage(this.handle, 194, 0, new TCHAR(n4, "", true));
                this.ignoreModify = false;
                this.ignoreCharacter = false;
                OS.SendMessage(this.handle, 177, nArray[0], nArray[0]);
                OS.SendMessage(this.handle, 177, nArray[0], nArray2[0]);
            }
        }
        return new Point(OS.GET_X_LPARAM(n3), OS.GET_Y_LPARAM(n3));
    }

    public int getCaretPosition() {
        this.checkWidget();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.SendMessage(this.handle, 176, nArray, nArray2);
        int n2 = nArray[0];
        if (nArray[0] != nArray2[0]) {
            int n3;
            int n4 = OS.SendMessage(this.handle, 201, nArray[0], 0);
            if (n4 == (n3 = OS.SendMessage(this.handle, 201, nArray2[0], 0))) {
                if (!OS.IsWinCE) {
                    POINT pOINT;
                    int n5 = OS.GetWindowThreadProcessId(this.handle, null);
                    GUITHREADINFO gUITHREADINFO = new GUITHREADINFO();
                    gUITHREADINFO.cbSize = GUITHREADINFO.sizeof;
                    if (OS.GetGUIThreadInfo(n5, gUITHREADINFO) && (gUITHREADINFO.hwndCaret == this.handle || gUITHREADINFO.hwndCaret == 0) && OS.GetCaretPos(pOINT = new POINT())) {
                        int n6 = OS.SendMessage(this.handle, 214, nArray2[0], 0);
                        if (n6 == -1) {
                            int n7 = OS.SendMessage(this.handle, 214, nArray[0], 0);
                            int n8 = OS.GET_X_LPARAM(n7);
                            if (pOINT.x > n8) {
                                n2 = nArray2[0];
                            }
                        } else {
                            int n9 = OS.GET_X_LPARAM(n6);
                            if (pOINT.x >= n9) {
                                n2 = nArray2[0];
                            }
                        }
                    }
                }
            } else {
                int n10 = OS.SendMessage(this.handle, 187, -1, 0);
                int n11 = OS.SendMessage(this.handle, 201, n10, 0);
                if (n11 == n3) {
                    n2 = nArray2[0];
                }
            }
        }
        if (!OS.IsUnicode && OS.IsDBLocale) {
            n2 = this.mbcsToWcsPos(n2);
        }
        return this.untranslateOffset(n2);
    }

    public int getCharCount() {
        this.checkWidget();
        int n2 = OS.GetWindowTextLength(this.handle);
        if (!OS.IsUnicode && OS.IsDBLocale) {
            n2 = this.mbcsToWcsPos(n2);
        }
        return this.untranslateOffset(n2);
    }

    public boolean getDoubleClickEnabled() {
        this.checkWidget();
        return this.doubleClick;
    }

    public char getEchoChar() {
        this.checkWidget();
        int n2 = OS.SendMessage(this.handle, 210, 0, 0);
        if (n2 != 0 && (n2 = Display.mbcsToWcs(n2, this.getCodePage())) == 0) {
            n2 = 42;
        }
        return (char)n2;
    }

    public boolean getEditable() {
        this.checkWidget();
        int n2 = OS.GetWindowLong(this.handle, -16);
        return (n2 & 0x800) == 0;
    }

    public int getLineCount() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 186, 0, 0);
    }

    public String getLineDelimiter() {
        this.checkWidget();
        return DELIMITER;
    }

    public int getLineHeight() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getLineHeightInPixels());
    }

    int getLineHeightInPixels() {
        int n2 = 0;
        int n3 = OS.GetDC(this.handle);
        int n4 = OS.SendMessage(this.handle, 49, 0, 0);
        if (n4 != 0) {
            n2 = OS.SelectObject(n3, n4);
        }
        TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
        OS.GetTextMetrics(n3, tEXTMETRIC);
        if (n4 != 0) {
            OS.SelectObject(n3, n2);
        }
        OS.ReleaseDC(this.handle, n3);
        return tEXTMETRIC.tmHeight;
    }

    @Override
    public int getOrientation() {
        return super.getOrientation();
    }

    public String getMessage() {
        this.checkWidget();
        return this.message;
    }

    int getPosition(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        int n2 = OS.MAKELPARAM(point.x, point.y);
        int n3 = OS.LOWORD(OS.SendMessage(this.handle, 215, 0, n2));
        if (!OS.IsUnicode && OS.IsDBLocale) {
            n3 = this.mbcsToWcsPos(n3);
        }
        return this.untranslateOffset(n3);
    }

    public Point getSelection() {
        this.checkWidget();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.SendMessage(this.handle, 176, nArray, nArray2);
        if (!OS.IsUnicode && OS.IsDBLocale) {
            nArray[0] = this.mbcsToWcsPos(nArray[0]);
            nArray2[0] = this.mbcsToWcsPos(nArray2[0]);
        }
        return new Point(this.untranslateOffset(nArray[0]), this.untranslateOffset(nArray2[0]));
    }

    public int getSelectionCount() {
        this.checkWidget();
        Point point = this.getSelection();
        return point.y - point.x;
    }

    public String getSelectionText() {
        this.checkWidget();
        int n2 = OS.GetWindowTextLength(this.handle);
        if (n2 == 0) {
            return "";
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.SendMessage(this.handle, 176, nArray, nArray2);
        if (nArray[0] == nArray2[0]) {
            return "";
        }
        TCHAR tCHAR = new TCHAR(this.getCodePage(), n2 + 1);
        OS.GetWindowText(this.handle, tCHAR, n2 + 1);
        if (this.segments != null) {
            tCHAR = this.deprocessText(tCHAR, nArray[0], nArray2[0], false);
            return tCHAR.toString();
        }
        return tCHAR.toString(nArray[0], nArray2[0] - nArray[0]);
    }

    public int getTabs() {
        this.checkWidget();
        return this.tabs;
    }

    int getTabWidth(int n2) {
        int n3 = 0;
        RECT rECT = new RECT();
        int n4 = OS.GetDC(this.handle);
        int n5 = OS.SendMessage(this.handle, 49, 0, 0);
        if (n5 != 0) {
            n3 = OS.SelectObject(n4, n5);
        }
        int n6 = 3104;
        TCHAR tCHAR = new TCHAR(this.getCodePage(), " ", false);
        OS.DrawText(n4, tCHAR, tCHAR.length(), rECT, n6);
        if (n5 != 0) {
            OS.SelectObject(n4, n3);
        }
        OS.ReleaseDC(this.handle, n4);
        return (rECT.right - rECT.left) * n2;
    }

    public String getText() {
        this.checkWidget();
        int n2 = OS.GetWindowTextLength(this.handle);
        if (n2 == 0) {
            return "";
        }
        TCHAR tCHAR = new TCHAR(this.getCodePage(), n2 + 1);
        OS.GetWindowText(this.handle, tCHAR, n2 + 1);
        if (this.segments != null) {
            tCHAR = this.deprocessText(tCHAR, 0, -1, false);
            return tCHAR.toString();
        }
        return tCHAR.toString(0, n2);
    }

    public char[] getTextChars() {
        this.checkWidget();
        int n2 = OS.GetWindowTextLength(this.handle);
        if (n2 == 0) {
            return new char[0];
        }
        TCHAR tCHAR = new TCHAR(this.getCodePage(), n2 + 1);
        OS.GetWindowText(this.handle, tCHAR, n2 + 1);
        if (this.segments != null) {
            tCHAR = this.deprocessText(tCHAR, 0, -1, false);
        }
        char[] cArray = new char[n2];
        System.arraycopy(tCHAR.chars, 0, cArray, 0, n2);
        tCHAR.clear();
        return cArray;
    }

    public String getText(int n2, int n3) {
        this.checkWidget();
        if (n2 > n3 || 0 > n3) {
            return "";
        }
        int n4 = OS.GetWindowTextLength(this.handle);
        if (!OS.IsUnicode && OS.IsDBLocale) {
            n4 = this.mbcsToWcsPos(n4);
        }
        if (n2 > (n3 = Math.min(n3, this.untranslateOffset(n4) - 1))) {
            return "";
        }
        n2 = Math.max(0, n2);
        return this.getText().substring(n2, n3 + 1);
    }

    public int getTextLimit() {
        this.checkWidget();
        int n2 = OS.SendMessage(this.handle, 213, 0, 0) & Integer.MAX_VALUE;
        if (this.segments != null && n2 < LIMIT) {
            n2 = Math.max(1, n2 - this.segments.length);
        }
        return n2;
    }

    public int getTopIndex() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 0;
        }
        return OS.SendMessage(this.handle, 206, 0, 0);
    }

    public int getTopPixel() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getTopPixelInPixels());
    }

    int getTopPixelInPixels() {
        int[] nArray = new int[2];
        int n2 = OS.SendMessage(this.handle, 1245, 0, nArray);
        if (n2 == 1) {
            return nArray[1];
        }
        return this.getTopIndex() * this.getLineHeightInPixels();
    }

    public void insert(String string) {
        Object object;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        string = Display.withCrLf(string);
        if (this.hooks(25) || this.filters(25)) {
            object = new int[1];
            int[] nArray = new int[1];
            OS.SendMessage(this.handle, 176, object, nArray);
            string = this.verifyText(string, object[0], nArray[0], null);
            if (string == null) {
                return;
            }
        }
        this.clearSegments(true);
        object = new TCHAR(this.getCodePage(), string, true);
        this.ignoreCharacter = true;
        OS.SendMessage(this.handle, 194, 0, (TCHAR)object);
        this.ignoreCharacter = false;
        if ((this.state & 0x400000) != 0) {
            super.updateTextDirection(0x6000000);
        }
        this.applySegments();
    }

    int mbcsToWcsPos(int n2) {
        if (n2 <= 0) {
            return 0;
        }
        if (OS.IsUnicode) {
            return n2;
        }
        int n3 = this.getCodePage();
        int n4 = 0;
        int n5 = 0;
        byte[] byArray = new byte[128];
        String string = this.getLineDelimiter();
        int n6 = string.length();
        int n7 = OS.SendMessageA(this.handle, 186, 0, 0);
        for (int i2 = 0; i2 < n7; ++i2) {
            int n8;
            int n9 = 0;
            int n10 = OS.SendMessageA(this.handle, 187, i2, 0);
            int n11 = OS.SendMessageA(this.handle, 193, n10, 0);
            if (n11 != 0) {
                if (n11 + n6 > byArray.length) {
                    byArray = new byte[n11 + n6];
                }
                byArray[0] = (byte)(n11 & 0xFF);
                byArray[1] = (byte)(n11 >> 8);
                n11 = OS.SendMessageA(this.handle, 196, i2, byArray);
                n9 = OS.MultiByteToWideChar(n3, 1, byArray, n11, null, 0);
            }
            if (i2 - 1 != n7) {
                for (n8 = 0; n8 < n6; ++n8) {
                    byArray[n11++] = (byte)string.charAt(n8);
                }
                n9 += n6;
            }
            if (n5 + n11 >= n2) {
                n8 = n2 - n5;
                n9 = OS.MultiByteToWideChar(n3, 1, byArray, n8, null, 0);
                return n4 + n9;
            }
            n4 += n9;
            n5 += n11;
        }
        return n4;
    }

    public void paste() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        OS.SendMessage(this.handle, 770, 0, 0);
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.message = null;
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, modifyListener);
    }

    public void removeSegmentListener(SegmentListener segmentListener) {
        this.checkWidget();
        if (segmentListener == null) {
            this.error(4);
        }
        this.eventTable.unhook(49, segmentListener);
        this.clearSegments(true);
        this.applySegments();
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void removeVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, verifyListener);
    }

    @Override
    int resolveTextDirection() {
        int n2 = 0;
        int n3 = OS.GetWindowTextLength(this.handle);
        if (n3 > 0) {
            TCHAR tCHAR = new TCHAR(this.getCodePage(), n3 + 1);
            OS.GetWindowText(this.handle, tCHAR, n3 + 1);
            if (this.segments != null) {
                tCHAR = this.deprocessText(tCHAR, 0, -1, false);
                n2 = BidiUtil.resolveTextDirection(tCHAR.toString());
            } else {
                n2 = BidiUtil.resolveTextDirection(tCHAR.toString(0, n3));
            }
            if (n2 == 0) {
                n2 = (this.style & 0x4000000) != 0 ? 0x4000000 : 0x2000000;
            }
        }
        return n2;
    }

    public void selectAll() {
        this.checkWidget();
        OS.SendMessage(this.handle, 177, 0, -1);
    }

    @Override
    boolean sendKeyEvent(int n2, int n3, int n4, int n5, Event event) {
        String string;
        Object object;
        if (!super.sendKeyEvent(n2, n3, n4, n5, event)) {
            return false;
        }
        if ((this.style & 8) != 0) {
            return true;
        }
        if (this.ignoreVerify) {
            return true;
        }
        if (n2 != 1) {
            return true;
        }
        if (n3 != 258 && n3 != 256 && n3 != 646) {
            return true;
        }
        if (event.character == '\u0000') {
            return true;
        }
        if (!this.hooks(25) && !this.filters(25)) {
            return true;
        }
        char c2 = event.character;
        int n6 = event.stateMask;
        switch (n3) {
            case 258: {
                if (c2 != '\b' && c2 != '\u007f' && c2 != '\r' && c2 != '\t' && c2 != '\n') break;
            }
            case 256: {
                if ((n6 & 0x70000) == 0) break;
                return false;
            }
        }
        if (OS.GetKeyState(1) < 0 && this.handle == OS.GetCapture()) {
            return true;
        }
        String string2 = "";
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.SendMessage(this.handle, 176, nArray, nArray2);
        switch (c2) {
            case '\b': {
                if (nArray[0] != nArray2[0]) break;
                if (nArray[0] == 0) {
                    return true;
                }
                int n7 = OS.SendMessage(this.handle, 187, -1, 0);
                if (nArray[0] == n7) {
                    nArray[0] = nArray[0] - DELIMITER.length();
                } else {
                    nArray[0] = nArray[0] - 1;
                    if (!OS.IsUnicode && OS.IsDBLocale) {
                        object = new int[1];
                        int[] nArray3 = new int[1];
                        OS.SendMessage(this.handle, 177, nArray[0], nArray2[0]);
                        OS.SendMessage(this.handle, 176, (int[])object, nArray3);
                        if (nArray[0] != object[0]) {
                            nArray[0] = nArray[0] - 1;
                        }
                    }
                }
                nArray[0] = Math.max(nArray[0], 0);
                break;
            }
            case '\u007f': {
                if (nArray[0] != nArray2[0]) break;
                int n7 = OS.GetWindowTextLength(this.handle);
                if (nArray[0] == n7) {
                    return true;
                }
                int n8 = OS.SendMessage(this.handle, 201, nArray2[0], 0);
                int n9 = OS.SendMessage(this.handle, 187, n8 + 1, 0);
                if (nArray2[0] == n9 - DELIMITER.length()) {
                    nArray2[0] = nArray2[0] + DELIMITER.length();
                } else {
                    nArray2[0] = nArray2[0] + 1;
                    if (!OS.IsUnicode && OS.IsDBLocale) {
                        int[] nArray4 = new int[1];
                        int[] nArray5 = new int[1];
                        OS.SendMessage(this.handle, 177, nArray[0], nArray2[0]);
                        OS.SendMessage(this.handle, 176, nArray4, nArray5);
                        if (nArray2[0] != nArray5[0]) {
                            nArray2[0] = nArray2[0] + 1;
                        }
                    }
                }
                nArray2[0] = Math.min(nArray2[0], n7);
                break;
            }
            case '\r': {
                if ((this.style & 4) != 0) {
                    return true;
                }
                string2 = DELIMITER;
                break;
            }
            default: {
                if (c2 != '\t' && c2 < ' ') {
                    return true;
                }
                string2 = new String(new char[]{c2});
            }
        }
        if ((string = this.verifyText(string2, nArray[0], nArray2[0], event)) == null) {
            return false;
        }
        if (string == string2) {
            return true;
        }
        string = Display.withCrLf(string);
        object = new TCHAR(this.getCodePage(), string, true);
        OS.SendMessage(this.handle, 177, nArray[0], nArray2[0]);
        this.ignoreCharacter = true;
        OS.SendMessage(this.handle, 194, 0, (TCHAR)object);
        this.ignoreCharacter = false;
        return false;
    }

    @Override
    void setBoundsInPixels(int n2, int n3, int n4, int n5, int n6) {
        int n7;
        Object object;
        int n8;
        int n9;
        if ((n6 & 1) == 0 && n4 != 0) {
            RECT rECT = new RECT();
            OS.GetWindowRect(this.handle, rECT);
            n9 = OS.SendMessage(this.handle, 212, 0, 0);
            n8 = OS.LOWORD(n9) + OS.HIWORD(n9);
            if (rECT.right - rECT.left <= n8) {
                int[] nArray = new int[1];
                object = new int[1];
                OS.SendMessage(this.handle, 176, nArray, object);
                if (nArray[0] != 0 || object[0] != 0) {
                    this.SetWindowPos(this.handle, 0, n2, n3, n4, n5, n6);
                    OS.SendMessage(this.handle, 177, 0, 0);
                    OS.SendMessage(this.handle, 177, nArray[0], object[0]);
                    return;
                }
            }
        }
        super.setBoundsInPixels(n2, n3, n4, n5, n6);
        if ((n6 & 1) == 0 && ((n7 = OS.GetWindowLong(this.handle, -16)) & 4) != 0) {
            n8 = 0;
            int n10 = OS.GetDC(this.handle);
            n9 = OS.SendMessage(this.handle, 49, 0, 0);
            if (n9 != 0) {
                n8 = OS.SelectObject(n10, n9);
            }
            object = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
            OS.GetTextMetrics(n10, (TEXTMETRIC)object);
            if (n9 != 0) {
                OS.SelectObject(n10, n8);
            }
            OS.ReleaseDC(this.handle, n10);
            RECT rECT = new RECT();
            OS.GetClientRect(this.handle, rECT);
            if (rECT.bottom - rECT.top < object.tmHeight) {
                int n11 = OS.SendMessage(this.handle, 212, 0, 0);
                rECT.left += OS.LOWORD(n11);
                rECT.right -= OS.HIWORD(n11);
                rECT.top = 0;
                rECT.bottom = object.tmHeight;
                OS.SendMessage(this.handle, 179, 0, rECT);
            }
        }
    }

    @Override
    void setDefaultFont() {
        super.setDefaultFont();
        this.setMargins();
    }

    public void setDoubleClickEnabled(boolean bl2) {
        this.checkWidget();
        this.doubleClick = bl2;
    }

    public void setEchoChar(char c2) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        if (c2 != '\u0000' && (c2 = (char)Display.wcsToMbcs(c2, this.getCodePage())) == '\u0000') {
            c2 = (char)42;
        }
        this.allowPasswordChar = true;
        OS.SendMessage(this.handle, 204, (int)c2, 0);
        this.allowPasswordChar = false;
        OS.InvalidateRect(this.handle, null, true);
    }

    public void setEditable(boolean bl2) {
        this.checkWidget();
        this.style &= 0xFFFFFFF7;
        if (!bl2) {
            this.style |= 8;
        }
        OS.SendMessage(this.handle, 207, bl2 ? 0 : 1, 0);
    }

    @Override
    public void setFont(Font font) {
        this.checkWidget();
        super.setFont(font);
        this.setTabStops(this.tabs);
        this.setMargins();
    }

    void setMargins() {
        if ((this.style & 0x80) != 0 && !OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
            OS.SendMessage(this.handle, 211, 3, 0);
        }
    }

    public void setMessage(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.message = string;
        if (!OS.IsWinCE) {
            if (OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
                int n2 = OS.GetWindowLong(this.handle, -16);
                if ((n2 & 4) == 0) {
                    int n3 = string.length();
                    char[] cArray = new char[n3 + 1];
                    string.getChars(0, n3, cArray, 0);
                    OS.SendMessage(this.handle, 5377, 0, cArray);
                }
            } else {
                OS.InvalidateRect(this.handle, null, true);
            }
        }
    }

    @Override
    public void setOrientation(int n2) {
        super.setOrientation(n2);
    }

    public void setSelection(int n2) {
        this.checkWidget();
        n2 = this.translateOffset(n2);
        if (!OS.IsUnicode && OS.IsDBLocale) {
            n2 = this.wcsToMbcsPos(n2);
        }
        OS.SendMessage(this.handle, 177, n2, n2);
        OS.SendMessage(this.handle, 183, 0, 0);
    }

    public void setSelection(int n2, int n3) {
        this.checkWidget();
        n2 = this.translateOffset(n2);
        n3 = this.translateOffset(n3);
        if (!OS.IsUnicode && OS.IsDBLocale) {
            n2 = this.wcsToMbcsPos(n2);
            n3 = this.wcsToMbcsPos(n3);
        }
        OS.SendMessage(this.handle, 177, n2, n3);
        OS.SendMessage(this.handle, 183, 0, 0);
    }

    @Override
    public void setRedraw(boolean bl2) {
        this.checkWidget();
        super.setRedraw(bl2);
        if (!this.getDrawing()) {
            return;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.SendMessage(this.handle, 176, nArray, nArray2);
        if (!bl2) {
            this.oldStart = nArray[0];
            this.oldEnd = nArray2[0];
        } else {
            if (this.oldStart == nArray[0] && this.oldEnd == nArray2[0]) {
                return;
            }
            OS.SendMessage(this.handle, 183, 0, 0);
        }
    }

    public void setSelection(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setSelection(point.x, point.y);
    }

    public void setTabs(int n2) {
        this.checkWidget();
        if (n2 < 0) {
            return;
        }
        this.tabs = n2;
        this.setTabStops(this.tabs);
    }

    void setTabStops(int n2) {
        int n3 = this.getTabWidth(n2) * 4 / OS.LOWORD(OS.GetDialogBaseUnits());
        OS.SendMessage(this.handle, 203, 1, new int[]{n3});
    }

    public void setText(String string) {
        int n2;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        string = Display.withCrLf(string);
        if ((this.hooks(25) || this.filters(25)) && (string = this.verifyText(string, 0, n2 = OS.GetWindowTextLength(this.handle), null)) == null) {
            return;
        }
        this.clearSegments(false);
        n2 = OS.SendMessage(this.handle, 213, 0, 0) & Integer.MAX_VALUE;
        if (string.length() > n2) {
            string = string.substring(0, n2);
        }
        TCHAR tCHAR = new TCHAR(this.getCodePage(), string, true);
        OS.SetWindowText(this.handle, tCHAR);
        if ((this.state & 0x400000) != 0) {
            super.updateTextDirection(0x6000000);
        }
        this.applySegments();
        int n3 = OS.GetWindowLong(this.handle, -16);
        if ((n3 & 4) != 0) {
            this.sendEvent(24);
        }
    }

    public void setTextChars(char[] object) {
        int n2;
        Object object2;
        int n3;
        this.checkWidget();
        if (object == null) {
            this.error(4);
        }
        object = Display.withCrLf(object);
        if (this.hooks(25) || this.filters(25)) {
            n3 = OS.GetWindowTextLength(this.handle);
            object2 = this.verifyText(new String((char[])object), 0, n3, null);
            if (object2 == null) {
                return;
            }
            object = new char[((String)object2).length()];
            ((String)object2).getChars(0, ((char[])object).length, (char[])object, 0);
        }
        this.clearSegments(false);
        n3 = OS.SendMessage(this.handle, 213, 0, 0) & Integer.MAX_VALUE;
        if (((char[])object).length > n3) {
            object2 = new char[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                object2[n2] = object[n2];
            }
            object = object2;
        }
        object2 = new TCHAR(this.getCodePage(), (char[])object, true);
        OS.SetWindowText(this.handle, (TCHAR)object2);
        ((TCHAR)object2).clear();
        if ((this.state & 0x400000) != 0) {
            super.updateTextDirection(0x6000000);
        }
        this.applySegments();
        n2 = OS.GetWindowLong(this.handle, -16);
        if ((n2 & 4) != 0) {
            this.sendEvent(24);
        }
    }

    public void setTextLimit(int n2) {
        this.checkWidget();
        if (n2 == 0) {
            this.error(7);
        }
        if (this.segments != null && n2 > 0) {
            OS.SendMessage(this.handle, 197, n2 + Math.min(this.segments.length, LIMIT - n2), 0);
        } else {
            OS.SendMessage(this.handle, 197, n2, 0);
        }
    }

    public void setTopIndex(int n2) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        int n3 = OS.SendMessage(this.handle, 186, 0, 0);
        n2 = Math.min(Math.max(n2, 0), n3 - 1);
        int n4 = OS.SendMessage(this.handle, 206, 0, 0);
        OS.SendMessage(this.handle, 182, 0, n2 - n4);
    }

    public void showSelection() {
        this.checkWidget();
        OS.SendMessage(this.handle, 183, 0, 0);
    }

    int translateOffset(int n2) {
        if (this.segments == null) {
            return n2;
        }
        int n3 = this.segments.length;
        for (int i2 = 0; i2 < n3 && n2 - i2 >= this.segments[i2]; ++i2) {
            ++n2;
        }
        return n2;
    }

    int untranslateOffset(int n2) {
        if (this.segments == null) {
            return n2;
        }
        int n3 = this.segments.length;
        for (int i2 = 0; i2 < n3 && n2 > this.segments[i2]; --n2, ++i2) {
        }
        return n2;
    }

    @Override
    void updateMenuLocation(Event event) {
        Point point = this.display.mapInPixels((Control)this, null, this.getCaretLocationInPixels());
        event.setLocationInPixels(point.x, point.y + this.getLineHeightInPixels());
    }

    @Override
    void updateOrientation() {
        int n2 = OS.GetWindowLong(this.handle, -20);
        n2 = (this.style & 0x4000000) != 0 ? (n2 |= 0x6000) : (n2 &= 0xFFFF9FFF);
        OS.SetWindowLong(this.handle, -20, n2);
        this.fixAlignment();
    }

    @Override
    boolean updateTextDirection(int n2) {
        if (super.updateTextDirection(n2)) {
            this.clearSegments(true);
            this.applySegments();
            return true;
        }
        return false;
    }

    String verifyText(String string, int n2, int n3, Event event) {
        if (this.ignoreVerify) {
            return string;
        }
        Event event2 = new Event();
        event2.text = string;
        event2.start = n2;
        event2.end = n3;
        if (event != null) {
            event2.character = event.character;
            event2.keyCode = event.keyCode;
            event2.stateMask = event.stateMask;
        }
        if (!OS.IsUnicode && OS.IsDBLocale) {
            event2.start = this.mbcsToWcsPos(n2);
            event2.end = this.mbcsToWcsPos(n3);
        }
        event2.start = this.untranslateOffset(event2.start);
        event2.end = this.untranslateOffset(event2.end);
        this.sendEvent(25, event2);
        if (!event2.doit || this.isDisposed()) {
            return null;
        }
        return event2.text;
    }

    int wcsToMbcsPos(int n2) {
        if (n2 <= 0) {
            return 0;
        }
        if (OS.IsUnicode) {
            return n2;
        }
        int n3 = this.getCodePage();
        int n4 = 0;
        int n5 = 0;
        byte[] byArray = new byte[128];
        String string = this.getLineDelimiter();
        int n6 = string.length();
        int n7 = OS.SendMessageA(this.handle, 186, 0, 0);
        for (int i2 = 0; i2 < n7; ++i2) {
            int n8;
            int n9 = 0;
            int n10 = OS.SendMessageA(this.handle, 187, i2, 0);
            int n11 = OS.SendMessageA(this.handle, 193, n10, 0);
            if (n11 != 0) {
                if (n11 + n6 > byArray.length) {
                    byArray = new byte[n11 + n6];
                }
                byArray[0] = (byte)(n11 & 0xFF);
                byArray[1] = (byte)(n11 >> 8);
                n11 = OS.SendMessageA(this.handle, 196, i2, byArray);
                n9 = OS.MultiByteToWideChar(n3, 1, byArray, n11, null, 0);
            }
            if (i2 - 1 != n7) {
                for (n8 = 0; n8 < n6; ++n8) {
                    byArray[n11++] = (byte)string.charAt(n8);
                }
                n9 += n6;
            }
            if (n4 + n9 >= n2) {
                n9 = 0;
                n8 = 0;
                while (n8 < n11) {
                    if (n4 + n9 == n2) {
                        return n5 + n8;
                    }
                    if (OS.IsDBCSLeadByte(byArray[n8++])) {
                        ++n8;
                    }
                    ++n9;
                }
                return n5 + n11;
            }
            n4 += n9;
            n5 += n11;
        }
        return n5;
    }

    @Override
    int widgetStyle() {
        int n2 = super.widgetStyle() | 0x80;
        if ((this.style & 0x400000) != 0) {
            n2 |= 0x20;
        }
        if ((this.style & 0x1000000) != 0) {
            n2 |= 1;
        }
        if ((this.style & 0x20000) != 0) {
            n2 |= 2;
        }
        if ((this.style & 8) != 0) {
            n2 |= 0x800;
        }
        if ((this.style & 4) != 0) {
            if ((this.style & 8) != 0 && (this.style & 0x400B00) == 0 && OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
                n2 |= 4;
            }
            return n2;
        }
        n2 |= 0x144;
        if ((this.style & 0x40) != 0) {
            n2 &= 0xFFEFFF7F;
        }
        return n2;
    }

    @Override
    TCHAR windowClass() {
        return EditClass;
    }

    @Override
    int windowProc() {
        return EditProc;
    }

    @Override
    int windowProc(int n2, int n3, int n4, int n5) {
        int n6;
        boolean bl2;
        boolean bl3 = this.hooks(49) || this.filters(49);
        boolean bl4 = false;
        boolean bl5 = bl2 = (this.state & 0x400000) != 0;
        if (bl3 || bl2) {
            switch (n3) {
                case 198: {
                    if (bl3) {
                        return 0;
                    }
                    bl2 = false;
                    break;
                }
                case 199: 
                case 772: {
                    if (!bl3) break;
                    return 0;
                }
                case 256: {
                    if (n4 == 46) break;
                    bl2 = false;
                    bl3 = false;
                    break;
                }
                case 769: {
                    bl3 = this.segments != null;
                    bl2 = false;
                    break;
                }
                case 258: {
                    if (!this.ignoreCharacter && OS.GetKeyState(17) >= 0 && OS.GetKeyState(18) >= 0) break;
                    bl2 = false;
                    bl3 = false;
                    break;
                }
                case 768: 
                case 770: 
                case 771: {
                    break;
                }
                default: {
                    bl2 = false;
                    bl3 = false;
                }
            }
        }
        if (bl3) {
            if (this.getDrawing() && OS.IsWindowVisible(this.handle)) {
                bl4 = true;
                OS.DefWindowProc(this.handle, 11, 0, 0);
            }
            this.clearSegments(true);
        }
        if (n3 == 199 && ((n6 = OS.GetWindowLong(this.handle, -16)) & 4) == 0) {
            LRESULT lRESULT = this.wmClipboard(199, n4, n5);
            if (lRESULT != null) {
                return lRESULT.value;
            }
            return this.callWindowProc(n2, 199, n4, n5);
        }
        if (n3 == 204 && !this.allowPasswordChar) {
            return 1;
        }
        if (n3 == Display.SWT_RESTORECARET) {
            this.callWindowProc(n2, 8, 0, 0);
            this.callWindowProc(n2, 7, 0, 0);
            return 1;
        }
        int n7 = super.windowProc(n2, n3, n4, n5);
        if (bl2) {
            super.updateTextDirection(0x6000000);
        }
        if (bl3) {
            this.applySegments();
            if (bl4) {
                OS.DefWindowProc(this.handle, 11, 1, 0);
                OS.InvalidateRect(this.handle, null, true);
            }
            OS.SendMessage(this.handle, 183, 0, 0);
        }
        return n7;
    }

    @Override
    LRESULT WM_CHAR(int n2, int n3) {
        if (this.ignoreCharacter) {
            return null;
        }
        LRESULT lRESULT = super.WM_CHAR(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        switch (n2) {
            case 127: {
                String string;
                Matcher matcher;
                if (OS.GetKeyState(17) >= 0) break;
                if (OS.WIN32_VERSION < OS.VERSION(6, 0) || (this.style & 8) != 0 || (this.style & 0x400000) != 0) {
                    return LRESULT.ZERO;
                }
                Point point = this.getSelection();
                int n4 = point.x;
                int n5 = point.y;
                if (n4 == n5 && (matcher = CTRL_BS_PATTERN.matcher(string = this.getText(0, n4 - 1))).find()) {
                    n4 = matcher.start();
                    n5 = matcher.end();
                    OS.SendMessage(this.handle, 177, n4, n5);
                }
                if (n4 < n5) {
                    OS.SendMessage(this.handle, 194, 1, 0);
                }
                return LRESULT.ZERO;
            }
        }
        if ((this.style & 4) != 0) {
            switch (n2) {
                case 13: {
                    this.sendSelectionEvent(14);
                }
                case 9: 
                case 27: {
                    return LRESULT.ZERO;
                }
            }
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_CLEAR(int n2, int n3) {
        LRESULT lRESULT = super.WM_CLEAR(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        return this.wmClipboard(771, n2, n3);
    }

    @Override
    LRESULT WM_CUT(int n2, int n3) {
        LRESULT lRESULT = super.WM_CUT(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        return this.wmClipboard(768, n2, n3);
    }

    @Override
    LRESULT WM_ERASEBKGND(int n2, int n3) {
        Control control;
        int n4;
        LRESULT lRESULT = super.WM_ERASEBKGND(n2, n3);
        if ((this.style & 8) != 0 && (this.style & 0xB00) == 0 && ((n4 = OS.GetWindowLong(this.handle, -16)) & 4) != 0 && (control = this.findBackgroundControl()) == null && this.background == -1 && (this.state & 0x100) != 0 && OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() && (control = this.findThemeControl()) != null) {
            RECT rECT = new RECT();
            OS.GetClientRect(this.handle, rECT);
            this.fillThemeBackground(n2, control, rECT);
            return LRESULT.ONE;
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_GETDLGCODE(int n2, int n3) {
        LRESULT lRESULT = super.WM_GETDLGCODE(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (OS.IsPPC && (this.style & 2) != 0 && (this.style & 8) == 0 && n3 == 0) {
            return new LRESULT(140);
        }
        if ((this.style & 8) != 0) {
            int n4 = this.callWindowProc(this.handle, 135, n2, n3);
            return new LRESULT(n4 &= 0xFFFFFFF9);
        }
        return null;
    }

    @Override
    LRESULT WM_GETOBJECT(int n2, int n3) {
        if ((this.style & 0x80) != 0 && this.accessible == null) {
            this.accessible = this.new_Accessible(this);
        }
        return super.WM_GETOBJECT(n2, n3);
    }

    @Override
    LRESULT WM_IME_CHAR(int n2, int n3) {
        Display display = this.display;
        display.lastKey = 0;
        display.lastAscii = n2;
        display.lastDead = false;
        display.lastNull = false;
        display.lastVirtual = false;
        if (!this.sendKeyEvent(1, 646, n2, n3)) {
            return LRESULT.ZERO;
        }
        this.ignoreCharacter = true;
        int n4 = this.callWindowProc(this.handle, 646, n2, n3);
        MSG mSG = new MSG();
        int n5 = 10420227;
        while (OS.PeekMessage(mSG, this.handle, 258, 258, n5)) {
            OS.TranslateMessage(mSG);
            OS.DispatchMessage(mSG);
        }
        this.ignoreCharacter = false;
        this.sendKeyEvent(2, 646, n2, n3);
        display.lastAscii = 0;
        display.lastKey = 0;
        return new LRESULT(n4);
    }

    @Override
    LRESULT WM_LBUTTONDBLCLK(int n2, int n3) {
        int n4;
        int n5;
        LRESULT lRESULT = null;
        this.sendMouseEvent(3, 1, this.handle, 513, n2, n3);
        if (!this.sendMouseEvent(8, 1, this.handle, 515, n2, n3)) {
            lRESULT = LRESULT.ZERO;
        }
        if (!this.display.captureChanged && !this.isDisposed() && OS.GetCapture() != this.handle) {
            OS.SetCapture(this.handle);
        }
        if (!this.doubleClick) {
            return LRESULT.ZERO;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.SendMessage(this.handle, 176, nArray, nArray2);
        if (nArray[0] == nArray2[0] && (n5 = OS.GetWindowTextLength(this.handle)) == nArray[0] && (n4 = OS.SendMessage(this.handle, 193, n5, 0)) == 0) {
            return LRESULT.ZERO;
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_LBUTTONDOWN(int n2, int n3) {
        if (OS.IsPPC) {
            boolean bl2;
            LRESULT lRESULT = null;
            Display display = this.display;
            display.captureChanged = false;
            boolean bl3 = this.sendMouseEvent(3, 1, this.handle, 513, n2, n3);
            boolean bl4 = bl2 = this.menu != null && !this.menu.isDisposed();
            if (bl2 || this.hooks(35)) {
                int n4 = OS.GET_X_LPARAM(n3);
                int n5 = OS.GET_Y_LPARAM(n3);
                SHRGINFO sHRGINFO = new SHRGINFO();
                sHRGINFO.cbSize = SHRGINFO.sizeof;
                sHRGINFO.hwndClient = this.handle;
                sHRGINFO.ptDown_x = n4;
                sHRGINFO.ptDown_y = n5;
                sHRGINFO.dwFlags = 1;
                int n6 = OS.SHRecognizeGesture(sHRGINFO);
                if (n6 == 1000) {
                    this.showMenu(n4, n5);
                    return LRESULT.ONE;
                }
            }
            lRESULT = bl3 ? new LRESULT(this.callWindowProc(this.handle, 513, n2, n3)) : LRESULT.ZERO;
            if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != this.handle) {
                OS.SetCapture(this.handle);
            }
            return lRESULT;
        }
        return super.WM_LBUTTONDOWN(n2, n3);
    }

    @Override
    LRESULT WM_PASTE(int n2, int n3) {
        LRESULT lRESULT = super.WM_PASTE(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        return this.wmClipboard(770, n2, n3);
    }

    @Override
    LRESULT WM_UNDO(int n2, int n3) {
        LRESULT lRESULT = super.WM_UNDO(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        return this.wmClipboard(772, n2, n3);
    }

    LRESULT wmClipboard(int n2, int n3, int n4) {
        Object object;
        if ((this.style & 8) != 0) {
            return null;
        }
        if (!this.hooks(25) && !this.filters(25)) {
            return null;
        }
        boolean bl2 = false;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        String string = null;
        switch (n2) {
            case 768: 
            case 771: {
                OS.SendMessage(this.handle, 176, nArray, nArray2);
                if (nArray[0] == nArray2[0]) break;
                string = "";
                bl2 = true;
                break;
            }
            case 770: {
                OS.SendMessage(this.handle, 176, nArray, nArray2);
                string = this.getClipboardText();
                break;
            }
            case 199: 
            case 772: {
                if (OS.SendMessage(this.handle, 198, 0, 0) == 0) break;
                this.ignoreCharacter = true;
                this.ignoreModify = true;
                this.callWindowProc(this.handle, n2, n3, n4);
                int n5 = OS.GetWindowTextLength(this.handle);
                object = new int[1];
                int[] nArray3 = new int[1];
                OS.SendMessage(this.handle, 176, object, nArray3);
                if (n5 != 0 && object[0] != nArray3[0]) {
                    TCHAR tCHAR = new TCHAR(this.getCodePage(), n5 + 1);
                    OS.GetWindowText(this.handle, tCHAR, n5 + 1);
                    string = tCHAR.toString(object[0], nArray3[0] - object[0]);
                } else {
                    string = "";
                }
                this.callWindowProc(this.handle, n2, n3, n4);
                OS.SendMessage(this.handle, 176, nArray, nArray2);
                this.ignoreCharacter = false;
                this.ignoreModify = false;
            }
        }
        if (string != null) {
            String string2 = string;
            if ((string = this.verifyText(string, nArray[0], nArray2[0], null)) == null) {
                return LRESULT.ZERO;
            }
            if (!string.equals(string2)) {
                if (bl2) {
                    this.callWindowProc(this.handle, n2, n3, n4);
                }
                string = Display.withCrLf(string);
                object = new TCHAR(this.getCodePage(), string, true);
                this.ignoreCharacter = true;
                OS.SendMessage(this.handle, 194, 0, (TCHAR)object);
                this.ignoreCharacter = false;
                return LRESULT.ZERO;
            }
        }
        if (n2 == 772) {
            this.ignoreCharacter = true;
            this.ignoreVerify = true;
            this.callWindowProc(this.handle, 772, n3, n4);
            this.ignoreCharacter = false;
            this.ignoreVerify = false;
            return LRESULT.ONE;
        }
        return null;
    }

    @Override
    LRESULT wmColorChild(int n2, int n3) {
        Control control;
        int n4;
        if ((this.style & 8) != 0 && (this.style & 0xB00) == 0 && ((n4 = OS.GetWindowLong(this.handle, -16)) & 4) != 0 && (control = this.findBackgroundControl()) == null && this.background == -1 && (this.state & 0x100) != 0 && OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() && (control = this.findThemeControl()) != null) {
            OS.SetTextColor(n2, this.getForegroundPixel());
            OS.SetBkColor(n2, this.getBackgroundPixel());
            OS.SetBkMode(n2, 1);
            return new LRESULT(OS.GetStockObject(5));
        }
        return super.wmColorChild(n2, n3);
    }

    @Override
    LRESULT wmCommandChild(int n2, int n3) {
        int n4 = OS.HIWORD(n2);
        switch (n4) {
            case 768: {
                if (this.findImageControl() != null) {
                    OS.InvalidateRect(this.handle, null, true);
                }
                if (this.ignoreModify) break;
                this.sendEvent(24);
                if (!this.isDisposed()) break;
                return LRESULT.ZERO;
            }
            case 1792: 
            case 1793: {
                this.state &= 0xFFBFFFFF;
                int n5 = OS.GetWindowLong(this.handle, -20);
                if ((n5 & 0x2000) != 0) {
                    this.style &= 0xFDFFFFFF;
                    this.style |= 0x4000000;
                } else {
                    this.style &= 0xFBFFFFFF;
                    this.style |= 0x2000000;
                }
                Event event = new Event();
                event.doit = true;
                this.sendEvent(44, event);
                if (!event.doit) {
                    if (n4 == 1792) {
                        n5 |= 0x6000;
                        this.style &= 0xFDFFFFFF;
                        this.style |= 0x4000000;
                    } else {
                        n5 &= 0xFFFF9FFF;
                        this.style &= 0xFBFFFFFF;
                        this.style |= 0x2000000;
                    }
                    OS.SetWindowLong(this.handle, -20, n5);
                } else {
                    this.clearSegments(true);
                    this.applySegments();
                }
                this.fixAlignment();
            }
        }
        return super.wmCommandChild(n2, n3);
    }

    @Override
    LRESULT wmKeyDown(int n2, int n3, int n4) {
        LRESULT lRESULT = super.wmKeyDown(n2, n3, n4);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (this.segments != null) {
            switch (n3) {
                case 37: 
                case 38: 
                case 39: 
                case 40: {
                    int n5 = 0;
                    int[] nArray = new int[1];
                    int[] nArray2 = new int[1];
                    int[] nArray3 = new int[1];
                    int[] nArray4 = new int[1];
                    OS.SendMessage(this.handle, 176, nArray, nArray2);
                    while (true) {
                        n5 = this.callWindowProc(this.handle, 256, n3, n4);
                        OS.SendMessage(this.handle, 176, nArray3, nArray4);
                        if (nArray3[0] != nArray[0] ? this.untranslateOffset(nArray3[0]) != this.untranslateOffset(nArray[0]) : nArray4[0] == nArray2[0] || this.untranslateOffset(nArray4[0]) != this.untranslateOffset(nArray2[0])) break;
                        nArray[0] = nArray3[0];
                        nArray2[0] = nArray4[0];
                    }
                    lRESULT = n5 == 0 ? LRESULT.ZERO : new LRESULT(n5);
                }
            }
        }
        return lRESULT;
    }

    static {
        EditClass = new TCHAR(0, "EDIT", true);
        WNDCLASS wNDCLASS = new WNDCLASS();
        OS.GetClassInfo(0, EditClass, wNDCLASS);
        EditProc = wNDCLASS.lpfnWndProc;
    }
}

