/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.util.function.Function;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.Platform$1;
import org.lwjgl.system.Platform$2;
import org.lwjgl.system.Platform$3;
import org.lwjgl.system.Platform$Architecture;

public abstract class Platform
extends Enum {
    public static final /* enum */ Platform LINUX = new Platform$1("Linux", "linux");
    public static final /* enum */ Platform MACOSX = new Platform$2("macOS", "macos");
    public static final /* enum */ Platform WINDOWS = new Platform$3("Windows", "windows");
    private static final Platform current;
    private static final Function bundledLibraryNameMapper;
    private static final Function bundledLibraryPathMapper;
    private final String name;
    private final String nativePath;
    private static final /* synthetic */ Platform[] $VALUES;

    public static Platform[] values() {
        return (Platform[])$VALUES.clone();
    }

    public static Platform valueOf(String string) {
        return Enum.valueOf(Platform.class, string);
    }

    /*
     * WARNING - void declaration
     */
    private Platform() {
        void var4_1;
        void var3_2;
        void var2_-1;
        void var1_-1;
        this.name = var3_2;
        this.nativePath = var4_1;
    }

    public String getName() {
        return this.name;
    }

    abstract String mapLibraryName(String var1);

    public static Platform get() {
        return current;
    }

    public static Platform$Architecture getArchitecture() {
        return Platform$Architecture.current;
    }

    public static String mapLibraryNameBundled(String string) {
        return (String)bundledLibraryNameMapper.apply(string);
    }

    static String mapLibraryPathBundled(String string) {
        return (String)bundledLibraryPathMapper.apply(string);
    }

    private static Function getMapper(Object object, Function function, Function function2) {
        if (object == null || "default".equals(object)) {
            return function;
        }
        if ("legacy".equals(object)) {
            return function2;
        }
        if (object instanceof Function) {
            return (Function)object;
        }
        String string = object.toString();
        try {
            return (Function)Class.forName(string).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable throwable) {
            if (Checks.DEBUG) {
                throwable.printStackTrace(APIUtil.DEBUG_STREAM);
            }
            APIUtil.apiLog(String.format("Warning: Failed to instantiate bundled library mapper: %s. Using the default.", string));
            return function;
        }
    }

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    /* synthetic */ Platform(String string, String string2, Platform$1 platform$1) {
        this((String)var1_-1, (int)string2, (String)((Object)platform$1), (String)var4_3);
        void var4_3;
        void var1_-1;
    }

    static {
        $VALUES = new Platform[]{LINUX, MACOSX, WINDOWS};
        String string2 = System.getProperty("os.name");
        if (string2.startsWith("Windows")) {
            current = WINDOWS;
        } else if (string2.startsWith("Linux") || string2.startsWith("FreeBSD") || string2.startsWith("SunOS") || string2.startsWith("Unix")) {
            current = LINUX;
        } else if (string2.startsWith("Mac OS X") || string2.startsWith("Darwin")) {
            current = MACOSX;
        } else {
            throw new LinkageError("Unknown platform: " + string2);
        }
        bundledLibraryNameMapper = Platform.getMapper(Configuration.BUNDLED_LIBRARY_NAME_MAPPER.get("default"), string -> string, string -> Platform$Architecture.current.is64Bit ? string : string + "32");
        bundledLibraryPathMapper = Platform.getMapper(Configuration.BUNDLED_LIBRARY_PATH_MAPPER.get("default"), string -> Platform.current.nativePath + "/" + Platform$Architecture.current.name().toLowerCase() + "/" + string, string -> string.substring(string.lastIndexOf(47)));
    }
}

