/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.util;

import java.util.HashMap;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.util.AbstractVisitor;
import org.objectweb.asm.util.TraceAbstractVisitor;
import org.objectweb.asm.util.TraceSignatureVisitor;

public class TraceMethodVisitor
extends TraceAbstractVisitor {
    protected MethodVisitor mv;
    protected String tab2 = "    ";
    protected String tab3 = "      ";
    protected String ltab = "   ";
    protected final HashMap labelNames = new HashMap();

    public TraceMethodVisitor() {
        this(null);
    }

    public TraceMethodVisitor(MethodVisitor methodVisitor) {
        this.mv = methodVisitor;
    }

    @Override
    public void visitAttribute(Attribute attribute) {
        this.buf.setLength(0);
        this.buf.append(this.tab).append("ATTRIBUTE ");
        this.appendDescriptor(-1, attribute.type);
        this.buf.append(" : unknown\n");
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitAttribute(attribute);
        }
    }

    @Override
    public void visitCode() {
        if (this.mv != null) {
            this.mv.visitCode();
        }
    }

    @Override
    public void visitFrame(int n2, int n3, Object[] objectArray, int n4, Object[] objectArray2) {
        this.buf.setLength(0);
        this.buf.append(this.ltab);
        this.buf.append("FRAME ");
        switch (n2) {
            case -1: 
            case 0: {
                this.buf.append("FULL [");
                this.appendFrameTypes(n3, objectArray);
                this.buf.append("] [");
                this.appendFrameTypes(n4, objectArray2);
                this.buf.append("]");
                break;
            }
            case 1: {
                this.buf.append("APPEND [");
                this.appendFrameTypes(n3, objectArray);
                this.buf.append("]");
                break;
            }
            case 2: {
                this.buf.append("CHOP ").append(n3);
                break;
            }
            case 3: {
                this.buf.append("SAME");
                break;
            }
            case 4: {
                this.buf.append("SAME1 ");
                this.appendFrameTypes(1, objectArray2);
            }
        }
        this.buf.append("\n");
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitFrame(n2, n3, objectArray, n4, objectArray2);
        }
    }

    @Override
    public void visitInsn(int n2) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append(AbstractVisitor.OPCODES[n2]).append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitInsn(n2);
        }
    }

    @Override
    public void visitIntInsn(int n2, int n3) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append(AbstractVisitor.OPCODES[n2]).append(' ').append(n2 == 188 ? AbstractVisitor.TYPES[n3] : Integer.toString(n3)).append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitIntInsn(n2, n3);
        }
    }

    @Override
    public void visitVarInsn(int n2, int n3) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append(AbstractVisitor.OPCODES[n2]).append(' ').append(n3).append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitVarInsn(n2, n3);
        }
    }

    @Override
    public void visitTypeInsn(int n2, String string) {
        int n3;
        TraceMethodVisitor traceMethodVisitor;
        this.buf.setLength(0);
        this.buf.append(this.tab2).append(AbstractVisitor.OPCODES[n2]).append(' ');
        if (string.startsWith("[")) {
            traceMethodVisitor = this;
            n3 = 1;
        } else {
            traceMethodVisitor = this;
            n3 = 0;
        }
        traceMethodVisitor.appendDescriptor(n3, string);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitTypeInsn(n2, string);
        }
    }

    @Override
    public void visitFieldInsn(int n2, String string, String string2, String string3) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append(AbstractVisitor.OPCODES[n2]).append(' ');
        this.appendDescriptor(0, string);
        this.buf.append('.').append(string2).append(" : ");
        this.appendDescriptor(1, string3);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitFieldInsn(n2, string, string2, string3);
        }
    }

    @Override
    public void visitMethodInsn(int n2, String string, String string2, String string3) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append(AbstractVisitor.OPCODES[n2]).append(' ');
        this.appendDescriptor(0, string);
        this.buf.append('.').append(string2).append(' ');
        this.appendDescriptor(3, string3);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitMethodInsn(n2, string, string2, string3);
        }
    }

    @Override
    public void visitJumpInsn(int n2, Label label) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append(AbstractVisitor.OPCODES[n2]).append(' ');
        this.appendLabel(label);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitJumpInsn(n2, label);
        }
    }

    @Override
    public void visitLabel(Label label) {
        this.buf.setLength(0);
        this.buf.append(this.ltab);
        this.appendLabel(label);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitLabel(label);
        }
    }

    @Override
    public void visitLdcInsn(Object object) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("LDC ");
        if (object instanceof String) {
            AbstractVisitor.appendString(this.buf, (String)object);
        } else if (object instanceof Type) {
            this.buf.append(((Type)object).getDescriptor() + ".class");
        } else {
            this.buf.append(object);
        }
        this.buf.append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitLdcInsn(object);
        }
    }

    @Override
    public void visitIincInsn(int n2, int n3) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("IINC ").append(n2).append(' ').append(n3).append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitIincInsn(n2, n3);
        }
    }

    @Override
    public void visitTableSwitchInsn(int n2, int n3, Label label, Label[] labelArray) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("TABLESWITCH\n");
        for (int i2 = 0; i2 < labelArray.length; ++i2) {
            this.buf.append(this.tab3).append(n2 + i2).append(": ");
            this.appendLabel(labelArray[i2]);
            this.buf.append('\n');
        }
        this.buf.append(this.tab3).append("default: ");
        this.appendLabel(label);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitTableSwitchInsn(n2, n3, label, labelArray);
        }
    }

    @Override
    public void visitLookupSwitchInsn(Label label, int[] nArray, Label[] labelArray) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("LOOKUPSWITCH\n");
        for (int i2 = 0; i2 < labelArray.length; ++i2) {
            this.buf.append(this.tab3).append(nArray[i2]).append(": ");
            this.appendLabel(labelArray[i2]);
            this.buf.append('\n');
        }
        this.buf.append(this.tab3).append("default: ");
        this.appendLabel(label);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitLookupSwitchInsn(label, nArray, labelArray);
        }
    }

    @Override
    public void visitMultiANewArrayInsn(String string, int n2) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("MULTIANEWARRAY ");
        this.appendDescriptor(1, string);
        this.buf.append(' ').append(n2).append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitMultiANewArrayInsn(string, n2);
        }
    }

    @Override
    public void visitTryCatchBlock(Label label, Label label2, Label label3, String string) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("TRYCATCHBLOCK ");
        this.appendLabel(label);
        this.buf.append(' ');
        this.appendLabel(label2);
        this.buf.append(' ');
        this.appendLabel(label3);
        this.buf.append(' ');
        this.appendDescriptor(0, string);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitTryCatchBlock(label, label2, label3, string);
        }
    }

    @Override
    public void visitLocalVariable(String string, String string2, String string3, Label label, Label label2, int n2) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("LOCALVARIABLE ").append(string).append(' ');
        this.appendDescriptor(1, string2);
        this.buf.append(' ');
        this.appendLabel(label);
        this.buf.append(' ');
        this.appendLabel(label2);
        this.buf.append(' ').append(n2).append('\n');
        if (string3 != null) {
            this.buf.append(this.tab2);
            this.appendDescriptor(2, string3);
            TraceSignatureVisitor traceSignatureVisitor = new TraceSignatureVisitor(0);
            new SignatureReader(string3).acceptType(traceSignatureVisitor);
            this.buf.append(this.tab2).append("// declaration: ").append(traceSignatureVisitor.getDeclaration()).append('\n');
        }
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitLocalVariable(string, string2, string3, label, label2, n2);
        }
    }

    @Override
    public void visitLineNumber(int n2, Label label) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("LINENUMBER ").append(n2).append(' ');
        this.appendLabel(label);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitLineNumber(n2, label);
        }
    }

    @Override
    public void visitMaxs(int n2, int n3) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("MAXSTACK = ").append(n2).append('\n');
        this.text.add(this.buf.toString());
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("MAXLOCALS = ").append(n3).append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitMaxs(n2, n3);
        }
    }

    @Override
    public void visitEnd() {
        super.visitEnd();
        if (this.mv != null) {
            this.mv.visitEnd();
        }
    }

    private void appendFrameTypes(int n2, Object[] objectArray) {
        block9: for (int i2 = 0; i2 < n2; ++i2) {
            Object object;
            if (i2 > 0) {
                this.buf.append(' ');
            }
            if (objectArray[i2] instanceof String) {
                int n3;
                TraceMethodVisitor traceMethodVisitor;
                object = (String)objectArray[i2];
                if (((String)object).startsWith("[")) {
                    traceMethodVisitor = this;
                    n3 = 1;
                } else {
                    traceMethodVisitor = this;
                    n3 = 0;
                }
                traceMethodVisitor.appendDescriptor(n3, (String)object);
                continue;
            }
            if (objectArray[i2] instanceof Integer) {
                object = null;
                int n4 = 0;
                String string = null;
                switch ((Integer)objectArray[i2]) {
                    case 0: {
                        object = this;
                        n4 = 1;
                        string = "T";
                        break;
                    }
                    case 1: {
                        object = this;
                        n4 = 1;
                        string = "I";
                        break;
                    }
                    case 2: {
                        object = this;
                        n4 = 1;
                        string = "F";
                        break;
                    }
                    case 3: {
                        object = this;
                        n4 = 1;
                        string = "D";
                        break;
                    }
                    case 4: {
                        object = this;
                        n4 = 1;
                        string = "J";
                        break;
                    }
                    case 5: {
                        object = this;
                        n4 = 1;
                        string = "N";
                        break;
                    }
                    case 6: {
                        object = this;
                        n4 = 1;
                        string = "U";
                        break;
                    }
                    default: {
                        continue block9;
                    }
                }
                ((TraceAbstractVisitor)object).appendDescriptor(n4, string);
                continue;
            }
            this.appendLabel((Label)objectArray[i2]);
        }
    }

    protected void appendLabel(Label label) {
        String string = (String)this.labelNames.get(label);
        if (string == null) {
            string = "L" + this.labelNames.size();
            this.labelNames.put(label, string);
        }
        this.buf.append(string);
    }
}

