/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.m3g;

import emulator.graphics3D.G3DUtils;
import javax.microedition.m3g.Object3D;

public class Material
extends Object3D {
    public static final int AMBIENT = 1024;
    public static final int DIFFUSE = 2048;
    public static final int EMISSIVE = 4096;
    public static final int SPECULAR = 8192;
    private boolean vertexColorTracking = false;
    private int ambientColor = 0x333333;
    private int diffuseColor = -3355444;
    private int emissiveColor = 0;
    private int specularColor = 0;
    private float shininess = 0.0f;

    public void setColor(int var1, int var2) {
        if ((var1 & 0x400) == 0 && (var1 & 0x800) == 0 && (var1 & 0x1000) == 0 && (var1 & 0x2000) == 0) {
            throw new IllegalArgumentException();
        }
        if ((var1 & 0x400) != 0) {
            this.ambientColor = var2;
        }
        if ((var1 & 0x800) != 0) {
            this.diffuseColor = var2;
        }
        if ((var1 & 0x1000) != 0) {
            this.emissiveColor = var2;
        }
        if ((var1 & 0x2000) != 0) {
            this.specularColor = var2;
        }
    }

    public int getColor(int var1) {
        if (var1 != 1024 && var1 != 2048 && var1 != 4096 && var1 != 8192) {
            throw new IllegalArgumentException();
        }
        return var1 == 1024 ? this.ambientColor : (var1 == 2048 ? this.diffuseColor : (var1 == 4096 ? this.emissiveColor : (var1 == 8192 ? this.specularColor : 0)));
    }

    public void setShininess(float var1) {
        if (!(var1 >= 0.0f) || !(var1 <= 128.0f)) {
            throw new IllegalArgumentException();
        }
        this.shininess = var1;
    }

    public float getShininess() {
        return this.shininess;
    }

    public void setVertexColorTrackingEnable(boolean var1) {
        this.vertexColorTracking = var1;
    }

    public boolean isVertexColorTrackingEnabled() {
        return this.vertexColorTracking;
    }

    @Override
    protected void updateProperty(int var1, float[] var2) {
        switch (var1) {
            case 256: {
                this.diffuseColor = this.diffuseColor & 0xFFFFFF | G3DUtils.getIntColor((float[])var2) & 0xFF000000;
                return;
            }
            case 257: {
                this.ambientColor = G3DUtils.getIntColor((float[])var2);
                return;
            }
            default: {
                super.updateProperty(var1, var2);
                return;
            }
            case 261: {
                this.diffuseColor = this.diffuseColor & 0xFF000000 | G3DUtils.getIntColor((float[])var2) & 0xFFFFFF;
                return;
            }
            case 262: {
                this.emissiveColor = G3DUtils.getIntColor((float[])var2);
                return;
            }
            case 271: {
                this.shininess = G3DUtils.limit((float)var2[0], (float)0.0f, (float)128.0f);
                return;
            }
            case 272: 
        }
        this.specularColor = G3DUtils.getIntColor((float[])var2);
    }
}

