/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.m3g;

import emulator.graphics2D.IImage;
import emulator.graphics3D.lwjgl.Emulator3D;
import javax.microedition.lcdui.Image;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.Object3D;

public class Image2D
extends Object3D {
    public static final int ALPHA = 96;
    public static final int LUMINANCE = 97;
    public static final int LUMINANCE_ALPHA = 98;
    public static final int RGB = 99;
    public static final int RGBA = 100;
    private int type;
    private int width;
    private int height;
    private byte[] imageData;
    private boolean mutable;
    private static byte[] tmp;
    public boolean loaded;
    private int id;

    public Image2D(int var1, Object var2) {
        if (var2 == null) {
            throw new NullPointerException();
        }
        if (!Image2D.checkType(var1)) {
            throw new IllegalArgumentException();
        }
        if (!(var2 instanceof Image)) {
            throw new IllegalArgumentException();
        }
        Image var3 = (Image)var2;
        this.width = var3.getWidth();
        this.height = var3.getHeight();
        this.mutable = false;
        this.type = var1;
        this.imageData = Image2D.convert(var1, var3.getImpl().getData(), var3.isMutable());
    }

    public Image2D(int var1, int var2, int var3, byte[] var4) {
        int var5;
        if (var4 == null) {
            throw new NullPointerException();
        }
        if (var2 > 0 && var3 > 0 && Image2D.checkType(var1)) {
            var5 = var2 * var3 * Image2D.bytesPerPixel(var1);
            if (var4.length < var5) {
                throw new IllegalArgumentException();
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.width = var2;
        this.height = var3;
        this.mutable = false;
        this.type = var1;
        this.imageData = new byte[var5];
        System.arraycopy(var4, 0, this.imageData, 0, var5);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Image2D(int var1, int var2, int var3, byte[] var4, byte[] var5) {
        if (var4 == null || var5 == null) throw new NullPointerException();
        int var6 = var2 * var3;
        if (var2 <= 0 || var3 <= 0 || !Image2D.checkType(var1) || var4.length < var6) throw new IllegalArgumentException();
        int var7 = Image2D.bytesPerPixel(var1);
        if (var5.length < 256 * var7 && var5.length % var7 != 0) {
            throw new IllegalArgumentException();
        }
        this.width = var2;
        this.height = var3;
        this.mutable = false;
        this.type = var1;
        this.imageData = new byte[var6 * var7];
        for (int var8 = 0; var8 < var6; ++var8) {
            System.arraycopy(var5, (var4[var8] & 0xFF) * var7, this.imageData, var8 * var7, var7);
        }
    }

    public Image2D(int var1, int var2, int var3) {
        if (var2 > 0 && var3 > 0 && Image2D.checkType(var1)) {
            int var5;
            this.width = var2;
            this.height = var3;
            this.mutable = true;
            this.type = var1;
            int var4 = var2 * Image2D.bytesPerPixel(var1);
            this.imageData = new byte[var4 * var3];
            if (tmp == null || tmp.length < var4) {
                tmp = new byte[var4];
                for (var5 = var4 - 1; var5 >= 0; --var5) {
                    Image2D.tmp[var5] = -1;
                }
            }
            for (var5 = 0; var5 < var3; ++var5) {
                System.arraycopy(tmp, 0, this.imageData, var5 * var4, var4);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void set(int var1, int var2, int var3, int var4, byte[] var5) {
        if (var5 == null) {
            throw new NullPointerException();
        }
        if (this.mutable && var1 >= 0 && var2 >= 0 && var3 > 0 && var4 > 0 && var1 + var3 <= this.width && var2 + var4 <= this.height) {
            int var6 = this.getBitsPerColor();
            if (var5.length < var3 * var4 * var6) {
                throw new IllegalArgumentException();
            }
            for (int var7 = 0; var7 < var4; ++var7) {
                System.arraycopy(var5, var7 * var3 * var6, this.imageData, ((var2 + var7) * this.width + var1) * var6, var3 * var6);
            }
        } else {
            throw new IllegalArgumentException();
        }
        ((Emulator3D)Graphics3D.getImpl()).invalidateTexture(this);
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public int getFormat() {
        return this.type;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getBitsPerColor() {
        return Image2D.bytesPerPixel(this.type);
    }

    private static int bytesPerPixel(int type) {
        switch (type) {
            case 96: 
            case 97: {
                return 1;
            }
            case 98: {
                return 2;
            }
            case 99: {
                return 3;
            }
            case 100: {
                return 4;
            }
        }
        throw new IllegalArgumentException();
    }

    private static boolean checkType(int var0) {
        return var0 >= 96 && var0 <= 100;
    }

    public final byte[] getImageData() {
        return this.imageData;
    }

    private static byte[] convert(int type, int[] data, boolean mutable) {
        byte[] var3 = null;
        int var4 = data.length;
        if (mutable) {
            switch (type) {
                case 96: 
                case 97: {
                    var3 = new byte[var4];
                    for (int var5 = var4 - 1; var5 >= 0; --var5) {
                        var3[var5] = (byte)(((data[var5] >> 16 & 0xFF) + (data[var5] >> 8 & 0xFF) + (data[var5] & 0xFF)) / 3 & 0xFF);
                    }
                    return var3;
                }
                case 98: {
                    var3 = new byte[var4 * 2];
                    for (int var5 = var4 - 1; var5 >= 0; --var5) {
                        var3[var5 * 2] = (byte)(((data[var5] >> 16 & 0xFF) + (data[var5] >> 8 & 0xFF) + (data[var5] & 0xFF)) / 3 & 0xFF);
                        var3[var5 * 2 + 1] = -1;
                    }
                    return var3;
                }
                case 99: {
                    var3 = new byte[var4 * 3];
                    for (int var5 = var4 - 1; var5 >= 0; --var5) {
                        var3[var5 * 3] = (byte)(data[var5] >> 16 & 0xFF);
                        var3[var5 * 3 + 1] = (byte)(data[var5] >> 8 & 0xFF);
                        var3[var5 * 3 + 2] = (byte)(data[var5] & 0xFF);
                    }
                    return var3;
                }
                case 100: {
                    var3 = new byte[var4 * 4];
                    for (int var5 = var4 - 1; var5 >= 0; --var5) {
                        var3[var5 * 4] = (byte)(data[var5] >> 16 & 0xFF);
                        var3[var5 * 4 + 1] = (byte)(data[var5] >> 8 & 0xFF);
                        var3[var5 * 4 + 2] = (byte)(data[var5] & 0xFF);
                        var3[var5 * 4 + 3] = -1;
                    }
                    break;
                }
            }
        } else {
            switch (type) {
                case 96: {
                    var3 = new byte[var4];
                    for (int var5 = var4 - 1; var5 >= 0; --var5) {
                        var3[var5] = (byte)(data[var5] >> 24 & 0xFF);
                    }
                    return var3;
                }
                case 97: {
                    var3 = new byte[var4];
                    for (int var5 = var4 - 1; var5 >= 0; --var5) {
                        var3[var5] = (byte)(((data[var5] >> 16 & 0xFF) + (data[var5] >> 8 & 0xFF) + (data[var5] & 0xFF)) / 3 & 0xFF);
                    }
                    return var3;
                }
                case 98: {
                    var3 = new byte[var4 * 2];
                    for (int var5 = var4 - 1; var5 >= 0; --var5) {
                        var3[var5 * 2] = (byte)(((data[var5] >> 16 & 0xFF) + (data[var5] >> 8 & 0xFF) + (data[var5] & 0xFF)) / 3 & 0xFF);
                        var3[var5 * 2 + 1] = (byte)(data[var5] >> 24 & 0xFF);
                    }
                    return var3;
                }
                case 99: {
                    var3 = new byte[var4 * 3];
                    for (int var5 = var4 - 1; var5 >= 0; --var5) {
                        var3[var5 * 3] = (byte)(data[var5] >> 16 & 0xFF);
                        var3[var5 * 3 + 1] = (byte)(data[var5] >> 8 & 0xFF);
                        var3[var5 * 3 + 2] = (byte)(data[var5] & 0xFF);
                    }
                    return var3;
                }
                case 100: {
                    var3 = new byte[var4 * 4];
                    for (int var5 = var4 - 1; var5 >= 0; --var5) {
                        var3[var5 * 4] = (byte)(data[var5] >> 16 & 0xFF);
                        var3[var5 * 4 + 1] = (byte)(data[var5] >> 8 & 0xFF);
                        var3[var5 * 4 + 2] = (byte)(data[var5] & 0xFF);
                        var3[var5 * 4 + 3] = (byte)(data[var5] >> 24 & 0xFF);
                    }
                    break;
                }
            }
        }
        return var3;
    }

    @Override
    protected Object3D duplicateObject() {
        Image2D var1 = (Image2D)super.duplicateObject();
        var1.imageData = (byte[])this.imageData.clone();
        return var1;
    }

    public void finalize() {
        if (this.id == 0) {
            return;
        }
        ((Emulator3D)Graphics3D.getImpl()).finalizeTexture(this);
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void setLoaded(boolean b) {
        this.loaded = b;
    }

    public void setId(int id) {
        this.id = id;
        this.loaded = false;
    }

    public int getId() {
        return this.id;
    }

    public int size() {
        return this.imageData.length;
    }

    public void getPixels(byte[] dist) {
        byte[] b = this.getImageData();
        System.arraycopy(b, 0, dist, 0, b.length);
    }

    public boolean isPalettized() {
        return false;
    }

    public void getPalette(byte[] array) {
    }

    void setRGB(IImage image) {
        int[] data = image.getData();
        int l = data.length;
        if (this.imageData == null || this.imageData.length != l * 3) {
            this.imageData = new byte[l * 3];
        }
        byte[] var3 = this.imageData;
        for (int var5 = l - 1; var5 >= 0; --var5) {
            var3[var5 * 3] = (byte)(data[var5] >> 16 & 0xFF);
            var3[var5 * 3 + 1] = (byte)(data[var5] >> 8 & 0xFF);
            var3[var5 * 3 + 2] = (byte)(data[var5] & 0xFF);
        }
        ((Emulator3D)Graphics3D.getImpl()).invalidateTexture(this);
    }
}

