/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.m3g;

import emulator.graphics3D.Quaternion;
import javax.microedition.m3g.Object3D;
import javax.microedition.m3g.Transform;

public abstract class Transformable
extends Object3D {
    float[] scale = new float[3];
    float[] translation = new float[3];
    Quaternion rotation = new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
    Transform transform = new Transform();

    Transformable() {
        this.scale[2] = 1.0f;
        this.scale[1] = 1.0f;
        this.scale[0] = 1.0f;
    }

    public void setOrientation(float var1, float var2, float var3, float var4) {
        if (var1 != 0.0f && var2 == 0.0f && var3 == 0.0f && var4 == 0.0f) {
            throw new IllegalArgumentException();
        }
        this.rotation.setAngleAxis(var1, var2, var3, var4);
    }

    public void getOrientation(float[] var1) {
        if (var1 == null) {
            throw new NullPointerException();
        }
        if (var1.length < 4) {
            throw new IllegalArgumentException();
        }
        this.rotation.getAngleAxis(var1);
    }

    public void preRotate(float var1, float var2, float var3, float var4) {
        if (var1 != 0.0f && var2 == 0.0f && var3 == 0.0f && var4 == 0.0f) {
            throw new IllegalArgumentException();
        }
        Quaternion var5 = new Quaternion();
        var5.setAngleAxis(var1, var2, var3, var4);
        var5.mul(this.rotation);
        this.rotation.set(var5);
    }

    public void postRotate(float var1, float var2, float var3, float var4) {
        if (var1 != 0.0f && var2 == 0.0f && var3 == 0.0f && var4 == 0.0f) {
            throw new IllegalArgumentException();
        }
        Quaternion var5 = new Quaternion();
        var5.setAngleAxis(var1, var2, var3, var4);
        this.rotation.mul(var5);
    }

    public void setScale(float var1, float var2, float var3) {
        this.scale[0] = var1;
        this.scale[1] = var2;
        this.scale[2] = var3;
    }

    public void scale(float var1, float var2, float var3) {
        this.scale[0] = this.scale[0] * var1;
        this.scale[1] = this.scale[1] * var2;
        this.scale[2] = this.scale[2] * var3;
    }

    public void getScale(float[] var1) {
        if (var1 == null) {
            throw new NullPointerException();
        }
        if (var1.length < 3) {
            throw new IllegalArgumentException();
        }
        System.arraycopy(this.scale, 0, var1, 0, 3);
    }

    public void setTranslation(float var1, float var2, float var3) {
        this.translation[0] = var1;
        this.translation[1] = var2;
        this.translation[2] = var3;
    }

    public void translate(float var1, float var2, float var3) {
        this.translation[0] = this.translation[0] + var1;
        this.translation[1] = this.translation[1] + var2;
        this.translation[2] = this.translation[2] + var3;
    }

    public void getTranslation(float[] var1) {
        if (var1 == null) {
            throw new NullPointerException();
        }
        if (var1.length < 3) {
            throw new IllegalArgumentException();
        }
        System.arraycopy(this.translation, 0, var1, 0, 3);
    }

    public void setTransform(Transform var1) {
        if (var1 == null) {
            this.transform.setIdentity();
        } else {
            this.transform.set(var1);
        }
    }

    public void getTransform(Transform var1) {
        if (var1 == null) {
            throw new NullPointerException();
        }
        var1.set(this.transform);
    }

    public void getCompositeTransform(Transform var1) {
        if (var1 == null) {
            throw new NullPointerException();
        }
        var1.setIdentity();
        var1.postTranslate(this.translation[0], this.translation[1], this.translation[2]);
        var1.postRotateQuat(this.rotation.x, this.rotation.y, this.rotation.z, this.rotation.w);
        var1.postScale(this.scale[0], this.scale[1], this.scale[2]);
        var1.postMultiply(this.transform);
    }

    @Override
    protected void updateProperty(int property, float[] values) {
        switch (property) {
            case 268: {
                this.rotation.set(values);
                this.rotation.normalize();
                return;
            }
            case 270: {
                if (values.length == 1) {
                    this.scale[1] = this.scale[2] = values[0];
                    this.scale[0] = this.scale[2];
                } else {
                    this.scale[0] = values[0];
                    this.scale[1] = values[1];
                    this.scale[2] = values[2];
                }
                return;
            }
            case 275: {
                this.translation[0] = values[0];
                this.translation[1] = values[1];
                this.translation[2] = values[2];
                return;
            }
        }
        super.updateProperty(property, values);
    }

    @Override
    protected Object3D duplicateObject() {
        Transformable var1 = (Transformable)super.duplicateObject();
        ((Transformable)super.duplicateObject()).rotation = new Quaternion(this.rotation);
        var1.transform = new Transform(this.transform);
        var1.translation = (float[])this.translation.clone();
        var1.scale = (float[])this.scale.clone();
        return var1;
    }
}

