/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public abstract class CipherSpi {
    protected abstract void engineSetMode(String var1) throws NoSuchAlgorithmException;

    protected abstract void engineSetPadding(String var1) throws NoSuchPaddingException;

    protected abstract int engineGetBlockSize();

    protected abstract int engineGetOutputSize(int var1);

    protected abstract byte[] engineGetIV();

    protected abstract AlgorithmParameters engineGetParameters();

    protected abstract void engineInit(int var1, Key var2, SecureRandom var3) throws InvalidKeyException;

    protected abstract void engineInit(int var1, Key var2, AlgorithmParameterSpec var3, SecureRandom var4) throws InvalidKeyException, InvalidAlgorithmParameterException;

    protected abstract void engineInit(int var1, Key var2, AlgorithmParameters var3, SecureRandom var4) throws InvalidKeyException, InvalidAlgorithmParameterException;

    protected abstract byte[] engineUpdate(byte[] var1, int var2, int var3);

    protected abstract int engineUpdate(byte[] var1, int var2, int var3, byte[] var4, int var5) throws ShortBufferException;

    protected int engineUpdate(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws ShortBufferException {
        try {
            return this.bufferCrypt(byteBuffer, byteBuffer2, true);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new ProviderException("Internal error in update()");
        }
        catch (BadPaddingException badPaddingException) {
            throw new ProviderException("Internal error in update()");
        }
    }

    protected abstract byte[] engineDoFinal(byte[] var1, int var2, int var3) throws IllegalBlockSizeException, BadPaddingException;

    protected abstract int engineDoFinal(byte[] var1, int var2, int var3, byte[] var4, int var5) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException;

    protected int engineDoFinal(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return this.bufferCrypt(byteBuffer, byteBuffer2, false);
    }

    static int getTempArraySize(int n) {
        return Math.min(4096, n);
    }

    private int bufferCrypt(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, boolean bl) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        int n;
        byte[] byArray;
        if (byteBuffer == null || byteBuffer2 == null) {
            throw new NullPointerException("Input and output buffers must not be null");
        }
        int n2 = byteBuffer.position();
        int n3 = byteBuffer.limit();
        int n4 = n3 - n2;
        if (bl && n4 == 0) {
            return 0;
        }
        int n5 = this.engineGetOutputSize(n4);
        if (byteBuffer2.remaining() < n5) {
            throw new ShortBufferException("Need at least " + n5 + " bytes of space in output buffer");
        }
        boolean bl2 = byteBuffer.hasArray();
        boolean bl3 = byteBuffer2.hasArray();
        if (bl2 && bl3) {
            byte[] byArray2 = byteBuffer.array();
            int n6 = byteBuffer.arrayOffset() + n2;
            byte[] byArray3 = byteBuffer2.array();
            int n7 = byteBuffer2.position();
            int n8 = byteBuffer2.arrayOffset() + n7;
            int n9 = bl ? this.engineUpdate(byArray2, n6, n4, byArray3, n8) : this.engineDoFinal(byArray2, n6, n4, byArray3, n8);
            byteBuffer.position(n3);
            byteBuffer2.position(n7 + n9);
            return n9;
        }
        if (!bl2 && bl3) {
            int n10;
            int n11 = byteBuffer2.position();
            byte[] byArray4 = byteBuffer2.array();
            int n12 = byteBuffer2.arrayOffset() + n11;
            byte[] byArray5 = new byte[CipherSpi.getTempArraySize(n4)];
            int n13 = 0;
            do {
                if ((n10 = Math.min(n4, byArray5.length)) > 0) {
                    byteBuffer.get(byArray5, 0, n10);
                }
                int n14 = bl || n4 != n10 ? this.engineUpdate(byArray5, 0, n10, byArray4, n12) : this.engineDoFinal(byArray5, 0, n10, byArray4, n12);
                n13 += n14;
                n12 += n14;
            } while ((n4 -= n10) > 0);
            byteBuffer2.position(n11 + n13);
            return n13;
        }
        if (bl2) {
            byArray = byteBuffer.array();
            n = byteBuffer.arrayOffset() + n2;
        } else {
            byArray = new byte[CipherSpi.getTempArraySize(n4)];
            n = 0;
        }
        byte[] byArray6 = new byte[CipherSpi.getTempArraySize(n5)];
        int n15 = byArray6.length;
        int n16 = 0;
        boolean bl4 = false;
        do {
            int n17 = Math.min(n4, n15 == 0 ? byArray.length : n15);
            if (!bl2 && !bl4 && n17 > 0) {
                byteBuffer.get(byArray, 0, n17);
                n = 0;
            }
            try {
                int n18 = bl || n4 != n17 ? this.engineUpdate(byArray, n, n17, byArray6, 0) : this.engineDoFinal(byArray, n, n17, byArray6, 0);
                bl4 = false;
                n += n17;
                n4 -= n17;
                if (n18 <= 0) continue;
                byteBuffer2.put(byArray6, 0, n18);
                n16 += n18;
            }
            catch (ShortBufferException shortBufferException) {
                if (bl4) {
                    throw (ProviderException)new ProviderException("Could not determine buffer size").initCause(shortBufferException);
                }
                bl4 = true;
                n15 = this.engineGetOutputSize(n17);
                byArray6 = new byte[n15];
            }
        } while (n4 > 0);
        if (bl2) {
            byteBuffer.position(n3);
        }
        return n16;
    }

    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        throw new UnsupportedOperationException();
    }

    protected Key engineUnwrap(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
        throw new UnsupportedOperationException();
    }

    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        throw new UnsupportedOperationException();
    }

    protected void engineUpdateAAD(byte[] byArray, int n, int n2) {
        throw new UnsupportedOperationException("The underlying Cipher implementation does not support this method");
    }

    protected void engineUpdateAAD(ByteBuffer byteBuffer) {
        throw new UnsupportedOperationException("The underlying Cipher implementation does not support this method");
    }
}

