/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.encoding;

import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.WSFeatureList;
import com.sun.xml.internal.ws.api.message.Attachment;
import com.sun.xml.internal.ws.api.message.AttachmentEx;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.pipe.Codec;
import com.sun.xml.internal.ws.api.pipe.ContentType;
import com.sun.xml.internal.ws.developer.StreamingAttachmentFeature;
import com.sun.xml.internal.ws.encoding.ContentTypeImpl;
import com.sun.xml.internal.ws.encoding.MimeMultipartParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.ReadableByteChannel;
import java.util.Iterator;
import java.util.UUID;

abstract class MimeCodec
implements Codec {
    public static final String MULTIPART_RELATED_MIME_TYPE = "multipart/related";
    protected Codec mimeRootCodec;
    protected final SOAPVersion version;
    protected final WSFeatureList features;

    protected MimeCodec(SOAPVersion sOAPVersion, WSFeatureList wSFeatureList) {
        this.version = sOAPVersion;
        this.features = wSFeatureList;
    }

    @Override
    public String getMimeType() {
        return MULTIPART_RELATED_MIME_TYPE;
    }

    protected Codec getMimeRootCodec(Packet packet) {
        return this.mimeRootCodec;
    }

    @Override
    public ContentType encode(Packet packet, OutputStream outputStream) throws IOException {
        ContentType contentType;
        Message message = packet.getMessage();
        if (message == null) {
            return null;
        }
        ContentTypeImpl contentTypeImpl = (ContentTypeImpl)this.getStaticContentType(packet);
        String string = contentTypeImpl.getBoundary();
        boolean bl = string != null;
        Codec codec = this.getMimeRootCodec(packet);
        if (bl) {
            MimeCodec.writeln("--" + string, outputStream);
            contentType = codec.getStaticContentType(packet);
            String string2 = contentType != null ? contentType.getContentType() : codec.getMimeType();
            MimeCodec.writeln("Content-Type: " + (String)string2, outputStream);
            MimeCodec.writeln(outputStream);
        }
        contentType = codec.encode(packet, outputStream);
        if (bl) {
            MimeCodec.writeln(outputStream);
            for (Attachment attachment : message.getAttachments()) {
                MimeCodec.writeln("--" + string, outputStream);
                String string3 = attachment.getContentId();
                if (string3 != null && string3.length() > 0 && string3.charAt(0) != '<') {
                    string3 = '<' + string3 + '>';
                }
                MimeCodec.writeln("Content-Id:" + string3, outputStream);
                MimeCodec.writeln("Content-Type: " + attachment.getContentType(), outputStream);
                this.writeCustomMimeHeaders(attachment, outputStream);
                MimeCodec.writeln("Content-Transfer-Encoding: binary", outputStream);
                MimeCodec.writeln(outputStream);
                attachment.writeTo(outputStream);
                MimeCodec.writeln(outputStream);
            }
            MimeCodec.writeAsAscii("--" + string, outputStream);
            MimeCodec.writeAsAscii("--", outputStream);
        }
        return bl ? contentTypeImpl : contentType;
    }

    private void writeCustomMimeHeaders(Attachment attachment, OutputStream outputStream) throws IOException {
        if (attachment instanceof AttachmentEx) {
            Iterator<AttachmentEx.MimeHeader> iterator = ((AttachmentEx)attachment).getMimeHeaders();
            while (iterator.hasNext()) {
                AttachmentEx.MimeHeader mimeHeader = iterator.next();
                String string = mimeHeader.getName();
                if ("Content-Type".equalsIgnoreCase(string) || "Content-Id".equalsIgnoreCase(string)) continue;
                MimeCodec.writeln(string + ": " + mimeHeader.getValue(), outputStream);
            }
        }
    }

    @Override
    public ContentType getStaticContentType(Packet packet) {
        ContentType contentType = (ContentType)packet.getInternalContentType();
        if (contentType != null) {
            return contentType;
        }
        Message message = packet.getMessage();
        boolean bl = !message.getAttachments().isEmpty();
        Codec codec = this.getMimeRootCodec(packet);
        if (bl) {
            String string = "uuid:" + UUID.randomUUID().toString();
            String string2 = "boundary=\"" + string + "\"";
            String string3 = "multipart/related; type=\"" + codec.getMimeType() + "\"; " + string2;
            ContentTypeImpl contentTypeImpl = new ContentTypeImpl(string3, packet.soapAction, null);
            contentTypeImpl.setBoundary(string);
            contentTypeImpl.setBoundaryParameter(string2);
            packet.setContentType(contentTypeImpl);
            return contentTypeImpl;
        }
        contentType = codec.getStaticContentType(packet);
        packet.setContentType(contentType);
        return contentType;
    }

    protected MimeCodec(MimeCodec mimeCodec) {
        this.version = mimeCodec.version;
        this.features = mimeCodec.features;
    }

    @Override
    public void decode(InputStream inputStream, String string, Packet packet) throws IOException {
        MimeMultipartParser mimeMultipartParser = new MimeMultipartParser(inputStream, string, this.features.get(StreamingAttachmentFeature.class));
        this.decode(mimeMultipartParser, packet);
    }

    @Override
    public void decode(ReadableByteChannel readableByteChannel, String string, Packet packet) {
        throw new UnsupportedOperationException();
    }

    protected abstract void decode(MimeMultipartParser var1, Packet var2) throws IOException;

    @Override
    public abstract MimeCodec copy();

    public static void writeln(String string, OutputStream outputStream) throws IOException {
        MimeCodec.writeAsAscii(string, outputStream);
        MimeCodec.writeln(outputStream);
    }

    public static void writeAsAscii(String string, OutputStream outputStream) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            outputStream.write((byte)string.charAt(i));
        }
    }

    public static void writeln(OutputStream outputStream) throws IOException {
        outputStream.write(13);
        outputStream.write(10);
    }
}

