/*
 * Decompiled with CFR 0.152.
 */
package org.bridj.demangling;

import java.lang.reflect.Modifier;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bridj.CLong;
import org.bridj.NativeLibrary;
import org.bridj.ann.Convention$Style;
import org.bridj.demangling.Demangler;
import org.bridj.demangling.Demangler$ClassRef;
import org.bridj.demangling.Demangler$Constant;
import org.bridj.demangling.Demangler$DemanglingException;
import org.bridj.demangling.Demangler$FunctionTypeRef;
import org.bridj.demangling.Demangler$Ident;
import org.bridj.demangling.Demangler$IdentLike;
import org.bridj.demangling.Demangler$MemberRef;
import org.bridj.demangling.Demangler$NamespaceRef;
import org.bridj.demangling.Demangler$SpecialName;
import org.bridj.demangling.Demangler$TemplateArg;
import org.bridj.demangling.Demangler$TypeRef;
import org.bridj.demangling.VC9Demangler$1;
import org.bridj.demangling.VC9Demangler$AccessLevelAndStorageClass;
import org.bridj.demangling.VC9Demangler$AnonymousTemplateArg;
import org.bridj.demangling.VC9Demangler$CVClassModifier;
import org.bridj.demangling.VC9Demangler$DemanglingOp;

public class VC9Demangler
extends Demangler {
    List allQualifiedNames = new ArrayList();

    public VC9Demangler(NativeLibrary nativeLibrary, String string) {
        super(nativeLibrary, string);
    }

    private VC9Demangler$AccessLevelAndStorageClass parseAccessLevelAndStorageClass() {
        VC9Demangler$AccessLevelAndStorageClass vC9Demangler$AccessLevelAndStorageClass = new VC9Demangler$AccessLevelAndStorageClass();
        switch (this.consumeChar()) {
            case 'A': 
            case 'B': {
                vC9Demangler$AccessLevelAndStorageClass.modifiers = 2;
                break;
            }
            case 'C': 
            case 'D': {
                vC9Demangler$AccessLevelAndStorageClass.modifiers = 10;
                break;
            }
            case 'E': 
            case 'F': {
                vC9Demangler$AccessLevelAndStorageClass.modifiers = 2;
                vC9Demangler$AccessLevelAndStorageClass.isVirtual = true;
                break;
            }
            case 'G': 
            case 'H': {
                vC9Demangler$AccessLevelAndStorageClass.modifiers = 2;
                vC9Demangler$AccessLevelAndStorageClass.isThunk = true;
                break;
            }
            case 'I': 
            case 'J': {
                vC9Demangler$AccessLevelAndStorageClass.modifiers = 4;
                break;
            }
            case 'K': 
            case 'L': {
                vC9Demangler$AccessLevelAndStorageClass.modifiers = 12;
                break;
            }
            case 'M': 
            case 'N': {
                vC9Demangler$AccessLevelAndStorageClass.modifiers = 4;
                vC9Demangler$AccessLevelAndStorageClass.isVirtual = true;
                break;
            }
            case 'O': 
            case 'P': {
                vC9Demangler$AccessLevelAndStorageClass.modifiers = 4;
                vC9Demangler$AccessLevelAndStorageClass.isThunk = true;
                break;
            }
            case 'Q': 
            case 'R': {
                vC9Demangler$AccessLevelAndStorageClass.modifiers = 1;
                break;
            }
            case 'S': 
            case 'T': {
                vC9Demangler$AccessLevelAndStorageClass.modifiers = 9;
                break;
            }
            case 'U': 
            case 'V': {
                vC9Demangler$AccessLevelAndStorageClass.modifiers = 1;
                vC9Demangler$AccessLevelAndStorageClass.isVirtual = true;
                break;
            }
            case 'W': 
            case 'X': {
                vC9Demangler$AccessLevelAndStorageClass.modifiers = 1;
                vC9Demangler$AccessLevelAndStorageClass.isThunk = true;
                break;
            }
            case 'Y': 
            case 'Z': {
                vC9Demangler$AccessLevelAndStorageClass.modifiers = 0;
                break;
            }
            default: {
                throw this.error("Unknown access level + storage class");
            }
        }
        return vC9Demangler$AccessLevelAndStorageClass;
    }

    private Demangler$ClassRef parseTemplateType() {
        String string = this.parseNameFragment();
        List list2 = this.parseTemplateParams();
        List list3 = this.parseNameQualifications();
        Demangler$ClassRef demangler$ClassRef = new Demangler$ClassRef(new Demangler$Ident(string, list2.toArray(new Demangler$TemplateArg[list2.size()])));
        demangler$ClassRef.setEnclosingType(VC9Demangler.reverseNamespace(list3));
        this.addBackRef(demangler$ClassRef);
        return demangler$ClassRef;
    }

    private void parseFunctionProperty(Demangler$MemberRef demangler$MemberRef) {
        demangler$MemberRef.callingConvention = this.parseCallingConvention();
        Demangler$TypeRef demangler$TypeRef = this.consumeCharIf('@') ? VC9Demangler.classType(Void.TYPE, new Class[0]) : this.parseType(true);
        List list2 = this.parseParams();
        demangler$MemberRef.paramTypes = list2.toArray(new Demangler$TypeRef[list2.size()]);
        if (!this.consumeCharIf('Z')) {
            List list3 = this.parseParams();
            demangler$MemberRef.throwTypes = list3.toArray(new Demangler$TypeRef[list3.size()]);
        }
        demangler$MemberRef.setValueType(demangler$TypeRef);
    }

    private Demangler$TemplateArg parseTemplateParameter() {
        switch (this.peekChar()) {
            case '?': {
                this.consumeChar();
                return new VC9Demangler$AnonymousTemplateArg("'anonymous template param " + this.parseNumber(false) + "'");
            }
            case '$': {
                this.consumeChar();
                switch (this.consumeChar()) {
                    case '0': {
                        return new Demangler$Constant(this.parseNumber(true));
                    }
                    case '2': {
                        int n2 = this.parseNumber(true);
                        int n3 = this.parseNumber(true);
                        return new Demangler$Constant((double)n2 * Math.exp(10 * (int)Math.log((double)n3 - Math.log10(n2) + 1.0)));
                    }
                    case 'D': {
                        return new VC9Demangler$AnonymousTemplateArg("'anonymous template param " + this.parseNumber(false) + "'");
                    }
                    case 'F': {
                        return new VC9Demangler$AnonymousTemplateArg("'tuple (" + this.parseNumber(true) + ", " + this.parseNumber(true) + ")'");
                    }
                    case 'G': {
                        return new VC9Demangler$AnonymousTemplateArg("'tuple (" + this.parseNumber(true) + ", " + this.parseNumber(true) + ", " + this.parseNumber(true) + ")'");
                    }
                    case 'Q': {
                        return new VC9Demangler$AnonymousTemplateArg("'anonymous non-type template param " + this.parseNumber(false) + "'");
                    }
                }
                break;
            }
        }
        return this.parseType(true);
    }

    @Override
    public Demangler$MemberRef parseSymbol() {
        Demangler$TypeRef demangler$TypeRef;
        Object object;
        Demangler$MemberRef demangler$MemberRef = new Demangler$MemberRef();
        int n2 = this.str.indexOf(64);
        if (n2 >= 0 && this.consumeCharIf('_') && n2 > 0) {
            demangler$MemberRef.setMemberName(new Demangler$Ident(this.str.substring(1, n2), new Demangler$TemplateArg[0]));
            demangler$MemberRef.setArgumentsStackSize(Integer.parseInt(this.str.substring(n2 + 1)));
            return demangler$MemberRef;
        }
        if (!this.consumeCharIf('@', '?')) {
            return null;
        }
        Demangler$IdentLike demangler$IdentLike = this.parseFirstQualifiedTypeNameComponent();
        if (demangler$IdentLike instanceof Demangler$SpecialName && !((Demangler$SpecialName)(object = (Demangler$SpecialName)demangler$IdentLike)).isFunction()) {
            return null;
        }
        demangler$MemberRef.setMemberName(demangler$IdentLike);
        object = this.parseNameQualifications();
        VC9Demangler$AccessLevelAndStorageClass vC9Demangler$AccessLevelAndStorageClass = this.parseAccessLevelAndStorageClass();
        VC9Demangler$CVClassModifier vC9Demangler$CVClassModifier = null;
        if (vC9Demangler$AccessLevelAndStorageClass.modifiers != 0 && !Modifier.isStatic(vC9Demangler$AccessLevelAndStorageClass.modifiers)) {
            vC9Demangler$CVClassModifier = this.parseCVClassModifier();
        }
        if (vC9Demangler$CVClassModifier != null && (vC9Demangler$CVClassModifier.isMember || demangler$IdentLike instanceof Demangler$SpecialName || Modifier.isPublic(vC9Demangler$AccessLevelAndStorageClass.modifiers))) {
            Object e2 = object.get(0);
            Demangler$ClassRef demangler$ClassRef = e2 instanceof Demangler$ClassRef ? (Demangler$ClassRef)e2 : new Demangler$ClassRef(new Demangler$Ident((String)e2, new Demangler$TemplateArg[0]));
            object.remove(0);
            demangler$ClassRef.setEnclosingType(VC9Demangler.reverseNamespace((List)object));
            demangler$TypeRef = demangler$ClassRef;
        } else {
            demangler$TypeRef = VC9Demangler.reverseNamespace((List)object);
        }
        this.addBackRef(demangler$TypeRef);
        demangler$MemberRef.setEnclosingType(demangler$TypeRef);
        this.parseFunctionProperty(demangler$MemberRef);
        if (this.position != this.length) {
            this.error("Failed to demangle the whole symbol");
        }
        return demangler$MemberRef;
    }

    Demangler$TypeRef parseReturnType() {
        Demangler$TypeRef demangler$TypeRef = this.parseType(true);
        return demangler$TypeRef;
    }

    int parseNumber(boolean bl2) {
        char c2;
        int n2;
        int n3 = n2 = bl2 && this.consumeCharIf('?') ? -1 : 1;
        if (Character.isDigit(this.peekChar())) {
            char c3 = this.consumeChar();
            return n2 * (c3 - 48);
        }
        if (this.peekChar() == '@') {
            return 0;
        }
        StringBuilder stringBuilder = new StringBuilder();
        long l2 = 0L;
        while ((c2 = this.consumeChar()) >= 'A' && c2 <= 'P' && c2 != '@') {
            l2 += (long)(16 * (c2 - 65));
        }
        String string = stringBuilder.toString().trim();
        if (c2 != '@' || string.length() == 0) {
            throw this.error("Expected a number here", -stringBuilder.length());
        }
        return n2 * Integer.parseInt(string, 16);
    }

    Demangler$TypeRef consumeIfBackRef() {
        char c2 = this.peekChar();
        if (Character.isDigit(c2)) {
            this.consumeChar();
            int n2 = c2 - 48;
            return this.getBackRef(n2);
        }
        return null;
    }

    Demangler$TypeRef parseType(boolean bl2) {
        Demangler$TypeRef demangler$TypeRef = this.consumeIfBackRef();
        if (demangler$TypeRef != null) {
            return demangler$TypeRef;
        }
        char c2 = this.consumeChar();
        switch (c2) {
            case '_': {
                Demangler$TypeRef demangler$TypeRef2;
                switch (this.consumeChar()) {
                    case 'D': 
                    case 'E': {
                        demangler$TypeRef2 = VC9Demangler.classType(Byte.TYPE, new Class[0]);
                        break;
                    }
                    case 'F': 
                    case 'G': {
                        demangler$TypeRef2 = VC9Demangler.classType(Short.TYPE, new Class[0]);
                        break;
                    }
                    case 'H': 
                    case 'I': {
                        demangler$TypeRef2 = VC9Demangler.classType(Integer.TYPE, new Class[0]);
                        break;
                    }
                    case 'J': 
                    case 'K': {
                        demangler$TypeRef2 = VC9Demangler.classType(Long.TYPE, new Class[0]);
                        break;
                    }
                    case 'L': {
                        demangler$TypeRef2 = VC9Demangler.classType(BigInteger.class, new Class[0]);
                        break;
                    }
                    case 'N': {
                        demangler$TypeRef2 = VC9Demangler.classType(Boolean.TYPE, new Class[0]);
                        break;
                    }
                    case '0': {
                        this.parseCVClassModifier();
                        this.parseType(false);
                        demangler$TypeRef2 = VC9Demangler.classType(Object[].class, new Class[0]);
                        break;
                    }
                    case 'W': {
                        demangler$TypeRef2 = VC9Demangler.classType(Character.TYPE, new Class[0]);
                        break;
                    }
                    default: {
                        throw this.error(-1);
                    }
                }
                this.addBackRef(demangler$TypeRef2);
                return demangler$TypeRef2;
            }
            case 'Z': {
                return VC9Demangler.classType(Object[].class, new Class[0]);
            }
            case 'O': {
                throw this.error("'long double' type cannot be mapped !", -1);
            }
            case 'C': 
            case 'D': 
            case 'E': {
                return VC9Demangler.classType(Byte.TYPE, new Class[0]);
            }
            case 'F': 
            case 'G': {
                return VC9Demangler.classType(Short.TYPE, new Class[0]);
            }
            case 'H': 
            case 'I': {
                return VC9Demangler.classType(Integer.TYPE, new Class[0]);
            }
            case 'J': 
            case 'K': {
                return VC9Demangler.classType(CLong.class, new Class[0]);
            }
            case 'M': {
                return VC9Demangler.classType(Float.TYPE, new Class[0]);
            }
            case 'N': {
                return VC9Demangler.classType(Double.TYPE, new Class[0]);
            }
            case 'Y': {
                throw this.error("TODO handle cointerfaces", -1);
            }
            case 'X': {
                if (!bl2) {
                    return null;
                }
                return VC9Demangler.classType(Void.TYPE, new Class[0]);
            }
            case '?': {
                this.parseCVClassModifier();
                return this.parseType(bl2);
            }
            case 'A': 
            case 'B': 
            case 'P': 
            case 'Q': 
            case 'R': 
            case 'S': {
                Demangler$TypeRef demangler$TypeRef3;
                boolean bl3;
                boolean bl4 = c2 == 'A' || c2 == 'B';
                boolean bl5 = bl3 = c2 == 'Q' || c2 == 'S';
                if (!this.consumeCharsIf('$', 'A')) {
                    this.consumeCharsIf('$', 'B');
                }
                VC9Demangler$CVClassModifier vC9Demangler$CVClassModifier = this.parseCVClassModifier();
                if (vC9Demangler$CVClassModifier.isVariable) {
                    if (this.consumeCharIf('Y')) {
                        int n2 = this.parseNumber(false);
                        int[] nArray = new int[n2];
                        for (int i2 = 0; i2 < n2; ++i2) {
                            nArray[i2] = this.parseNumber(false);
                        }
                    }
                    demangler$TypeRef3 = VC9Demangler.pointerType(this.parseType(true), bl3, bl4);
                } else {
                    Demangler$MemberRef demangler$MemberRef = new Demangler$MemberRef();
                    this.parseFunctionProperty(demangler$MemberRef);
                    demangler$TypeRef3 = VC9Demangler.pointerType(new Demangler$FunctionTypeRef(demangler$MemberRef), bl3, bl4);
                }
                this.addBackRef(demangler$TypeRef3);
                return demangler$TypeRef3;
            }
            case 'T': 
            case 'U': 
            case 'V': {
                return this.parseQualifiedTypeName();
            }
            case 'W': {
                Class<Number> clazz;
                switch (this.consumeChar()) {
                    case '0': 
                    case '1': {
                        clazz = Byte.TYPE;
                        break;
                    }
                    case '2': 
                    case '3': {
                        clazz = Short.TYPE;
                        break;
                    }
                    case '4': 
                    case '5': {
                        clazz = Integer.TYPE;
                        break;
                    }
                    case '6': 
                    case '7': {
                        clazz = Integer.TYPE;
                        break;
                    }
                    default: {
                        throw this.error("Unfinished enum", -1);
                    }
                }
                Demangler$TypeRef demangler$TypeRef4 = this.parseQualifiedTypeName();
                this.addBackRef(demangler$TypeRef4);
                return VC9Demangler.classType(clazz, new Class[0]);
            }
        }
        throw this.error(-1);
    }

    static Demangler$NamespaceRef reverseNamespace(List list2) {
        if (list2 == null || list2.isEmpty()) {
            return null;
        }
        Collections.reverse(list2);
        return new Demangler$NamespaceRef(list2.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object withEmptyQualifiedNames(VC9Demangler$DemanglingOp vC9Demangler$DemanglingOp) {
        List list2 = this.allQualifiedNames;
        try {
            this.allQualifiedNames = new ArrayList();
            Object object = vC9Demangler$DemanglingOp.run();
            return object;
        }
        finally {
            this.allQualifiedNames = list2;
        }
    }

    Demangler$IdentLike parseFirstQualifiedTypeNameComponent() {
        if (this.consumeCharIf('?')) {
            if (this.consumeCharIf('$')) {
                return this.parseTemplateType().getIdent();
            }
            return this.parseSpecialName();
        }
        return new Demangler$Ident(this.parseNameFragment(), new Demangler$TemplateArg[0]);
    }

    Demangler$TypeRef parseQualifiedTypeName() {
        List list2;
        Demangler$TypeRef demangler$TypeRef = this.consumeIfBackRef();
        if (demangler$TypeRef != null) {
            return demangler$TypeRef;
        }
        char c2 = this.peekChar();
        Object e2 = (list2 = this.parseNameQualifications()).get(0);
        list2.set(0, e2 instanceof String ? new Demangler$Ident((String)e2, new Demangler$TemplateArg[0]) : ((Demangler$ClassRef)e2).getIdent());
        if (list2.size() == 1 && list2.get(0) instanceof Demangler$TypeRef) {
            return (Demangler$TypeRef)list2.get(0);
        }
        Demangler$ClassRef demangler$ClassRef = new Demangler$ClassRef((Demangler$Ident)list2.get(0));
        list2.remove(0);
        demangler$ClassRef.setEnclosingType(VC9Demangler.reverseNamespace(list2));
        return demangler$ClassRef;
    }

    public Demangler$IdentLike parseSpecialName() {
        switch (this.consumeChar()) {
            case '0': {
                return Demangler$SpecialName.Constructor;
            }
            case '1': {
                return Demangler$SpecialName.Destructor;
            }
            case '2': {
                return Demangler$SpecialName.New;
            }
            case '3': {
                return Demangler$SpecialName.Delete;
            }
            case '4': {
                return Demangler$SpecialName.OperatorAssign;
            }
            case '5': {
                return Demangler$SpecialName.OperatorRShift;
            }
            case '6': {
                return Demangler$SpecialName.OperatorLShift;
            }
            case '7': {
                return Demangler$SpecialName.OperatorLogicNot;
            }
            case '8': {
                return Demangler$SpecialName.OperatorEquals;
            }
            case '9': {
                return Demangler$SpecialName.OperatorDifferent;
            }
            case 'A': {
                return Demangler$SpecialName.OperatorSquareBrackets;
            }
            case 'B': {
                return Demangler$SpecialName.OperatorCast;
            }
            case 'C': {
                return Demangler$SpecialName.OperatorArrow;
            }
            case 'D': {
                return Demangler$SpecialName.OperatorMultiply;
            }
            case 'E': {
                return Demangler$SpecialName.OperatorIncrement;
            }
            case 'F': {
                return Demangler$SpecialName.OperatorDecrement;
            }
            case 'G': {
                return Demangler$SpecialName.OperatorSubstract;
            }
            case 'H': {
                return Demangler$SpecialName.OperatorAdd;
            }
            case 'I': {
                return Demangler$SpecialName.OperatorBitAnd;
            }
            case 'J': {
                return Demangler$SpecialName.OperatorArrowStar;
            }
            case 'K': {
                return Demangler$SpecialName.OperatorDivide;
            }
            case 'L': {
                return Demangler$SpecialName.OperatorModulo;
            }
            case 'M': {
                return Demangler$SpecialName.OperatorLower;
            }
            case 'N': {
                return Demangler$SpecialName.OperatorLowerEquals;
            }
            case 'O': {
                return Demangler$SpecialName.OperatorGreater;
            }
            case 'P': {
                return Demangler$SpecialName.OperatorGreaterEquals;
            }
            case 'Q': {
                return Demangler$SpecialName.OperatorComma;
            }
            case 'R': {
                return Demangler$SpecialName.OperatorParenthesis;
            }
            case 'S': {
                return Demangler$SpecialName.OperatorBitNot;
            }
            case 'T': {
                return Demangler$SpecialName.OperatorXOR;
            }
            case 'U': {
                return Demangler$SpecialName.OperatorBitOr;
            }
            case 'V': {
                return Demangler$SpecialName.OperatorLogicAnd;
            }
            case 'W': {
                return Demangler$SpecialName.OperatorLogicOr;
            }
            case 'X': {
                return Demangler$SpecialName.OperatorMultiplyAssign;
            }
            case 'Y': {
                return Demangler$SpecialName.OperatorAddAssign;
            }
            case 'Z': {
                return Demangler$SpecialName.OperatorSubstractAssign;
            }
            case '_': {
                switch (this.consumeChar()) {
                    case '0': {
                        return Demangler$SpecialName.OperatorDivideAssign;
                    }
                    case '1': {
                        return Demangler$SpecialName.OperatorModuloAssign;
                    }
                    case '2': {
                        return Demangler$SpecialName.OperatorLShiftAssign;
                    }
                    case '3': {
                        return Demangler$SpecialName.OperatorRShiftAssign;
                    }
                    case '4': {
                        return Demangler$SpecialName.OperatorBitAndAssign;
                    }
                    case '5': {
                        return Demangler$SpecialName.OperatorBitOrAssign;
                    }
                    case '6': {
                        return Demangler$SpecialName.OperatorXORAssign;
                    }
                    case '7': {
                        return Demangler$SpecialName.VFTable;
                    }
                    case '8': {
                        return Demangler$SpecialName.VBTable;
                    }
                    case '9': {
                        return Demangler$SpecialName.VCall;
                    }
                    case 'E': {
                        return Demangler$SpecialName.VectorDeletingDestructor;
                    }
                    case 'G': {
                        return Demangler$SpecialName.ScalarDeletingDestructor;
                    }
                }
                throw this.error("unhandled extended special name");
            }
        }
        throw this.error("Invalid special name");
    }

    private List parseParams() {
        ArrayList<Demangler$TypeRef> arrayList = new ArrayList<Demangler$TypeRef>();
        if (!this.consumeCharIf('X')) {
            char c2;
            while ((c2 = this.peekChar()) != '@' && c2 != '\u0000' && (c2 != 'Z' || this.peekChar(2) == 'Z')) {
                Demangler$TypeRef demangler$TypeRef = this.parseType(false);
                if (demangler$TypeRef == null) continue;
                arrayList.add(demangler$TypeRef);
            }
            if (c2 == 'Z') {
                this.consumeChar();
            }
            if (c2 == '@') {
                this.consumeChar();
            }
        }
        return arrayList;
    }

    private List parseTemplateParams() {
        return (List)this.withEmptyQualifiedNames(new VC9Demangler$1(this));
    }

    String parseNameFragment() {
        char c2;
        StringBuilder stringBuilder = new StringBuilder();
        while ((c2 = this.consumeChar()) != '@') {
            stringBuilder.append(c2);
        }
        if (stringBuilder.length() == 0) {
            throw new Demangler$DemanglingException(this, "Unexpected empty name fragment");
        }
        String string = stringBuilder.toString();
        return string;
    }

    void addBackRef(Demangler$TypeRef demangler$TypeRef) {
        if (demangler$TypeRef == null || this.allQualifiedNames.contains(demangler$TypeRef)) {
            return;
        }
        this.allQualifiedNames.add(demangler$TypeRef);
    }

    Demangler$TypeRef getBackRef(int n2) {
        if (n2 == this.allQualifiedNames.size()) {
            --n2;
        }
        if (n2 < 0 || n2 >= this.allQualifiedNames.size()) {
            throw this.error("Invalid back references in name qualifications", -1);
        }
        return (Demangler$TypeRef)this.allQualifiedNames.get(n2);
    }

    private List parseNameQualifications() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (Character.isDigit(this.peekChar())) {
            try {
                int n2 = this.consumeChar() - 48;
                arrayList.add(this.getBackRef(n2));
                this.expectChars('@');
                return arrayList;
            }
            catch (Exception exception) {
                throw this.error("Invalid back references in name qualifications", -1);
            }
        }
        while (this.peekChar() != '@') {
            arrayList.add(this.parseNameQualification());
        }
        this.expectChars('@');
        return arrayList;
    }

    Object parseNameQualification() {
        if (this.consumeCharIf('?')) {
            if (this.consumeCharIf('$')) {
                return this.parseTemplateType();
            }
            if (this.peekChar() == 'A') {
                throw this.error("Anonymous numbered namespaces not handled yet");
            }
            int n2 = this.parseNumber(false);
            return String.valueOf(n2);
        }
        return this.parseNameFragment();
    }

    Convention$Style parseCallingConvention() {
        Convention$Style convention$Style;
        boolean bl2 = true;
        switch (this.consumeChar()) {
            case 'A': {
                bl2 = false;
            }
            case 'B': {
                convention$Style = Convention$Style.CDecl;
                break;
            }
            case 'C': {
                bl2 = false;
            }
            case 'D': {
                convention$Style = Convention$Style.Pascal;
                break;
            }
            case 'E': {
                bl2 = false;
            }
            case 'F': {
                convention$Style = Convention$Style.ThisCall;
                break;
            }
            case 'G': {
                bl2 = false;
            }
            case 'H': {
                convention$Style = Convention$Style.StdCall;
                break;
            }
            case 'I': {
                bl2 = false;
            }
            case 'J': {
                convention$Style = Convention$Style.FastCall;
                break;
            }
            case 'K': {
                bl2 = false;
            }
            case 'L': {
                convention$Style = null;
                break;
            }
            case 'N': {
                convention$Style = Convention$Style.CLRCall;
                break;
            }
            default: {
                throw this.error("Unknown calling convention");
            }
        }
        return convention$Style;
    }

    VC9Demangler$CVClassModifier parseCVClassModifier() {
        VC9Demangler$CVClassModifier vC9Demangler$CVClassModifier = new VC9Demangler$CVClassModifier();
        switch (this.peekChar()) {
            case 'E': 
            case 'F': 
            case 'I': {
                this.consumeChar();
            }
        }
        boolean bl2 = false;
        block3 : switch (this.consumeChar()) {
            case 'M': 
            case 'N': 
            case 'O': 
            case 'P': {
                vC9Demangler$CVClassModifier.isBased = true;
            }
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'G': 
            case 'H': 
            case 'J': 
            case 'K': 
            case 'L': {
                vC9Demangler$CVClassModifier.isVariable = true;
                vC9Demangler$CVClassModifier.isMember = false;
                break;
            }
            case '2': 
            case '3': 
            case '4': 
            case '5': {
                vC9Demangler$CVClassModifier.isBased = true;
            }
            case '0': 
            case '1': 
            case 'Q': 
            case 'R': 
            case 'S': 
            case 'T': 
            case 'U': 
            case 'V': 
            case 'W': 
            case 'X': 
            case 'Y': 
            case 'Z': {
                vC9Demangler$CVClassModifier.isVariable = true;
                vC9Demangler$CVClassModifier.isMember = true;
                break;
            }
            case '_': {
                vC9Demangler$CVClassModifier.isBased = true;
                switch (this.consumeChar()) {
                    case 'A': 
                    case 'B': {
                        vC9Demangler$CVClassModifier.isVariable = false;
                        break block3;
                    }
                    case 'C': 
                    case 'D': {
                        vC9Demangler$CVClassModifier.isVariable = false;
                        vC9Demangler$CVClassModifier.isMember = true;
                        break block3;
                    }
                }
                throw this.error("Unknown extended __based class modifier", -1);
            }
            case '6': 
            case '7': {
                vC9Demangler$CVClassModifier.isVariable = false;
                vC9Demangler$CVClassModifier.isMember = false;
                break;
            }
            case '8': 
            case '9': {
                vC9Demangler$CVClassModifier.isVariable = false;
                vC9Demangler$CVClassModifier.isMember = true;
                break;
            }
            default: {
                throw this.error("Unknown CV class modifier", -1);
            }
        }
        if (vC9Demangler$CVClassModifier.isBased) {
            switch (this.consumeChar()) {
                case '0': {
                    break;
                }
                case '2': {
                    this.parseNameQualifications();
                    break;
                }
            }
        }
        return vC9Demangler$CVClassModifier;
    }

    static /* synthetic */ Demangler$TemplateArg access$000(VC9Demangler vC9Demangler) {
        return vC9Demangler.parseTemplateParameter();
    }
}

