/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.WebKit;
import org.eclipse.swt.browser.WebPolicyDelegate$1;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.COMObject;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IUnknown;
import org.eclipse.swt.internal.webkit.IWebError;
import org.eclipse.swt.internal.webkit.IWebPolicyDecisionListener;
import org.eclipse.swt.internal.webkit.IWebPreferences;
import org.eclipse.swt.internal.webkit.IWebURLRequest;
import org.eclipse.swt.internal.webkit.IWebView;
import org.eclipse.swt.internal.webkit.WebKit_win32;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.widgets.MessageBox;

class WebPolicyDelegate {
    COMObject iWebPolicyDelegate;
    int refCount = 0;
    Browser browser;

    WebPolicyDelegate(Browser browser) {
        this.createCOMInterfaces();
        this.browser = browser;
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    void createCOMInterfaces() {
        this.iWebPolicyDelegate = new WebPolicyDelegate$1(this, new int[]{2, 0, 0, 5, 5, 5, 3});
    }

    int decidePolicyForMIMEType(int n2, int n3, int n4, int n5, int n6) {
        IWebView iWebView = new IWebView(n2);
        int[] nArray = new int[1];
        iWebView.canShowMIMEType(n3, nArray);
        IWebPolicyDecisionListener iWebPolicyDecisionListener = new IWebPolicyDecisionListener(n6);
        if (nArray[0] != 0) {
            iWebPolicyDecisionListener.use();
        } else {
            iWebPolicyDecisionListener.download();
        }
        return 0;
    }

    int decidePolicyForNavigationAction(int n2, int n3, int n4, int n5, int n6) {
        IWebURLRequest iWebURLRequest = new IWebURLRequest(n4);
        int[] nArray = new int[1];
        int n7 = iWebURLRequest.URL(nArray);
        if (n7 != 0 || nArray[0] == 0) {
            return 0;
        }
        String string = WebKit.extractBSTR(nArray[0]);
        COM.SysFreeString(nArray[0]);
        IWebPolicyDecisionListener iWebPolicyDecisionListener = new IWebPolicyDecisionListener(n6);
        WebKit webKit = (WebKit)this.browser.webBrowser;
        if (webKit.loadingText) {
            iWebPolicyDecisionListener.use();
            return 0;
        }
        if (string.length() == 0) {
            iWebPolicyDecisionListener.ignore();
            return 0;
        }
        if (string.startsWith("file://") && webKit.getUrl().startsWith("about:blank") && webKit.untrustedText) {
            iWebPolicyDecisionListener.ignore();
            return 0;
        }
        if (string.equals("file:///")) {
            string = "about:blank";
        } else {
            int n8 = "file:///".length();
            if (string.startsWith("file:///") && string.charAt(n8) == '#') {
                string = "about:blank" + string.substring(n8);
            }
        }
        LocationEvent locationEvent = new LocationEvent(this.browser);
        locationEvent.display = this.browser.getDisplay();
        locationEvent.widget = this.browser;
        locationEvent.location = string;
        locationEvent.doit = true;
        LocationListener[] locationListenerArray = webKit.locationListeners;
        if (locationListenerArray != null) {
            for (int i2 = 0; i2 < locationListenerArray.length; ++i2) {
                locationListenerArray[i2].changing(locationEvent);
            }
        }
        if (locationEvent.doit) {
            if (webKit.jsEnabled != webKit.jsEnabledOnNextPage) {
                webKit.jsEnabled = webKit.jsEnabledOnNextPage;
                IWebView iWebView = new IWebView(n2);
                nArray[0] = 0;
                n7 = iWebView.preferences(nArray);
                if (n7 == 0 && nArray[0] != 0) {
                    IWebPreferences iWebPreferences = new IWebPreferences(nArray[0]);
                    n7 = iWebPreferences.setJavaScriptEnabled(webKit.jsEnabled ? 1 : 0);
                    iWebView.setPreferences(iWebPreferences.getAddress());
                    iWebPreferences.Release();
                }
            }
            iWebPolicyDecisionListener.use();
            webKit.lastNavigateURL = string;
        } else {
            iWebPolicyDecisionListener.ignore();
        }
        return 0;
    }

    int decidePolicyForNewWindowAction(int n2, int n3, int n4, int n5, int n6) {
        IWebPolicyDecisionListener iWebPolicyDecisionListener = new IWebPolicyDecisionListener(n6);
        iWebPolicyDecisionListener.use();
        return 0;
    }

    protected void disposeCOMInterfaces() {
        if (this.iWebPolicyDelegate != null) {
            this.iWebPolicyDelegate.dispose();
            this.iWebPolicyDelegate = null;
        }
    }

    int getAddress() {
        return this.iWebPolicyDelegate.getAddress();
    }

    int QueryInterface(int n2, int n3) {
        if (n2 == 0 || n3 == 0) {
            return -2147024809;
        }
        GUID gUID = new GUID();
        COM.MoveMemory(gUID, n2, GUID.sizeof);
        if (COM.IsEqualGUID(gUID, COM.IIDIUnknown)) {
            COM.MoveMemory(n3, new int[]{this.iWebPolicyDelegate.getAddress()}, OS.PTR_SIZEOF);
            new IUnknown(this.iWebPolicyDelegate.getAddress()).AddRef();
            return 0;
        }
        if (COM.IsEqualGUID(gUID, WebKit_win32.IID_IWebPolicyDelegate)) {
            COM.MoveMemory(n3, new int[]{this.iWebPolicyDelegate.getAddress()}, OS.PTR_SIZEOF);
            new IUnknown(this.iWebPolicyDelegate.getAddress()).AddRef();
            return 0;
        }
        COM.MoveMemory(n3, new int[]{0}, OS.PTR_SIZEOF);
        return -2147467262;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    int unableToImplementPolicyWithError(int n2, int n3, int n4) {
        if (this.browser.isDisposed()) {
            return 0;
        }
        IWebError iWebError = new IWebError(n3);
        String string = null;
        int[] nArray = new int[1];
        int n5 = iWebError.failingURL(nArray);
        if (n5 == 0 && nArray[0] != 0) {
            string = WebKit.extractBSTR(nArray[0]);
            COM.SysFreeString(nArray[0]);
        }
        nArray[0] = 0;
        n5 = iWebError.localizedDescription(nArray);
        if (n5 != 0 || nArray[0] == 0) {
            return 0;
        }
        String string2 = WebKit.extractBSTR(nArray[0]);
        COM.SysFreeString(nArray[0]);
        String string3 = string != null ? string + "\n\n" : "";
        string3 = string3 + Compatibility.getMessage("SWT_Page_Load_Failed", new Object[]{string2});
        MessageBox messageBox = new MessageBox(this.browser.getShell(), 33);
        messageBox.setMessage(string3);
        messageBox.open();
        return 0;
    }
}

