/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.win32.HDITEM;
import org.eclipse.swt.internal.win32.LVCOLUMN;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TOOLINFO;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TypedListener;

public class TableColumn
extends Item {
    Table parent;
    boolean resizable = true;
    boolean moveable;
    String toolTipText;
    int id;

    public TableColumn(Table table, int n2) {
        super(table, TableColumn.checkStyle(n2));
        this.parent = table;
        table.createItem(this, table.getColumnCount());
    }

    public TableColumn(Table table, int n2, int n3) {
        super(table, TableColumn.checkStyle(n2));
        this.parent = table;
        table.createItem(this, n3);
    }

    public void addControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(controlListener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n2) {
        return TableColumn.checkBits(n2, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    @Override
    String getNameText() {
        return this.getText();
    }

    public Table getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getMoveable() {
        this.checkWidget();
        return this.moveable;
    }

    public boolean getResizable() {
        this.checkWidget();
        return this.resizable;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public int getWidth() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getWidthInPixels());
    }

    int getWidthInPixels() {
        int n2 = this.parent.indexOf(this);
        if (n2 == -1) {
            return 0;
        }
        int n3 = this.parent.handle;
        return OS.SendMessage(n3, 4125, n2, 0);
    }

    public void pack() {
        int n2;
        int n3;
        int n4;
        int n5;
        this.checkWidget();
        int n6 = this.parent.indexOf(this);
        if (n6 == -1) {
            return;
        }
        int n7 = this.parent.handle;
        int n8 = OS.SendMessage(n7, 4125, n6, 0);
        TCHAR tCHAR = new TCHAR(this.parent.getCodePage(), this.text, true);
        int n9 = OS.SendMessage(n7, OS.LVM_GETSTRINGWIDTH, 0, tCHAR) + 12;
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            n9 += 3;
        }
        boolean bl2 = false;
        if (this.image != null || this.parent.sortColumn == this) {
            bl2 = true;
            Image image = null;
            if (this.parent.sortColumn == this && this.parent.sortDirection != 0) {
                if (OS.COMCTL32_MAJOR < 6) {
                    image = this.display.getSortImage(this.parent.sortDirection);
                } else {
                    n9 += 10;
                }
            } else {
                image = this.image;
            }
            if (image != null) {
                Rectangle rectangle = image.getBoundsInPixels();
                n9 += rectangle.width;
            }
            n5 = 0;
            if (OS.COMCTL32_VERSION >= OS.VERSION(5, 80)) {
                n4 = OS.SendMessage(n7, 4127, 0, 0);
                n5 = OS.SendMessage(n4, 4629, 0, 0);
            } else {
                n5 = OS.GetSystemMetrics(45) * 3;
            }
            n9 += n5 * 4;
        }
        this.parent.ignoreColumnResize = true;
        int n10 = 0;
        if (this.parent.hooks(41)) {
            RECT rECT = new RECT();
            n4 = OS.SendMessage(n7, 4127, 0, 0);
            OS.SendMessage(n4, 4615, n6, rECT);
            OS.MapWindowPoints(n4, n7, rECT, 2);
            n3 = OS.GetDC(n7);
            int n11 = 0;
            n2 = OS.SendMessage(n7, 49, 0, 0);
            if (n2 != 0) {
                n11 = OS.SelectObject(n3, n2);
            }
            int n12 = OS.SendMessage(n7, 4100, 0, 0);
            for (int i2 = 0; i2 < n12; ++i2) {
                TableItem tableItem = this.parent._getItem(i2, false);
                if (tableItem == null) continue;
                int n13 = tableItem.fontHandle(n6);
                if (n13 != -1) {
                    n13 = OS.SelectObject(n3, n13);
                }
                Event event = this.parent.sendMeasureItemEvent(tableItem, i2, n6, n3);
                if (n13 != -1) {
                    n13 = OS.SelectObject(n3, n13);
                }
                if (this.isDisposed() || this.parent.isDisposed()) break;
                Rectangle rectangle = event.getBoundsInPixels();
                n10 = Math.max(n10, rectangle.x + rectangle.width - rECT.left);
            }
            if (n2 != 0) {
                OS.SelectObject(n3, n11);
            }
            OS.ReleaseDC(n7, n3);
            OS.SendMessage(n7, 4126, n6, n10);
        } else {
            OS.SendMessage(n7, 4126, n6, -1);
            n10 = OS.SendMessage(n7, 4125, n6, 0);
            if (n6 == 0) {
                int[] nArray;
                if (this.parent.imageList == null) {
                    n10 += 2;
                }
                if (!OS.IsWinCE && OS.WIN32_VERSION < OS.VERSION(6, 0) && !this.parent.firstColumnImage && (n5 = OS.SendMessage(n7, 4098, 1, 0)) != 0) {
                    int[] nArray2 = new int[1];
                    nArray = new int[1];
                    OS.ImageList_GetIconSize(n5, nArray2, nArray);
                    n10 += nArray2[0];
                }
                if ((this.parent.style & 0x20) != 0 && (n5 = OS.SendMessage(n7, 4098, 2, 0)) != 0) {
                    int[] nArray3 = new int[1];
                    nArray = new int[1];
                    OS.ImageList_GetIconSize(n5, nArray3, nArray);
                    n10 += nArray3[0];
                }
            }
        }
        if (n9 > n10) {
            if (!bl2) {
                boolean bl3;
                RECT rECT = null;
                boolean bl4 = bl3 = n6 == this.parent.getColumnCount() - 1;
                if (bl3) {
                    rECT = new RECT();
                    OS.GetWindowRect(n7, rECT);
                    OS.UpdateWindow(n7);
                    n3 = 30;
                    this.SetWindowPos(n7, 0, 0, 0, 0, rECT.bottom - rECT.top, n3);
                }
                OS.SendMessage(n7, 4126, n6, -2);
                if (bl3) {
                    n3 = 22;
                    this.SetWindowPos(n7, 0, 0, 0, rECT.right - rECT.left, rECT.bottom - rECT.top, n3);
                }
            } else {
                OS.SendMessage(n7, 4126, n6, n9);
            }
        } else if (n6 == 0) {
            OS.SendMessage(n7, 4126, n6, n10);
        }
        this.parent.ignoreColumnResize = false;
        int n14 = OS.SendMessage(n7, 4125, n6, 0);
        if (n8 != n14) {
            this.updateToolTip(n6);
            this.sendEvent(11);
            if (this.isDisposed()) {
                return;
            }
            boolean bl5 = false;
            int[] nArray = this.parent.getColumnOrder();
            TableColumn[] tableColumnArray = this.parent.getColumns();
            for (n2 = 0; n2 < nArray.length; ++n2) {
                TableColumn tableColumn = tableColumnArray[nArray[n2]];
                if (bl5 && !tableColumn.isDisposed()) {
                    tableColumn.updateToolTip(nArray[n2]);
                    tableColumn.sendEvent(10);
                }
                if (tableColumn != this) continue;
                bl5 = true;
            }
        }
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
    }

    @Override
    void releaseParent() {
        super.releaseParent();
        if (this.parent.sortColumn == this) {
            this.parent.sortColumn = null;
        }
    }

    public void removeControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, controlListener);
        this.eventTable.unhook(11, controlListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setAlignment(int n2) {
        this.checkWidget();
        if ((n2 & 0x1024000) == 0) {
            return;
        }
        int n3 = this.parent.indexOf(this);
        if (n3 == -1 || n3 == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= n2 & 0x1024000;
        int n4 = this.parent.handle;
        LVCOLUMN lVCOLUMN = new LVCOLUMN();
        lVCOLUMN.mask = 1;
        OS.SendMessage(n4, OS.LVM_GETCOLUMN, n3, lVCOLUMN);
        lVCOLUMN.fmt &= 0xFFFFFFFC;
        int n5 = 0;
        if ((this.style & 0x4000) == 16384) {
            n5 = 0;
        }
        if ((this.style & 0x1000000) == 0x1000000) {
            n5 = 2;
        }
        if ((this.style & 0x20000) == 131072) {
            n5 = 1;
        }
        lVCOLUMN.fmt |= n5;
        OS.SendMessage(n4, OS.LVM_SETCOLUMN, n3, lVCOLUMN);
        if (n3 != 0) {
            this.parent.forceResize();
            RECT rECT = new RECT();
            RECT rECT2 = new RECT();
            OS.GetClientRect(n4, rECT);
            int n6 = OS.SendMessage(n4, 4127, 0, 0);
            OS.SendMessage(n6, 4615, n3, rECT2);
            OS.MapWindowPoints(n6, n4, rECT2, 2);
            rECT.left = rECT2.left;
            rECT.right = rECT2.right;
            OS.InvalidateRect(n4, rECT, true);
        }
    }

    @Override
    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        super.setImage(image);
        if (this.parent.sortColumn != this || this.parent.sortDirection != 0) {
            this.setImage(image, false, false);
        }
    }

    void setImage(Image image, boolean bl2, boolean bl3) {
        int n2 = this.parent.indexOf(this);
        if (n2 == -1) {
            return;
        }
        int n3 = this.parent.handle;
        if (OS.COMCTL32_MAJOR < 6) {
            int n4 = OS.SendMessage(n3, 4127, 0, 0);
            HDITEM hDITEM = new HDITEM();
            hDITEM.mask = 52;
            OS.SendMessage(n4, OS.HDM_GETITEM, n2, hDITEM);
            hDITEM.fmt &= 0xFFFFEFFF;
            if (image != null) {
                if (bl2) {
                    hDITEM.mask &= 0xFFFFFFDF;
                    hDITEM.fmt &= 0xFFFFF7FF;
                    hDITEM.fmt |= 0x2000;
                    hDITEM.hbm = image.handle;
                } else {
                    hDITEM.mask &= 0xFFFFFFEF;
                    hDITEM.fmt &= 0xFFFFDFFF;
                    hDITEM.fmt |= 0x800;
                    hDITEM.iImage = this.parent.imageIndexHeader(image);
                }
                if (bl3) {
                    hDITEM.fmt |= 0x1000;
                }
            } else {
                hDITEM.fmt &= 0xFFFFD7FF;
            }
            OS.SendMessage(n4, OS.HDM_SETITEM, n2, hDITEM);
        } else {
            LVCOLUMN lVCOLUMN = new LVCOLUMN();
            lVCOLUMN.mask = 17;
            OS.SendMessage(n3, OS.LVM_GETCOLUMN, n2, lVCOLUMN);
            if (image != null) {
                lVCOLUMN.fmt |= 0x800;
                lVCOLUMN.iImage = this.parent.imageIndexHeader(image);
                if (bl3) {
                    lVCOLUMN.fmt |= 0x1000;
                }
            } else {
                lVCOLUMN.mask &= 0xFFFFFFEF;
                lVCOLUMN.fmt &= 0xFFFFE7FF;
            }
            OS.SendMessage(n3, OS.LVM_SETCOLUMN, n2, lVCOLUMN);
        }
    }

    public void setMoveable(boolean bl2) {
        this.checkWidget();
        this.moveable = bl2;
        this.parent.updateMoveable();
    }

    public void setResizable(boolean bl2) {
        this.checkWidget();
        this.resizable = bl2;
    }

    void setSortDirection(int n2) {
        if (OS.COMCTL32_MAJOR >= 6) {
            RECT rECT;
            int n3 = this.parent.indexOf(this);
            if (n3 == -1) {
                return;
            }
            int n4 = this.parent.handle;
            int n5 = OS.SendMessage(n4, 4127, 0, 0);
            HDITEM hDITEM = new HDITEM();
            hDITEM.mask = 36;
            OS.SendMessage(n5, OS.HDM_GETITEM, n3, hDITEM);
            switch (n2) {
                case 128: {
                    hDITEM.fmt &= 0xFFFFF5FF;
                    hDITEM.fmt |= 0x400;
                    if (this.image != null) break;
                    hDITEM.mask &= 0xFFFFFFDF;
                    break;
                }
                case 1024: {
                    hDITEM.fmt &= 0xFFFFF3FF;
                    hDITEM.fmt |= 0x200;
                    if (this.image != null) break;
                    hDITEM.mask &= 0xFFFFFFDF;
                    break;
                }
                case 0: {
                    hDITEM.fmt &= 0xFFFFF9FF;
                    if (this.image != null) {
                        hDITEM.fmt |= 0x800;
                        hDITEM.iImage = this.parent.imageIndexHeader(this.image);
                        break;
                    }
                    hDITEM.fmt &= 0xFFFFF7FF;
                    hDITEM.mask &= 0xFFFFFFDF;
                }
            }
            OS.SendMessage(n5, OS.HDM_SETITEM, n3, hDITEM);
            this.parent.forceResize();
            RECT rECT2 = new RECT();
            OS.GetClientRect(n4, rECT2);
            if (OS.SendMessage(n4, 4096, 0, 0) != -1) {
                int n6 = OS.SendMessage(n4, 4270, 0, 0);
                int n7 = n2 == 0 ? -1 : n3;
                OS.SendMessage(n4, 4236, n7, 0);
                RECT rECT3 = new RECT();
                if (n6 != -1 && OS.SendMessage(n5, 4615, n6, rECT3) != 0) {
                    OS.MapWindowPoints(n5, n4, rECT3, 2);
                    rECT2.left = rECT3.left;
                    rECT2.right = rECT3.right;
                    OS.InvalidateRect(n4, rECT2, true);
                }
            }
            if (OS.SendMessage(n5, 4615, n3, rECT = new RECT()) != 0) {
                OS.MapWindowPoints(n5, n4, rECT, 2);
                rECT2.left = rECT.left;
                rECT2.right = rECT.right;
                OS.InvalidateRect(n4, rECT2, true);
            }
        } else {
            switch (n2) {
                case 128: 
                case 1024: {
                    this.setImage(this.display.getSortImage(n2), true, true);
                    break;
                }
                case 0: {
                    this.setImage(this.image, false, false);
                }
            }
        }
    }

    @Override
    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(this.text)) {
            return;
        }
        int n2 = this.parent.indexOf(this);
        if (n2 == -1) {
            return;
        }
        super.setText(string);
        int n3 = this.parent.handle;
        LVCOLUMN lVCOLUMN = new LVCOLUMN();
        lVCOLUMN.mask = 1;
        OS.SendMessage(n3, OS.LVM_GETCOLUMN, n2, lVCOLUMN);
        boolean bl2 = !OS.IsWinCE && OS.WIN32_VERSION <= OS.VERSION(4, 10);
        int n4 = OS.GetProcessHeap();
        TCHAR tCHAR = new TCHAR(this.parent.getCodePage(), this.fixMnemonic(string, bl2), true);
        int n5 = tCHAR.length() * TCHAR.sizeof;
        int n6 = OS.HeapAlloc(n4, 8, n5);
        OS.MoveMemory(n6, tCHAR, n5);
        lVCOLUMN.mask |= 4;
        lVCOLUMN.pszText = n6;
        int n7 = OS.SendMessage(n3, OS.LVM_SETCOLUMN, n2, lVCOLUMN);
        if (n6 != 0) {
            OS.HeapFree(n4, 0, n6);
        }
        if (n7 == 0) {
            this.error(13);
        }
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
        int n2 = this.parent.headerToolTipHandle;
        if (n2 == 0) {
            this.parent.createHeaderToolTips();
            this.parent.updateHeaderToolTips();
        }
    }

    public void setWidth(int n2) {
        this.checkWidget();
        this.setWidthInPixels(DPIUtil.autoScaleUp(n2));
    }

    void setWidthInPixels(int n2) {
        if (n2 < 0) {
            return;
        }
        int n3 = this.parent.indexOf(this);
        if (n3 == -1) {
            return;
        }
        int n4 = this.parent.handle;
        if (n2 != OS.SendMessage(n4, 4125, n3, 0)) {
            OS.SendMessage(n4, 4126, n3, n2);
        }
    }

    void updateToolTip(int n2) {
        RECT rECT;
        int n3;
        int n4;
        int n5 = this.parent.headerToolTipHandle;
        if (n5 != 0 && OS.SendMessage(n4 = OS.SendMessage(n3 = this.parent.handle, 4127, 0, 0), 4615, n2, rECT = new RECT()) != 0) {
            TOOLINFO tOOLINFO = new TOOLINFO();
            tOOLINFO.cbSize = TOOLINFO.sizeof;
            tOOLINFO.hwnd = n4;
            tOOLINFO.uId = this.id;
            tOOLINFO.left = rECT.left;
            tOOLINFO.top = rECT.top;
            tOOLINFO.right = rECT.right;
            tOOLINFO.bottom = rECT.bottom;
            OS.SendMessage(n5, OS.TTM_NEWTOOLRECT, 0, tOOLINFO);
        }
    }
}

