/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.libffi;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.libffi.FFICIF;
import org.lwjgl.system.libffi.FFIClosure$Buffer;

public class FFIClosure
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CIF;
    public static final int FUN;
    public static final int USER_DATA;

    private static native int offsets(long var0);

    protected FFIClosure(long l2, ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected FFIClosure create(long l2, ByteBuffer byteBuffer) {
        return new FFIClosure(l2, byteBuffer);
    }

    public FFIClosure(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), FFIClosure.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public FFICIF cif() {
        return FFIClosure.ncif(this.address());
    }

    public long fun() {
        return FFIClosure.nfun(this.address());
    }

    public long user_data() {
        return FFIClosure.nuser_data(this.address());
    }

    public static FFIClosure malloc() {
        return new FFIClosure(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static FFIClosure calloc() {
        return new FFIClosure(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static FFIClosure create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new FFIClosure(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static FFIClosure create(long l2) {
        return new FFIClosure(l2, null);
    }

    public static FFIClosure createSafe(long l2) {
        return l2 == 0L ? null : new FFIClosure(l2, null);
    }

    public static FFIClosure$Buffer malloc(int n2) {
        return new FFIClosure$Buffer(MemoryUtil.nmemAllocChecked(FFIClosure.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static FFIClosure$Buffer calloc(int n2) {
        return new FFIClosure$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static FFIClosure$Buffer create(int n2) {
        ByteBuffer byteBuffer = FFIClosure.__create(n2, SIZEOF);
        return new FFIClosure$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n2, n2);
    }

    public static FFIClosure$Buffer create(long l2, int n2) {
        return new FFIClosure$Buffer(l2, n2);
    }

    public static FFIClosure$Buffer createSafe(long l2, int n2) {
        return l2 == 0L ? null : new FFIClosure$Buffer(l2, n2);
    }

    public static FFIClosure malloc(MemoryStack memoryStack) {
        return new FFIClosure(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static FFIClosure calloc(MemoryStack memoryStack) {
        return new FFIClosure(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static FFIClosure$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new FFIClosure$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static FFIClosure$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new FFIClosure$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static FFICIF ncif(long l2) {
        return FFICIF.create(MemoryUtil.memGetAddress(l2 + (long)CIF));
    }

    public static long nfun(long l2) {
        return MemoryUtil.memGetAddress(l2 + (long)FUN);
    }

    public static long nuser_data(long l2) {
        return MemoryUtil.memGetAddress(l2 + (long)USER_DATA);
    }

    static {
        try (MemoryStack memoryStack = MemoryStack.stackPush();){
            IntBuffer intBuffer = memoryStack.mallocInt(4);
            SIZEOF = FFIClosure.offsets(MemoryUtil.memAddress(intBuffer));
            CIF = intBuffer.get(0);
            FUN = intBuffer.get(1);
            USER_DATA = intBuffer.get(2);
            ALIGNOF = intBuffer.get(3);
        }
    }
}

