/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.linux.XExposeEvent$Buffer;

public class XExposeEvent
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int SERIAL;
    public static final int SEND_EVENT;
    public static final int DISPLAY;
    public static final int WINDOW;
    public static final int X;
    public static final int Y;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int COUNT;

    protected XExposeEvent(long l2, ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected XExposeEvent create(long l2, ByteBuffer byteBuffer) {
        return new XExposeEvent(l2, byteBuffer);
    }

    public XExposeEvent(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), XExposeEvent.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int type() {
        return XExposeEvent.ntype(this.address());
    }

    public long serial() {
        return XExposeEvent.nserial(this.address());
    }

    public boolean send_event() {
        return XExposeEvent.nsend_event(this.address()) != 0;
    }

    public long display() {
        return XExposeEvent.ndisplay(this.address());
    }

    public long window() {
        return XExposeEvent.nwindow(this.address());
    }

    public int x() {
        return XExposeEvent.nx(this.address());
    }

    public int y() {
        return XExposeEvent.ny(this.address());
    }

    public int width() {
        return XExposeEvent.nwidth(this.address());
    }

    public int height() {
        return XExposeEvent.nheight(this.address());
    }

    public int count() {
        return XExposeEvent.ncount(this.address());
    }

    public XExposeEvent type(int n2) {
        XExposeEvent.ntype(this.address(), n2);
        return this;
    }

    public XExposeEvent serial(long l2) {
        XExposeEvent.nserial(this.address(), l2);
        return this;
    }

    public XExposeEvent send_event(boolean bl2) {
        XExposeEvent.nsend_event(this.address(), bl2 ? 1 : 0);
        return this;
    }

    public XExposeEvent display(long l2) {
        XExposeEvent.ndisplay(this.address(), l2);
        return this;
    }

    public XExposeEvent window(long l2) {
        XExposeEvent.nwindow(this.address(), l2);
        return this;
    }

    public XExposeEvent x(int n2) {
        XExposeEvent.nx(this.address(), n2);
        return this;
    }

    public XExposeEvent y(int n2) {
        XExposeEvent.ny(this.address(), n2);
        return this;
    }

    public XExposeEvent width(int n2) {
        XExposeEvent.nwidth(this.address(), n2);
        return this;
    }

    public XExposeEvent height(int n2) {
        XExposeEvent.nheight(this.address(), n2);
        return this;
    }

    public XExposeEvent count(int n2) {
        XExposeEvent.ncount(this.address(), n2);
        return this;
    }

    public XExposeEvent set(int n2, long l2, boolean bl2, long l3, long l4, int n3, int n4, int n5, int n6, int n7) {
        this.type(n2);
        this.serial(l2);
        this.send_event(bl2);
        this.display(l3);
        this.window(l4);
        this.x(n3);
        this.y(n4);
        this.width(n5);
        this.height(n6);
        this.count(n7);
        return this;
    }

    public XExposeEvent set(XExposeEvent xExposeEvent) {
        MemoryUtil.memCopy(xExposeEvent.address(), this.address(), SIZEOF);
        return this;
    }

    public static XExposeEvent malloc() {
        return new XExposeEvent(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XExposeEvent calloc() {
        return new XExposeEvent(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XExposeEvent create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new XExposeEvent(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static XExposeEvent create(long l2) {
        return new XExposeEvent(l2, null);
    }

    public static XExposeEvent createSafe(long l2) {
        return l2 == 0L ? null : new XExposeEvent(l2, null);
    }

    public static XExposeEvent$Buffer malloc(int n2) {
        return new XExposeEvent$Buffer(MemoryUtil.nmemAllocChecked(XExposeEvent.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static XExposeEvent$Buffer calloc(int n2) {
        return new XExposeEvent$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static XExposeEvent$Buffer create(int n2) {
        ByteBuffer byteBuffer = XExposeEvent.__create(n2, SIZEOF);
        return new XExposeEvent$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n2, n2);
    }

    public static XExposeEvent$Buffer create(long l2, int n2) {
        return new XExposeEvent$Buffer(l2, n2);
    }

    public static XExposeEvent$Buffer createSafe(long l2, int n2) {
        return l2 == 0L ? null : new XExposeEvent$Buffer(l2, n2);
    }

    public static XExposeEvent mallocStack() {
        return XExposeEvent.malloc(MemoryStack.stackGet());
    }

    public static XExposeEvent callocStack() {
        return XExposeEvent.calloc(MemoryStack.stackGet());
    }

    public static XExposeEvent mallocStack(MemoryStack memoryStack) {
        return XExposeEvent.malloc(memoryStack);
    }

    public static XExposeEvent callocStack(MemoryStack memoryStack) {
        return XExposeEvent.calloc(memoryStack);
    }

    public static XExposeEvent$Buffer mallocStack(int n2) {
        return XExposeEvent.malloc(n2, MemoryStack.stackGet());
    }

    public static XExposeEvent$Buffer callocStack(int n2) {
        return XExposeEvent.calloc(n2, MemoryStack.stackGet());
    }

    public static XExposeEvent$Buffer mallocStack(int n2, MemoryStack memoryStack) {
        return XExposeEvent.malloc(n2, memoryStack);
    }

    public static XExposeEvent$Buffer callocStack(int n2, MemoryStack memoryStack) {
        return XExposeEvent.calloc(n2, memoryStack);
    }

    public static XExposeEvent malloc(MemoryStack memoryStack) {
        return new XExposeEvent(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XExposeEvent calloc(MemoryStack memoryStack) {
        return new XExposeEvent(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static XExposeEvent$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new XExposeEvent$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static XExposeEvent$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new XExposeEvent$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static int ntype(long l2) {
        return UNSAFE.getInt(null, l2 + (long)TYPE);
    }

    public static long nserial(long l2) {
        return MemoryUtil.memGetCLong(l2 + (long)SERIAL);
    }

    public static int nsend_event(long l2) {
        return UNSAFE.getInt(null, l2 + (long)SEND_EVENT);
    }

    public static long ndisplay(long l2) {
        return MemoryUtil.memGetAddress(l2 + (long)DISPLAY);
    }

    public static long nwindow(long l2) {
        return MemoryUtil.memGetCLong(l2 + (long)WINDOW);
    }

    public static int nx(long l2) {
        return UNSAFE.getInt(null, l2 + (long)X);
    }

    public static int ny(long l2) {
        return UNSAFE.getInt(null, l2 + (long)Y);
    }

    public static int nwidth(long l2) {
        return UNSAFE.getInt(null, l2 + (long)WIDTH);
    }

    public static int nheight(long l2) {
        return UNSAFE.getInt(null, l2 + (long)HEIGHT);
    }

    public static int ncount(long l2) {
        return UNSAFE.getInt(null, l2 + (long)COUNT);
    }

    public static void ntype(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)TYPE, n2);
    }

    public static void nserial(long l2, long l3) {
        MemoryUtil.memPutCLong(l2 + (long)SERIAL, l3);
    }

    public static void nsend_event(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)SEND_EVENT, n2);
    }

    public static void ndisplay(long l2, long l3) {
        MemoryUtil.memPutAddress(l2 + (long)DISPLAY, Checks.check(l3));
    }

    public static void nwindow(long l2, long l3) {
        MemoryUtil.memPutCLong(l2 + (long)WINDOW, l3);
    }

    public static void nx(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)X, n2);
    }

    public static void ny(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)Y, n2);
    }

    public static void nwidth(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)WIDTH, n2);
    }

    public static void nheight(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)HEIGHT, n2);
    }

    public static void ncount(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)COUNT, n2);
    }

    public static void validate(long l2) {
        Checks.check(MemoryUtil.memGetAddress(l2 + (long)DISPLAY));
    }

    static {
        Struct$Layout struct$Layout = XExposeEvent.__struct(XExposeEvent.__member(4), XExposeEvent.__member(CLONG_SIZE), XExposeEvent.__member(4), XExposeEvent.__member(POINTER_SIZE), XExposeEvent.__member(CLONG_SIZE), XExposeEvent.__member(4), XExposeEvent.__member(4), XExposeEvent.__member(4), XExposeEvent.__member(4), XExposeEvent.__member(4));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        TYPE = struct$Layout.offsetof(0);
        SERIAL = struct$Layout.offsetof(1);
        SEND_EVENT = struct$Layout.offsetof(2);
        DISPLAY = struct$Layout.offsetof(3);
        WINDOW = struct$Layout.offsetof(4);
        X = struct$Layout.offsetof(5);
        Y = struct$Layout.offsetof(6);
        WIDTH = struct$Layout.offsetof(7);
        HEIGHT = struct$Layout.offsetof(8);
        COUNT = struct$Layout.offsetof(9);
    }
}

