/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux.liburing;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.linux.liburing.IOURingProbeOp$Buffer;

public class IOURingProbeOp
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int OP;
    public static final int RESV;
    public static final int FLAGS;
    public static final int RESV2;

    protected IOURingProbeOp(long l2, ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected IOURingProbeOp create(long l2, ByteBuffer byteBuffer) {
        return new IOURingProbeOp(l2, byteBuffer);
    }

    public IOURingProbeOp(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), IOURingProbeOp.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public byte op() {
        return IOURingProbeOp.nop(this.address());
    }

    public byte resv() {
        return IOURingProbeOp.nresv(this.address());
    }

    public short flags() {
        return IOURingProbeOp.nflags(this.address());
    }

    public int resv2() {
        return IOURingProbeOp.nresv2(this.address());
    }

    public IOURingProbeOp op(byte by2) {
        IOURingProbeOp.nop(this.address(), by2);
        return this;
    }

    public IOURingProbeOp resv(byte by2) {
        IOURingProbeOp.nresv(this.address(), by2);
        return this;
    }

    public IOURingProbeOp flags(short s2) {
        IOURingProbeOp.nflags(this.address(), s2);
        return this;
    }

    public IOURingProbeOp resv2(int n2) {
        IOURingProbeOp.nresv2(this.address(), n2);
        return this;
    }

    public IOURingProbeOp set(byte by2, byte by3, short s2, int n2) {
        this.op(by2);
        this.resv(by3);
        this.flags(s2);
        this.resv2(n2);
        return this;
    }

    public IOURingProbeOp set(IOURingProbeOp iOURingProbeOp) {
        MemoryUtil.memCopy(iOURingProbeOp.address(), this.address(), SIZEOF);
        return this;
    }

    public static IOURingProbeOp malloc() {
        return new IOURingProbeOp(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static IOURingProbeOp calloc() {
        return new IOURingProbeOp(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static IOURingProbeOp create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new IOURingProbeOp(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static IOURingProbeOp create(long l2) {
        return new IOURingProbeOp(l2, null);
    }

    public static IOURingProbeOp createSafe(long l2) {
        return l2 == 0L ? null : new IOURingProbeOp(l2, null);
    }

    public static IOURingProbeOp$Buffer malloc(int n2) {
        return new IOURingProbeOp$Buffer(MemoryUtil.nmemAllocChecked(IOURingProbeOp.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static IOURingProbeOp$Buffer calloc(int n2) {
        return new IOURingProbeOp$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static IOURingProbeOp$Buffer create(int n2) {
        ByteBuffer byteBuffer = IOURingProbeOp.__create(n2, SIZEOF);
        return new IOURingProbeOp$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n2, n2);
    }

    public static IOURingProbeOp$Buffer create(long l2, int n2) {
        return new IOURingProbeOp$Buffer(l2, n2);
    }

    public static IOURingProbeOp$Buffer createSafe(long l2, int n2) {
        return l2 == 0L ? null : new IOURingProbeOp$Buffer(l2, n2);
    }

    public static IOURingProbeOp malloc(MemoryStack memoryStack) {
        return new IOURingProbeOp(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static IOURingProbeOp calloc(MemoryStack memoryStack) {
        return new IOURingProbeOp(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static IOURingProbeOp$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new IOURingProbeOp$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static IOURingProbeOp$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new IOURingProbeOp$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static byte nop(long l2) {
        return UNSAFE.getByte(null, l2 + (long)OP);
    }

    public static byte nresv(long l2) {
        return UNSAFE.getByte(null, l2 + (long)RESV);
    }

    public static short nflags(long l2) {
        return UNSAFE.getShort(null, l2 + (long)FLAGS);
    }

    public static int nresv2(long l2) {
        return UNSAFE.getInt(null, l2 + (long)RESV2);
    }

    public static void nop(long l2, byte by2) {
        UNSAFE.putByte(null, l2 + (long)OP, by2);
    }

    public static void nresv(long l2, byte by2) {
        UNSAFE.putByte(null, l2 + (long)RESV, by2);
    }

    public static void nflags(long l2, short s2) {
        UNSAFE.putShort(null, l2 + (long)FLAGS, s2);
    }

    public static void nresv2(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)RESV2, n2);
    }

    static {
        Struct$Layout struct$Layout = IOURingProbeOp.__struct(IOURingProbeOp.__member(1), IOURingProbeOp.__member(1), IOURingProbeOp.__member(2), IOURingProbeOp.__member(4));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        OP = struct$Layout.offsetof(0);
        RESV = struct$Layout.offsetof(1);
        FLAGS = struct$Layout.offsetof(2);
        RESV2 = struct$Layout.offsetof(3);
    }
}

