/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux.liburing;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.util.function.Consumer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.linux.KernelTimespec;
import org.lwjgl.system.linux.liburing.IOURingSyncCancelReg$Buffer;

public class IOURingSyncCancelReg
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ADDR;
    public static final int FD;
    public static final int FLAGS;
    public static final int TIMEOUT;
    public static final int PAD;

    protected IOURingSyncCancelReg(long l2, ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected IOURingSyncCancelReg create(long l2, ByteBuffer byteBuffer) {
        return new IOURingSyncCancelReg(l2, byteBuffer);
    }

    public IOURingSyncCancelReg(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), IOURingSyncCancelReg.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public long addr() {
        return IOURingSyncCancelReg.naddr(this.address());
    }

    public int fd() {
        return IOURingSyncCancelReg.nfd(this.address());
    }

    public int flags() {
        return IOURingSyncCancelReg.nflags(this.address());
    }

    public KernelTimespec timeout() {
        return IOURingSyncCancelReg.ntimeout(this.address());
    }

    public IOURingSyncCancelReg addr(long l2) {
        IOURingSyncCancelReg.naddr(this.address(), l2);
        return this;
    }

    public IOURingSyncCancelReg fd(int n2) {
        IOURingSyncCancelReg.nfd(this.address(), n2);
        return this;
    }

    public IOURingSyncCancelReg flags(int n2) {
        IOURingSyncCancelReg.nflags(this.address(), n2);
        return this;
    }

    public IOURingSyncCancelReg timeout(KernelTimespec kernelTimespec) {
        IOURingSyncCancelReg.ntimeout(this.address(), kernelTimespec);
        return this;
    }

    public IOURingSyncCancelReg timeout(Consumer consumer) {
        consumer.accept(this.timeout());
        return this;
    }

    public IOURingSyncCancelReg set(long l2, int n2, int n3, KernelTimespec kernelTimespec) {
        this.addr(l2);
        this.fd(n2);
        this.flags(n3);
        this.timeout(kernelTimespec);
        return this;
    }

    public IOURingSyncCancelReg set(IOURingSyncCancelReg iOURingSyncCancelReg) {
        MemoryUtil.memCopy(iOURingSyncCancelReg.address(), this.address(), SIZEOF);
        return this;
    }

    public static IOURingSyncCancelReg malloc() {
        return new IOURingSyncCancelReg(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static IOURingSyncCancelReg calloc() {
        return new IOURingSyncCancelReg(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static IOURingSyncCancelReg create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new IOURingSyncCancelReg(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static IOURingSyncCancelReg create(long l2) {
        return new IOURingSyncCancelReg(l2, null);
    }

    public static IOURingSyncCancelReg createSafe(long l2) {
        return l2 == 0L ? null : new IOURingSyncCancelReg(l2, null);
    }

    public static IOURingSyncCancelReg$Buffer malloc(int n2) {
        return new IOURingSyncCancelReg$Buffer(MemoryUtil.nmemAllocChecked(IOURingSyncCancelReg.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static IOURingSyncCancelReg$Buffer calloc(int n2) {
        return new IOURingSyncCancelReg$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static IOURingSyncCancelReg$Buffer create(int n2) {
        ByteBuffer byteBuffer = IOURingSyncCancelReg.__create(n2, SIZEOF);
        return new IOURingSyncCancelReg$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n2, n2);
    }

    public static IOURingSyncCancelReg$Buffer create(long l2, int n2) {
        return new IOURingSyncCancelReg$Buffer(l2, n2);
    }

    public static IOURingSyncCancelReg$Buffer createSafe(long l2, int n2) {
        return l2 == 0L ? null : new IOURingSyncCancelReg$Buffer(l2, n2);
    }

    public static IOURingSyncCancelReg malloc(MemoryStack memoryStack) {
        return new IOURingSyncCancelReg(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static IOURingSyncCancelReg calloc(MemoryStack memoryStack) {
        return new IOURingSyncCancelReg(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static IOURingSyncCancelReg$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new IOURingSyncCancelReg$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static IOURingSyncCancelReg$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new IOURingSyncCancelReg$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static long naddr(long l2) {
        return UNSAFE.getLong(null, l2 + (long)ADDR);
    }

    public static int nfd(long l2) {
        return UNSAFE.getInt(null, l2 + (long)FD);
    }

    public static int nflags(long l2) {
        return UNSAFE.getInt(null, l2 + (long)FLAGS);
    }

    public static KernelTimespec ntimeout(long l2) {
        return KernelTimespec.create(l2 + (long)TIMEOUT);
    }

    public static LongBuffer npad(long l2) {
        return MemoryUtil.memLongBuffer(l2 + (long)PAD, 4);
    }

    public static long npad(long l2, int n2) {
        return UNSAFE.getLong(null, l2 + (long)PAD + Checks.check(n2, 4) * 8L);
    }

    public static void naddr(long l2, long l3) {
        UNSAFE.putLong(null, l2 + (long)ADDR, l3);
    }

    public static void nfd(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)FD, n2);
    }

    public static void nflags(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)FLAGS, n2);
    }

    public static void ntimeout(long l2, KernelTimespec kernelTimespec) {
        MemoryUtil.memCopy(kernelTimespec.address(), l2 + (long)TIMEOUT, KernelTimespec.SIZEOF);
    }

    public static void npad(long l2, LongBuffer longBuffer) {
        if (Checks.CHECKS) {
            Checks.checkGT(longBuffer, 4);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(longBuffer), l2 + (long)PAD, longBuffer.remaining() * 8);
    }

    public static void npad(long l2, int n2, long l3) {
        UNSAFE.putLong(null, l2 + (long)PAD + Checks.check(n2, 4) * 8L, l3);
    }

    static {
        Struct$Layout struct$Layout = IOURingSyncCancelReg.__struct(IOURingSyncCancelReg.__member(8), IOURingSyncCancelReg.__member(4), IOURingSyncCancelReg.__member(4), IOURingSyncCancelReg.__member(KernelTimespec.SIZEOF, KernelTimespec.ALIGNOF), IOURingSyncCancelReg.__array(8, 4));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        ADDR = struct$Layout.offsetof(0);
        FD = struct$Layout.offsetof(1);
        FLAGS = struct$Layout.offsetof(2);
        TIMEOUT = struct$Layout.offsetof(3);
        PAD = struct$Layout.offsetof(4);
    }
}

