/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux.liburing;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.linux.CMsghdr;
import org.lwjgl.system.linux.EpollEvent;
import org.lwjgl.system.linux.IOVec$Buffer;
import org.lwjgl.system.linux.KernelTimespec;
import org.lwjgl.system.linux.Msghdr;
import org.lwjgl.system.linux.OpenHow;
import org.lwjgl.system.linux.Sockaddr;
import org.lwjgl.system.linux.Statx;
import org.lwjgl.system.linux.liburing.IOURing;
import org.lwjgl.system.linux.liburing.IOURingBuf;
import org.lwjgl.system.linux.liburing.IOURingBufReg;
import org.lwjgl.system.linux.liburing.IOURingBufRing;
import org.lwjgl.system.linux.liburing.IOURingCQE;
import org.lwjgl.system.linux.liburing.IOURingParams;
import org.lwjgl.system.linux.liburing.IOURingProbe;
import org.lwjgl.system.linux.liburing.IOURingRecvmsgOut;
import org.lwjgl.system.linux.liburing.IOURingRestriction$Buffer;
import org.lwjgl.system.linux.liburing.IOURingSQE;
import org.lwjgl.system.linux.liburing.IOURingSyncCancelReg;

public class LibURing {
    public static final long LIBURING_UDATA_TIMEOUT = -1L;

    protected LibURing() {
        throw new UnsupportedOperationException();
    }

    public static native long nio_uring_get_probe_ring(long var0);

    public static IOURingProbe io_uring_get_probe_ring(IOURing iOURing) {
        long l2 = LibURing.nio_uring_get_probe_ring(iOURing.address());
        return IOURingProbe.createSafe(l2);
    }

    public static native long nio_uring_get_probe();

    public static IOURingProbe io_uring_get_probe() {
        long l2 = LibURing.nio_uring_get_probe();
        return IOURingProbe.createSafe(l2);
    }

    public static native void nio_uring_free_probe(long var0);

    public static void io_uring_free_probe(IOURingProbe iOURingProbe) {
        LibURing.nio_uring_free_probe(iOURingProbe.address());
    }

    public static native int nio_uring_opcode_supported(long var0, int var2);

    public static int io_uring_opcode_supported(IOURingProbe iOURingProbe, int n2) {
        return LibURing.nio_uring_opcode_supported(iOURingProbe.address(), n2);
    }

    public static native int nio_uring_queue_init_params(int var0, long var1, long var3);

    public static int io_uring_queue_init_params(int n2, IOURing iOURing, IOURingParams iOURingParams) {
        return LibURing.nio_uring_queue_init_params(n2, iOURing.address(), iOURingParams.address());
    }

    public static native int nio_uring_queue_init(int var0, long var1, int var3);

    public static int io_uring_queue_init(int n2, IOURing iOURing, int n3) {
        return LibURing.nio_uring_queue_init(n2, iOURing.address(), n3);
    }

    public static native int nio_uring_queue_mmap(int var0, long var1, long var3);

    public static int io_uring_queue_mmap(int n2, IOURingParams iOURingParams, IOURing iOURing) {
        return LibURing.nio_uring_queue_mmap(n2, iOURingParams.address(), iOURing.address());
    }

    public static native int nio_uring_ring_dontfork(long var0);

    public static int io_uring_ring_dontfork(IOURing iOURing) {
        return LibURing.nio_uring_ring_dontfork(iOURing.address());
    }

    public static native void nio_uring_queue_exit(long var0);

    public static void io_uring_queue_exit(IOURing iOURing) {
        LibURing.nio_uring_queue_exit(iOURing.address());
    }

    public static native int nio_uring_peek_batch_cqe(long var0, long var2, int var4);

    public static int io_uring_peek_batch_cqe(IOURing iOURing, PointerBuffer pointerBuffer) {
        return LibURing.nio_uring_peek_batch_cqe(iOURing.address(), MemoryUtil.memAddress(pointerBuffer), pointerBuffer.remaining());
    }

    public static native int nio_uring_wait_cqes(long var0, long var2, int var4, long var5, long var7);

    public static int io_uring_wait_cqes(IOURing iOURing, PointerBuffer pointerBuffer, KernelTimespec kernelTimespec, long l2) {
        return LibURing.nio_uring_wait_cqes(iOURing.address(), MemoryUtil.memAddress(pointerBuffer), pointerBuffer.remaining(), MemoryUtil.memAddressSafe(kernelTimespec), l2);
    }

    public static native int nio_uring_wait_cqe_timeout(long var0, long var2, long var4);

    public static int io_uring_wait_cqe_timeout(IOURing iOURing, PointerBuffer pointerBuffer, KernelTimespec kernelTimespec) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pointerBuffer, 1);
        }
        return LibURing.nio_uring_wait_cqe_timeout(iOURing.address(), MemoryUtil.memAddress(pointerBuffer), MemoryUtil.memAddressSafe(kernelTimespec));
    }

    public static native int nio_uring_submit(long var0);

    public static int io_uring_submit(IOURing iOURing) {
        return LibURing.nio_uring_submit(iOURing.address());
    }

    public static native int nio_uring_submit_and_wait(long var0, int var2);

    public static int io_uring_submit_and_wait(IOURing iOURing, int n2) {
        return LibURing.nio_uring_submit_and_wait(iOURing.address(), n2);
    }

    public static native int nio_uring_submit_and_wait_timeout(long var0, long var2, int var4, long var5, long var7);

    public static int io_uring_submit_and_wait_timeout(IOURing iOURing, PointerBuffer pointerBuffer, KernelTimespec kernelTimespec, long l2) {
        return LibURing.nio_uring_submit_and_wait_timeout(iOURing.address(), MemoryUtil.memAddress(pointerBuffer), pointerBuffer.remaining(), MemoryUtil.memAddressSafe(kernelTimespec), l2);
    }

    public static native int nio_uring_register_buffers(long var0, long var2, int var4);

    public static int io_uring_register_buffers(IOURing iOURing, IOVec$Buffer iOVec$Buffer) {
        return LibURing.nio_uring_register_buffers(iOURing.address(), iOVec$Buffer.address(), iOVec$Buffer.remaining());
    }

    public static native int nio_uring_register_buffers_tags(long var0, long var2, long var4, int var6);

    public static int io_uring_register_buffers_tags(IOURing iOURing, IOVec$Buffer iOVec$Buffer, LongBuffer longBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)longBuffer, iOVec$Buffer.remaining());
        }
        return LibURing.nio_uring_register_buffers_tags(iOURing.address(), iOVec$Buffer.address(), MemoryUtil.memAddress(longBuffer), iOVec$Buffer.remaining());
    }

    public static native int nio_uring_register_buffers_sparse(long var0, int var2);

    public static int io_uring_register_buffers_sparse(IOURing iOURing, int n2) {
        return LibURing.nio_uring_register_buffers_sparse(iOURing.address(), n2);
    }

    public static native int nio_uring_register_buffers_update_tag(long var0, int var2, long var3, long var5, int var7);

    public static int io_uring_register_buffers_update_tag(IOURing iOURing, int n2, IOVec$Buffer iOVec$Buffer, LongBuffer longBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)longBuffer, iOVec$Buffer.remaining());
        }
        return LibURing.nio_uring_register_buffers_update_tag(iOURing.address(), n2, iOVec$Buffer.address(), MemoryUtil.memAddress(longBuffer), iOVec$Buffer.remaining());
    }

    public static native int nio_uring_unregister_buffers(long var0);

    public static int io_uring_unregister_buffers(IOURing iOURing) {
        return LibURing.nio_uring_unregister_buffers(iOURing.address());
    }

    public static native int nio_uring_register_files(long var0, long var2, int var4);

    public static int io_uring_register_files(IOURing iOURing, IntBuffer intBuffer) {
        return LibURing.nio_uring_register_files(iOURing.address(), MemoryUtil.memAddress(intBuffer), intBuffer.remaining());
    }

    public static native int nio_uring_register_files_tags(long var0, long var2, long var4, int var6);

    public static int io_uring_register_files_tags(IOURing iOURing, IntBuffer intBuffer, LongBuffer longBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)longBuffer, intBuffer.remaining());
        }
        return LibURing.nio_uring_register_files_tags(iOURing.address(), MemoryUtil.memAddress(intBuffer), MemoryUtil.memAddress(longBuffer), intBuffer.remaining());
    }

    public static native int nio_uring_register_files_sparse(long var0, int var2);

    public static int io_uring_register_files_sparse(IOURing iOURing, int n2) {
        return LibURing.nio_uring_register_files_sparse(iOURing.address(), n2);
    }

    public static native int nio_uring_register_files_update_tag(long var0, int var2, long var3, long var5, int var7);

    public static int io_uring_register_files_update_tag(IOURing iOURing, int n2, IntBuffer intBuffer, LongBuffer longBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)longBuffer, intBuffer.remaining());
        }
        return LibURing.nio_uring_register_files_update_tag(iOURing.address(), n2, MemoryUtil.memAddress(intBuffer), MemoryUtil.memAddress(longBuffer), intBuffer.remaining());
    }

    public static native int nio_uring_unregister_files(long var0);

    public static int io_uring_unregister_files(IOURing iOURing) {
        return LibURing.nio_uring_unregister_files(iOURing.address());
    }

    public static native int nio_uring_register_files_update(long var0, int var2, long var3, int var5);

    public static int io_uring_register_files_update(IOURing iOURing, int n2, IntBuffer intBuffer) {
        return LibURing.nio_uring_register_files_update(iOURing.address(), n2, MemoryUtil.memAddress(intBuffer), intBuffer.remaining());
    }

    public static native int nio_uring_register_eventfd(long var0, int var2);

    public static int io_uring_register_eventfd(IOURing iOURing, int n2) {
        return LibURing.nio_uring_register_eventfd(iOURing.address(), n2);
    }

    public static native int nio_uring_register_eventfd_async(long var0, int var2);

    public static int io_uring_register_eventfd_async(IOURing iOURing, int n2) {
        return LibURing.nio_uring_register_eventfd_async(iOURing.address(), n2);
    }

    public static native int nio_uring_unregister_eventfd(long var0);

    public static int io_uring_unregister_eventfd(IOURing iOURing) {
        return LibURing.nio_uring_unregister_eventfd(iOURing.address());
    }

    public static native int nio_uring_register_probe(long var0, long var2, int var4);

    public static int io_uring_register_probe(IOURing iOURing, IOURingProbe iOURingProbe, int n2) {
        return LibURing.nio_uring_register_probe(iOURing.address(), iOURingProbe.address(), n2);
    }

    public static native int nio_uring_register_personality(long var0);

    public static int io_uring_register_personality(IOURing iOURing) {
        return LibURing.nio_uring_register_personality(iOURing.address());
    }

    public static native int nio_uring_unregister_personality(long var0, int var2);

    public static int io_uring_unregister_personality(IOURing iOURing, int n2) {
        return LibURing.nio_uring_unregister_personality(iOURing.address(), n2);
    }

    public static native int nio_uring_register_restrictions(long var0, long var2, int var4);

    public static int io_uring_register_restrictions(IOURing iOURing, IOURingRestriction$Buffer iOURingRestriction$Buffer) {
        return LibURing.nio_uring_register_restrictions(iOURing.address(), iOURingRestriction$Buffer.address(), iOURingRestriction$Buffer.remaining());
    }

    public static native int nio_uring_enable_rings(long var0);

    public static int io_uring_enable_rings(IOURing iOURing) {
        return LibURing.nio_uring_enable_rings(iOURing.address());
    }

    public static native int n__io_uring_sqring_wait(long var0);

    public static int __io_uring_sqring_wait(IOURing iOURing) {
        return LibURing.n__io_uring_sqring_wait(iOURing.address());
    }

    public static native int nio_uring_register_iowq_aff(long var0, long var2, long var4);

    public static int io_uring_register_iowq_aff(IOURing iOURing, long l2, long l3) {
        if (Checks.CHECKS) {
            Checks.check(l3);
        }
        return LibURing.nio_uring_register_iowq_aff(iOURing.address(), l2, l3);
    }

    public static native int nio_uring_unregister_iowq_aff(long var0);

    public static int io_uring_unregister_iowq_aff(IOURing iOURing) {
        return LibURing.nio_uring_unregister_iowq_aff(iOURing.address());
    }

    public static native int nio_uring_register_iowq_max_workers(long var0, long var2);

    public static int io_uring_register_iowq_max_workers(IOURing iOURing, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 2);
        }
        return LibURing.nio_uring_register_iowq_max_workers(iOURing.address(), MemoryUtil.memAddress(intBuffer));
    }

    public static native int nio_uring_register_ring_fd(long var0);

    public static int io_uring_register_ring_fd(IOURing iOURing) {
        return LibURing.nio_uring_register_ring_fd(iOURing.address());
    }

    public static native int nio_uring_unregister_ring_fd(long var0);

    public static int io_uring_unregister_ring_fd(IOURing iOURing) {
        return LibURing.nio_uring_unregister_ring_fd(iOURing.address());
    }

    public static native int nio_uring_close_ring_fd(long var0);

    public static int io_uring_close_ring_fd(IOURing iOURing) {
        return LibURing.nio_uring_close_ring_fd(iOURing.address());
    }

    public static native int nio_uring_register_buf_ring(long var0, long var2, int var4);

    public static int io_uring_register_buf_ring(IOURing iOURing, IOURingBufReg iOURingBufReg, int n2) {
        return LibURing.nio_uring_register_buf_ring(iOURing.address(), iOURingBufReg.address(), n2);
    }

    public static native int nio_uring_unregister_buf_ring(long var0, int var2);

    public static int io_uring_unregister_buf_ring(IOURing iOURing, int n2) {
        return LibURing.nio_uring_unregister_buf_ring(iOURing.address(), n2);
    }

    public static native int nio_uring_register_sync_cancel(long var0, long var2);

    public static int io_uring_register_sync_cancel(IOURing iOURing, IOURingSyncCancelReg iOURingSyncCancelReg) {
        return LibURing.nio_uring_register_sync_cancel(iOURing.address(), iOURingSyncCancelReg.address());
    }

    public static native int nio_uring_register_file_alloc_range(long var0, int var2, int var3);

    public static int io_uring_register_file_alloc_range(IOURing iOURing, int n2, int n3) {
        return LibURing.nio_uring_register_file_alloc_range(iOURing.address(), n2, n3);
    }

    public static native int nio_uring_get_events(long var0);

    public static int io_uring_get_events(IOURing iOURing) {
        return LibURing.nio_uring_get_events(iOURing.address());
    }

    public static native int nio_uring_submit_and_get_events(long var0);

    public static int io_uring_submit_and_get_events(IOURing iOURing) {
        return LibURing.nio_uring_submit_and_get_events(iOURing.address());
    }

    public static native int nio_uring_enter(int var0, int var1, int var2, int var3, long var4);

    public static int io_uring_enter(int n2, int n3, int n4, int n5, long l2) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return LibURing.nio_uring_enter(n2, n3, n4, n5, l2);
    }

    public static native int nio_uring_enter2(int var0, int var1, int var2, int var3, long var4, long var6);

    public static int io_uring_enter2(int n2, int n3, int n4, int n5, long l2, long l3) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return LibURing.nio_uring_enter2(n2, n3, n4, n5, l2, l3);
    }

    public static native int nio_uring_setup(int var0, long var1);

    public static int io_uring_setup(int n2, IOURingParams iOURingParams) {
        return LibURing.nio_uring_setup(n2, iOURingParams.address());
    }

    public static native int io_uring_register(int var0, int var1, long var2, int var4);

    public static native long nio_uring_setup_buf_ring(long var0, int var2, int var3, int var4, long var5);

    public static IOURingBufRing io_uring_setup_buf_ring(IOURing iOURing, int n2, int n3, int n4, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 1);
        }
        long l2 = LibURing.nio_uring_setup_buf_ring(iOURing.address(), n2, n3, n4, MemoryUtil.memAddress(intBuffer));
        return IOURingBufRing.createSafe(l2);
    }

    public static native int nio_uring_free_buf_ring(long var0, long var2, int var4, int var5);

    public static int io_uring_free_buf_ring(IOURing iOURing, IOURingBufRing iOURingBufRing, int n2, int n3) {
        return LibURing.nio_uring_free_buf_ring(iOURing.address(), iOURingBufRing.address(), n2, n3);
    }

    public static native void nio_uring_cqe_seen(long var0, long var2);

    public static void io_uring_cqe_seen(IOURing iOURing, IOURingCQE iOURingCQE) {
        LibURing.nio_uring_cqe_seen(iOURing.address(), iOURingCQE.address());
    }

    public static native void nio_uring_sqe_set_data(long var0, long var2);

    public static void io_uring_sqe_set_data(IOURingSQE iOURingSQE, long l2) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        LibURing.nio_uring_sqe_set_data(iOURingSQE.address(), l2);
    }

    public static native long nio_uring_cqe_get_data(long var0);

    public static long io_uring_cqe_get_data(IOURingCQE iOURingCQE) {
        return LibURing.nio_uring_cqe_get_data(iOURingCQE.address());
    }

    public static native void nio_uring_sqe_set_data64(long var0, long var2);

    public static void io_uring_sqe_set_data64(IOURingSQE iOURingSQE, long l2) {
        LibURing.nio_uring_sqe_set_data64(iOURingSQE.address(), l2);
    }

    public static native long nio_uring_cqe_get_data64(long var0);

    public static long io_uring_cqe_get_data64(IOURingCQE iOURingCQE) {
        return LibURing.nio_uring_cqe_get_data64(iOURingCQE.address());
    }

    public static native void nio_uring_sqe_set_flags(long var0, int var2);

    public static void io_uring_sqe_set_flags(IOURingSQE iOURingSQE, int n2) {
        LibURing.nio_uring_sqe_set_flags(iOURingSQE.address(), n2);
    }

    public static native void nio_uring_prep_splice(long var0, int var2, long var3, int var5, long var6, int var8, int var9);

    public static void io_uring_prep_splice(IOURingSQE iOURingSQE, int n2, long l2, int n3, long l3, int n4, int n5) {
        LibURing.nio_uring_prep_splice(iOURingSQE.address(), n2, l2, n3, l3, n4, n5);
    }

    public static native void nio_uring_prep_tee(long var0, int var2, int var3, int var4, int var5);

    public static void io_uring_prep_tee(IOURingSQE iOURingSQE, int n2, int n3, int n4, int n5) {
        LibURing.nio_uring_prep_tee(iOURingSQE.address(), n2, n3, n4, n5);
    }

    public static native void nio_uring_prep_readv(long var0, int var2, long var3, int var5, int var6);

    public static void io_uring_prep_readv(IOURingSQE iOURingSQE, int n2, IOVec$Buffer iOVec$Buffer, int n3) {
        LibURing.nio_uring_prep_readv(iOURingSQE.address(), n2, iOVec$Buffer.address(), iOVec$Buffer.remaining(), n3);
    }

    public static native void nio_uring_prep_readv2(long var0, int var2, long var3, int var5, int var6, int var7);

    public static void io_uring_prep_readv2(IOURingSQE iOURingSQE, int n2, IOVec$Buffer iOVec$Buffer, int n3, int n4) {
        LibURing.nio_uring_prep_readv2(iOURingSQE.address(), n2, iOVec$Buffer.address(), iOVec$Buffer.remaining(), n3, n4);
    }

    public static native void nio_uring_prep_read_fixed(long var0, int var2, long var3, int var5, int var6, int var7);

    public static void io_uring_prep_read_fixed(IOURingSQE iOURingSQE, int n2, ByteBuffer byteBuffer, int n3, int n4) {
        LibURing.nio_uring_prep_read_fixed(iOURingSQE.address(), n2, MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining(), n3, n4);
    }

    public static native void nio_uring_prep_writev(long var0, int var2, long var3, int var5, int var6);

    public static void io_uring_prep_writev(IOURingSQE iOURingSQE, int n2, IOVec$Buffer iOVec$Buffer, int n3) {
        LibURing.nio_uring_prep_writev(iOURingSQE.address(), n2, iOVec$Buffer.address(), iOVec$Buffer.remaining(), n3);
    }

    public static native void nio_uring_prep_writev2(long var0, int var2, long var3, int var5, int var6, int var7);

    public static void io_uring_prep_writev2(IOURingSQE iOURingSQE, int n2, IOVec$Buffer iOVec$Buffer, int n3, int n4) {
        LibURing.nio_uring_prep_writev2(iOURingSQE.address(), n2, iOVec$Buffer.address(), iOVec$Buffer.remaining(), n3, n4);
    }

    public static native void nio_uring_prep_write_fixed(long var0, int var2, long var3, int var5, int var6, int var7);

    public static void io_uring_prep_write_fixed(IOURingSQE iOURingSQE, int n2, ByteBuffer byteBuffer, int n3, int n4) {
        LibURing.nio_uring_prep_write_fixed(iOURingSQE.address(), n2, MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining(), n3, n4);
    }

    public static native void nio_uring_prep_recvmsg(long var0, int var2, long var3, int var5);

    public static void io_uring_prep_recvmsg(IOURingSQE iOURingSQE, int n2, Msghdr msghdr, int n3) {
        LibURing.nio_uring_prep_recvmsg(iOURingSQE.address(), n2, msghdr.address(), n3);
    }

    public static native void nio_uring_prep_recvmsg_multishot(long var0, int var2, long var3, int var5);

    public static void io_uring_prep_recvmsg_multishot(IOURingSQE iOURingSQE, int n2, Msghdr msghdr, int n3) {
        LibURing.nio_uring_prep_recvmsg_multishot(iOURingSQE.address(), n2, msghdr.address(), n3);
    }

    public static native void nio_uring_prep_sendmsg(long var0, int var2, long var3, int var5);

    public static void io_uring_prep_sendmsg(IOURingSQE iOURingSQE, int n2, Msghdr msghdr, int n3) {
        if (Checks.CHECKS) {
            Msghdr.validate(msghdr.address());
        }
        LibURing.nio_uring_prep_sendmsg(iOURingSQE.address(), n2, msghdr.address(), n3);
    }

    public static native void nio_uring_prep_poll_add(long var0, int var2, int var3);

    public static void io_uring_prep_poll_add(IOURingSQE iOURingSQE, int n2, int n3) {
        LibURing.nio_uring_prep_poll_add(iOURingSQE.address(), n2, n3);
    }

    public static native void nio_uring_prep_poll_multishot(long var0, int var2, int var3);

    public static void io_uring_prep_poll_multishot(IOURingSQE iOURingSQE, int n2, int n3) {
        LibURing.nio_uring_prep_poll_multishot(iOURingSQE.address(), n2, n3);
    }

    public static native void nio_uring_prep_poll_remove(long var0, long var2);

    public static void io_uring_prep_poll_remove(IOURingSQE iOURingSQE, long l2) {
        LibURing.nio_uring_prep_poll_remove(iOURingSQE.address(), l2);
    }

    public static native void nio_uring_prep_poll_update(long var0, long var2, long var4, int var6, int var7);

    public static void io_uring_prep_poll_update(IOURingSQE iOURingSQE, long l2, long l3, int n2, int n3) {
        LibURing.nio_uring_prep_poll_update(iOURingSQE.address(), l2, l3, n2, n3);
    }

    public static native void nio_uring_prep_fsync(long var0, int var2, int var3);

    public static void io_uring_prep_fsync(IOURingSQE iOURingSQE, int n2, int n3) {
        LibURing.nio_uring_prep_fsync(iOURingSQE.address(), n2, n3);
    }

    public static native void nio_uring_prep_nop(long var0);

    public static void io_uring_prep_nop(IOURingSQE iOURingSQE) {
        LibURing.nio_uring_prep_nop(iOURingSQE.address());
    }

    public static native void nio_uring_prep_timeout(long var0, long var2, int var4, int var5);

    public static void io_uring_prep_timeout(IOURingSQE iOURingSQE, KernelTimespec kernelTimespec, int n2, int n3) {
        LibURing.nio_uring_prep_timeout(iOURingSQE.address(), kernelTimespec.address(), n2, n3);
    }

    public static native void nio_uring_prep_timeout_remove(long var0, long var2, int var4);

    public static void io_uring_prep_timeout_remove(IOURingSQE iOURingSQE, long l2, int n2) {
        LibURing.nio_uring_prep_timeout_remove(iOURingSQE.address(), l2, n2);
    }

    public static native void nio_uring_prep_timeout_update(long var0, long var2, long var4, int var6);

    public static void io_uring_prep_timeout_update(IOURingSQE iOURingSQE, KernelTimespec kernelTimespec, long l2, int n2) {
        LibURing.nio_uring_prep_timeout_update(iOURingSQE.address(), kernelTimespec.address(), l2, n2);
    }

    public static native void nio_uring_prep_accept(long var0, int var2, long var3, long var5, int var7);

    public static void io_uring_prep_accept(IOURingSQE iOURingSQE, int n2, Sockaddr sockaddr, IntBuffer intBuffer, int n3) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 1);
        }
        LibURing.nio_uring_prep_accept(iOURingSQE.address(), n2, sockaddr.address(), MemoryUtil.memAddress(intBuffer), n3);
    }

    public static native void nio_uring_prep_accept_direct(long var0, int var2, long var3, long var5, int var7, int var8);

    public static void io_uring_prep_accept_direct(IOURingSQE iOURingSQE, int n2, Sockaddr sockaddr, IntBuffer intBuffer, int n3, int n4) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 1);
        }
        LibURing.nio_uring_prep_accept_direct(iOURingSQE.address(), n2, sockaddr.address(), MemoryUtil.memAddress(intBuffer), n3, n4);
    }

    public static native void nio_uring_prep_multishot_accept(long var0, int var2, long var3, long var5, int var7);

    public static void io_uring_prep_multishot_accept(IOURingSQE iOURingSQE, int n2, Sockaddr sockaddr, IntBuffer intBuffer, int n3) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 1);
        }
        LibURing.nio_uring_prep_multishot_accept(iOURingSQE.address(), n2, sockaddr.address(), MemoryUtil.memAddress(intBuffer), n3);
    }

    public static native void nio_uring_prep_multishot_accept_direct(long var0, int var2, long var3, long var5, int var7);

    public static void io_uring_prep_multishot_accept_direct(IOURingSQE iOURingSQE, int n2, Sockaddr sockaddr, IntBuffer intBuffer, int n3) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)intBuffer, 1);
        }
        LibURing.nio_uring_prep_multishot_accept_direct(iOURingSQE.address(), n2, sockaddr.address(), MemoryUtil.memAddress(intBuffer), n3);
    }

    public static native void nio_uring_prep_cancel64(long var0, long var2, int var4);

    public static void io_uring_prep_cancel64(IOURingSQE iOURingSQE, long l2, int n2) {
        LibURing.nio_uring_prep_cancel64(iOURingSQE.address(), l2, n2);
    }

    public static native void nio_uring_prep_cancel(long var0, long var2, int var4);

    public static void io_uring_prep_cancel(IOURingSQE iOURingSQE, long l2, int n2) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        LibURing.nio_uring_prep_cancel(iOURingSQE.address(), l2, n2);
    }

    public static native void nio_uring_prep_cancel_fd(long var0, int var2, int var3);

    public static void io_uring_prep_cancel_fd(IOURingSQE iOURingSQE, int n2, int n3) {
        LibURing.nio_uring_prep_cancel_fd(iOURingSQE.address(), n2, n3);
    }

    public static native void nio_uring_prep_link_timeout(long var0, long var2, int var4);

    public static void io_uring_prep_link_timeout(IOURingSQE iOURingSQE, KernelTimespec kernelTimespec, int n2) {
        LibURing.nio_uring_prep_link_timeout(iOURingSQE.address(), kernelTimespec.address(), n2);
    }

    public static native void nio_uring_prep_connect(long var0, int var2, long var3, int var5);

    public static void io_uring_prep_connect(IOURingSQE iOURingSQE, int n2, Sockaddr sockaddr, int n3) {
        LibURing.nio_uring_prep_connect(iOURingSQE.address(), n2, sockaddr.address(), n3);
    }

    public static native void nio_uring_prep_files_update(long var0, long var2, int var4, int var5);

    public static void io_uring_prep_files_update(IOURingSQE iOURingSQE, IntBuffer intBuffer, int n2) {
        LibURing.nio_uring_prep_files_update(iOURingSQE.address(), MemoryUtil.memAddress(intBuffer), intBuffer.remaining(), n2);
    }

    public static native void nio_uring_prep_fallocate(long var0, int var2, int var3, long var4, long var6);

    public static void io_uring_prep_fallocate(IOURingSQE iOURingSQE, int n2, int n3, long l2, long l3) {
        LibURing.nio_uring_prep_fallocate(iOURingSQE.address(), n2, n3, l2, l3);
    }

    public static native void nio_uring_prep_openat(long var0, int var2, long var3, int var5, int var6);

    public static void io_uring_prep_openat(IOURingSQE iOURingSQE, int n2, ByteBuffer byteBuffer, int n3, int n4) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        LibURing.nio_uring_prep_openat(iOURingSQE.address(), n2, MemoryUtil.memAddress(byteBuffer), n3, n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void io_uring_prep_openat(IOURingSQE iOURingSQE, int n2, CharSequence charSequence, int n3, int n4) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n5 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l2 = memoryStack.getPointerAddress();
            LibURing.nio_uring_prep_openat(iOURingSQE.address(), n2, l2, n3, n4);
        }
        finally {
            memoryStack.setPointer(n5);
        }
    }

    public static native void nio_uring_prep_openat_direct(long var0, int var2, long var3, int var5, int var6, int var7);

    public static void io_uring_prep_openat_direct(IOURingSQE iOURingSQE, int n2, ByteBuffer byteBuffer, int n3, int n4, int n5) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        LibURing.nio_uring_prep_openat_direct(iOURingSQE.address(), n2, MemoryUtil.memAddress(byteBuffer), n3, n4, n5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void io_uring_prep_openat_direct(IOURingSQE iOURingSQE, int n2, CharSequence charSequence, int n3, int n4, int n5) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n6 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l2 = memoryStack.getPointerAddress();
            LibURing.nio_uring_prep_openat_direct(iOURingSQE.address(), n2, l2, n3, n4, n5);
        }
        finally {
            memoryStack.setPointer(n6);
        }
    }

    public static native void nio_uring_prep_close(long var0, int var2);

    public static void io_uring_prep_close(IOURingSQE iOURingSQE, int n2) {
        LibURing.nio_uring_prep_close(iOURingSQE.address(), n2);
    }

    public static native void nio_uring_prep_close_direct(long var0, int var2);

    public static void io_uring_prep_close_direct(IOURingSQE iOURingSQE, int n2) {
        LibURing.nio_uring_prep_close_direct(iOURingSQE.address(), n2);
    }

    public static native void nio_uring_prep_read(long var0, int var2, long var3, int var5, int var6);

    public static void io_uring_prep_read(IOURingSQE iOURingSQE, int n2, ByteBuffer byteBuffer, int n3) {
        LibURing.nio_uring_prep_read(iOURingSQE.address(), n2, MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining(), n3);
    }

    public static native void nio_uring_prep_write(long var0, int var2, long var3, int var5, int var6);

    public static void io_uring_prep_write(IOURingSQE iOURingSQE, int n2, ByteBuffer byteBuffer, int n3) {
        LibURing.nio_uring_prep_write(iOURingSQE.address(), n2, MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining(), n3);
    }

    public static native void nio_uring_prep_statx(long var0, int var2, long var3, int var5, int var6, long var7);

    public static void io_uring_prep_statx(IOURingSQE iOURingSQE, int n2, ByteBuffer byteBuffer, int n3, int n4, Statx statx) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        LibURing.nio_uring_prep_statx(iOURingSQE.address(), n2, MemoryUtil.memAddress(byteBuffer), n3, n4, statx.address());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void io_uring_prep_statx(IOURingSQE iOURingSQE, int n2, CharSequence charSequence, int n3, int n4, Statx statx) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n5 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l2 = memoryStack.getPointerAddress();
            LibURing.nio_uring_prep_statx(iOURingSQE.address(), n2, l2, n3, n4, statx.address());
        }
        finally {
            memoryStack.setPointer(n5);
        }
    }

    public static native void nio_uring_prep_fadvise(long var0, int var2, int var3, long var4, int var6);

    public static void io_uring_prep_fadvise(IOURingSQE iOURingSQE, int n2, int n3, long l2, int n4) {
        LibURing.nio_uring_prep_fadvise(iOURingSQE.address(), n2, n3, l2, n4);
    }

    public static native void nio_uring_prep_madvise(long var0, long var2, long var4, int var6);

    public static void io_uring_prep_madvise(IOURingSQE iOURingSQE, ByteBuffer byteBuffer, int n2) {
        LibURing.nio_uring_prep_madvise(iOURingSQE.address(), MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining(), n2);
    }

    public static native void nio_uring_prep_send(long var0, int var2, long var3, long var5, int var7);

    public static void io_uring_prep_send(IOURingSQE iOURingSQE, int n2, ByteBuffer byteBuffer, int n3) {
        LibURing.nio_uring_prep_send(iOURingSQE.address(), n2, MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining(), n3);
    }

    public static native void nio_uring_prep_send_set_addr(long var0, long var2, short var4);

    public static void io_uring_prep_send_set_addr(IOURingSQE iOURingSQE, Sockaddr sockaddr, short s2) {
        LibURing.nio_uring_prep_send_set_addr(iOURingSQE.address(), sockaddr.address(), s2);
    }

    public static native void nio_uring_prep_sendto(long var0, int var2, long var3, long var5, int var7, long var8, int var10);

    public static void io_uring_prep_sendto(IOURingSQE iOURingSQE, int n2, ByteBuffer byteBuffer, int n3, Sockaddr sockaddr, int n4) {
        LibURing.nio_uring_prep_sendto(iOURingSQE.address(), n2, MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining(), n3, sockaddr.address(), n4);
    }

    public static native void nio_uring_prep_send_zc(long var0, int var2, long var3, long var5, int var7, int var8);

    public static void io_uring_prep_send_zc(IOURingSQE iOURingSQE, int n2, ByteBuffer byteBuffer, int n3, int n4) {
        LibURing.nio_uring_prep_send_zc(iOURingSQE.address(), n2, MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining(), n3, n4);
    }

    public static native void nio_uring_prep_send_zc_fixed(long var0, int var2, long var3, long var5, int var7, int var8, int var9);

    public static void io_uring_prep_send_zc_fixed(IOURingSQE iOURingSQE, int n2, ByteBuffer byteBuffer, int n3, int n4, int n5) {
        LibURing.nio_uring_prep_send_zc_fixed(iOURingSQE.address(), n2, MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining(), n3, n4, n5);
    }

    public static native void nio_uring_prep_sendmsg_zc(long var0, int var2, long var3, int var5);

    public static void io_uring_prep_sendmsg_zc(IOURingSQE iOURingSQE, int n2, Msghdr msghdr, int n3) {
        if (Checks.CHECKS) {
            Msghdr.validate(msghdr.address());
        }
        LibURing.nio_uring_prep_sendmsg_zc(iOURingSQE.address(), n2, msghdr.address(), n3);
    }

    public static native void nio_uring_prep_recv(long var0, int var2, long var3, long var5, int var7);

    public static void io_uring_prep_recv(IOURingSQE iOURingSQE, int n2, ByteBuffer byteBuffer, int n3) {
        LibURing.nio_uring_prep_recv(iOURingSQE.address(), n2, MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining(), n3);
    }

    public static native void nio_uring_prep_recv_multishot(long var0, int var2, long var3, long var5, int var7);

    public static void io_uring_prep_recv_multishot(IOURingSQE iOURingSQE, int n2, ByteBuffer byteBuffer, int n3) {
        LibURing.nio_uring_prep_recv_multishot(iOURingSQE.address(), n2, MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining(), n3);
    }

    public static native long nio_uring_recvmsg_validate(long var0, int var2, long var3);

    public static IOURingRecvmsgOut io_uring_recvmsg_validate(ByteBuffer byteBuffer, Msghdr msghdr) {
        long l2 = LibURing.nio_uring_recvmsg_validate(MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining(), msghdr.address());
        return IOURingRecvmsgOut.createSafe(l2);
    }

    public static native long nio_uring_recvmsg_name(long var0);

    public static long io_uring_recvmsg_name(IOURingRecvmsgOut iOURingRecvmsgOut) {
        return LibURing.nio_uring_recvmsg_name(iOURingRecvmsgOut.address());
    }

    public static native long nio_uring_recvmsg_cmsg_firsthdr(long var0, long var2);

    public static CMsghdr io_uring_recvmsg_cmsg_firsthdr(IOURingRecvmsgOut iOURingRecvmsgOut, Msghdr msghdr) {
        long l2 = LibURing.nio_uring_recvmsg_cmsg_firsthdr(iOURingRecvmsgOut.address(), msghdr.address());
        return CMsghdr.createSafe(l2);
    }

    public static native long nio_uring_recvmsg_cmsg_nexthdr(long var0, long var2, long var4);

    public static CMsghdr io_uring_recvmsg_cmsg_nexthdr(IOURingRecvmsgOut iOURingRecvmsgOut, Msghdr msghdr, CMsghdr cMsghdr) {
        long l2 = LibURing.nio_uring_recvmsg_cmsg_nexthdr(iOURingRecvmsgOut.address(), msghdr.address(), cMsghdr.address());
        return CMsghdr.createSafe(l2);
    }

    public static native long nio_uring_recvmsg_payload(long var0, long var2);

    public static long io_uring_recvmsg_payload(IOURingRecvmsgOut iOURingRecvmsgOut, Msghdr msghdr) {
        return LibURing.nio_uring_recvmsg_payload(iOURingRecvmsgOut.address(), msghdr.address());
    }

    public static native int nio_uring_recvmsg_payload_length(long var0, int var2, long var3);

    public static int io_uring_recvmsg_payload_length(IOURingRecvmsgOut iOURingRecvmsgOut, int n2, Msghdr msghdr) {
        return LibURing.nio_uring_recvmsg_payload_length(iOURingRecvmsgOut.address(), n2, msghdr.address());
    }

    public static native void nio_uring_prep_openat2(long var0, int var2, long var3, long var5);

    public static void io_uring_prep_openat2(IOURingSQE iOURingSQE, int n2, ByteBuffer byteBuffer, OpenHow openHow) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        LibURing.nio_uring_prep_openat2(iOURingSQE.address(), n2, MemoryUtil.memAddress(byteBuffer), openHow.address());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void io_uring_prep_openat2(IOURingSQE iOURingSQE, int n2, CharSequence charSequence, OpenHow openHow) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n3 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l2 = memoryStack.getPointerAddress();
            LibURing.nio_uring_prep_openat2(iOURingSQE.address(), n2, l2, openHow.address());
        }
        finally {
            memoryStack.setPointer(n3);
        }
    }

    public static native void nio_uring_prep_openat2_direct(long var0, int var2, long var3, long var5, int var7);

    public static void io_uring_prep_openat2_direct(IOURingSQE iOURingSQE, int n2, ByteBuffer byteBuffer, OpenHow openHow, int n3) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        LibURing.nio_uring_prep_openat2_direct(iOURingSQE.address(), n2, MemoryUtil.memAddress(byteBuffer), openHow.address(), n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void io_uring_prep_openat2_direct(IOURingSQE iOURingSQE, int n2, CharSequence charSequence, OpenHow openHow, int n3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n4 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l2 = memoryStack.getPointerAddress();
            LibURing.nio_uring_prep_openat2_direct(iOURingSQE.address(), n2, l2, openHow.address(), n3);
        }
        finally {
            memoryStack.setPointer(n4);
        }
    }

    public static native void nio_uring_prep_epoll_ctl(long var0, int var2, int var3, int var4, long var5);

    public static void io_uring_prep_epoll_ctl(IOURingSQE iOURingSQE, int n2, int n3, int n4, EpollEvent epollEvent) {
        LibURing.nio_uring_prep_epoll_ctl(iOURingSQE.address(), n2, n3, n4, epollEvent.address());
    }

    public static native void nio_uring_prep_provide_buffers(long var0, long var2, int var4, int var5, int var6, int var7);

    public static void io_uring_prep_provide_buffers(IOURingSQE iOURingSQE, ByteBuffer byteBuffer, int n2, int n3, int n4) {
        LibURing.nio_uring_prep_provide_buffers(iOURingSQE.address(), MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining(), n2, n3, n4);
    }

    public static native void nio_uring_prep_remove_buffers(long var0, int var2, int var3);

    public static void io_uring_prep_remove_buffers(IOURingSQE iOURingSQE, int n2, int n3) {
        LibURing.nio_uring_prep_remove_buffers(iOURingSQE.address(), n2, n3);
    }

    public static native void nio_uring_prep_shutdown(long var0, int var2, int var3);

    public static void io_uring_prep_shutdown(IOURingSQE iOURingSQE, int n2, int n3) {
        LibURing.nio_uring_prep_shutdown(iOURingSQE.address(), n2, n3);
    }

    public static native void nio_uring_prep_unlinkat(long var0, int var2, long var3, int var5);

    public static void io_uring_prep_unlinkat(IOURingSQE iOURingSQE, int n2, ByteBuffer byteBuffer, int n3) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        LibURing.nio_uring_prep_unlinkat(iOURingSQE.address(), n2, MemoryUtil.memAddress(byteBuffer), n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void io_uring_prep_unlinkat(IOURingSQE iOURingSQE, int n2, CharSequence charSequence, int n3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n4 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l2 = memoryStack.getPointerAddress();
            LibURing.nio_uring_prep_unlinkat(iOURingSQE.address(), n2, l2, n3);
        }
        finally {
            memoryStack.setPointer(n4);
        }
    }

    public static native void nio_uring_prep_unlink(long var0, long var2, int var4);

    public static void io_uring_prep_unlink(IOURingSQE iOURingSQE, ByteBuffer byteBuffer, int n2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        LibURing.nio_uring_prep_unlink(iOURingSQE.address(), MemoryUtil.memAddress(byteBuffer), n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void io_uring_prep_unlink(IOURingSQE iOURingSQE, CharSequence charSequence, int n2) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n3 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l2 = memoryStack.getPointerAddress();
            LibURing.nio_uring_prep_unlink(iOURingSQE.address(), l2, n2);
        }
        finally {
            memoryStack.setPointer(n3);
        }
    }

    public static native void nio_uring_prep_renameat(long var0, int var2, long var3, int var5, long var6, int var8);

    public static void io_uring_prep_renameat(IOURingSQE iOURingSQE, int n2, ByteBuffer byteBuffer, int n3, ByteBuffer byteBuffer2, int n4) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
            Checks.checkNT1(byteBuffer2);
        }
        LibURing.nio_uring_prep_renameat(iOURingSQE.address(), n2, MemoryUtil.memAddress(byteBuffer), n3, MemoryUtil.memAddress(byteBuffer2), n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void io_uring_prep_renameat(IOURingSQE iOURingSQE, int n2, CharSequence charSequence, int n3, CharSequence charSequence2, int n4) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n5 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l2 = memoryStack.getPointerAddress();
            memoryStack.nUTF8(charSequence2, true);
            long l3 = memoryStack.getPointerAddress();
            LibURing.nio_uring_prep_renameat(iOURingSQE.address(), n2, l2, n3, l3, n4);
        }
        finally {
            memoryStack.setPointer(n5);
        }
    }

    public static native void nio_uring_prep_rename(long var0, long var2, long var4);

    public static void io_uring_prep_rename(IOURingSQE iOURingSQE, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
            Checks.checkNT1(byteBuffer2);
        }
        LibURing.nio_uring_prep_rename(iOURingSQE.address(), MemoryUtil.memAddress(byteBuffer), MemoryUtil.memAddress(byteBuffer2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void io_uring_prep_rename(IOURingSQE iOURingSQE, CharSequence charSequence, CharSequence charSequence2) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l2 = memoryStack.getPointerAddress();
            memoryStack.nUTF8(charSequence2, true);
            long l3 = memoryStack.getPointerAddress();
            LibURing.nio_uring_prep_rename(iOURingSQE.address(), l2, l3);
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static native void nio_uring_prep_sync_file_range(long var0, int var2, int var3, int var4, int var5);

    public static void io_uring_prep_sync_file_range(IOURingSQE iOURingSQE, int n2, int n3, int n4, int n5) {
        LibURing.nio_uring_prep_sync_file_range(iOURingSQE.address(), n2, n3, n4, n5);
    }

    public static native void nio_uring_prep_mkdirat(long var0, int var2, long var3, int var5);

    public static void io_uring_prep_mkdirat(IOURingSQE iOURingSQE, int n2, ByteBuffer byteBuffer, int n3) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        LibURing.nio_uring_prep_mkdirat(iOURingSQE.address(), n2, MemoryUtil.memAddress(byteBuffer), n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void io_uring_prep_mkdirat(IOURingSQE iOURingSQE, int n2, CharSequence charSequence, int n3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n4 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l2 = memoryStack.getPointerAddress();
            LibURing.nio_uring_prep_mkdirat(iOURingSQE.address(), n2, l2, n3);
        }
        finally {
            memoryStack.setPointer(n4);
        }
    }

    public static native void nio_uring_prep_mkdir(long var0, long var2, int var4);

    public static void io_uring_prep_mkdir(IOURingSQE iOURingSQE, ByteBuffer byteBuffer, int n2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        LibURing.nio_uring_prep_mkdir(iOURingSQE.address(), MemoryUtil.memAddress(byteBuffer), n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void io_uring_prep_mkdir(IOURingSQE iOURingSQE, CharSequence charSequence, int n2) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n3 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l2 = memoryStack.getPointerAddress();
            LibURing.nio_uring_prep_mkdir(iOURingSQE.address(), l2, n2);
        }
        finally {
            memoryStack.setPointer(n3);
        }
    }

    public static native void nio_uring_prep_symlinkat(long var0, long var2, int var4, long var5);

    public static void io_uring_prep_symlinkat(IOURingSQE iOURingSQE, ByteBuffer byteBuffer, int n2, ByteBuffer byteBuffer2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
            Checks.checkNT1(byteBuffer2);
        }
        LibURing.nio_uring_prep_symlinkat(iOURingSQE.address(), MemoryUtil.memAddress(byteBuffer), n2, MemoryUtil.memAddress(byteBuffer2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void io_uring_prep_symlinkat(IOURingSQE iOURingSQE, CharSequence charSequence, int n2, CharSequence charSequence2) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n3 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l2 = memoryStack.getPointerAddress();
            memoryStack.nUTF8(charSequence2, true);
            long l3 = memoryStack.getPointerAddress();
            LibURing.nio_uring_prep_symlinkat(iOURingSQE.address(), l2, n2, l3);
        }
        finally {
            memoryStack.setPointer(n3);
        }
    }

    public static native void nio_uring_prep_symlink(long var0, long var2, long var4);

    public static void io_uring_prep_symlink(IOURingSQE iOURingSQE, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
            Checks.checkNT1(byteBuffer2);
        }
        LibURing.nio_uring_prep_symlink(iOURingSQE.address(), MemoryUtil.memAddress(byteBuffer), MemoryUtil.memAddress(byteBuffer2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void io_uring_prep_symlink(IOURingSQE iOURingSQE, CharSequence charSequence, CharSequence charSequence2) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l2 = memoryStack.getPointerAddress();
            memoryStack.nUTF8(charSequence2, true);
            long l3 = memoryStack.getPointerAddress();
            LibURing.nio_uring_prep_symlink(iOURingSQE.address(), l2, l3);
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static native void nio_uring_prep_linkat(long var0, int var2, long var3, int var5, long var6, int var8);

    public static void io_uring_prep_linkat(IOURingSQE iOURingSQE, int n2, ByteBuffer byteBuffer, int n3, ByteBuffer byteBuffer2, int n4) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
            Checks.checkNT1(byteBuffer2);
        }
        LibURing.nio_uring_prep_linkat(iOURingSQE.address(), n2, MemoryUtil.memAddress(byteBuffer), n3, MemoryUtil.memAddress(byteBuffer2), n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void io_uring_prep_linkat(IOURingSQE iOURingSQE, int n2, CharSequence charSequence, int n3, CharSequence charSequence2, int n4) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n5 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l2 = memoryStack.getPointerAddress();
            memoryStack.nUTF8(charSequence2, true);
            long l3 = memoryStack.getPointerAddress();
            LibURing.nio_uring_prep_linkat(iOURingSQE.address(), n2, l2, n3, l3, n4);
        }
        finally {
            memoryStack.setPointer(n5);
        }
    }

    public static native void nio_uring_prep_link(long var0, long var2, long var4, int var6);

    public static void io_uring_prep_link(IOURingSQE iOURingSQE, ByteBuffer byteBuffer, ByteBuffer byteBuffer2, int n2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
            Checks.checkNT1(byteBuffer2);
        }
        LibURing.nio_uring_prep_link(iOURingSQE.address(), MemoryUtil.memAddress(byteBuffer), MemoryUtil.memAddress(byteBuffer2), n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void io_uring_prep_link(IOURingSQE iOURingSQE, CharSequence charSequence, CharSequence charSequence2, int n2) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n3 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l2 = memoryStack.getPointerAddress();
            memoryStack.nUTF8(charSequence2, true);
            long l3 = memoryStack.getPointerAddress();
            LibURing.nio_uring_prep_link(iOURingSQE.address(), l2, l3, n2);
        }
        finally {
            memoryStack.setPointer(n3);
        }
    }

    public static native void nio_uring_prep_msg_ring_cqe_flags(long var0, int var2, int var3, long var4, int var6, int var7);

    public static void io_uring_prep_msg_ring_cqe_flags(IOURingSQE iOURingSQE, int n2, int n3, long l2, int n4, int n5) {
        LibURing.nio_uring_prep_msg_ring_cqe_flags(iOURingSQE.address(), n2, n3, l2, n4, n5);
    }

    public static native void nio_uring_prep_msg_ring(long var0, int var2, int var3, long var4, int var6);

    public static void io_uring_prep_msg_ring(IOURingSQE iOURingSQE, int n2, int n3, long l2, int n4) {
        LibURing.nio_uring_prep_msg_ring(iOURingSQE.address(), n2, n3, l2, n4);
    }

    public static native void nio_uring_prep_msg_ring_fd(long var0, int var2, int var3, int var4, long var5, int var7);

    public static void io_uring_prep_msg_ring_fd(IOURingSQE iOURingSQE, int n2, int n3, int n4, long l2, int n5) {
        LibURing.nio_uring_prep_msg_ring_fd(iOURingSQE.address(), n2, n3, n4, l2, n5);
    }

    public static native void nio_uring_prep_msg_ring_fd_alloc(long var0, int var2, int var3, long var4, int var6);

    public static void io_uring_prep_msg_ring_fd_alloc(IOURingSQE iOURingSQE, int n2, int n3, long l2, int n4) {
        LibURing.nio_uring_prep_msg_ring_fd_alloc(iOURingSQE.address(), n2, n3, l2, n4);
    }

    public static native void nio_uring_prep_getxattr(long var0, long var2, long var4, long var6, int var8);

    public static void io_uring_prep_getxattr(IOURingSQE iOURingSQE, ByteBuffer byteBuffer, ByteBuffer byteBuffer2, ByteBuffer byteBuffer3) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
            Checks.checkNT1(byteBuffer3);
        }
        LibURing.nio_uring_prep_getxattr(iOURingSQE.address(), MemoryUtil.memAddress(byteBuffer), MemoryUtil.memAddress(byteBuffer2), MemoryUtil.memAddress(byteBuffer3), byteBuffer2.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void io_uring_prep_getxattr(IOURingSQE iOURingSQE, CharSequence charSequence, ByteBuffer byteBuffer, CharSequence charSequence2) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l2 = memoryStack.getPointerAddress();
            memoryStack.nUTF8(charSequence2, true);
            long l3 = memoryStack.getPointerAddress();
            LibURing.nio_uring_prep_getxattr(iOURingSQE.address(), l2, MemoryUtil.memAddress(byteBuffer), l3, byteBuffer.remaining());
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static native void nio_uring_prep_setxattr(long var0, long var2, long var4, long var6, int var8, int var9);

    public static void io_uring_prep_setxattr(IOURingSQE iOURingSQE, ByteBuffer byteBuffer, ByteBuffer byteBuffer2, ByteBuffer byteBuffer3, int n2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
            Checks.checkNT1(byteBuffer3);
        }
        LibURing.nio_uring_prep_setxattr(iOURingSQE.address(), MemoryUtil.memAddress(byteBuffer), MemoryUtil.memAddress(byteBuffer2), MemoryUtil.memAddress(byteBuffer3), n2, byteBuffer2.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void io_uring_prep_setxattr(IOURingSQE iOURingSQE, CharSequence charSequence, ByteBuffer byteBuffer, CharSequence charSequence2, int n2) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n3 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l2 = memoryStack.getPointerAddress();
            memoryStack.nUTF8(charSequence2, true);
            long l3 = memoryStack.getPointerAddress();
            LibURing.nio_uring_prep_setxattr(iOURingSQE.address(), l2, MemoryUtil.memAddress(byteBuffer), l3, n2, byteBuffer.remaining());
        }
        finally {
            memoryStack.setPointer(n3);
        }
    }

    public static native void nio_uring_prep_fgetxattr(long var0, int var2, long var3, long var5, int var7);

    public static void io_uring_prep_fgetxattr(IOURingSQE iOURingSQE, int n2, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        LibURing.nio_uring_prep_fgetxattr(iOURingSQE.address(), n2, MemoryUtil.memAddress(byteBuffer), MemoryUtil.memAddress(byteBuffer2), byteBuffer2.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void io_uring_prep_fgetxattr(IOURingSQE iOURingSQE, int n2, CharSequence charSequence, ByteBuffer byteBuffer) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n3 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l2 = memoryStack.getPointerAddress();
            LibURing.nio_uring_prep_fgetxattr(iOURingSQE.address(), n2, l2, MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining());
        }
        finally {
            memoryStack.setPointer(n3);
        }
    }

    public static native void nio_uring_prep_fsetxattr(long var0, int var2, long var3, long var5, int var7, int var8);

    public static void io_uring_prep_fsetxattr(IOURingSQE iOURingSQE, int n2, ByteBuffer byteBuffer, ByteBuffer byteBuffer2, int n3) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        LibURing.nio_uring_prep_fsetxattr(iOURingSQE.address(), n2, MemoryUtil.memAddress(byteBuffer), MemoryUtil.memAddress(byteBuffer2), n3, byteBuffer2.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void io_uring_prep_fsetxattr(IOURingSQE iOURingSQE, int n2, CharSequence charSequence, ByteBuffer byteBuffer, int n3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n4 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l2 = memoryStack.getPointerAddress();
            LibURing.nio_uring_prep_fsetxattr(iOURingSQE.address(), n2, l2, MemoryUtil.memAddress(byteBuffer), n3, byteBuffer.remaining());
        }
        finally {
            memoryStack.setPointer(n4);
        }
    }

    public static native void nio_uring_prep_socket(long var0, int var2, int var3, int var4, int var5);

    public static void io_uring_prep_socket(IOURingSQE iOURingSQE, int n2, int n3, int n4, int n5) {
        LibURing.nio_uring_prep_socket(iOURingSQE.address(), n2, n3, n4, n5);
    }

    public static native void nio_uring_prep_socket_direct(long var0, int var2, int var3, int var4, int var5, int var6);

    public static void io_uring_prep_socket_direct(IOURingSQE iOURingSQE, int n2, int n3, int n4, int n5, int n6) {
        LibURing.nio_uring_prep_socket_direct(iOURingSQE.address(), n2, n3, n4, n5, n6);
    }

    public static native void nio_uring_prep_socket_direct_alloc(long var0, int var2, int var3, int var4, int var5);

    public static void io_uring_prep_socket_direct_alloc(IOURingSQE iOURingSQE, int n2, int n3, int n4, int n5) {
        LibURing.nio_uring_prep_socket_direct_alloc(iOURingSQE.address(), n2, n3, n4, n5);
    }

    public static native int nio_uring_sq_ready(long var0);

    public static int io_uring_sq_ready(IOURing iOURing) {
        if (Checks.CHECKS) {
            IOURing.validate(iOURing.address());
        }
        return LibURing.nio_uring_sq_ready(iOURing.address());
    }

    public static native int nio_uring_sq_space_left(long var0);

    public static int io_uring_sq_space_left(IOURing iOURing) {
        if (Checks.CHECKS) {
            IOURing.validate(iOURing.address());
        }
        return LibURing.nio_uring_sq_space_left(iOURing.address());
    }

    public static native int nio_uring_sqring_wait(long var0);

    public static int io_uring_sqring_wait(IOURing iOURing) {
        return LibURing.nio_uring_sqring_wait(iOURing.address());
    }

    public static native int nio_uring_cq_ready(long var0);

    public static int io_uring_cq_ready(IOURing iOURing) {
        if (Checks.CHECKS) {
            IOURing.validate(iOURing.address());
        }
        return LibURing.nio_uring_cq_ready(iOURing.address());
    }

    public static native boolean nio_uring_cq_has_overflow(long var0);

    public static boolean io_uring_cq_has_overflow(IOURing iOURing) {
        if (Checks.CHECKS) {
            IOURing.validate(iOURing.address());
        }
        return LibURing.nio_uring_cq_has_overflow(iOURing.address());
    }

    public static native boolean nio_uring_cq_eventfd_enabled(long var0);

    public static boolean io_uring_cq_eventfd_enabled(IOURing iOURing) {
        if (Checks.CHECKS) {
            IOURing.validate(iOURing.address());
        }
        return LibURing.nio_uring_cq_eventfd_enabled(iOURing.address());
    }

    public static native int nio_uring_cq_eventfd_toggle(long var0, boolean var2);

    public static int io_uring_cq_eventfd_toggle(IOURing iOURing, boolean bl2) {
        return LibURing.nio_uring_cq_eventfd_toggle(iOURing.address(), bl2);
    }

    public static native int nio_uring_wait_cqe_nr(long var0, long var2, int var4);

    public static int io_uring_wait_cqe_nr(IOURing iOURing, PointerBuffer pointerBuffer) {
        return LibURing.nio_uring_wait_cqe_nr(iOURing.address(), MemoryUtil.memAddress(pointerBuffer), pointerBuffer.remaining());
    }

    public static native int nio_uring_peek_cqe(long var0, long var2);

    public static int io_uring_peek_cqe(IOURing iOURing, PointerBuffer pointerBuffer) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pointerBuffer, 1);
        }
        return LibURing.nio_uring_peek_cqe(iOURing.address(), MemoryUtil.memAddress(pointerBuffer));
    }

    public static native int nio_uring_wait_cqe(long var0, long var2);

    public static int io_uring_wait_cqe(IOURing iOURing, PointerBuffer pointerBuffer) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pointerBuffer, 1);
        }
        return LibURing.nio_uring_wait_cqe(iOURing.address(), MemoryUtil.memAddress(pointerBuffer));
    }

    public static native void nio_uring_buf_ring_advance(long var0, int var2);

    public static void io_uring_buf_ring_advance(IOURingBufRing iOURingBufRing, int n2) {
        LibURing.nio_uring_buf_ring_advance(iOURingBufRing.address(), n2);
    }

    public static native void nio_uring_buf_ring_cq_advance(long var0, long var2, int var4);

    public static void io_uring_buf_ring_cq_advance(IOURing iOURing, IOURingBufRing iOURingBufRing, int n2) {
        LibURing.nio_uring_buf_ring_cq_advance(iOURing.address(), iOURingBufRing.address(), n2);
    }

    public static native long nio_uring_get_sqe(long var0);

    public static IOURingSQE io_uring_get_sqe(IOURing iOURing) {
        long l2 = LibURing.nio_uring_get_sqe(iOURing.address());
        return IOURingSQE.createSafe(l2);
    }

    public static native int io_uring_mlock_size(int var0, int var1);

    public static native int nio_uring_mlock_size_params(int var0, long var1);

    public static int io_uring_mlock_size_params(int n2, IOURingParams iOURingParams) {
        return LibURing.nio_uring_mlock_size_params(n2, iOURingParams.address());
    }

    public static native int io_uring_major_version();

    public static native int io_uring_minor_version();

    public static native boolean io_uring_check_version(int var0, int var1);

    public static int io_uring_buf_ring_mask(int n2) {
        return n2 - 1;
    }

    public static void io_uring_buf_ring_init(IOURingBufRing iOURingBufRing) {
        iOURingBufRing.tail((short)0);
    }

    public static void io_uring_buf_ring_add(IOURingBufRing iOURingBufRing, ByteBuffer byteBuffer, short s2, int n2, int n3) {
        IOURingBuf iOURingBuf = iOURingBufRing.bufs(iOURingBufRing.tail() + n3 & n2);
        iOURingBuf.addr(MemoryUtil.memAddress(byteBuffer));
        iOURingBuf.len(byteBuffer.remaining());
        iOURingBuf.bid(s2);
    }

    static {
        Library.initialize();
    }
}

