/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.macosx;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.macosx.ObjCMethodDescription$Buffer;

public class ObjCMethodDescription
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NAME;
    public static final int TYPES;

    protected ObjCMethodDescription(long l2, ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected ObjCMethodDescription create(long l2, ByteBuffer byteBuffer) {
        return new ObjCMethodDescription(l2, byteBuffer);
    }

    public ObjCMethodDescription(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), ObjCMethodDescription.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public long name() {
        return ObjCMethodDescription.nname(this.address());
    }

    public ByteBuffer types() {
        return ObjCMethodDescription.ntypes(this.address());
    }

    public String typesString() {
        return ObjCMethodDescription.ntypesString(this.address());
    }

    public static ObjCMethodDescription malloc() {
        return new ObjCMethodDescription(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static ObjCMethodDescription calloc() {
        return new ObjCMethodDescription(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static ObjCMethodDescription create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new ObjCMethodDescription(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static ObjCMethodDescription create(long l2) {
        return new ObjCMethodDescription(l2, null);
    }

    public static ObjCMethodDescription createSafe(long l2) {
        return l2 == 0L ? null : new ObjCMethodDescription(l2, null);
    }

    public static ObjCMethodDescription$Buffer malloc(int n2) {
        return new ObjCMethodDescription$Buffer(MemoryUtil.nmemAllocChecked(ObjCMethodDescription.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static ObjCMethodDescription$Buffer calloc(int n2) {
        return new ObjCMethodDescription$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static ObjCMethodDescription$Buffer create(int n2) {
        ByteBuffer byteBuffer = ObjCMethodDescription.__create(n2, SIZEOF);
        return new ObjCMethodDescription$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n2, n2);
    }

    public static ObjCMethodDescription$Buffer create(long l2, int n2) {
        return new ObjCMethodDescription$Buffer(l2, n2);
    }

    public static ObjCMethodDescription$Buffer createSafe(long l2, int n2) {
        return l2 == 0L ? null : new ObjCMethodDescription$Buffer(l2, n2);
    }

    public static ObjCMethodDescription mallocStack() {
        return ObjCMethodDescription.malloc(MemoryStack.stackGet());
    }

    public static ObjCMethodDescription callocStack() {
        return ObjCMethodDescription.calloc(MemoryStack.stackGet());
    }

    public static ObjCMethodDescription mallocStack(MemoryStack memoryStack) {
        return ObjCMethodDescription.malloc(memoryStack);
    }

    public static ObjCMethodDescription callocStack(MemoryStack memoryStack) {
        return ObjCMethodDescription.calloc(memoryStack);
    }

    public static ObjCMethodDescription$Buffer mallocStack(int n2) {
        return ObjCMethodDescription.malloc(n2, MemoryStack.stackGet());
    }

    public static ObjCMethodDescription$Buffer callocStack(int n2) {
        return ObjCMethodDescription.calloc(n2, MemoryStack.stackGet());
    }

    public static ObjCMethodDescription$Buffer mallocStack(int n2, MemoryStack memoryStack) {
        return ObjCMethodDescription.malloc(n2, memoryStack);
    }

    public static ObjCMethodDescription$Buffer callocStack(int n2, MemoryStack memoryStack) {
        return ObjCMethodDescription.calloc(n2, memoryStack);
    }

    public static ObjCMethodDescription malloc(MemoryStack memoryStack) {
        return new ObjCMethodDescription(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static ObjCMethodDescription calloc(MemoryStack memoryStack) {
        return new ObjCMethodDescription(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static ObjCMethodDescription$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new ObjCMethodDescription$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static ObjCMethodDescription$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new ObjCMethodDescription$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static long nname(long l2) {
        return MemoryUtil.memGetAddress(l2 + (long)NAME);
    }

    public static ByteBuffer ntypes(long l2) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(l2 + (long)TYPES));
    }

    public static String ntypesString(long l2) {
        return MemoryUtil.memUTF8(MemoryUtil.memGetAddress(l2 + (long)TYPES));
    }

    static {
        Struct$Layout struct$Layout = ObjCMethodDescription.__struct(ObjCMethodDescription.__member(POINTER_SIZE), ObjCMethodDescription.__member(POINTER_SIZE));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        NAME = struct$Layout.offsetof(0);
        TYPES = struct$Layout.offsetof(1);
    }
}

