/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.ByteBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class WinBase {
    public static final int FALSE = 0;
    public static final int TRUE = 1;

    protected WinBase() {
        throw new UnsupportedOperationException();
    }

    public static native long nLocalFree(long var0);

    public static long LocalFree(long l2) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return WinBase.nLocalFree(l2);
    }

    public static native int GetLastError();

    public static native int getLastError();

    public static native long nGetModuleHandle(long var0);

    public static long GetModuleHandle(ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT2Safe(byteBuffer);
        }
        return WinBase.nGetModuleHandle(MemoryUtil.memAddressSafe(byteBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long GetModuleHandle(CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF16Safe(charSequence, true);
            long l2 = charSequence == null ? 0L : memoryStack.getPointerAddress();
            long l3 = WinBase.nGetModuleHandle(l2);
            return l3;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static native int nGetModuleFileName(long var0, long var2, int var4);

    public static int GetModuleFileName(long l2, ByteBuffer byteBuffer) {
        return WinBase.nGetModuleFileName(l2, MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining() >> 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String GetModuleFileName(long l2, int n2) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n3 = memoryStack.getPointer();
        try {
            ByteBuffer byteBuffer = memoryStack.malloc(n2);
            int n4 = WinBase.nGetModuleFileName(l2, MemoryUtil.memAddress(byteBuffer), n2);
            String string = MemoryUtil.memUTF16(byteBuffer, n4);
            return string;
        }
        finally {
            memoryStack.setPointer(n3);
        }
    }

    public static native long nLoadLibrary(long var0);

    public static long LoadLibrary(ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT2(byteBuffer);
        }
        return WinBase.nLoadLibrary(MemoryUtil.memAddress(byteBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long LoadLibrary(CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF16(charSequence, true);
            long l2 = memoryStack.getPointerAddress();
            long l3 = WinBase.nLoadLibrary(l2);
            return l3;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static native long nGetProcAddress(long var0, long var2);

    public static long GetProcAddress(long l2, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.checkNT1(byteBuffer);
        }
        return WinBase.nGetProcAddress(l2, MemoryUtil.memAddress(byteBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long GetProcAddress(long l2, CharSequence charSequence) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nASCII(charSequence, true);
            long l3 = memoryStack.getPointerAddress();
            long l4 = WinBase.nGetProcAddress(l2, l3);
            return l4;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static native int nFreeLibrary(long var0);

    public static boolean FreeLibrary(long l2) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return WinBase.nFreeLibrary(l2) != 0;
    }

    static {
        Library.initialize();
    }
}

