/*
 * Decompiled with CFR 0.152.
 */
package com.Gameplay;

import com.Gameplay.GameScreen;
import com.Gameplay.Shop;
import com.Gameplay.Weapon;
import com.misc.Stringer;
import javax.microedition.lcdui.Graphics;

public class Arsenal {
    public static Weapon[] weapons;
    public static int current;
    public static boolean hasHand;

    public static final void destroy() {
        for (int var1 = 0; var1 < weapons.length; ++var1) {
            if (weapons[var1] == null) continue;
            weapons[var1].reset();
            Arsenal.weapons[var1] = null;
        }
        weapons = null;
    }

    public static final Weapon currentWeapon() {
        if (current >= 0 && current < weapons.length) {
            return weapons[current];
        }
        return null;
    }

    public static final Weapon[] getWeapons() {
        return weapons;
    }

    public static final void next() {
        if (Arsenal.currentWeapon() != null) {
            Arsenal.currentWeapon().reset();
        }
        if (++current >= weapons.length) {
            current = 0;
            if (hasHand) {
                current = -1;
            }
        }
        if (current != -1 && weapons[current] == null) {
            Arsenal.next();
        }
    }

    public static final void previous() {
        if (Arsenal.currentWeapon() != null) {
            Arsenal.currentWeapon().reset();
        }
        if (--current < (hasHand ? -1 : 0)) {
            current = weapons.length - 1;
        }
        if (current != -1 && weapons[current] == null) {
            Arsenal.previous();
        }
    }

    public static final void drawWeapon(Graphics g, int y, int width, int height, GameScreen gs) {
        if (Arsenal.currentWeapon() == null) {
            return;
        }
        Weapon weapon = Arsenal.currentWeapon();
        if (!gs.player.zoom || !weapon.hasZoom) {
            weapon.draw(g, 0, y, width, height);
        } else {
            weapon.drawSight(g, 0, y, width, height);
        }
        if (weapon.isReloading()) {
            int maxY = Math.max(height / 50, 6);
            int x = (width /= 2) - width / 2;
            int y2 = height - maxY - 2 + y;
            int perc = weapon.reloadingPercentage();
            g.setColor(0xFFFFFF);
            g.drawRect(x, y2, width, maxY);
            g.fillRect(x, y2, width * perc / 100, maxY);
        }
    }

    public Arsenal(int width_g3d, int height_g3d) {
        int i;
        current = -1;
        weapons = new Weapon[Shop.weapon_count];
        if (Shop.defaultArsenal != null) {
            for (i = 0; i < Shop.defaultArsenal.length; ++i) {
                if (Shop.defaultArsenal[i] != -1) {
                    Arsenal.weapons[Shop.defaultArsenal[i]] = Stringer.createWeapon(Shop.defaultArsenal[i]);
                    if (current == -1) {
                        current = Shop.defaultArsenal[i];
                    }
                }
                if (Shop.defaultArsenal[i] != -1) continue;
                hasHand = true;
            }
        } else {
            hasHand = true;
            current = -1;
        }
        for (i = 0; i < weapons.length; ++i) {
            if (weapons[i] == null) continue;
            weapons[i].reset();
            if (!weapons[i].isTwoHands()) {
                weapons[i].setAmmo(200);
                continue;
            }
            weapons[i].setAmmo(400);
        }
        if (Arsenal.currentWeapon() != null) {
            Arsenal.currentWeapon().createSprite(width_g3d, height_g3d);
        }
    }

    public Arsenal() {
    }

    static {
        hasHand = false;
    }
}

