/*
 * Decompiled with CFR 0.152.
 */
package com.Gameplay.Objects;

import com.AI.Player;
import com.Gameplay.GameScreen;
import com.Gameplay.Inventory.ItemList;
import com.Gameplay.Inventory.ItemsEngine;
import com.Gameplay.Map.House;
import com.Gameplay.Map.RoomObject;
import com.Math.Matrix;
import com.Math.Vector3D;
import com.Rendering.DirectX7;
import com.Rendering.Meshes.Mesh;
import com.Rendering.Meshes.Sprite;
import com.Rendering.MultyTexture;
import com.misc.Asset;
import com.misc.Main;
import com.misc.Stringer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ItemsBag
extends RoomObject {
    public static int addsz = -1;
    public static Matrix matrix = new Matrix();
    public Vector3D pos = new Vector3D(0, 0, 0);
    public Mesh mesh;
    public Sprite spr;
    public ItemList items;

    public ItemsBag(Vector3D pos2) {
        this.activable = true;
        this.clickable = true;
        this.radius = 800L;
        this.items = new ItemList();
        this.pos.set(pos2);
        float scale = Main.settings.getFloat("BAG_SCALE", 1.0f);
        String meshStr = Main.settings.getString("BAG_MESH");
        String tex = Main.settings.getString("BAG_TEXTURE");
        if (meshStr != null) {
            this.mesh = Asset.getMeshCloneDynamic(meshStr, scale, scale, scale);
            this.mesh.setTexture(new MultyTexture(tex, true));
        } else {
            this.spr = new Sprite(Asset.getTexture(tex), (int)scale);
        }
        if (addsz == -1) {
            addsz = Main.settings.getInt("BAG_ADDSZ", 4500);
        }
    }

    public final void destroy() {
    }

    public final void render(DirectX7 g3d, int x1, int y1, int x2, int y2) {
        matrix.setPosition(this.pos);
        Matrix mat = g3d.computeFinalMatrix(matrix);
        if (this.mesh != null) {
            g3d.transformAndProjectVertices(this.mesh, mat);
            g3d.addMesh(this.mesh, x1, y1, x2, y2, this.mesh.getTexture());
            this.mesh.increaseMeshSz(addsz);
        } else {
            this.spr.updateFrame();
            this.spr.getPosition().set(this.pos.x, this.pos.y, this.pos.z);
            this.spr.project(g3d.getInvCamera(), g3d);
            if (!this.spr.isVisible(x1, y1, x2, y2)) {
                return;
            }
            g3d.addRenderObject(this.spr, x1, y1, x2, y2);
            this.spr.sz += addsz;
        }
    }

    public final int getPosX() {
        return this.pos.x;
    }

    public final int getPosZ() {
        return this.pos.z;
    }

    public final int getPosY() {
        return this.pos.y;
    }

    public final void setPos(int x, int y, int z) {
        this.pos.set(x, y, z);
    }

    public void activate(House house, Player player, GameScreen gs) {
        this.message = Main.getGameText().getString2("ITEMS_PICKEDUP") + ":";
        for (int i = 0; i < this.items.size(); ++i) {
            int itemId = this.items.itemAt(i);
            int count = this.items.itemAtCount(i);
            Stringer item = ItemsEngine.items[itemId];
            String itemName = item.getString("NAME");
            String tmp = Main.getGameText().getString2(itemName + "_ITEM");
            if (tmp != null) {
                itemName = tmp;
            }
            this.message = this.message + '*' + itemName;
            if (this.items.itemAtCount(i) > 1) {
                this.message = this.message + " " + String.valueOf(count) + "x";
            }
            player.items.addItem(itemId, count);
            String pickupScript = item.getString("ON_PICKUP");
            if (pickupScript == null) continue;
            gs.runScript(Mesh.cutOnStrings(pickupScript, ';'));
        }
        this.prMsg(gs);
        house.removeObject(this);
    }

    public void writeSave(DataOutputStream dos) throws IOException {
        dos.writeInt(this.pos.x);
        dos.writeInt(this.pos.y);
        dos.writeInt(this.pos.z);
        this.items.writeSave(dos);
    }

    public void loadSave(DataInputStream dis) throws IOException {
        this.pos.set(dis.readInt(), dis.readInt(), dis.readInt());
        this.items.loadSave(dis);
    }
}

