/*
 * Decompiled with CFR 0.152.
 */
package com.Gameplay;

import com.AI.BigZombie;
import com.AI.Bot;
import com.AI.NPC;
import com.AI.Player;
import com.AI.Zombie;
import com.Gameplay.Arsenal;
import com.Gameplay.DialogScreen;
import com.Gameplay.GameScreen;
import com.Gameplay.Map.House;
import com.Gameplay.Map.HouseCreator;
import com.Gameplay.Map.Light;
import com.Gameplay.Map.LightMapper;
import com.Gameplay.Map.Room;
import com.Gameplay.Map.RoomObject;
import com.Gameplay.Map.Scene;
import com.Gameplay.Map.Skybox;
import com.Gameplay.Objects.GameObject;
import com.Gameplay.Objects.Image2D;
import com.Gameplay.Objects.KeyObject;
import com.Gameplay.Objects.LVLChange;
import com.Gameplay.Objects.MeshObject;
import com.Gameplay.Objects.NPCSpawner;
import com.Gameplay.Objects.ShopObject;
import com.Gameplay.Objects.SpriteObject;
import com.Gameplay.Objects.Teleport;
import com.Gameplay.Respawn;
import com.Gameplay.Shop;
import com.HUD.DeveloperMenu;
import com.Math.Vector3D;
import com.Rendering.Camera;
import com.Rendering.DirectX7;
import com.Rendering.Meshes.Mesh;
import com.Rendering.Meshes.MeshImage;
import com.Rendering.Meshes.Sprite;
import com.Rendering.MultyTexture;
import com.Rendering.Texture;
import com.Rendering.Vertex;
import com.misc.Asset;
import com.misc.ImageResize;
import com.misc.Main;
import com.misc.Stringer;
import com.misc.WeatherGenerator;
import java.util.Vector;
import javax.microedition.lcdui.Image;

public class LevelLoader {
    public static boolean defaultOneBot = false;
    private static final String[] levelGroups = new String[]{"WTEX_BEGIN", "WTEX_END"};

    private static String[] cutLevelFile(String file) {
        int index = file.indexOf(91);
        if (index > -1) {
            int tmpIndex = file.indexOf(levelGroups[0]);
            if (tmpIndex > -1) {
                int ind2 = file.indexOf(levelGroups[1]);
                String textures = file.substring(tmpIndex + levelGroups[1].length() + 3, ind2 - 2);
                index = (file = file.substring(0, tmpIndex - 2) + file.substring(ind2 + levelGroups[1].length() + 1, file.length())).indexOf(91);
                if (index > -1) {
                    file = file.substring(0, index - 1);
                }
                return new String[]{file, textures};
            }
            return new String[]{file.substring(0, index - 1)};
        }
        return new String[]{file};
    }

    public static final Scene createScene(int width, int height, String file, Main main, GameScreen gs) {
        String str;
        String weatherType;
        boolean botsInLevel;
        String c;
        String file2;
        String oldF = file2 = Mesh.getStringFromResource(file);
        String[] data = LevelLoader.cutLevelFile(file2);
        file2 = data[0];
        Stringer lvl = new Stringer(file2);
        Main.zombiemod = null;
        Main.bigzombiemod = null;
        Main.bigzombietex = null;
        Main.zombietex = null;
        Main.zombieanimspeed = 140;
        Main.zombieattackanimspeed = 700;
        Main.zombiedamage = 1;
        Main.zombieattackradius = 1.2f;
        Main.zombiejumpheight = 140;
        Main.zombiejumpspeed = 1.2f;
        Main.zombiespeed = 140;
        Main.zombiereacttimer = 8;
        Main.zombieattacktimer = 8;
        Main.zombieai = 1;
        Main.zombieplayerreaction = 2;
        Main.zombieattacktrigger = 2;
        Main.zombieprice = 10;
        Zombie.max_hp = 100;
        String zombiemod = "/zombie.3d";
        String zombietex = "/zombie.png";
        Zombie.attack = new int[]{0, 3};
        float zombiescale = 4.5f;
        Main.bigzombieanimspeed = 135;
        Main.bigzombieattackanimspeed = 270;
        Main.bigzombiedamage = 7;
        Main.bigzombieattackradius = 1.2f;
        Main.bigzombiejumpheight = 202;
        Main.bigzombiejumpspeed = 1.2f;
        Main.bigzombiejumpheight2 = 202;
        Main.bigzombiejumpspeed2 = 1.5f;
        Main.bigzombiespeed = 135;
        Main.bigzombiereacttimer = 8;
        Main.bigzombieattacktimer = 14;
        Main.bigzombieai = 1;
        Main.bigzombieplayerreaction = 2;
        Main.bigzombieattacktrigger = 2;
        Main.bigzombieprice = 30;
        BigZombie.max_hp = 400;
        String bigzombiemod = "/big_zombie.3d";
        String bigzombietex = "/big_zombie.png";
        BigZombie.attack = new int[]{0, 3};
        float bigzombiescale = 50.0f;
        Stringer setting = Main.settings;
        defaultOneBot = LevelLoader.getInt("SPAWN_ONE_ENEMY", lvl, setting, 0) == 1;
        boolean bl = Bot.cleverPathfinfing = LevelLoader.getInt("BOTS_CLEVER_PATHFINDING", lvl, setting, 1) == 1;
        if (LevelLoader.getInt("OBSERVER", lvl, setting, 0) == 1) {
            gs.camFollow = new Camera();
            gs.camFollow.angle = 0;
        }
        float levelScale = LevelLoader.getFloat("WORLD_SCALE", lvl, setting, 1.0f);
        Main.offsetsz = LevelLoader.getInt("FLOOR_OFFSETSZ", lvl, setting, 0);
        Main.fullScreenSight = LevelLoader.getInt("MAXIMIZE_SIGHT", lvl, setting, 0) == 1;
        Main.originalSight = LevelLoader.getInt("ORIGINAL_SIGHT", lvl, setting, 0) == 1;
        Main.sight_icon = LevelLoader.getStringdef("SIGHT_ICON", lvl, setting, "/sight.png");
        boolean bl2 = Main.originalUseIcon = LevelLoader.getInt("ORIGINAL_USE_ICON", lvl, setting, 0) == 1;
        if (LevelLoader.getString("LIFE_ZOMBIE", lvl, setting) != null) {
            Zombie.max_hp = LevelLoader.getInt("LIFE_ZOMBIE", lvl, setting);
        }
        if (LevelLoader.getString("LIFE_BIG_ZOMBIE", lvl, setting) != null) {
            BigZombie.max_hp = LevelLoader.getInt("LIFE_BIG_ZOMBIE", lvl, setting);
        }
        if (LevelLoader.getString("BIGZOMBIE_ANIMSPEED", lvl, setting) != null) {
            Main.bigzombieanimspeed = LevelLoader.getInt("BIGZOMBIE_ANIMSPEED", lvl, setting);
        }
        if (LevelLoader.getString("BIGZOMBIE_ATTACKANIMSPEED", lvl, setting) != null) {
            Main.bigzombieattackanimspeed = LevelLoader.getInt("BIGZOMBIE_ATTACKANIMSPEED", lvl, setting);
        }
        if (LevelLoader.getString("BIGZOMBIE_DAMAGE", lvl, setting) != null) {
            Main.bigzombiedamage = LevelLoader.getInt("BIGZOMBIE_DAMAGE", lvl, setting);
        }
        if (LevelLoader.getString("BIGZOMBIE_ATTACKRADIUS", lvl, setting) != null) {
            Main.bigzombieattackradius = LevelLoader.getFloat("BIGZOMBIE_ATTACKRADIUS", lvl, setting);
        }
        if (LevelLoader.getString("BIGZOMBIE_JUMPHEIGHT", lvl, setting) != null) {
            Main.bigzombiejumpheight = LevelLoader.getInt("BIGZOMBIE_JUMPHEIGHT", lvl, setting);
        }
        if (LevelLoader.getString("BIGZOMBIE_JUMPSPEED", lvl, setting) != null) {
            Main.bigzombiejumpspeed = LevelLoader.getFloat("BIGZOMBIE_JUMPSPEED", lvl, setting);
        }
        if (LevelLoader.getString("BIGZOMBIE_JUMPHEIGHT2", lvl, setting) != null) {
            Main.bigzombiejumpheight2 = LevelLoader.getInt("BIGZOMBIE_JUMPHEIGHT2", lvl, setting);
        }
        if (LevelLoader.getString("BIGZOMBIE_JUMPSPEED2", lvl, setting) != null) {
            Main.bigzombiejumpspeed2 = LevelLoader.getFloat("BIGZOMBIE_JUMPSPEED2", lvl, setting);
        }
        if (LevelLoader.getString("BIGZOMBIE_SPEED", lvl, setting) != null) {
            Main.bigzombiespeed = LevelLoader.getInt("BIGZOMBIE_SPEED", lvl, setting);
        }
        if (LevelLoader.getString("ZOMBIE_REACTTIMER", lvl, setting) != null) {
            Main.bigzombiereacttimer = LevelLoader.getInt("BIGZOMBIE_REACTTIMER", lvl, setting);
        }
        if (LevelLoader.getString("BIGZOMBIE_ATTACKTIMER", lvl, setting) != null) {
            Main.bigzombieattacktimer = LevelLoader.getInt("BIGZOMBIE_ATTACKTIMER", lvl, setting);
        }
        if (LevelLoader.getString("BIGZOMBIE_AI", lvl, setting) != null) {
            Main.bigzombieai = LevelLoader.getInt("BIGZOMBIE_AI", lvl, setting);
        }
        if (LevelLoader.getString("BIGZOMBIE_PLAYERREACTION", lvl, setting) != null) {
            Main.bigzombieplayerreaction = LevelLoader.getInt("BIGZOMBIE_PLAYERREACTION", lvl, setting);
        }
        if (LevelLoader.getString("BIGZOMBIE_ATTACKTRIGGER", lvl, setting) != null) {
            Main.bigzombieattacktrigger = LevelLoader.getInt("BIGZOMBIE_ATTACKTRIGGER", lvl, setting);
        }
        if (LevelLoader.getString("ZOMBIE_ANIMSPEED", lvl, setting) != null) {
            Main.zombieanimspeed = LevelLoader.getInt("ZOMBIE_ANIMSPEED", lvl, setting);
        }
        if (LevelLoader.getString("ZOMBIE_ATTACKANIMSPEED", lvl, setting) != null) {
            Main.zombieattackanimspeed = LevelLoader.getInt("ZOMBIE_ATTACKANIMSPEED", lvl, setting);
        }
        if (LevelLoader.getString("ZOMBIE_DAMAGE", lvl, setting) != null) {
            Main.zombiedamage = LevelLoader.getInt("ZOMBIE_DAMAGE", lvl, setting);
        }
        if (LevelLoader.getString("ZOMBIE_ATTACKRADIUS", lvl, setting) != null) {
            Main.zombieattackradius = LevelLoader.getFloat("ZOMBIE_ATTACKRADIUS", lvl, setting);
        }
        if (LevelLoader.getString("ZOMBIE_JUMPHEIGHT", lvl, setting) != null) {
            Main.zombiejumpheight = LevelLoader.getInt("ZOMBIE_JUMPHEIGHT", lvl, setting);
        }
        if (LevelLoader.getString("ZOMBIE_JUMPSPEED", lvl, setting) != null) {
            Main.zombiejumpspeed = LevelLoader.getFloat("ZOMBIE_JUMPSPEED", lvl, setting);
        }
        if (LevelLoader.getString("ZOMBIE_SPEED", lvl, setting) != null) {
            Main.zombiespeed = LevelLoader.getInt("ZOMBIE_SPEED", lvl, setting);
        }
        if (LevelLoader.getString("ZOMBIE_REACTTIMER", lvl, setting) != null) {
            Main.zombiereacttimer = LevelLoader.getInt("ZOMBIE_REACTTIMER", lvl, setting);
        }
        if (LevelLoader.getString("ZOMBIE_ATTACKTIMER", lvl, setting) != null) {
            Main.zombieattacktimer = LevelLoader.getInt("ZOMBIE_ATTACKTIMER", lvl, setting);
        }
        if (LevelLoader.getString("ZOMBIE_AI", lvl, setting) != null) {
            Main.zombieai = LevelLoader.getInt("ZOMBIE_AI", lvl, setting);
        }
        if (LevelLoader.getString("ZOMBIE_ATTACK", lvl, setting) != null) {
            Zombie.attack = Mesh.cutOnInts(LevelLoader.getString("ZOMBIE_ATTACK", lvl, setting), ',', ';');
        }
        if (LevelLoader.getString("BIGZOMBIE_ATTACK", lvl, setting) != null) {
            BigZombie.attack = Mesh.cutOnInts(LevelLoader.getString("BIGZOMBIE_ATTACK", lvl, setting), ',', ';');
        }
        if (LevelLoader.getString("ZOMBIE_PLAYERREACTION", lvl, setting) != null) {
            Main.zombieplayerreaction = LevelLoader.getInt("ZOMBIE_PLAYERREACTION", lvl, setting);
        }
        if (LevelLoader.getString("ZOMBIE_ATTACKTRIGGER", lvl, setting) != null) {
            Main.zombieattacktrigger = LevelLoader.getInt("ZOMBIE_ATTACKTRIGGER", lvl, setting);
        }
        if (LevelLoader.getString("ZOMBIE_TEXTURE", lvl, setting) != null) {
            zombietex = LevelLoader.getString("ZOMBIE_TEXTURE", lvl, setting);
        }
        if (LevelLoader.getString("ZOMBIE_SCALE", lvl, setting) != null) {
            zombiescale = LevelLoader.getFloat("ZOMBIE_SCALE", lvl, setting);
        }
        if (LevelLoader.getString("BIGZOMBIE_SCALE", lvl, setting) != null) {
            bigzombiescale = LevelLoader.getFloat("BIGZOMBIE_SCALE", lvl, setting);
        }
        if (LevelLoader.getString("BIGZOMBIE_TEXTURE", lvl, setting) != null) {
            bigzombietex = LevelLoader.getString("BIGZOMBIE_TEXTURE", lvl, setting);
        }
        if (LevelLoader.getString("ZOMBIE_MODEL", lvl, setting) != null) {
            zombiemod = LevelLoader.getString("ZOMBIE_MODEL", lvl, setting);
        }
        if (LevelLoader.getString("BIGZOMBIE_MODEL", lvl, setting) != null) {
            bigzombiemod = LevelLoader.getString("BIGZOMBIE_MODEL", lvl, setting);
        }
        if (LevelLoader.getString("ZOMBIE_PRICE", lvl, setting) != null) {
            Main.zombieprice = LevelLoader.getInt("ZOMBIE_PRICE", lvl, setting);
        }
        if (LevelLoader.getString("BIGZOMBIE_PRICE", lvl, setting) != null) {
            Main.bigzombieprice = LevelLoader.getInt("BIGZOMBIE_PRICE", lvl, setting);
        }
        Zombie.fallDeath = (byte)LevelLoader.getInt("ZOMBIE_FALL_ON_DEATH", lvl, setting, 1);
        BigZombie.fallDeath = (byte)LevelLoader.getInt("BIGZOMBIE_FALL_ON_DEATH", lvl, setting, 1);
        Zombie.bloodHas = (byte)LevelLoader.getInt("ZOMBIE_HAS_BLOOD", lvl, setting, 1) == 1;
        BigZombie.bloodHas = (byte)LevelLoader.getInt("BIGZOMBIE_HAS_BLOOD", lvl, setting, 1) == 1;
        Main.Blood = LevelLoader.getString("BLOOD_TEX", lvl, setting);
        if (Main.Blood != null) {
            Asset.getTexture(Main.Blood);
        }
        DirectX7.lightdiry = (short)LevelLoader.getInt("LIGHT_Y", lvl, setting, 4096);
        DirectX7.lightdirx = (short)LevelLoader.getInt("LIGHT_X", lvl, setting, -4096);
        DirectX7.lightdirz = (short)LevelLoader.getInt("LIGHT_Z", lvl, setting, 4096);
        GameScreen.bloom = LevelLoader.getInt("BLOOM", lvl, setting, 0) == 1;
        DirectX7.setFogDist(LevelLoader.getInt("FOGD", lvl, setting, 1));
        DirectX7.setDrDist(LevelLoader.getInt("DIST", lvl, setting, Integer.MAX_VALUE));
        DirectX7.fog = (byte)LevelLoader.getInt("DMODE", lvl, setting, 0);
        String r = LevelLoader.getStringdef("FOGCR", lvl, setting, "NULL");
        if (!r.equals("NULL")) {
            int g = LevelLoader.getInt("FOGCG", lvl, setting, 0);
            int b = LevelLoader.getInt("FOGCB", lvl, setting, 0);
            DirectX7.fogc = Stringer.parseInt(r) << 16 | g << 8 | b;
        }
        if (!(c = LevelLoader.getStringdef("FOGC", lvl, setting, "NULL")).equals("NULL")) {
            int[] cols = Mesh.cutOnInts(c, ';', ',');
            DirectX7.fogc = cols[0] << 16 | cols[1] << 8 | cols[2];
        }
        MultyTexture mt = data.length == 1 ? new MultyTexture(lvl.getString("WORLD_TEXTURE"), true) : new MultyTexture(Mesh.cutOnStrings(data[1], '\n'));
        Mesh[] meshes = Room.loadMeshes(lvl.getString("WORLD_MODEL"), levelScale, levelScale, levelScale, mt);
        String modes = lvl.getString("DRAW_MODES");
        if (modes != null) {
            Asset.applyMeshEffects(meshes, modes);
        }
        if ((modes = lvl.getString("MAP_ADDSZ")) != null) {
            int[] asz = Mesh.cutOnInts(modes, ',', ';');
            for (int i = 0; i < asz.length; ++i) {
                mt.textures[i].addsz = asz[i];
            }
        }
        boolean bl3 = Main.forceLQFog = LevelLoader.getInt("LQFOG", lvl, setting, 0) == 1;
        if (DeveloperMenu.debugMode) {
            System.out.println("Please replace UPDATE_ONLYNEAR to UPDATE_ONLY_NEAR if you have some physics issues");
        }
        Main.updateOnlyNear = LevelLoader.getInt("UPDATE_ONLY_NEAR", lvl, setting, 0) == 1;
        boolean bl4 = Main.updateOnlyNearPhysics = LevelLoader.getInt("UPDATE_ONLY_NEAR_PHYSICS", lvl, setting, 0) == 1;
        if (Main.updateOnlyNear) {
            Main.updateOnlyNearPhysics = false;
        }
        String skyboxModel = LevelLoader.getStringdef("SKYBOX_MODEL", lvl, setting, "NULL");
        String skyboxTexture = LevelLoader.getStringdef("SKYBOX_TEXTURE", lvl, setting, "NULL");
        String skyboxGradient = LevelLoader.getStringdef("SKYBOX_GRADIENT", lvl, setting, "NULL");
        String skyboxLighting = LevelLoader.getStringdef("SKYBOX_LIGHTING", lvl, setting, "NULL");
        boolean M3G_SkyBoxSpeedUp = false;
        try {
            Class.forName("javax.microedition.m3g.Graphics3D");
        }
        catch (ClassNotFoundException e) {
            M3G_SkyBoxSpeedUp = false;
        }
        Skybox skybox = null;
        byte oldf = DirectX7.fog;
        DirectX7.fog = 0;
        if (!skyboxModel.equals("NULL") && !skyboxTexture.equals("NULL")) {
            if (!M3G_SkyBoxSpeedUp || skyboxTexture.indexOf(59) > -1 || skyboxTexture.indexOf(44) > -1) {
                String modesz;
                skybox = new Skybox(lvl.getString("SKYBOX_MODEL"), lvl.getString("SKYBOX_TEXTURE"), false, 0, 0);
                if (LevelLoader.getString("SKYBOX_PERS", lvl, setting) != null) {
                    boolean pers = LevelLoader.getInt("SKYBOX_PERS", lvl, setting, 1) == 1;
                    Texture[] texs = skybox.texture.textures;
                    for (int ti = 0; ti < texs.length; ++ti) {
                        texs[ti].setPerspectiveCorrection(pers);
                    }
                }
                if (!(modesz = LevelLoader.getStringdef("SKYBOX_MODES", lvl, setting, "NULL")).equals("NULL")) {
                    Asset.applyMeshEffects(skybox.getMesh(), modesz);
                }
            } else {
                skybox = new Skybox(lvl.getString("SKYBOX_MODEL"), lvl.getString("SKYBOX_TEXTURE"), true, width, height);
            }
        } else if (lvl.getString("SKYBOX_COLOR_R") != null && skyboxModel.equals("NULL") && skyboxTexture.equals("NULL")) {
            skybox = new Skybox(lvl.getInt("SKYBOX_COLOR_R") << 16 | lvl.getInt("SKYBOX_COLOR_G") << 8 | lvl.getInt("SKYBOX_COLOR_B"));
        } else if (lvl.getString("SKYBOX_COLOR") != null && skyboxModel.equals("NULL") && skyboxTexture.equals("NULL")) {
            int[] rgb = Mesh.cutOnInts(lvl.getString("SKYBOX_COLOR"), ',', ';');
            skybox = new Skybox(rgb[0] << 16 | rgb[1] << 8 | rgb[2]);
        } else if (lvl.getString("SKYBOX_COLOR_R") == null && skyboxModel.equals("NULL") && !skyboxTexture.equals("NULL")) {
            float xs = LevelLoader.getFloat("SKYBOX_REPEAT_X", lvl, setting, 2.0f);
            float ys = LevelLoader.getFloat("SKYBOX_REPEAT_Y", lvl, setting, 1.0f);
            skybox = new Skybox(Asset.getTexture(skyboxTexture), xs, ys);
        } else if (!skyboxGradient.equals("NULL") && skyboxModel.equals("NULL") && skyboxTexture.equals("NULL")) {
            int crop = -91;
            float scale = 1.0f;
            String[] tmp = Mesh.cutOnStrings(skyboxGradient, ',', ';');
            if (tmp.length >= 2) {
                scale = Stringer.parseFloat(tmp[1]);
            }
            if (tmp.length >= 3) {
                crop = Stringer.parseInt(tmp[2]);
            }
            skybox = new Skybox(Asset.getTexture(tmp[0]), crop, scale);
        }
        if (skybox != null && !skyboxLighting.equals("NULL")) {
            skybox.skyLighting = Asset.getTexture(skyboxLighting);
        }
        if (skybox != null) {
            boolean bl5 = skybox.skyboxAlways = LevelLoader.getInt("SKYBOX_ALWAYS", lvl, setting, 0) == 1;
        }
        if (skybox != null) {
            skybox.addViewport(0, 0, width, height);
        }
        DirectX7.fog = oldf;
        Room.chunkSize = LevelLoader.getInt("CHUNK_COLLISION_SIZE", lvl, setting, 5000);
        Room.chunkSizeRender = LevelLoader.getInt("CHUNK_SIZE", lvl, setting, 0);
        LightMapper.reset();
        LightMapper.ambientLightSet(Mesh.cutOnInts(LevelLoader.getString("AMBIENT_LIGHT", lvl, setting), ',', ';'));
        LightMapper.aoDistance = LevelLoader.getInt("AO_DISTANCE", lvl, setting, LightMapper.aoDistance);
        LightMapper.aoIntensity = LevelLoader.getInt("AO_INTENSITY", lvl, setting, LightMapper.aoIntensity);
        LightMapper.skyLightIntensitySet(Mesh.cutOnInts(LevelLoader.getString("SKY_LIGHT_INTENSITY", lvl, setting), ',', ';'));
        LightMapper.sunLightIntensitySet(Mesh.cutOnInts(LevelLoader.getString("SUN_LIGHT_INTENSITY", lvl, setting), ',', ';'));
        LightMapper.giRays = LevelLoader.getInt("GI_RAYS", lvl, setting, LightMapper.giRays);
        LightMapper.giIntensitySet(Mesh.cutOnInts(LevelLoader.getString("GI_INTENSITY", lvl, setting), ',', ';'));
        LightMapper.giFallOffSet(Mesh.cutOnInts(LevelLoader.getString("GI_FALLOFF", lvl, setting), ',', ';'));
        LightMapper.cameraVectorLight = LevelLoader.getInt("CAMERA_VECTOR_LIGHT", lvl, setting, 0) == 1;
        LightMapper.bwGI = LevelLoader.getInt("GI_BW", lvl, setting, 0) == 1;
        LightMapper.lumFromTextures = LevelLoader.getInt("GI_LUM_FROM_TEXTURES", lvl, setting, 0) == 1;
        LightMapper.smoothMax = (int)(8192.0f * LevelLoader.getFloat("PHONG_ANGLE", lvl, setting, 29.6631f) / 90.0f);
        gs.doubleBright = LevelLoader.getInt("DOUBLE_BRIGHT", lvl, setting, 0) == 1;
        LightMapper.allRooms = LevelLoader.getInt("LIGHTMAPPER_ALLROOMS_RAYCAST", lvl, setting, 1) == 1;
        LightMapper.raysStep = LevelLoader.getInt("LIGHT_RAYS_STEP", lvl, setting, LightMapper.raysStep);
        Main.arcadeJumpPhysics = LevelLoader.getInt("ARCADE_JUMP_PHYSICS", lvl, setting, 0) == 1;
        LevelLoader.loadLights(oldF, lvl);
        House house = HouseCreator.create(meshes, false, lvl.getString("LIGHTMAP"));
        Respawn start = null;
        if (lvl.getString("START") != null) {
            start = LevelLoader.readPoints(lvl.getString("START"), house)[0];
        }
        Respawn finish = null;
        if (lvl.getString("FINISH") != null) {
            finish = LevelLoader.readPoints(lvl.getString("FINISH"), house)[0];
        }
        Respawn[] enemies = null;
        if (lvl.getString("ENEMIES") != null) {
            enemies = LevelLoader.readPoints(lvl.getString("ENEMIES"), house);
        }
        int enemyCount = 0;
        if (enemies != null) {
            enemyCount = enemies.length;
        }
        if (lvl.getString("ENEMY_COUNT") != null) {
            enemyCount = lvl.getInt("ENEMY_COUNT");
        }
        int frequency = 2000;
        if (LevelLoader.getString("FREQUENCY", lvl, setting) != null) {
            frequency = LevelLoader.getInt("FREQUENCY", lvl, setting);
        }
        boolean bl6 = botsInLevel = enemies != null;
        if (botsInLevel) {
            boolean bl7 = botsInLevel = enemies.length > 0;
        }
        if (enemyCount > 0 && botsInLevel) {
            Main.bigzombietex = new MultyTexture(bigzombietex, false);
            Main.zombietex = new MultyTexture(zombietex, false);
            Main.zombiemod = Asset.getMeshImageDynamic(zombiemod, zombiescale, zombiescale, zombiescale);
            Zombie.model_height = Main.zombiemod.getAnimation().getMesh().maxY() - Main.zombiemod.getAnimation().getMesh().minY();
            Main.bigzombiemod = Asset.getMeshImageDynamic(bigzombiemod, bigzombiescale, bigzombiescale, bigzombiescale);
            BigZombie.model_height = Main.bigzombiemod.getAnimation().getMesh().maxY() - Main.bigzombiemod.getAnimation().getMesh().minY();
            if (LevelLoader.getString("ZOMBIE_DRAW_MODES", lvl, setting) != null) {
                Asset.applyMeshEffects(Main.zombiemod.getMesh(), LevelLoader.getString("ZOMBIE_DRAW_MODES", lvl, setting));
            }
            if (LevelLoader.getString("BIGZOMBIE_DRAW_MODES", lvl, setting) != null) {
                Asset.applyMeshEffects(Main.bigzombiemod.getMesh(), LevelLoader.getString("BIGZOMBIE_DRAW_MODES", lvl, setting));
            }
        } else {
            Main.zombietex = null;
            Main.zombiemod = null;
            Main.bigzombietex = null;
            Main.bigzombiemod = null;
        }
        Scene scene = new Scene(width, height, house, start, finish, enemies, enemyCount, frequency, main, LevelLoader.getInt("ZOMBIE_COUNT", lvl, setting, 5), LevelLoader.getInt("GENERATE_BOTS_WAYS", lvl, setting, 1) == 1);
        house.setSkybox(skybox);
        if (LightMapper.lights != null) {
            house.sortLights(LightMapper.lights);
        }
        scene.g3d.updateFov(Main.stdFov);
        if (lvl.get("NEED_TO_EXIT") != null) {
            scene.need = Mesh.cutOnStrings(lvl.getString("NEED_TO_EXIT"), ',');
        }
        scene.deleteAnPart = LevelLoader.getInt("DELETE_IN_DISTANCE", lvl, setting, 0) == 1;
        scene.alwaysExit = LevelLoader.getInt("ALWAYS_EXIT", lvl, setting, 1) == 1;
        GameScreen.mus = LevelLoader.getStringdef("MUSIC", lvl, setting, "/music.mid");
        boolean bl8 = scene.newExit = LevelLoader.getInt("NEW_EXIT", lvl, setting, 0) == 1;
        if (LevelLoader.getString("PLAYER_SHOP", lvl, setting) != null) {
            String sh = LevelLoader.getString2("PLAYER_SHOP", lvl, setting);
            gs.shopItems = (int[])(sh.equals("OFF") ? null : Mesh.cutOnInts(sh, ','));
        }
        if (gs.shopItems != null) {
            for (int i = 0; i < gs.shopItems.length; ++i) {
                if (gs.shopItems[i] != -1) continue;
                gs.shopItems[i] = Arsenal.weapons.length - 1;
            }
        }
        if ((weatherType = LevelLoader.getString("WEATHER", lvl, setting)) != null) {
            int[] tmp;
            int particlesCount = LevelLoader.getInt("WEATHER_PARTICLES_COUNT", lvl, setting, 170);
            boolean isRain = weatherType.equals("RAIN");
            int[] colors = new int[]{0xAABBDD, 0x666666, 0xFFFFFF, 13290719};
            String userClrs = LevelLoader.getString("WEATHER_COLOR_NEAR", lvl, setting);
            if (userClrs != null) {
                tmp = Mesh.cutOnInts(userClrs, ',', ';');
                colors[isRain ? 0 : 2] = tmp[0] << 16 | tmp[1] << 8 | tmp[2];
            }
            if ((userClrs = LevelLoader.getString("WEATHER_COLOR_FAR", lvl, setting)) != null) {
                tmp = Mesh.cutOnInts(userClrs, ',', ';');
                colors[isRain ? 1 : 3] = tmp[0] << 16 | tmp[1] << 8 | tmp[2];
            }
            int[] lightingTimes = null;
            userClrs = LevelLoader.getString("WEATHER_LIGHTING", lvl, setting);
            if (userClrs != null) {
                lightingTimes = Mesh.cutOnInts(userClrs, ',', ';');
            }
            int particlesSize = LevelLoader.getInt("WEATHER_PARTICLES_SIZE", lvl, setting, isRain ? 22 : 4);
            (gs.wg = new WeatherGenerator((int)GameScreen.width, (int)(GameScreen.height * Main.getDisplaySize() / 100), (int)particlesCount, (int)colors[0], (int)colors[1], (int)colors[2], (int)colors[3], (boolean)(lightingTimes != null ? true : false), (int[])lightingTimes, (int)(isRain ? 4 : particlesSize), (int)(isRain ? particlesSize : 22), (int)Main.stdFov, (int)(GameScreen.width / 2), (int)(GameScreen.height / 2), (int)2, (int)10)).generate = (byte)(isRain ? 1 : 2);
            gs.wg.createParticles();
        }
        if ((str = LevelLoader.getString("WALK_SOUND", lvl, setting)) != null) {
            String[] snds = Mesh.cutOnStrings(str, ';', ',');
            Main.stepSound = snds;
            for (int i = 0; i < snds.length; ++i) {
                if (!Main.isFootsteps || Main.footsteps == 0) continue;
                Asset.getSound(snds[i]);
            }
        }
        Main.jumpSound = LevelLoader.getString("JUMP_SOUND", lvl, setting);
        if (Main.isFootsteps && Main.footsteps != 0 && Main.jumpSound != null) {
            Asset.getSound(Main.jumpSound);
        }
        gs.var10 = lvl;
        String rev = LevelLoader.getString("REVERB", lvl, setting);
        for (int i = 0; i < house.getRooms().length; ++i) {
            Room rm = house.getRooms()[i];
            str = lvl.getString("WALK_SOUND_" + i);
            String reverb = LevelLoader.getStringdef("REVERB_" + i, lvl, setting, rev);
            if (str != null) {
                String[] snds = Mesh.cutOnStrings(str, ';', ',');
                rm.stepSound = snds;
                for (int i2 = 0; i2 < snds.length; ++i2) {
                    if (!Main.isFootsteps || Main.footsteps == 0) continue;
                    Asset.getSound(snds[i2]);
                }
            }
            rm.reverb = reverb;
            rm.jumpSound = lvl.getString("JUMP_SOUND_" + i);
            if (rm.jumpSound == null || !Main.isFootsteps || Main.footsteps == 0) continue;
            Asset.getSound(rm.jumpSound);
        }
        str = LevelLoader.getString("PLAYER_ZOOM", lvl, setting);
        if (str != null) {
            int[] snds = Mesh.cutOnInts(str, ';', ',');
            Main.stdFov = snds[0];
            Main.zoomFov = snds[1];
            Main.hasZoom = false;
            if (snds[2] == 1) {
                Main.hasZoom = true;
            }
        }
        Main.l2dRoomRendering = LevelLoader.getInt("L2D_ROOM_RENDERING", lvl, setting, 0) == 1;
        Main.fallDamage = LevelLoader.getInt("FALL_DAMAGE", lvl, setting, 1) == 1;
        boolean bl9 = gs.fullMoveLvl = LevelLoader.getInt("LEVEL_END_CHANGEPOS", lvl, setting, 0) == 1;
        if (LevelLoader.getString("SPAWN_LIMITER", lvl, setting) != null) {
            scene.botLimiter = Mesh.cutOnInts(LevelLoader.getString("SPAWN_LIMITER", lvl, setting), ',', ';');
        }
        if ((str = LevelLoader.getString("VIGNETTE", lvl, setting)) != null) {
            Image img = ImageResize.createImage(str, scene.g3d.getWidth(), scene.g3d.getHeight());
            int[] vignette = new int[img.getWidth() * img.getHeight()];
            img.getRGB(vignette, 0, width, 0, 0, img.getWidth(), img.getHeight());
            gs.vignette = new byte[vignette.length];
            for (int i = 0; i < vignette.length; ++i) {
                gs.vignette[i] = (byte)((vignette[i] & 0xFF) - 128);
            }
        }
        Asset.prefetchAudio();
        return scene;
    }

    private static Respawn[] readPoints(String file, House house) {
        if (file == null) {
            return null;
        }
        StringBuffer points = new StringBuffer();
        for (int i = 0; i < file.length(); ++i) {
            char ch = file.charAt(i);
            if (ch == ' ') continue;
            points.append(ch);
        }
        String[] var5 = Mesh.cutOnStrings(points.toString(), ';');
        Respawn[] var6 = new Respawn[var5.length];
        for (int i = 0; i < var6.length; ++i) {
            int[] var7 = Mesh.cutOnInts(var5[i], ',');
            Vector3D var8 = new Vector3D(var7[0], var7[1], var7[2]);
            var6[i] = new Respawn(var8, house);
            if (var7.length == 4 || var7.length == 5) {
                var6[i].mode = (byte)-127;
                var6[i].cmode = (byte)(-127 + var7[3]);
                if (var7.length != 5 || var7[4] != 1) continue;
                var6[i].respa = true;
                continue;
            }
            if (!defaultOneBot) continue;
            var6[i].mode = (byte)-127;
            var6[i].cmode = (byte)-126;
        }
        return var6;
    }

    public static final void loadLights(String file, Stringer lvl) {
        int pos = 0;
        if (file == null) {
            return;
        }
        Vector<Light> light = new Vector<Light>();
        while (file.indexOf(91) >= 0) {
            pos = file.indexOf(91);
            int endpos = file.indexOf(93);
            String objectType = file.substring(pos + 1, endpos);
            String object = file.substring(endpos + 1);
            if ((endpos = object.indexOf(91)) >= 0) {
                file = object.substring(endpos);
                object = object.substring(0, endpos - 1);
            }
            Stringer obj = new Stringer(object);
            String key = obj.getString("PRESET") + "@@@";
            if (objectType.indexOf("LIGHT") > -1) {
                String[] poses = Mesh.cutOnStrings(obj.getString("POS"), ';');
                for (int count = 0; count < poses.length; ++count) {
                    int[] color = new int[3];
                    String col = LevelLoader.getString("COLOR", obj, Main.settings, key);
                    if (col != null) {
                        color = Mesh.cutOnInts(col, ',', ';');
                        int brightness = LevelLoader.getInt("BRIGHTNESS", obj, Main.settings, key, lvl, 255);
                        color[0] = color[0] * brightness / 255;
                        color[1] = color[1] * brightness / 255;
                        color[2] = color[2] * brightness / 255;
                    } else {
                        color[1] = color[2] = LevelLoader.getInt("BRIGHTNESS", obj, Main.settings, key, lvl, 255);
                        color[0] = color[2];
                    }
                    Light l = new Light(Mesh.cutOnInts(poses[count], ','), color);
                    String tmp = LevelLoader.getString("DIRECTION", obj, Main.settings, key);
                    if (tmp != null) {
                        l.direction = new Vector3D(Mesh.cutOnInts(tmp, ','));
                    } else {
                        tmp = LevelLoader.getString("LOOK_AT", obj, Main.settings, key);
                        if (tmp != null) {
                            l.direction = new Vector3D(Mesh.cutOnInts(tmp, ','));
                            l.direction.add(-l.pos.x, -l.pos.y, -l.pos.z);
                        }
                    }
                    l.ceilingFix = (short)LevelLoader.getInt("CEILING_FIX", obj, Main.settings, key, lvl, 0);
                    l.floorFix = (short)LevelLoader.getInt("FLOOR_FIX", obj, Main.settings, key, lvl, 0);
                    l.part = LevelLoader.getInt("ROOM_ID", obj, Main.settings, key, lvl, -1);
                    light.addElement(l);
                }
            }
            if (endpos >= 0) continue;
            break;
        }
        LightMapper.lights = null;
        if (light.size() > 0) {
            Light[] l2 = new Light[light.size()];
            for (int i = 0; i < l2.length; ++i) {
                l2[i] = (Light)light.elementAt(i);
            }
            LightMapper.lights = l2;
        }
    }

    public static final void loadObjects(String level, Stringer lvl, Scene scene, Player p, boolean onlyObjs) {
        int pos = 0;
        String file = Mesh.getStringFromResource(level);
        int spawnersCount = 0;
        if (scene.rmsBots == null) {
            scene.rmsBots = new Vector();
        }
        if (scene.rmsObjects == null) {
            scene.rmsObjects = new Vector();
        }
        RoomObject lastAddedObject = null;
        int cmdIndex = -1;
        while (file.indexOf(91) >= 0) {
            pos = file.indexOf(91);
            int endpos = file.indexOf(93);
            String objectType = file.substring(pos + 1, endpos);
            String object = file.substring(endpos + 1);
            if ((endpos = object.indexOf(91)) >= 0) {
                file = object.substring(endpos);
                object = object.substring(0, endpos - 1);
            }
            Stringer obj = new Stringer(object);
            String key = obj.getString("PRESET") + "@@@";
            cmdIndex = objectType.indexOf("ON_ACTIVATE");
            if (cmdIndex > -1) {
                Vector objs = scene.getHouse().getObjects();
                if (cmdIndex > 0) {
                    if (objs.size() > 0) {
                        String newName = objectType.substring(0, cmdIndex - 1);
                        for (int i = 0; i < objs.size(); ++i) {
                            RoomObject robj = (RoomObject)objs.elementAt(i);
                            if (robj == null || robj.name == null || !robj.name.equals(newName)) continue;
                            robj.additional = LevelLoader.createScript(object);
                        }
                    }
                } else if (lastAddedObject != null) {
                    lastAddedObject.additional = LevelLoader.createScript(object);
                }
            } else {
                cmdIndex = objectType.indexOf("ON_SPAWN");
                if (cmdIndex > -1) {
                    Vector objs = scene.getHouse().getObjects();
                    if (cmdIndex > 0) {
                        if (objs.size() > 0) {
                            String newName = objectType.substring(0, cmdIndex - 1);
                            for (int i = 0; i < objs.size(); ++i) {
                                RoomObject robj = (RoomObject)objs.elementAt(i);
                                if (robj == null || robj.name == null || !robj.name.equals(newName) || !(robj instanceof NPCSpawner)) continue;
                                ((NPCSpawner)robj).onSpawn = LevelLoader.createScript(object);
                            }
                        }
                    } else if (lastAddedObject != null && lastAddedObject instanceof NPCSpawner) {
                        ((NPCSpawner)lastAddedObject).onSpawn = LevelLoader.createScript(object);
                    }
                } else {
                    cmdIndex = objectType.indexOf("ON_DEATH");
                    if (cmdIndex > -1) {
                        Vector objs = scene.getHouse().getObjects();
                        if (cmdIndex > 0) {
                            if (objs.size() > 0) {
                                String newName = objectType.substring(0, cmdIndex - 1);
                                for (int i = 0; i < objs.size(); ++i) {
                                    RoomObject robj = (RoomObject)objs.elementAt(i);
                                    if (robj == null || robj.name == null || !robj.name.equals(newName) || !(robj instanceof NPC)) continue;
                                    ((NPC)robj).onDeath = LevelLoader.createScript(object);
                                }
                            }
                        } else if (lastAddedObject != null && lastAddedObject instanceof NPC) {
                            ((NPC)lastAddedObject).onDeath = LevelLoader.createScript(object);
                        }
                    } else {
                        int i;
                        cmdIndex = objectType.indexOf("MESSAGE");
                        if (cmdIndex > -1) {
                            Vector objs = scene.getHouse().getObjects();
                            String msg = object.replace('\n', '@');
                            if (cmdIndex > 0) {
                                if (objs.size() > 0) {
                                    String newName = objectType.substring(0, cmdIndex - 1);
                                    for (i = 0; i < objs.size(); ++i) {
                                        RoomObject robj = (RoomObject)objs.elementAt(i);
                                        if (robj == null || robj.name == null || !robj.name.equals(newName)) continue;
                                        robj.message = msg;
                                    }
                                }
                            } else if (lastAddedObject != null) {
                                lastAddedObject.message = msg;
                            }
                        } else {
                            cmdIndex = objectType.indexOf("ERRMSG");
                            if (cmdIndex > -1) {
                                Vector objs = scene.getHouse().getObjects();
                                String msg = object.replace('\n', '@');
                                if (cmdIndex > 0) {
                                    if (objs.size() > 0) {
                                        String newName = objectType.substring(0, cmdIndex - 1);
                                        for (i = 0; i < objs.size(); ++i) {
                                            RoomObject robj = (RoomObject)objs.elementAt(i);
                                            if (robj == null || robj.name == null || !robj.name.equals(newName)) continue;
                                            robj.errMessage = msg;
                                        }
                                    }
                                } else if (lastAddedObject != null) {
                                    lastAddedObject.errMessage = msg;
                                }
                            } else if (objectType.indexOf("OBJECT") > -1) {
                                System.out.println("Spawning OBJ");
                                String[] poses = Mesh.cutOnStrings(obj.getString("POS"), ';');
                                for (int count = 0; count < poses.length; ++count) {
                                    int[] ps = Mesh.cutOnInts(poses[count], ',');
                                    KeyObject t = new KeyObject(new Vector3D(ps[0], ps[1], ps[2]));
                                    LevelLoader.loadRM(obj, t, lvl, key);
                                    lastAddedObject = t;
                                    scene.getHouse().addObject(t);
                                }
                            } else if (objectType.indexOf("TELEPORT") > -1) {
                                System.out.println("Spawning OBJ");
                                String[] poses = Mesh.cutOnStrings(obj.getString("POS"), ';');
                                for (int count = 0; count < poses.length; ++count) {
                                    int[] ps = Mesh.cutOnInts(poses[count], ',');
                                    int[] ps2 = Mesh.cutOnInts(LevelLoader.getString("NEW_POS", obj, Main.settings, key), ',');
                                    Teleport t = new Teleport(new Vector3D(ps[0], ps[1], ps[2]), new Vector3D(ps2[0], ps2[1], ps2[2]));
                                    LevelLoader.loadRM(obj, t, lvl, key);
                                    t.pRot = LevelLoader.getInt("ROT", obj, Main.settings, key, 0);
                                    lastAddedObject = t;
                                    scene.getHouse().addObject(t);
                                }
                            } else if (objectType.indexOf("NPC") > -1) {
                                System.out.println("Spawning NPC");
                                String[] poses = Mesh.cutOnStrings(obj.getString("POS"), ';');
                                for (int count = 0; count < poses.length; ++count) {
                                    boolean saveInRms;
                                    int[] ps = Mesh.cutOnInts(poses[count], ',');
                                    NPC t = LevelLoader.loadNPC(obj, key, ps);
                                    NPCSpawner spawn = null;
                                    String str = LevelLoader.getString("SPAWN", obj, Main.settings, key);
                                    if (str != null) {
                                        int[] sets = Mesh.cutOnInts(str, ',', ';');
                                        spawn = new NPCSpawner(new Vector3D(ps[0], ps[1], ps[2]));
                                        spawn.canSpawn = sets[0];
                                        if (sets.length >= 2) {
                                            spawn.respawnIn = sets[1];
                                        }
                                        if (sets.length == 3) {
                                            spawn.rot = sets[2];
                                        }
                                        LevelLoader.loadRM(obj, spawn, lvl, key, "SPAWNER_");
                                        spawn.visiblityChecker = LevelLoader.getInt("SPAWNER_IGNORE_VISIBLITY_CHECK", obj, Main.settings, key, spawn.visiblityChecker ? 1 : 0) == 1;
                                        spawn.visiblityChecker = LevelLoader.getInt("SPAWNER_SAVE", obj, Main.settings, key, spawn.visiblityChecker ? 1 : 0) == 1;
                                        spawn.distanceToSpawn = LevelLoader.getLong("SPAWNER_DISTANCE", obj, Main.settings, key, spawn.distanceToSpawn);
                                        if (LevelLoader.getString("SPAWNER_ON_SPAWN", obj, Main.settings, key) != null) {
                                            spawn.onSpawn = Mesh.cutOnStrings(LevelLoader.getString("SPAWNER_ON_SPAWN", obj, Main.settings, key), ',');
                                        }
                                        if (LevelLoader.getString("SPAWNER_COUNT", obj, Main.settings, key) != null) {
                                            spawn.bots = new NPC[Math.max(1, LevelLoader.getInt("SPAWNER_COUNT", obj, Main.settings, key))];
                                            spawn.bots[0] = t;
                                            for (int i2 = 1; i2 < spawn.bots.length; ++i2) {
                                                spawn.bots[i2] = LevelLoader.loadNPC(obj, key, ps);
                                                spawn.bots[i2].name = spawn.bots[i2].name + "_" + String.valueOf(i2);
                                            }
                                        } else {
                                            spawn.bots = new NPC[1];
                                            spawn.bots[0] = t;
                                            spawn.bots[0].name = spawn.bots[0].name + "_1";
                                        }
                                    }
                                    boolean bl = saveInRms = LevelLoader.getInt("SAVE_IN_RMS", obj, Main.settings, key, 0) == 1;
                                    if (saveInRms) {
                                        ++spawnersCount;
                                    }
                                    LevelLoader.loadRM(obj, t, lvl, key);
                                    if (spawn == null) {
                                        if (saveInRms) {
                                            t.spawnerId = spawnersCount - 1;
                                            scene.rmsBots.addElement(t);
                                        }
                                        lastAddedObject = t;
                                        scene.getHouse().addObject(t);
                                        continue;
                                    }
                                    if (saveInRms) {
                                        spawn.spawnerId = spawnersCount - 1;
                                        scene.rmsBots.addElement(spawn);
                                    }
                                    lastAddedObject = spawn;
                                    scene.getHouse().addObject(spawn);
                                }
                            } else if (objectType.indexOf("SPRITE") > -1) {
                                System.out.println("creating sprite");
                                String[] poses = Mesh.cutOnStrings(obj.getString("POS"), ';');
                                for (int count = 0; count < poses.length; ++count) {
                                    int[] flc;
                                    int[] ps = Mesh.cutOnInts(poses[count], ',', ';');
                                    String[] texs = Mesh.cutOnStrings(LevelLoader.getString("TEX", obj, Main.settings, key), ',', ';');
                                    Texture[] textures = new Texture[texs.length];
                                    for (int ti = 0; ti < texs.length; ++ti) {
                                        textures[ti] = Asset.getTextureNM(texs[ti]);
                                    }
                                    SpriteObject spr = new SpriteObject();
                                    spr.spr.setTextures(textures);
                                    spr.spr.setScale(LevelLoader.getInt("SCALE", obj, Main.settings, key, spr.spr.scale));
                                    spr.addsz = LevelLoader.getInt("ADDSZ", obj, Main.settings, key, spr.addsz);
                                    spr.spr.color = LevelLoader.getInt("COLOR", obj, Main.settings, key, spr.spr.color);
                                    String tmp = LevelLoader.getString("OFFSET", obj, Main.settings, key, "NULL");
                                    if (!tmp.equals("NULL")) {
                                        if (tmp.equals("MID")) {
                                            spr.spr.setOffset(0, -spr.spr.getHeight() / 2);
                                        } else if (tmp.equals("UP")) {
                                            spr.spr.setOffset(0, -spr.spr.getHeight());
                                        }
                                    }
                                    spr.spr.animation_speed = LevelLoader.getFloat("ANIMATION_SPEED", obj, Main.settings, key, spr.spr.animation_speed);
                                    tmp = LevelLoader.getString("MODE", obj, Main.settings, key, "NULL");
                                    if (!tmp.equals("NULL")) {
                                        if (tmp.equals("ADD")) {
                                            spr.spr.mode = 1;
                                        } else if (tmp.equals("MUL")) {
                                            spr.spr.mode = (byte)2;
                                        } else if (tmp.equals("OPAQUE") && textures[0].rImg.alphaMixing) {
                                            spr.spr.mode = (byte)3;
                                        }
                                    } else {
                                        spr.spr.mode = 0;
                                        if (textures[0].rImg.alphaMixing) {
                                            spr.spr.mode = (byte)3;
                                        }
                                    }
                                    tmp = LevelLoader.getString("CUTOFF", obj, Main.settings, key, "NULL");
                                    if (!tmp.equals("NULL") && tmp.equals("UP")) {
                                        spr.spr.cutoff = 1;
                                    }
                                    if (!(tmp = LevelLoader.getString("FOG", obj, Main.settings, key, "NULL")).equals("NULL")) {
                                        if (tmp.equals("MIX")) {
                                            spr.spr.fog = true;
                                        }
                                    } else if (DirectX7.fog == 6 || DirectX7.fog == 3 || DirectX7.fog == 1) {
                                        spr.spr.fog = true;
                                    }
                                    if (!(tmp = LevelLoader.getString("FLICKER", obj, Main.settings, key, "NULL")).equals("NULL")) {
                                        flc = Mesh.cutOnInts(tmp, ',', ';');
                                        boolean[] flicker = new boolean[flc.length];
                                        for (int fi = 0; fi < flc.length; ++fi) {
                                            flicker[fi] = flc[fi] == 1;
                                        }
                                        spr.flicker = flicker;
                                    }
                                    if (!(tmp = LevelLoader.getString("COLOR_ANIM", obj, Main.settings, key, "NULL")).equals("NULL")) {
                                        flc = Mesh.cutOnInts(tmp, ',', ';');
                                        spr.colorFlicker = flc;
                                    }
                                    spr.spr.getPosition().set(ps[0], ps[1], ps[2]);
                                    LevelLoader.loadRM(obj, spr, lvl, key);
                                    lastAddedObject = spr;
                                    scene.getHouse().addObject(spr);
                                }
                            } else if (objectType.indexOf("MESH") > -1) {
                                System.out.println("creating mesh");
                                String[] poses = Mesh.cutOnStrings(obj.getString("POS"), ';');
                                for (int count = 0; count < poses.length; ++count) {
                                    int[] ps = Mesh.cutOnInts(poses[count], ',');
                                    float scale = LevelLoader.getFloat("MODEL_SCALE", obj, Main.settings, key, 1.0f);
                                    scale = LevelLoader.getFloat("SCALE", obj, Main.settings, key, scale);
                                    System.out.println("placing model");
                                    Mesh[] meshes = Asset.getMeshes(LevelLoader.getString("MODEL", obj, Main.settings, key), scale, scale, scale);
                                    MultyTexture mt = new MultyTexture(LevelLoader.getString("TEX", obj, Main.settings, key), false);
                                    MeshObject mobj = new MeshObject(meshes, mt, ps[0], ps[1], ps[2], LevelLoader.getInt("REALTIME_LIGHTING", obj, Main.settings, key, lvl, 0) == 1);
                                    LevelLoader.loadRM(obj, mobj, lvl, key);
                                    String modes = LevelLoader.getString("DRAW_MODES", obj, Main.settings, key);
                                    Mesh meshz = mobj.animation.getMesh();
                                    if (modes != null) {
                                        Asset.applyMeshEffects(meshz, modes);
                                    }
                                    int rotY = LevelLoader.getInt("ROTATE_Y", obj, Main.settings, key, 0);
                                    if ((rotY = LevelLoader.getInt("ROT", obj, Main.settings, key, rotY)) != 0) {
                                        mobj.getCharacter().getTransform().rotY(rotY);
                                    }
                                    mobj.animSpeed = LevelLoader.getFloat("ANIMATION_SPEED", obj, Main.settings, key, mobj.animSpeed);
                                    mobj.getCharacter().setCollision(LevelLoader.getInt("PHYSICS", obj, Main.settings, key, 1) == 1);
                                    mobj.getCharacter().setCollidable(LevelLoader.getInt("COLLIDER", obj, Main.settings, key, 1) == 1);
                                    mobj.getCharacter().setUpdatable(LevelLoader.getInt("NOCOLL_UPDATE", obj, Main.settings, key, mobj.getCharacter().isCollidable() ? 1 : 0) == 1);
                                    mobj.setFriction(LevelLoader.getFloat("FRICTION", obj, Main.settings, key, mobj.getFriction()));
                                    mobj.setHp(LevelLoader.getInt("HP", obj, Main.settings, key, mobj.getHp()));
                                    float cscalex = LevelLoader.getFloat("COLLISION_SCALE_X", obj, Main.settings, key, 1.0f);
                                    float cscaley = LevelLoader.getFloat("COLLISION_SCALE_Y", obj, Main.settings, key, 1.0f);
                                    int xsize = mobj.animation.getMesh().maxX() - mobj.animation.getMesh().minX();
                                    int zsize = mobj.animation.getMesh().maxZ() - mobj.animation.getMesh().minZ();
                                    int ysize = mobj.animation.getMesh().maxY() - mobj.animation.getMesh().minY();
                                    mobj.setCharacterSize((int)((float)(xsize / 2) * cscalex), (int)((float)(zsize / 2) * cscalex), (int)((float)ysize * cscaley));
                                    String tmp = LevelLoader.getString("LIFT_POS", obj, Main.settings, key, "NULL");
                                    if (!tmp.equals("NULL")) {
                                        String[] poses2 = Mesh.cutOnStrings(tmp, ';');
                                        mobj.poses = new Vector3D[poses2.length + 1];
                                        mobj.poses[0] = new Vector3D(ps);
                                        for (int i3 = 0; i3 < poses2.length; ++i3) {
                                            int[] ps2 = Mesh.cutOnInts(poses2[i3], ',');
                                            mobj.poses[i3 + 1] = new Vector3D(ps2);
                                        }
                                        mobj.liftCycled = LevelLoader.getInt("LIFT_LOOP", obj, Main.settings, key, lvl, 0) == 1;
                                        tmp = LevelLoader.getString("LIFT_TIMER", obj, Main.settings, key, "NULL");
                                        if (!tmp.equals("NULL")) {
                                            mobj.timeToMove = Mesh.cutOnInts(tmp, ',', ';');
                                        } else {
                                            int speed = LevelLoader.getInt("LIFT_SPEED", obj, Main.settings, key, lvl, 2000);
                                            mobj.timeToMove = new int[mobj.poses.length - (mobj.liftCycled ? 0 : 1)];
                                            for (int i4 = 0; i4 < mobj.timeToMove.length; ++i4) {
                                                int i2 = i4 + 1;
                                                if (i2 >= mobj.poses.length) {
                                                    i2 = 0;
                                                }
                                                Vector3D a = mobj.poses[i4];
                                                Vector3D b = mobj.poses[i2];
                                                mobj.timeToMove[i4] = (int)(Math.sqrt((double)(a.x - b.x) * (double)(a.x - b.x) + (double)(a.y - b.y) * (double)(a.y - b.y) + (double)(a.z - b.z) * (double)(a.z - b.z)) * 1000.0 / (double)speed);
                                            }
                                        }
                                        mobj.lookAtDirect(mobj.poses[1].x, mobj.poses[1].z);
                                        mobj.activable = LevelLoader.getInt("ACTIVABLE", obj, Main.settings, key, lvl, 1) == 1;
                                        mobj.clickable = LevelLoader.getInt("CLICKABLE", obj, Main.settings, key, lvl, 1) == 1;
                                        mobj.liftReUse = LevelLoader.getInt("LIFT_REUSE", obj, Main.settings, key, lvl, 1) == 1;
                                        mobj.disactivateOnEnd = LevelLoader.getInt("LIFT_DISACTIVABLE_ON_END", obj, Main.settings, key, lvl, 0) == 1;
                                        mobj.liftSmoothMove = LevelLoader.getInt("LIFT_SMOOTH_MOVE", obj, Main.settings, key, lvl, 0);
                                        mobj.liftRotateToMove = LevelLoader.getInt("LIFT_SMOOTH_ROTATE", obj, Main.settings, key, lvl, 0) == 1;
                                        mobj.liftCanBePaused = LevelLoader.getInt("LIFT_CAN_BE_PAUSED", obj, Main.settings, key, lvl, 0) == 1;
                                        tmp = LevelLoader.getString("LIFT_PLAYER_FOLLOW", obj, Main.settings, key);
                                        if (tmp != null) {
                                            mobj.playerFollowLift = new Vector3D(Mesh.cutOnInts(tmp, ',', ';'));
                                        }
                                    }
                                    mobj.addsz = LevelLoader.getInt("ADDSZ", obj, Main.settings, key, mobj.addsz);
                                    tmp = LevelLoader.getString("ANIMATION_TYPE", obj, Main.settings, key, "NULL");
                                    if (!tmp.equals("NULL")) {
                                        int at = Stringer.parseInt(tmp);
                                        if (at < 2) {
                                            mobj.animType = at;
                                        }
                                        if (at == 2) {
                                            mobj.animType = 2;
                                            mobj.state = 2;
                                            mobj.activable = true;
                                            mobj.clickable = true;
                                        }
                                    }
                                    mobj.ignoreWeaponRayCast = LevelLoader.getInt("IGNORE_WEAPON_RAYCAST", obj, Main.settings, key, lvl, 0) == 1;
                                    mobj.precCol = LevelLoader.getInt("PRECISE_COLLISION", obj, Main.settings, key, 0) == 1;
                                    lastAddedObject = mobj;
                                    scene.getHouse().addObject(mobj);
                                }
                            } else if (objectType.indexOf("SHOP") > -1) {
                                System.out.println("creating shop");
                                String[] poses = Mesh.cutOnStrings(obj.getString("POS"), ';');
                                for (int count = 0; count < poses.length; ++count) {
                                    int[] ps = Mesh.cutOnInts(poses[count], ',');
                                    int[] prices = null;
                                    String[] files = null;
                                    int[] items = Shop.items;
                                    String tmp = LevelLoader.getString("SHOP", obj, Main.settings, key, "NULL");
                                    if (!tmp.equals("NULL")) {
                                        items = Mesh.cutOnInts(tmp, ',');
                                        for (int i5 = 0; i5 < items.length; ++i5) {
                                            if (items[i5] != -1) continue;
                                            items[i5] = Arsenal.weapons.length - 1;
                                        }
                                    }
                                    if (!(tmp = LevelLoader.getString("PRICES", obj, Main.settings, key, "NULL")).equals("NULL")) {
                                        prices = Mesh.cutOnInts(tmp, ',');
                                    }
                                    if (!(tmp = LevelLoader.getString("FILES", obj, Main.settings, key, "NULL")).equals("NULL")) {
                                        files = Mesh.cutOnStrings(LevelLoader.getString("FILES", obj, Main.settings, key), ',');
                                    }
                                    ShopObject mobj = new ShopObject(items, prices, files, ps[0], ps[1], ps[2]);
                                    LevelLoader.loadRM(obj, mobj, lvl, key);
                                    lastAddedObject = mobj;
                                    scene.getHouse().addObject(mobj);
                                }
                            } else if (objectType.indexOf("LEVELCHANGE") > -1) {
                                System.out.println("creating level change");
                                String[] poses = Mesh.cutOnStrings(obj.getString("POS"), ';');
                                for (int count = 0; count < poses.length; ++count) {
                                    int[] ps = Mesh.cutOnInts(poses[count], ',');
                                    int[] ps2 = Mesh.cutOnInts(LevelLoader.getString("START_POS", obj, Main.settings, key), ',');
                                    LVLChange mobj = new LVLChange(ps[0], ps[1], ps[2], new Vector3D(ps2[0], ps2[1], ps2[2]), LevelLoader.getInt("LEVEL", obj, Main.settings, key));
                                    mobj.pRot = LevelLoader.getInt("ROT", obj, Main.settings, key, mobj.pRot);
                                    mobj.saveMus = LevelLoader.getInt("SAVEMUSIC", obj, Main.settings, key, 0) == 1;
                                    mobj.fullMove = LevelLoader.getInt("FULLMOVE", obj, Main.settings, key, lvl, 0) == 1;
                                    mobj.activable = true;
                                    LevelLoader.loadRM(obj, mobj, lvl, key);
                                    lastAddedObject = mobj;
                                    scene.getHouse().addObject(mobj);
                                }
                            } else if (objectType.indexOf("IMAGE2D") > -1) {
                                System.out.println("creating image2D");
                                String[] poses = Mesh.cutOnStrings(obj.getString("POS"), ';');
                                for (int count = 0; count < poses.length; ++count) {
                                    int[] ps = Mesh.cutOnInts(poses[count], ',');
                                    Image img = null;
                                    try {
                                        String tmp = LevelLoader.getString("IMAGE", obj, Main.settings, key, "NULL");
                                        if (!tmp.equals("NULL")) {
                                            String scaleType = LevelLoader.getString("RESIZE", obj, Main.settings, key, "PROPORTIONAL3D");
                                            img = Image.createImage((String)tmp);
                                            float scalex = LevelLoader.getFloat("SCALE_X", obj, Main.settings, key, 1.0f);
                                            float scaley = LevelLoader.getFloat("SCALE_Y", obj, Main.settings, key, 1.0f);
                                            if (scaleType.equalsIgnoreCase("PROPORTIONAL3D")) {
                                                img = ImageResize.bilinearScaleImage(img, (float)scene.g3d.height * scalex / (float)img.getHeight(), (float)scene.g3d.height * scaley / (float)img.getHeight());
                                            } else if (scaleType.equalsIgnoreCase("FULL3DSCREEN")) {
                                                img = ImageResize.bilinearScaleImage(img, (float)scene.g3d.width * scalex / (float)img.getWidth(), (float)scene.g3d.height * scaley / (float)img.getHeight());
                                            } else if (scaleType.equalsIgnoreCase("PROPORTIONAL")) {
                                                img = ImageResize.bilinearScaleImage(img, (float)scene.g3d.height * scalex / (float)img.getHeight(), (float)(scene.g3d.height * 100 / Main.displaySize) * scaley / (float)img.getHeight());
                                            } else if (scaleType.equalsIgnoreCase("FULLSCREEN")) {
                                                img = ImageResize.bilinearResizeImage(img, scene.g3d.width, scene.g3d.height * 100 / Main.displaySize);
                                            } else if (scaleType.equalsIgnoreCase("ORIGINALSIZE")) {
                                                img = ImageResize.bilinearScaleImage(img, scaley, scaley);
                                            }
                                        }
                                    }
                                    catch (Exception tmp) {
                                        // empty catch block
                                    }
                                    long timeout = LevelLoader.getLong("TIMEOUT", obj, Main.settings, key, 1000L);
                                    Image2D mobj = new Image2D(new Vector3D(ps[0], ps[1], ps[2]), img, timeout);
                                    LevelLoader.loadRM(obj, mobj, lvl, key);
                                    lastAddedObject = mobj;
                                    scene.getHouse().addObject(mobj);
                                }
                            } else if (!onlyObjs && objectType.indexOf("PLAYER") == 0) {
                                if (LevelLoader.getString("CAM_X", obj, Main.settings, key) != null || LevelLoader.getString("CAM_Y", obj, Main.settings, key) != null || LevelLoader.getString("CAM_Z", obj, Main.settings, key) != null || LevelLoader.getString("CAM_ANGLE", obj, Main.settings, key) != null || LevelLoader.getString("THIRDPERSON", obj, Main.settings, key) != null) {
                                    System.out.println("creating camera");
                                    GameScreen.cam = new Camera();
                                    GameScreen.cam.x = LevelLoader.getInt("CAM_X", obj, Main.settings, key, GameScreen.cam.x);
                                    GameScreen.cam.y = LevelLoader.getInt("CAM_Y", obj, Main.settings, key, GameScreen.cam.y);
                                    GameScreen.cam.z = LevelLoader.getInt("CAM_Z", obj, Main.settings, key, GameScreen.cam.z);
                                    GameScreen.cam.angle = LevelLoader.getInt("CAM_ANGLE", obj, Main.settings, key, GameScreen.cam.angle);
                                }
                                if (LevelLoader.getString("MODEL", obj, Main.settings, key) != null) {
                                    float scale = LevelLoader.getFloat("SCALE", obj, Main.settings, key, 1.0f);
                                    System.out.println("placing model");
                                    p.setModel(LevelLoader.getString("MODEL", obj, Main.settings, key), LevelLoader.getString("TEX", obj, Main.settings, key), scale);
                                    String modes = LevelLoader.getString("DRAW_MODES", obj, Main.settings, key);
                                    Mesh meshz = p.getAnim().getMesh();
                                    if (modes != null) {
                                        Asset.applyMeshEffects(meshz, modes);
                                    }
                                }
                                p.setFriction(LevelLoader.getFloat("FRICTION", obj, Main.settings, key, p.getFriction()));
                            }
                        }
                    }
                }
            }
            if (lastAddedObject != null && lastAddedObject.destroyOnUse && lastAddedObject.reloadDestroy && lastAddedObject.name == null) {
                scene.rmsObjects.addElement(lastAddedObject);
            }
            if (endpos >= 0) continue;
            break;
        }
    }

    public static NPC loadNPC(Stringer obj, String key, int[] ps) {
        int rotY;
        int ti;
        Texture[] textures;
        String[] texs;
        float scale = LevelLoader.getFloat("SCALE", obj, Main.settings, key, 1.0f);
        scale = LevelLoader.getFloat("MODEl_SCALE", obj, Main.settings, key, scale);
        int hp = LevelLoader.getInt("HP", obj, Main.settings, key, 100);
        MultyTexture mt = null;
        String str = LevelLoader.getString("TEX", obj, Main.settings, key, "NULL");
        if (!str.equals("NULL")) {
            mt = new MultyTexture(LevelLoader.getString("TEX", obj, Main.settings, key), false);
        }
        String modes = LevelLoader.getString("DRAW_MODES", obj, Main.settings, key);
        MeshImage meim = null;
        str = LevelLoader.getString("MODEL", obj, Main.settings, key, "NULL");
        if (!str.equals("NULL")) {
            meim = Asset.getMeshImageDynamic(str, scale, scale, scale);
        }
        NPC t = new NPC(new Vector3D(ps[0], ps[1], ps[2]), meim, hp, mt);
        str = LevelLoader.getString("DAMAGE_ANIM", obj, Main.settings, key);
        if (str != null) {
            texs = Mesh.cutOnStrings(str, ',', ';');
            textures = new Texture[texs.length - 2];
            for (ti = 0; ti < texs.length; ++ti) {
                if (ti <= 1) continue;
                textures[ti - 2] = Asset.getTextureNM(texs[ti]);
            }
            t.damageFront = new Sprite(textures, Stringer.parseInt(texs[1]), Stringer.parseFloat(texs[0]));
        }
        if ((str = LevelLoader.getString("DEATH_ANIM", obj, Main.settings, key)) != null) {
            texs = Mesh.cutOnStrings(str, ',', ';');
            textures = new Texture[texs.length - 2];
            for (ti = 0; ti < texs.length; ++ti) {
                if (ti <= 1) continue;
                textures[ti - 2] = Asset.getTextureNM(texs[ti]);
            }
            t.deathFront = new Sprite(textures, Stringer.parseInt(texs[1]), Stringer.parseFloat(texs[0]));
            t.deathFront.limiter = true;
        }
        if ((str = LevelLoader.getString("ATTACK_ANIM", obj, Main.settings, key)) != null) {
            texs = Mesh.cutOnStrings(str, ',', ';');
            textures = new Texture[texs.length - 2];
            for (ti = 0; ti < texs.length; ++ti) {
                if (ti <= 1) continue;
                textures[ti - 2] = Asset.getTextureNM(texs[ti]);
            }
            t.attackFront = new Sprite(textures, Stringer.parseInt(texs[1]), Stringer.parseFloat(texs[0]));
        }
        if ((str = LevelLoader.getString("STAY_ANIM", obj, Main.settings, key)) != null) {
            texs = Mesh.cutOnStrings(str, ',', ';');
            textures = new Texture[texs.length - 2];
            for (ti = 0; ti < texs.length; ++ti) {
                if (ti <= 1) continue;
                textures[ti - 2] = Asset.getTextureNM(texs[ti]);
            }
            t.stayFront = new Sprite(textures, Stringer.parseInt(texs[1]), Stringer.parseFloat(texs[0]));
            t.model_height = t.stayFront.getHeight() * (t.stayFront.textures[0].rImg.scale < 2 ? 2 : 1);
            t.setCharacterSize(t.model_height);
        }
        if ((str = LevelLoader.getString("WALK_ANIM", obj, Main.settings, key)) != null) {
            texs = Mesh.cutOnStrings(str, ',', ';');
            textures = new Texture[texs.length - 2];
            for (ti = 0; ti < texs.length; ++ti) {
                if (ti <= 1) continue;
                textures[ti - 2] = Asset.getTextureNM(texs[ti]);
            }
            t.walkFront = new Sprite(textures, Stringer.parseInt(texs[1]), Stringer.parseFloat(texs[0]));
        }
        if ((str = LevelLoader.getString("DAMAGE_BACK_ANIM", obj, Main.settings, key)) != null) {
            texs = Mesh.cutOnStrings(str, ',', ';');
            textures = new Texture[texs.length - 2];
            for (ti = 0; ti < texs.length; ++ti) {
                if (ti <= 1) continue;
                textures[ti - 2] = Asset.getTextureNM(texs[ti]);
            }
            t.damageBack = new Sprite(textures, Stringer.parseInt(texs[1]), Stringer.parseFloat(texs[0]));
        }
        if ((str = LevelLoader.getString("DEATH_BACK_ANIM", obj, Main.settings, key)) != null) {
            texs = Mesh.cutOnStrings(str, ',', ';');
            textures = new Texture[texs.length - 2];
            for (ti = 0; ti < texs.length; ++ti) {
                if (ti <= 1) continue;
                textures[ti - 2] = Asset.getTextureNM(texs[ti]);
            }
            t.deathBack = new Sprite(textures, Stringer.parseInt(texs[1]), Stringer.parseFloat(texs[0]));
            t.deathBack.limiter = true;
        }
        if ((str = LevelLoader.getString("ATTACK_BACK_ANIM", obj, Main.settings, key)) != null) {
            texs = Mesh.cutOnStrings(str, ',', ';');
            textures = new Texture[texs.length - 2];
            for (ti = 0; ti < texs.length; ++ti) {
                if (ti <= 1) continue;
                textures[ti - 2] = Asset.getTextureNM(texs[ti]);
            }
            t.attackBack = new Sprite(textures, Stringer.parseInt(texs[1]), Stringer.parseFloat(texs[0]));
        }
        if ((str = LevelLoader.getString("STAY_BACK_ANIM", obj, Main.settings, key)) != null) {
            texs = Mesh.cutOnStrings(str, ',', ';');
            textures = new Texture[texs.length - 2];
            for (ti = 0; ti < texs.length; ++ti) {
                if (ti <= 1) continue;
                textures[ti - 2] = Asset.getTextureNM(texs[ti]);
            }
            t.stayBack = new Sprite(textures, Stringer.parseInt(texs[1]), Stringer.parseFloat(texs[0]));
        }
        if ((str = LevelLoader.getString("WALK_BACK_ANIM", obj, Main.settings, key)) != null) {
            texs = Mesh.cutOnStrings(str, ',', ';');
            textures = new Texture[texs.length - 2];
            for (ti = 0; ti < texs.length; ++ti) {
                if (ti <= 1) continue;
                textures[ti - 2] = Asset.getTextureNM(texs[ti]);
            }
            t.walkBack = new Sprite(textures, Stringer.parseInt(texs[1]), Stringer.parseFloat(texs[0]));
        }
        if ((str = LevelLoader.getString("DAMAGE_SIDE_ANIM", obj, Main.settings, key)) != null) {
            texs = Mesh.cutOnStrings(str, ',', ';');
            textures = new Texture[texs.length - 2];
            for (ti = 0; ti < texs.length; ++ti) {
                if (ti <= 1) continue;
                textures[ti - 2] = Asset.getTextureNM(texs[ti]);
            }
            t.damageSide = new Sprite(textures, Stringer.parseInt(texs[1]), Stringer.parseFloat(texs[0]));
        }
        if ((str = LevelLoader.getString("DEATH_SIDE_ANIM", obj, Main.settings, key)) != null) {
            texs = Mesh.cutOnStrings(str, ',', ';');
            textures = new Texture[texs.length - 2];
            for (ti = 0; ti < texs.length; ++ti) {
                if (ti <= 1) continue;
                textures[ti - 2] = Asset.getTextureNM(texs[ti]);
            }
            t.deathSide = new Sprite(textures, Stringer.parseInt(texs[1]), Stringer.parseFloat(texs[0]));
            t.deathSide.limiter = true;
        }
        if ((str = LevelLoader.getString("ATTACK_SIDE_ANIM", obj, Main.settings, key)) != null) {
            texs = Mesh.cutOnStrings(str, ',', ';');
            textures = new Texture[texs.length - 2];
            for (ti = 0; ti < texs.length; ++ti) {
                if (ti <= 1) continue;
                textures[ti - 2] = Asset.getTextureNM(texs[ti]);
            }
            t.attackSide = new Sprite(textures, Stringer.parseInt(texs[1]), Stringer.parseFloat(texs[0]));
        }
        if ((str = LevelLoader.getString("STAY_SIDE_ANIM", obj, Main.settings, key)) != null) {
            texs = Mesh.cutOnStrings(str, ',', ';');
            textures = new Texture[texs.length - 2];
            for (ti = 0; ti < texs.length; ++ti) {
                if (ti <= 1) continue;
                textures[ti - 2] = Asset.getTextureNM(texs[ti]);
            }
            t.staySide = new Sprite(textures, Stringer.parseInt(texs[1]), Stringer.parseFloat(texs[0]));
        }
        if ((str = LevelLoader.getString("WALK_SIDE_ANIM", obj, Main.settings, key)) != null) {
            texs = Mesh.cutOnStrings(str, ',', ';');
            textures = new Texture[texs.length - 2];
            for (ti = 0; ti < texs.length; ++ti) {
                if (ti <= 1) continue;
                textures[ti - 2] = Asset.getTextureNM(texs[ti]);
            }
            t.walkSide = new Sprite(textures, Stringer.parseInt(texs[1]), Stringer.parseFloat(texs[0]));
        }
        Mesh meshz = null;
        if (t.meshImage != null) {
            meshz = t.meshImage.getMesh();
            meshz.setTexture(mt);
        }
        t.animspeed = LevelLoader.getInt("ANIMSPEED", obj, Main.settings, key, t.animspeed);
        t.attackanimspeed = LevelLoader.getInt("ATTACKANIMSPEED", obj, Main.settings, key, t.attackanimspeed);
        t.damage = LevelLoader.getInt("DAMAGE", obj, Main.settings, key, t.damage);
        t.attackradius = LevelLoader.getFloat("ATTACKRADIUS", obj, Main.settings, key, t.attackradius);
        t.jumpheight = LevelLoader.getInt("JUMPHEIGHT", obj, Main.settings, key, t.jumpheight);
        t.jumpspeed = LevelLoader.getFloat("JUMPSPEED", obj, Main.settings, key, t.jumpspeed);
        t.speed = LevelLoader.getInt("SPEED", obj, Main.settings, key, t.speed);
        t.reacttimer = LevelLoader.getInt("REACTTIMER", obj, Main.settings, key, t.reacttimer);
        t.attacktimer = LevelLoader.getInt("ATTACKTIMER", obj, Main.settings, key, t.attacktimer);
        t.ai = LevelLoader.getInt("AI", obj, Main.settings, key, t.ai);
        t.playerreaction = LevelLoader.getInt("ENEMYREACTION", obj, Main.settings, key, t.playerreaction);
        t.attacktrigger = LevelLoader.getInt("ATTACKTRIGGER", obj, Main.settings, key, t.attacktrigger);
        t.fraction = LevelLoader.getInt("FRACTION", obj, Main.settings, key, t.fraction);
        t.fragsOnDeath = LevelLoader.getInt("FRAGSONDEATH", obj, Main.settings, key, t.fragsOnDeath);
        t.fragsOnAnyDeath = LevelLoader.getInt("FRAGS_ON_ANY_DEATH", obj, Main.settings, key, t.fragsOnAnyDeath);
        t.moneyOnDeath = LevelLoader.getInt("MONEYONDEATH", obj, Main.settings, key, t.moneyOnDeath);
        t.damageSleepTime = LevelLoader.getInt("SLEEPONDAMAGE", obj, Main.settings, key, t.damageSleepTime);
        t.maxEnemyDistance = LevelLoader.getLong("MAXENEMYDISTANCE", obj, Main.settings, key, t.maxEnemyDistance);
        t.visiblityCheck = LevelLoader.getInt("VISIBLITY_CHECK", obj, Main.settings, key, 0) == 1;
        t.deathFall = (byte)LevelLoader.getInt("FALL_ON_DEATH", obj, Main.settings, key, 1);
        t.hasBlood = (byte)LevelLoader.getInt("HAS_BLOOD", obj, Main.settings, key, 1) == 1;
        String observable = LevelLoader.getString("OBSERVABLE", obj, Main.settings, key);
        if (observable != null) {
            t.observable = Mesh.cutOnInts(observable, ',', ';');
        }
        if ((str = LevelLoader.getString("ATTACK", obj, Main.settings, key)) != null) {
            t.toAttack = (int[])(str.equalsIgnoreCase("all") ? null : Mesh.cutOnInts(str, ',', ';'));
        }
        if ((str = LevelLoader.getString("FOLLOW", obj, Main.settings, key)) != null) {
            t.toFollow = (int[])(str.equalsIgnoreCase("all") ? null : Mesh.cutOnInts(str, ',', ';'));
        }
        if ((str = LevelLoader.getString("FRIENDLY_FIRE", obj, Main.settings, key)) != null) {
            t.friendlyFire = Mesh.cutOnInts(str, ',', ';');
        }
        if ((str = LevelLoader.getString("ATTACKONDAMAGE", obj, Main.settings, key)) != null && Stringer.parseInt(str) == 1) {
            t.unicalEnemies = new Vector();
        }
        if ((str = LevelLoader.getString("ATTACKONDAMAGE_OP", obj, Main.settings, key)) != null && Stringer.parseInt(str) == 1) {
            if (t.unicalEnemies == null) {
                t.unicalEnemies = new Vector();
            }
            t.attackOnDamageOnlyPlayer = true;
        }
        if ((rotY = LevelLoader.getInt("ROT", obj, Main.settings, key, 0)) != 0) {
            t.getCharacter().rotY(rotY);
        }
        if ((str = LevelLoader.getString("MUZZLE_FLASH_POS", obj, Main.settings, key)) != null) {
            t.muzzleFlashPos = new Vertex(Mesh.cutOnInts(str, ',', ';'));
            t.muzzleFlash = new Sprite(Asset.getTexture(LevelLoader.getString("MUZZLE_FLASH", obj, Main.settings, key)), LevelLoader.getInt("MUZZLE_FLASH_SCALE", obj, Main.settings, key));
            if (t.muzzleFlash.textures[0].rImg.alphaMixing) {
                t.muzzleFlash.mode = (byte)3;
            }
            t.muzzleFlash.fog = false;
            t.lastAttack = 0L;
            t.muzzleFlashTimer = LevelLoader.getInt("MUZZLE_FLASH_TIMER", obj, Main.settings, key);
        }
        if ((str = LevelLoader.getString("ON_DEATH", obj, Main.settings, key)) != null) {
            t.onDeath = LevelLoader.loadScriptFromFile(str);
        }
        if (modes != null && meshz != null) {
            Asset.applyMeshEffects(meshz, modes);
        }
        t.getCharacter().setCollision(LevelLoader.getInt("PHYSICS", obj, Main.settings, key, 1) == 1);
        t.getCharacter().setCollidable(LevelLoader.getInt("COLLIDER", obj, Main.settings, key, 1) == 1);
        t.getCharacter().setUpdatable(LevelLoader.getInt("NOCOLL_UPDATE", obj, Main.settings, key, t.getCharacter().isCollidable() ? 1 : 0) == 1);
        float cscalex = (float)t.getCharacter().getRadius() * LevelLoader.getFloat("COLLISION_SCALE_X", obj, Main.settings, key, 1.0f);
        float cscaley = (float)t.getCharacter().getHeight() * LevelLoader.getFloat("COLLISION_SCALE_Y", obj, Main.settings, key, 1.0f);
        t.setCharacterSize((int)cscalex, (int)cscaley);
        t.initStaySprite();
        return t;
    }

    public static void loadRM(Stringer txt, RoomObject obj, Stringer lvl, String key) {
        LevelLoader.loadRM(txt, obj, lvl, key, "");
    }

    public static void loadRM(Stringer txt, RoomObject obj, Stringer lvl, String key, String bN) {
        String tmp = LevelLoader.getString(bN + "ACTIVABLE", txt, Main.settings, key);
        if (tmp != null) {
            obj.activable = tmp.equals("1");
        }
        if ((tmp = LevelLoader.getString(bN + "CLICKABLE", txt, Main.settings, key)) != null) {
            obj.clickable = tmp.equals("1");
        }
        if ((tmp = LevelLoader.getString(bN + "SINGLEUSE", txt, Main.settings, key)) != null) {
            obj.singleUse = tmp.equals("1");
        }
        if ((tmp = LevelLoader.getString(bN + "DESTROYONUSE", txt, Main.settings, key)) != null) {
            obj.destroyOnUse = tmp.equals("1");
        }
        if ((tmp = LevelLoader.getString(bN + "NAME", txt, Main.settings, key)) != null) {
            obj.name = tmp;
        }
        if ((tmp = LevelLoader.getString(bN + "DESC", txt, Main.settings, key)) != null) {
            obj.desc = tmp;
        }
        if ((tmp = LevelLoader.getString(bN + "NEED", txt, Main.settings, key)) != null) {
            obj.need = Mesh.cutOnStrings(tmp, ',');
        }
        if ((tmp = LevelLoader.getString(bN + "ON_ACTIVATE", txt, Main.settings, key)) != null) {
            obj.additional = LevelLoader.loadScriptFromFile(tmp);
        }
        if ((tmp = LevelLoader.getString(bN + "ALWAYS_ACTIVATE", txt, Main.settings, key)) != null) {
            obj.alwaysActivate = tmp.equals("1");
        }
        if ((tmp = LevelLoader.getString(bN + "MESSAGE", txt, Main.settings, key)) != null) {
            obj.message = DialogScreen.loadTextFromFile(tmp);
        }
        if ((tmp = LevelLoader.getString(bN + "ERRMESSAGE", txt, Main.settings, key)) != null) {
            obj.errMessage = DialogScreen.loadTextFromFile(tmp);
        }
        if ((tmp = LevelLoader.getString(bN + "RADIUS", txt, Main.settings, key)) != null) {
            obj.radius = Stringer.parseLong(tmp);
        }
        if ((tmp = LevelLoader.getString(bN + "MESSAGETIMEOUT", txt, Main.settings, key)) != null) {
            obj.messageTimeOut = Stringer.parseLong(tmp);
        }
        if ((tmp = LevelLoader.getString(bN + "MESSAGETYPE", txt, Main.settings, key)) != null) {
            obj.messageType = Stringer.parseInt(tmp);
        }
        if ((tmp = LevelLoader.getString(bN + "ERRMESSAGETIMEOUT", txt, Main.settings, key)) != null) {
            obj.messageTimeOut = Stringer.parseLong(tmp);
        }
        if ((tmp = LevelLoader.getString(bN + "ERRMESSAGETYPE", txt, Main.settings, key)) != null) {
            obj.messageType = Stringer.parseInt(tmp);
        }
        if ((tmp = LevelLoader.getString(bN + "MSGDELAY", txt, Main.settings, key)) != null) {
            obj.messageDelay = Stringer.parseLong(tmp);
        }
        if ((tmp = LevelLoader.getString(bN + "REUSETIMER", txt, Main.settings, key)) != null) {
            obj.lastActivate = 0L;
            obj.timeToReset = Stringer.parseLong(tmp);
            obj.hideWhenUnusable = true;
        }
        if ((tmp = LevelLoader.getString(bN + "HIDEREUSE", txt, Main.settings, key)) != null) {
            obj.hideWhenUnusable = tmp.equals("1");
        }
        if ((tmp = LevelLoader.getString(bN + "ERRMSGDELAY", txt, Main.settings, key)) != null) {
            obj.errMessageDelay = Stringer.parseLong(tmp);
        }
        if ((tmp = LevelLoader.getString(bN + "NEEDTOPOINT", txt, Main.settings, key)) != null) {
            if (tmp.equals("1")) {
                obj.needToPoint = true;
            } else if (tmp.equals("2")) {
                obj.needToPoint = true;
                obj.squarePoint = true;
            }
        }
        if (obj.needToPoint && (obj instanceof SpriteObject || obj instanceof MeshObject || obj instanceof NPC)) {
            obj.dynamicPoint = true;
        }
        if ((tmp = LevelLoader.getString(bN + "DYNAMICPOINT", txt, Main.settings, key)) != null) {
            obj.dynamicPoint = tmp.equals("1");
        }
        if (obj.needToPoint && !obj.dynamicPoint) {
            GameObject mo;
            if (obj instanceof SpriteObject) {
                SpriteObject spr = (SpriteObject)obj;
                obj.pointRadius = spr.spr.getWidth() / 2;
                obj.pointHeight = spr.spr.getHeight() / 2;
                obj.pointOffset = new Vector3D(0, spr.spr.getHeight() / 2 + spr.spr.offsetY, 0);
            } else if (obj instanceof MeshObject) {
                mo = (MeshObject)obj;
                int sizex = mo.animation.getMesh().maxX() - mo.animation.getMesh().minX();
                int sizey = mo.animation.getMesh().maxY() - mo.animation.getMesh().minY();
                int sizez = mo.animation.getMesh().maxZ() - mo.animation.getMesh().minZ();
                obj.pointRadius = (sizex + sizez) / 4;
                obj.pointHeight = sizey / 2;
                obj.pointOffset = new Vector3D(mo.animation.getMesh().maxX() - sizex / 2, mo.animation.getMesh().maxY() - sizey / 2, mo.animation.getMesh().maxZ() - sizez / 2);
            } else if (obj instanceof NPC) {
                mo = (NPC)obj;
                int sizex = ((NPC)mo).meshImage.getMesh().maxX() - ((NPC)mo).meshImage.getMesh().minX();
                int sizey = ((NPC)mo).meshImage.getMesh().maxY() - ((NPC)mo).meshImage.getMesh().minY();
                int sizez = ((NPC)mo).meshImage.getMesh().maxZ() - ((NPC)mo).meshImage.getMesh().minZ();
                obj.pointRadius = (sizex + sizez) / 4;
                obj.pointHeight = sizey / 2;
                obj.pointOffset = new Vector3D(((NPC)mo).meshImage.getMesh().maxX() - sizex / 2, ((NPC)mo).meshImage.getMesh().maxY() - sizey / 2, ((NPC)mo).meshImage.getMesh().maxZ() - sizez / 2);
            }
        }
        if ((tmp = LevelLoader.getString(bN + "POINTRADIUS", txt, Main.settings, key)) != null) {
            obj.pointHeight = obj.pointRadius = Stringer.parseInt(tmp);
        }
        if ((tmp = LevelLoader.getString(bN + "POINTHEIGHT", txt, Main.settings, key)) != null) {
            obj.pointHeight = Stringer.parseInt(tmp);
        }
        if ((tmp = LevelLoader.getString(bN + "POINTOFFSET", txt, Main.settings, key)) != null) {
            int[] ps = Mesh.cutOnInts(tmp, ',');
            obj.pointOffset = new Vector3D(ps[0], ps[1], ps[2]);
        }
        if ((tmp = LevelLoader.getString(bN + "SOUND_ON_ACTIVATE", txt, Main.settings, key)) != null) {
            obj.sound = tmp;
            if (Main.isSounds && Main.sounds != 0) {
                Asset.getSound(tmp);
            }
        }
        if ((tmp = LevelLoader.getString(bN + "VISIBLE", txt, Main.settings, key)) != null) {
            obj.visible = tmp.equals("1");
        }
        obj.activateOnlyOne = LevelLoader.getInt(bN + "ACTIVATE_ONLY_THIS", txt, Main.settings, key, lvl, 0) == 1;
        obj.reloadDestroy = LevelLoader.getInt(bN + "DESTROY_ON_LEVEL_RELOAD", txt, Main.settings, key, lvl, 1) == 1;
        tmp = LevelLoader.getString(bN + "ROOM_ID", txt, Main.settings, key);
        if (tmp != null) {
            obj.setNewPart(Stringer.parseInt(tmp));
        }
    }

    private static String getString(String s, Stringer s1, Stringer s2) {
        String ss = s1.getString(s);
        if (ss != null) {
            return ss;
        }
        if (s2 != null && (ss = s2.getString(s)) != null) {
            return ss;
        }
        return null;
    }

    private static String getString2(String s, Stringer s1, Stringer s2) {
        String ss = s1.getString2(s);
        if (ss != null) {
            return ss;
        }
        if (s2 != null && (ss = s2.getString2(s)) != null) {
            return ss;
        }
        return null;
    }

    private static int getInt(String s, Stringer s1, Stringer s2) {
        if (s1.getString(s) != null) {
            return s1.getInt(s);
        }
        if (s2 != null && s2.getString(s) != null) {
            return s2.getInt(s);
        }
        return 0;
    }

    private static int getInt(String s, Stringer s1, Stringer s2, int def) {
        if (s1.getString(s) != null) {
            return s1.getInt(s);
        }
        if (s2 != null && s2.getString(s) != null) {
            return s2.getInt(s);
        }
        return def;
    }

    private static float getFloat(String s, Stringer s1, Stringer s2) {
        if (s1.getString(s) != null) {
            return s1.getFloat(s);
        }
        if (s2 != null && s2.getString(s) != null) {
            return s2.getFloat(s);
        }
        return 0.0f;
    }

    private static String getString(String s, Stringer s1, Stringer s2, String key) {
        String ss = s1.getString(s);
        if (ss != null) {
            return ss;
        }
        if (s2 != null && (ss = s2.getString(key + s)) != null) {
            return ss;
        }
        if (s2 != null && (ss = s2.getString(s)) != null) {
            return ss;
        }
        return null;
    }

    private static String getString(String s, Stringer s1, Stringer s2, String key, String def) {
        String ss = s1.getString(s);
        if (ss != null) {
            return ss;
        }
        if (s2 != null && (ss = s2.getString(key + s)) != null) {
            return ss;
        }
        if (s2 != null && (ss = s2.getString(s)) != null) {
            return ss;
        }
        return def;
    }

    private static String getStringdef(String s, Stringer s1, Stringer s2, String def) {
        String ss = s1.getString(s);
        if (ss != null) {
            return ss;
        }
        if (s2 != null && (ss = s2.getString(s)) != null) {
            return ss;
        }
        return def;
    }

    private static String getString2(String s, Stringer s1, Stringer s2, String key) {
        String ss = s1.getString(s);
        if (ss != null) {
            return ss;
        }
        if (s2 != null && (ss = s2.getString2(key + s)) != null) {
            return ss;
        }
        if (s2 != null && (ss = s2.getString2(s)) != null) {
            return ss;
        }
        return null;
    }

    private static int getInt(String s, Stringer s1, Stringer s2, String key) {
        if (s1.getString(s) != null) {
            return s1.getInt(s);
        }
        if (s2 != null && s2.getString(key + s) != null) {
            return s2.getInt(key + s);
        }
        if (s2 != null && s2.getString(s) != null) {
            return s2.getInt(s);
        }
        return 0;
    }

    private static int getInt(String s, Stringer s1, Stringer s2, String key, int def) {
        if (s1.getString(s) != null) {
            return s1.getInt(s);
        }
        if (s2 != null && s2.getString(key + s) != null) {
            return s2.getInt(key + s);
        }
        if (s2 != null && s2.getString(s) != null) {
            return s2.getInt(s);
        }
        return def;
    }

    private static int getInt(String s, Stringer s1, Stringer s2, String key, Stringer lvl, int def) {
        if (s1.getString(s) != null) {
            return s1.getInt(s);
        }
        if (s2 != null && s2.getString(key + s) != null) {
            return s2.getInt(key + s);
        }
        if (lvl != null && lvl.getString(s) != null) {
            return lvl.getInt(s);
        }
        if (s2 != null && s2.getString(s) != null) {
            return s2.getInt(s);
        }
        return def;
    }

    private static float getFloat(String s, Stringer s1, Stringer s2, float def) {
        if (s1.getString(s) != null) {
            return s1.getFloat(s);
        }
        if (s2 != null && s2.getString(s) != null) {
            return s2.getFloat(s);
        }
        return def;
    }

    private static float getFloat(String s, Stringer s1, float def) {
        if (s1.getString(s) != null) {
            return s1.getFloat(s);
        }
        return def;
    }

    private static long getLong(String s, Stringer s1, Stringer s2, String key) {
        if (s1.getString(s) != null) {
            return s1.getLong(s);
        }
        if (s2 != null && s2.getString(key + s) != null) {
            return s2.getLong(key + s);
        }
        if (s2 != null && s2.getString(s) != null) {
            return s2.getLong(s);
        }
        return 0L;
    }

    private static long getLong(String s, Stringer s1, Stringer s2, String key, long def) {
        if (s1.getString(s) != null) {
            return s1.getLong(s);
        }
        if (s2 != null && s2.getString(key + s) != null) {
            return s2.getLong(key + s);
        }
        if (s2 != null && s2.getString(s) != null) {
            return s2.getLong(s);
        }
        return def;
    }

    private static float getFloat(String s, Stringer s1, Stringer s2, String key) {
        if (s1.getString(s) != null) {
            return s1.getFloat(s);
        }
        if (s2 != null && s2.getString(key + s) != null) {
            return s2.getFloat(key + s);
        }
        if (s2 != null && s2.getString(s) != null) {
            return s2.getFloat(s);
        }
        return 0.0f;
    }

    private static float getFloat(String s, Stringer s1, Stringer s2, String key, float def) {
        if (s1.getString(s) != null) {
            return s1.getFloat(s);
        }
        if (s2 != null && s2.getString(key + s) != null) {
            return s2.getFloat(key + s);
        }
        if (s2 != null && s2.getString(s) != null) {
            return s2.getFloat(s);
        }
        return def;
    }

    public static String[] createScript(String str) {
        Vector<Object> tmp = new Vector<Object>();
        Object[] strs = Mesh.cutOnStrings(str, '\n');
        for (int i = 0; i < strs.length; ++i) {
            if (strs[i] == null || strs[i].indexOf("//") == 0 || ((String)strs[i]).equals(" ")) continue;
            if (((String)strs[i]).indexOf("//") > 0) {
                strs[i] = ((String)strs[i]).substring(0, ((String)strs[i]).indexOf("//"));
            }
            Stringer.removeEmpty((String)strs[i]);
            Stringer.removeSpaces((String)strs[i]);
            if ((((String)strs[i]).charAt(0) == '}' || ((String)strs[i]).charAt(0) == '{') && ((String)strs[i]).length() > 1) {
                tmp.addElement(((String)strs[i]).substring(1, ((String)strs[i]).length()));
                tmp.addElement(((String)strs[i]).substring(0, 1));
                continue;
            }
            if ((((String)strs[i]).charAt(((String)strs[i]).length() - 1) == '}' || ((String)strs[i]).charAt(((String)strs[i]).length() - 1) == '{') && ((String)strs[i]).length() > 1) {
                tmp.addElement(((String)strs[i]).substring(0, ((String)strs[i]).length() - 1));
                tmp.addElement(((String)strs[i]).substring(((String)strs[i]).length() - 1, ((String)strs[i]).length()));
                continue;
            }
            tmp.addElement(strs[i]);
        }
        strs = new String[tmp.size()];
        tmp.copyInto(strs);
        return strs;
    }

    public static String[] loadScriptFromFile(String text) {
        if (text == null) {
            return null;
        }
        if (text.charAt(0) != '/' || !text.toLowerCase().endsWith(".txt")) {
            return Mesh.cutOnStrings(text, ';');
        }
        text = Mesh.getStringFromResource(text);
        return LevelLoader.createScript(text);
    }
}

