/*
 * Decompiled with CFR 0.152.
 */
package code.Gameplay.Objects;

import code.AI.Player;
import code.Gameplay.GameScreen;
import code.Gameplay.Map.House;
import code.Gameplay.Map.RoomObject;
import code.Rendering.DirectX7;
import code.Rendering.Meshes.Sprite;
import code.utils.Asset;
import code.utils.Main;
import code.utils.QFPS;

public final class SpriteObject
extends RoomObject {
    public Sprite spr = new Sprite(0);
    public int addsz = 2000;
    public boolean[] flicker = null;
    public int[] colorFlicker = null;
    private int intframe = 0;

    public final void destroy() {
        this.spr.destroy();
    }

    public final void render(DirectX7 g3d, int x1, int y1, int x2, int y2) {
        if (!this.visible) {
            return;
        }
        if (this.lastActivate > 0L && this.lastActivate + this.timeToReset > GameScreen.time && this.hideWhenUnusable) {
            return;
        }
        this.spr.updateFrame();
        this.spr.project(g3d.getInvCamera(), g3d);
        if (!this.spr.isVisible(x1, y1, x2, y2)) {
            return;
        }
        int oldFrame = this.intframe;
        this.intframe += 100 * QFPS.frameTime / 50;
        if (this.flicker != null && !this.flicker[oldFrame / 125 % this.flicker.length]) {
            return;
        }
        if (this.colorFlicker != null) {
            this.spr.color = this.colorFlicker[oldFrame / 125 % this.colorFlicker.length];
        }
        g3d.addRenderObject(this.spr, x1, y1, x2, y2);
        this.spr.sz += this.addsz;
    }

    public final int getPosX() {
        return this.spr.getPosition().x;
    }

    public final int getPosZ() {
        return this.spr.getPosition().z;
    }

    public final int getPosY() {
        return this.spr.getPosition().y;
    }

    public final void setPos(int x, int y, int z) {
        this.spr.getPosition().set(x, y, z);
    }

    public void activate(House house, Player player, GameScreen gs) {
        if (this.lastActivate > 0L && this.lastActivate + this.timeToReset > GameScreen.time) {
            return;
        }
        if (!this.isAllCollected(Player.usedPoints, player, house, gs)) {
            if (this.errMessage != null) {
                this.errMsg(gs);
            }
            return;
        }
        if (this.sound != null && Main.isSounds && Main.sounds != 0) {
            Asset.getSound(this.sound).start(Main.sounds);
        }
        if (!(this.singleUse && this.activated || this.message == null)) {
            this.prMsg(gs);
        }
        if (!this.singleUse || !this.activated) {
            this.give(this.additional, player, house, gs);
        }
        if (!this.contains(Player.usedPoints, this.name)) {
            this.give(this.name, player);
            this.activated = true;
            if (this.lastActivate >= 0L) {
                this.lastActivate = GameScreen.time;
            }
        }
        if (this.destroyOnUse) {
            house.removeObject(this);
        }
    }
}

