/*
 * Decompiled with CFR 0.152.
 */
package com.Gameplay.Map;

import com.Gameplay.Map.House;
import com.Gameplay.Map.LightMapper;
import com.Gameplay.Map.Portal;
import com.Gameplay.Map.Room;
import com.Math.Vector3D;
import com.Rendering.Graphics3D;
import com.Rendering.Meshes.Mesh;
import com.Rendering.Meshes.Polygon3V;
import com.Rendering.Meshes.Polygon4V;
import com.Rendering.RenderObject;
import com.Rendering.Vertex;
import com.misc.Main;
import java.util.Vector;

public class HouseCreator {
    private static Main main;

    public static House create(Mesh[] meshes, boolean np, String lightdataFile) {
        if (meshes.length > 1) {
            int var3;
            RenderObject[] var1 = meshes[meshes.length - 1].getPoligons();
            Room[] var2 = new Room[meshes.length - 1];
            for (var3 = 0; var3 < var2.length; ++var3) {
                meshes[var3].optimize();
                var2[var3] = new Room(meshes[var3], var3);
            }
            if (lightdataFile != null && Graphics3D.fog == 9) {
                LightMapper.loadLightMap(meshes, lightdataFile);
            }
            for (var3 = 0; var3 < var2.length; ++var3) {
                Room var26;
                Room var10000 = var26 = var2[var3];
                RenderObject[] var5 = var1;
                Room var4 = var10000;
                Vector<Portal> var6 = new Vector<Portal>();
                for (int var7 = 0; var7 < var5.length; ++var7) {
                    Vertex[] var28;
                    RenderObject var9 = var5[var7];
                    if (var9 instanceof Polygon3V) {
                        Polygon3V var10 = (Polygon3V)var9;
                        var28 = new Vertex[]{var10.a, var10.b, var10.c};
                    } else if (var9 instanceof Polygon4V) {
                        Polygon4V var35 = (Polygon4V)var9;
                        var28 = new Vertex[]{var35.a, var35.b, var35.c, var35.d};
                    } else {
                        var28 = null;
                    }
                    Vertex[] var8 = var28;
                    if (!HouseCreator.isExistsCommonCoords(var4.getMesh(), var8)) continue;
                    Mesh var36 = var4.getMesh();
                    Vector3D var34 = HouseCreator.computeCentre(var36.getVertices());
                    Vector3D var11 = HouseCreator.computeCentre(var8);
                    Vertex var27 = var8[0];
                    Vertex var10001 = var8[1];
                    Vertex var31 = var8[2];
                    Vertex var13 = var10001;
                    Vertex var12 = var27;
                    long var18 = (long)(var27.y - var13.y) * (long)(var12.z - var31.z) - (long)(var12.z - var13.z) * (long)(var12.y - var31.y);
                    long var20 = (long)(var12.z - var13.z) * (long)(var12.x - var31.x) - (long)(var12.x - var13.x) * (long)(var12.z - var31.z);
                    long var22 = (long)(var12.x - var13.x) * (long)(var12.y - var31.y) - (long)(var12.y - var13.y) * (long)(var12.x - var31.x);
                    double var24 = Math.sqrt(var18 * var18 + var20 * var20 + var22 * var22) / 4096.0;
                    int var33 = (int)((double)var18 / var24);
                    int var37 = (int)((double)var20 / var24);
                    int var38 = (int)((double)var22 / var24);
                    Vector3D var32 = new Vector3D(var33, var37, var38);
                    var34.x -= var11.x;
                    var34.y -= var11.y;
                    var34.z -= var11.z;
                    if (var32.dot(var34) >= 0) {
                        HouseCreator.reverse(var8);
                    }
                    var6.addElement(new Portal(var8));
                }
                Object[] var30 = new Portal[var6.size()];
                var6.copyInto(var30);
                var4.setPortals((Portal[])var30);
                HouseCreator.findRooms(var26, var2);
            }
            HouseCreator.countPortals(var2);
            Room[][] var29 = HouseCreator.createNeighbours(var2);
            House house = new House(var2, var29);
            if (lightdataFile == null && Graphics3D.fog == 9) {
                LightMapper.generateLightMap(house, meshes);
                LightMapper.saveLightMap(meshes, lightdataFile);
            }
            return house;
        }
        RenderObject[] var1 = meshes[meshes.length].getPoligons();
        Room[] var2 = new Room[meshes.length];
        var2[0] = new Room(meshes[0], 0);
        HouseCreator.countPortals(var2);
        return new House(var2, null);
    }

    private static void countPortals(Room[] rooms) {
        int var1 = 0;
        int var2 = 0;
        for (int var3 = 0; var3 < rooms.length; ++var3) {
            Portal[] var4 = rooms[var3].getPortals();
            if (var4 == null || var4.length == 0) {
                ++var2;
            }
            for (int var5 = 0; var5 < var4.length; ++var5) {
                if (var4[var5].getRoom() != null) continue;
                ++var1;
            }
        }
        if (var1 > 0) {
            System.out.println("HouseCreator: " + var1 + " \u043f\u043e\u0440\u0442\u0430\u043b\u0430\u043c \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b \u043a\u043e\u043c\u043d\u0430\u0442\u044b");
        }
        if (var2 > 0) {
            System.out.println("HouseCreator: " + var2 + " \u043a\u043e\u043c\u043d\u0430\u0442\u0430\u043c \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b \u043f\u043e\u0440\u0442\u0430\u043b\u044b");
        }
    }

    private static Vector3D computeCentre(Vertex[] vertices) {
        long var1 = 0L;
        long var3 = 0L;
        long var5 = 0L;
        for (int var7 = 0; var7 < vertices.length; ++var7) {
            Vertex var8 = vertices[var7];
            var1 += (long)var8.x;
            var3 += (long)var8.y;
            var5 += (long)var8.z;
        }
        return new Vector3D((int)(var1 /= (long)vertices.length), (int)(var3 /= (long)vertices.length), (int)(var5 /= (long)vertices.length));
    }

    private static void reverse(Vertex[] vertices) {
        Vertex[] var1 = new Vertex[vertices.length];
        for (int var2 = 0; var2 < var1.length; ++var2) {
            var1[var2] = vertices[vertices.length - 1 - var2];
        }
        System.arraycopy(var1, 0, vertices, 0, var1.length);
    }

    private static void findRooms(Room room, Room[] rooms) {
        Portal[] var2 = room.getPortals();
        block0: for (int var3 = 0; var3 < var2.length; ++var3) {
            Portal var4 = var2[var3];
            for (int var5 = 0; var5 < rooms.length; ++var5) {
                Room var6 = rooms[var5];
                if (var6 == room || !HouseCreator.isExistsCommonCoords(var6.getMesh(), var4.getVertices())) {
                    continue;
                }
                var4.setRoom(var6);
                continue block0;
            }
        }
    }

    private static Room[][] createNeighbours(Room[] rooms) {
        Room[][] neighbours = new Room[rooms.length][];
        for (int i = 0; i < neighbours.length; ++i) {
            Vector vRooms = HouseCreator.getRooms(rooms[i]);
            neighbours[i] = new Room[vRooms.size()];
            vRooms.copyInto(neighbours[i]);
        }
        return neighbours;
    }

    private static Vector getRooms(Room room) {
        Portal[] portals = room.getPortals();
        Vector<Room> rooms = new Vector<Room>();
        for (int i = 0; i < portals.length; ++i) {
            Portal p = portals[i];
            Room secondRoom = p.getRoom();
            if (rooms.contains(secondRoom)) continue;
            rooms.addElement(secondRoom);
        }
        return rooms;
    }

    private static boolean isExistsCommonCoords(Mesh mesh, Vertex[] poly) {
        for (int var2 = 0; var2 < poly.length; ++var2) {
            boolean var10000;
            block3: {
                Vertex var4 = poly[var2];
                Vertex[] var3 = mesh.getVertices();
                for (int var5 = 0; var5 < var3.length; ++var5) {
                    Vertex var6 = var3[var5];
                    if (var6.x / 50 != var4.x / 50 || var6.y / 50 != var4.y / 50 || var6.z / 50 != var4.z / 50) {
                        continue;
                    }
                    var10000 = true;
                    break block3;
                }
                var10000 = false;
            }
            if (!var10000) continue;
            return true;
        }
        return false;
    }
}

