/*
 * Decompiled with CFR 0.152.
 */
package com.Gameplay.Map;

import com.Gameplay.Map.Room;
import com.Math.MathUtils;
import com.Math.Matrix;
import com.Math.Vector3D;
import com.Rendering.Graphics3D;
import com.Rendering.Meshes.Polygon3V;
import com.Rendering.Meshes.Polygon4V;
import com.Rendering.RenderObject;
import com.Rendering.Vertex;
import javax.microedition.lcdui.Graphics;

public class Portal {
    public Room room;
    private Vertex[] vers;
    private Vertex[] proj;
    private int size;
    private Vector3D nor;
    private int minx;
    private int maxx;
    private int miny;
    private int maxy;
    private int minz;
    private int maxz;
    private boolean[] overlappVertexs = new boolean[8];
    private boolean overlappCentre;
    private int centreX;
    private int centreY;

    public Vertex[] getVertices() {
        return this.vers;
    }

    public Portal(Vertex[] portal) {
        this.vers = portal;
        this.nor = this.createNormal(this.vers[0], this.vers[1], this.vers[2]);
        if (portal.length != 4) {
            System.out.println("PORTAL: \u043f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435: \u043d\u0435\u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0432\u0435\u0440\u0448\u0438\u043d \u0432 \u043f\u043e\u0440\u0442\u0430\u043b\u0435 " + portal.length);
        }
        this.proj = new Vertex[8];
        for (int i = 0; i < this.proj.length; ++i) {
            this.proj[i] = new Vertex();
        }
    }

    private Vector3D createNormal(Vertex a, Vertex b, Vertex c) {
        Vector3D nor = new Vector3D();
        MathUtils.calcNormal(nor, a.x, a.y, a.z, b.x, b.y, b.z, c.x, c.y, c.z);
        return nor;
    }

    public void destroy() {
        this.room = null;
        for (int i = 0; i < this.vers.length; ++i) {
            this.vers[i] = null;
        }
        this.vers = null;
        this.proj = null;
    }

    public final Vertex[] getPortal() {
        return this.vers;
    }

    public final Room getRoom() {
        return this.room;
    }

    public final void setRoom(Room r) {
        this.room = r;
    }

    public final int getMinX() {
        return this.minx;
    }

    public final int getMinY() {
        return this.miny;
    }

    public final int getMaxX() {
        return this.maxx;
    }

    public final int getMaxY() {
        return this.maxy;
    }

    public final boolean isVisible(Graphics3D g3d, int x1, int y1, int x2, int y2) {
        Matrix cam = g3d.getCamera();
        if (this.distanceToPortal(cam.m03, cam.m13, cam.m23) < 500) {
            this.minx = x1;
            this.miny = y1;
            this.maxx = x2;
            this.maxy = y2;
            this.size = 2000;
            return true;
        }
        this.size = Portal.proj(g3d, x1, y1, x2, y2, this.vers, this.proj);
        if (this.size < 3) {
            return this.isVisible2(g3d, x1, y1, x2, y2);
        }
        if (this.maxx - this.minx > 200 || this.maxy - this.miny > 200) {
            return this.isVisible2(g3d, x1, y1, x2, y2);
        }
        return this.isVisible2(g3d, x1, y1, x2, y2);
    }

    private int distanceToPortal(int px, int py, int pz) {
        Vertex a = this.vers[0];
        int dx = px - a.x;
        int dy = py - a.y;
        int dz = pz - a.z;
        return Math.abs(dx * this.nor.x + dy * this.nor.y + dz * this.nor.z >> 12);
    }

    private final boolean isVisible2(Graphics3D g3d, int x1, int y1, int x2, int y2) {
        Vertex v = this.proj[0];
        this.maxx = v.sx;
        this.minx = v.sx;
        this.maxy = v.sy;
        this.miny = v.sy;
        this.minz = v.rz;
        this.maxz = v.rz;
        for (int i = 1; i < this.size; ++i) {
            v = this.proj[i];
            if (v.sx < this.minx) {
                this.minx = v.sx;
            }
            if (v.sx > this.maxx) {
                this.maxx = v.sx;
            }
            if (v.sy < this.miny) {
                this.miny = v.sy;
            }
            if (v.sy > this.maxy) {
                this.maxy = v.sy;
            }
            if (v.rz < this.minz) {
                this.minz = v.rz;
            }
            if (v.rz <= this.maxz) continue;
            this.maxz = v.rz;
        }
        return this.maxx >= x1 && this.maxy >= y1 && this.minx <= x2 && this.miny <= y2 && this.minz <= 0 && -this.maxz <= Graphics3D.drDist;
    }

    private final boolean isNeighbor(RenderObject el) {
        if (el instanceof Polygon3V) {
            Polygon3V p = (Polygon3V)el;
            if (this.isMyVertex(p.a)) {
                return true;
            }
            if (this.isMyVertex(p.b)) {
                return true;
            }
            if (this.isMyVertex(p.c)) {
                return true;
            }
        } else if (el instanceof Polygon4V) {
            Polygon4V p = (Polygon4V)el;
            if (this.isMyVertex(p.a)) {
                return true;
            }
            if (this.isMyVertex(p.b)) {
                return true;
            }
            if (this.isMyVertex(p.c)) {
                return true;
            }
            if (this.isMyVertex(p.d)) {
                return true;
            }
        }
        return false;
    }

    private final boolean isMyVertex(Vertex v) {
        int E = 400;
        for (int i = 0; i < this.vers.length; ++i) {
            Vertex t = this.vers[i];
            int dx = t.x - v.x;
            int dy = t.y - v.y;
            int dz = t.z - v.z;
            if (dx < 0) {
                dx = -dx;
            }
            if (dy < 0) {
                dy = -dy;
            }
            if (dz < 0) {
                dz = -dz;
            }
            if (dx >= 400 || dy >= 400 || dz >= 400) continue;
            return true;
        }
        return false;
    }

    private static final boolean isFaceToDisplay(int x1, int y1, int x2, int y2, int x3, int y3) {
        return (x1 - x2) * (y2 - y3) > (y1 - y2) * (x2 - x3);
    }

    public void paint(Graphics g, int x, int y) {
        Vertex a;
        int i;
        if (this.room != null) {
            g.setColor(0xFF0000);
        } else {
            g.setColor(0);
        }
        for (i = 0; i < this.size; ++i) {
            a = this.proj[i];
            Vertex b = this.proj[(i + 1) % this.size];
            g.drawLine(a.sx + x, a.sy + y, b.sx + x, b.sy + y);
        }
        g.setColor(0);
        for (i = 0; i < this.size; ++i) {
            if (!this.overlappVertexs[i]) continue;
            a = this.proj[i];
            g.fillRect(a.sx + x, a.sy + y, 3, 3);
        }
        if (this.overlappCentre && this.size != 0) {
            g.fillRect(this.centreX + x, this.centreY + y, 3, 3);
        }
    }

    static final int proj(Graphics3D g3d, int x1, int y1, int x2, int y2, Vertex[] srcVers, Vertex[] bufProj) {
        int i;
        Matrix invCam = g3d.getInvCamera();
        for (int i2 = 0; i2 < srcVers.length; ++i2) {
            srcVers[i2].transform(invCam);
        }
        int size = 0;
        for (i = 0; i < srcVers.length; ++i) {
            int na = i;
            int nb = i + 1;
            if (nb > srcVers.length - 1) {
                nb = 0;
            }
            Vertex a = srcVers[na];
            Vertex b = srcVers[nb];
            if (a.rz > 0 && b.rz > 0) continue;
            if (a.rz < 0 && b.rz < 0) {
                Portal.setVertex(bufProj[size], a);
                ++size;
            }
            if (a.rz < 0 && b.rz > 0) {
                Portal.setVertex(bufProj[size], a);
                Portal.intersection(a, b, bufProj[++size]);
                ++size;
            }
            if (a.rz <= 0 || b.rz >= 0) continue;
            Portal.intersection(a, b, bufProj[size]);
            ++size;
        }
        for (i = 0; i < size; ++i) {
            Vertex v = bufProj[i];
            v.project(g3d);
            if (v.rz < 0) continue;
            if (v.sx > x1 && v.sx < x2) {
                int n = v.sx = v.sx > (x2 + x1) / 2 ? x2 : x1;
            }
            if (v.sy <= y1 || v.sy >= y2) continue;
            v.sy = v.sy > (y2 + y1) / 2 ? y2 : y1;
        }
        for (i = 0; i < size; ++i) {
            Vertex bb;
            Vertex aa;
            Vertex a = Portal.getVertex(bufProj, size, i);
            Vertex b = Portal.getVertex(bufProj, size, i + 1);
            if (a.sx < x1 && b.sx < x1) {
                aa = Portal.getVertex(bufProj, size, i - 1);
                bb = Portal.getVertex(bufProj, size, i + 2);
                Portal.setX(a, aa, x1);
                Portal.setX(b, bb, x1);
            }
            if (a.sx <= x2 || b.sx <= x2) continue;
            aa = Portal.getVertex(bufProj, size, i - 1);
            bb = Portal.getVertex(bufProj, size, i + 2);
            Portal.setX(a, aa, x2 - 1);
            Portal.setX(b, bb, x2 - 1);
        }
        return size;
    }

    private static final Vertex getVertex(Vertex[] vers, int size, int i) {
        if (i < 0) {
            i += size;
        }
        return vers[i %= size];
    }

    private static final void setX(Vertex a, Vertex b, int x) {
        a.sy = Portal.calcY(a, b, x);
        a.sx = x;
    }

    private static final int calcX(Vertex a, Vertex b, int y) {
        if (a.sx == b.sx || a.sy == b.sy) {
            return a.sy;
        }
        int dx = (b.sx - a.sx << 12) / (b.sy - a.sy);
        return a.sx + (dx * (y - a.sy) >> 12);
    }

    private static final int calcY(Vertex a, Vertex b, int x) {
        if (a.sx == b.sx || a.sy == b.sy) {
            return a.sy;
        }
        int dy = (b.sy - a.sy << 12) / (b.sx - a.sx);
        return a.sy + (dy * (x - a.sx) >> 12);
    }

    private static final void intersection(Vertex a, Vertex b, Vertex res) {
        int fp = 12;
        int zlen = b.rz - a.rz;
        if (zlen == 0) {
            zlen = 1;
        }
        int dx = (b.sx - a.sx << 12) / zlen;
        int dy = (b.sy - a.sy << 12) / zlen;
        int x = a.sx - (dx * a.rz >> 12);
        int y = a.sy - (dy * a.rz >> 12);
        res.x = res.sx = x;
        res.y = res.sy = y;
        res.rz = 0;
        res.z = 0;
    }

    private static final void setVertex(Vertex res, Vertex src) {
        res.x = res.sx = src.sx;
        res.y = res.sy = src.sy;
        res.z = res.rz = src.rz;
    }
}

