/*
 * Decompiled with CFR 0.152.
 */
package com.Rendering.Meshes;

import com.Math.MathUtils;
import com.Rendering.Graphics3D;
import com.Rendering.Meshes.Polygon3V;
import com.Rendering.Texture;
import com.Rendering.TexturingAffine;
import com.Rendering.TexturingPers;
import com.Rendering.Vertex;
import com.misc.Main;

public class LightedPolygon3V
extends Polygon3V {
    public byte la;
    public byte lb;
    public byte lc = (byte)-128;
    private static int q;
    private static int sz2;
    private static short sizex;
    private static short sizey;
    private static short sizeu;
    private static short sizev;
    private static byte addmip;
    private static byte fog;

    public LightedPolygon3V(Vertex a2, Vertex b2, Vertex c2, byte au, byte av, byte bu, byte bv, byte cu, byte cv) {
        super(a2, b2, c2, au, av, bu, bv, cu, cv);
        this.lb = (byte)-128;
        this.la = (byte)-128;
    }

    public final void render(Graphics3D g3d, Texture texture) {
        if (Main.persQ == 0 && !Main.mipMapping) {
            this.renderFast(g3d, texture);
            return;
        }
        fog = texture.drawmode;
        sizex = (short)LightedPolygon3V.size(this.a.sx, this.b.sx, this.c.sx);
        sizey = (short)LightedPolygon3V.size(this.a.sy, this.b.sy, this.c.sy);
        int la2 = this.getLight(this.a, this.la, g3d);
        int lb2 = this.getLight(this.b, this.lb, g3d);
        int lc2 = this.getLight(this.c, this.lc, g3d);
        if (fog == 5) {
            sz2 = 255 - MathUtils.calcLight(this.nx, this.ny, this.nz, Graphics3D.lightdirx, Graphics3D.lightdiry, Graphics3D.lightdirz);
        }
        if (fog == 1) {
            this.szCalcfogAdd();
        }
        int n = q = this.ny > 4000 || this.ny < -4000 ? 9999999 : Main.q;
        if (Main.mipMapping && texture.mip != null) {
            if (texture.drawmode < 10) {
                addmip = (byte)(this.ny > 4000 || this.ny < -4000 ? 2 : 3);
                if ((sizex + sizey >> 1) * addmip < (sizeu = (short)(LightedPolygon3V.size(this.au & 0xFF, this.bu & 0xFF, this.cu & 0xFF) * texture.rImg.w >> 8)) + (sizev = (short)(LightedPolygon3V.size(this.av & 0xFF, this.bv & 0xFF, this.cv & 0xFF) * texture.rImg.h >> 8))) {
                    texture = texture.mip;
                    if (texture.mip != null && (sizex + sizey >> 1) * addmip < (sizeu = (short)(sizeu >> 1)) + (sizev = (short)(sizev >> 1))) {
                        texture = texture.mip;
                    }
                }
            } else if (sizex < texture.rImg.w || sizey < texture.rImg.w) {
                texture = texture.mip;
                if (texture.mip != null && (sizex < texture.rImg.w || sizey < texture.rImg.w)) {
                    texture = texture.mip;
                }
            }
        }
        if (texture.perspectiveCorrection && (sizex > 30 - (Main.persQ < 3 ? 0 : 15) || sizey > 30 - (Main.persQ < 3 ? 0 : 15)) && Main.persQ != 0 || Main.persQ == 4) {
            TexturingPers.paint(g3d, texture, this.a, this.au & 0xFF, this.av & 0xFF, this.b, this.bu & 0xFF, this.bv & 0xFF, this.c, this.cu & 0xFF, this.cv & 0xFF, Graphics3D.fogc, fog, sz2, q, la2, lb2, lc2, this.nx, this.ny, this.nz);
        } else {
            TexturingAffine.paint(g3d, texture, this.a, this.au & 0xFF, this.av & 0xFF, this.b, this.bu & 0xFF, this.bv & 0xFF, this.c, this.cu & 0xFF, this.cv & 0xFF, Graphics3D.fogc, fog, sz2, la2, lb2, lc2, this.nx, this.ny, this.nz);
        }
    }

    public void renderFast(Graphics3D g3d, Texture texture) {
        if (texture.drawmode == 5 && (sz2 = 255 - MathUtils.calcLight(this.nx, this.ny, this.nz, Graphics3D.lightdirx, Graphics3D.lightdiry, Graphics3D.lightdirz)) < 0) {
            sz2 = 0;
        }
        if (texture.drawmode == 1 && fog == 1) {
            this.szCalcfogAdd();
        }
        TexturingAffine.paint(g3d, texture, this.a, this.au & 0xFF, this.av & 0xFF, this.b, this.bu & 0xFF, this.bv & 0xFF, this.c, this.cu & 0xFF, this.cv & 0xFF, Graphics3D.fogc, texture.drawmode, sz2, this.la + 128, this.lb + 128, this.lc + 128, this.nx, this.ny, this.nz);
    }

    private static final int size(int a, int b, int c) {
        int t;
        if (b < a) {
            t = a;
            a = b;
            b = t;
        }
        if (c < a) {
            t = c;
            c = a;
            a = t;
        }
        if (c < b) {
            t = b;
            b = c;
            c = t;
        }
        return c - a;
    }
}

