/*
 * Decompiled with CFR 0.152.
 */
package com.Rendering.Meshes;

import com.Rendering.Meshes.Mesh;
import com.Rendering.Meshes.Polygon3V;
import com.Rendering.Meshes.Polygon4V;
import com.Rendering.MultyTexture;
import com.Rendering.RenderObject;
import com.Rendering.Vertex;
import java.util.Vector;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class MeshClone {
    private int[] vertexCoords;
    private int[] poly3vData;
    private int[] poly4vData;
    private MultyTexture texture;

    public MeshClone(Mesh mesh) {
        Vertex[] var2 = mesh.getVertices();
        RenderObject[] var3 = mesh.getPoligons();
        this.vertexCoords = MeshClone.verticesToArray(var2);
        this.poly3vData = MeshClone.polygons3VToArray(var2, var3);
        this.poly4vData = MeshClone.polygons4VToArray(var2, var3);
        this.texture = mesh.getTexture();
    }

    public void destroy() {
        Object var2 = null;
        Object var3 = null;
        this.vertexCoords = null;
        this.poly3vData = null;
        this.poly4vData = null;
        this.texture = null;
    }

    private static int[] verticesToArray(Vertex[] vertices) {
        int[] var1 = new int[vertices.length * 3];
        for (int var2 = 0; var2 < vertices.length; ++var2) {
            Vertex var3 = vertices[var2];
            var1[var2 * 3] = var3.x;
            var1[var2 * 3 + 1] = var3.y;
            var1[var2 * 3 + 2] = var3.z;
        }
        return var1;
    }

    private static int[] polygons3VToArray(Vertex[] vertices, RenderObject[] polygons) {
        Vector<RenderObject> var2 = new Vector<RenderObject>();
        for (int var3 = 0; var3 < polygons.length; ++var3) {
            if (!(polygons[var3] instanceof Polygon3V)) continue;
            var2.addElement(polygons[var3]);
        }
        int[] var6 = new int[var2.size() * 10];
        for (int var5 = 0; var5 < var2.size(); ++var5) {
            Polygon3V var4 = (Polygon3V)var2.elementAt(var5);
            var6[var5 * 10] = MeshClone.search(vertices, var4.a);
            var6[var5 * 10 + 1] = MeshClone.search(vertices, var4.b);
            var6[var5 * 10 + 2] = MeshClone.search(vertices, var4.c);
            var6[var5 * 10 + 3] = var4.au;
            var6[var5 * 10 + 4] = var4.av;
            var6[var5 * 10 + 5] = var4.bu;
            var6[var5 * 10 + 6] = var4.bv;
            var6[var5 * 10 + 7] = var4.cu;
            var6[var5 * 10 + 8] = var4.cv;
            var6[var5 * 10 + 9] = var4.tex;
        }
        return var6;
    }

    private static int[] polygons4VToArray(Vertex[] vertices, RenderObject[] polygons) {
        Vector<RenderObject> var2 = new Vector<RenderObject>();
        for (int var3 = 0; var3 < polygons.length; ++var3) {
            if (!(polygons[var3] instanceof Polygon4V)) continue;
            var2.addElement(polygons[var3]);
        }
        int[] var6 = new int[var2.size() * 13];
        for (int var5 = 0; var5 < var2.size(); ++var5) {
            Polygon4V var4 = (Polygon4V)var2.elementAt(var5);
            var6[var5 * 13] = MeshClone.search(vertices, var4.a);
            var6[var5 * 13 + 1] = MeshClone.search(vertices, var4.b);
            var6[var5 * 13 + 2] = MeshClone.search(vertices, var4.c);
            var6[var5 * 13 + 3] = MeshClone.search(vertices, var4.d);
            var6[var5 * 13 + 4] = var4.au;
            var6[var5 * 13 + 5] = var4.av;
            var6[var5 * 13 + 6] = var4.bu;
            var6[var5 * 13 + 7] = var4.bv;
            var6[var5 * 13 + 8] = var4.cu;
            var6[var5 * 13 + 9] = var4.cv;
            var6[var5 * 13 + 10] = var4.du;
            var6[var5 * 13 + 11] = var4.dv;
            var6[var5 * 13 + 12] = var4.tex;
        }
        return var6;
    }

    private static int search(Object[] objs, Object obj) {
        for (int var2 = 0; var2 < objs.length; ++var2) {
            if (objs[var2] != obj) continue;
            return var2;
        }
        return -1;
    }

    public final Mesh copy() {
        short var9;
        short var8;
        short var7;
        int var6;
        int var5;
        int[] var3 = this.vertexCoords;
        Vertex[] var4 = new Vertex[this.vertexCoords.length / 3];
        for (var5 = 0; var5 < var4.length; ++var5) {
            var4[var5] = new Vertex(var3[var5 * 3], var3[var5 * 3 + 1], var3[var5 * 3 + 2]);
        }
        Vertex[] var1 = var4;
        Vertex[] var10000 = var4;
        int[] var13 = this.poly3vData;
        Vertex[] var11 = var10000;
        Polygon3V[] var16 = new Polygon3V[var13.length / 10];
        for (var6 = 0; var6 < var16.length; ++var6) {
            var7 = (short)var13[var6 * 10];
            var8 = (short)var13[var6 * 10 + 1];
            var9 = (short)var13[var6 * 10 + 2];
            var16[var6] = new Polygon3V(var11[var7], var11[var8], var11[var9], (byte)var13[var6 * 10 + 3], (byte)var13[var6 * 10 + 4], (byte)var13[var6 * 10 + 5], (byte)var13[var6 * 10 + 6], (byte)var13[var6 * 10 + 7], (byte)var13[var6 * 10 + 8]);
            var16[var6].tex = (byte)var13[var6 * 10 + 9];
        }
        Polygon3V[] var2 = var16;
        var13 = this.poly4vData;
        var11 = var1;
        Polygon4V[] var15 = new Polygon4V[var13.length / 13];
        for (var6 = 0; var6 < var15.length; ++var6) {
            var7 = (short)var13[var6 * 13];
            var8 = (short)var13[var6 * 13 + 1];
            var9 = (short)var13[var6 * 13 + 2];
            short var10 = (short)var13[var6 * 13 + 3];
            var15[var6] = new Polygon4V(var11[var7], var11[var8], var11[var9], var11[var10], (byte)var13[var6 * 13 + 4], (byte)var13[var6 * 13 + 5], (byte)var13[var6 * 13 + 6], (byte)var13[var6 * 13 + 7], (byte)var13[var6 * 13 + 8], (byte)var13[var6 * 13 + 9], (byte)var13[var6 * 13 + 10], (byte)var13[var6 * 13 + 11]);
            var15[var6].tex = (byte)var13[var6 * 13 + 12];
        }
        Polygon4V[] var12 = var15;
        RenderObject[] var14 = new RenderObject[var16.length + var15.length];
        var5 = 0;
        var6 = 0;
        while (var6 < var2.length) {
            var14[var5] = var2[var6];
            ++var6;
            ++var5;
        }
        var6 = 0;
        while (var6 < var12.length) {
            var14[var5] = var12[var6];
            ++var6;
            ++var5;
        }
        Mesh var17 = new Mesh(var1, var14, this.texture);
        return var17;
    }

    public MeshClone() {
    }

    public static int getNumRecords(String recordStoreName) {
        try {
            RecordStore var3 = RecordStore.openRecordStore((String)recordStoreName, (boolean)false);
            int var1 = var3.getNumRecords();
            var3.closeRecordStore();
            return var1;
        }
        catch (RecordStoreException var2) {
            if (var2.getMessage() != null) {
                System.out.println(var2.getMessage());
            }
            return 0;
        }
    }

    public static boolean isNum(String recordStoreName) {
        try {
            RecordStore var3 = RecordStore.openRecordStore((String)recordStoreName, (boolean)false);
            int var1 = var3.getNumRecords();
            var3.closeRecordStore();
            return true;
        }
        catch (RecordStoreException var2) {
            if (var2.getMessage() != null) {
                System.out.println(var2.getMessage());
            }
            return false;
        }
    }

    public static byte[] getRecord(String recordStoreName, int recordId) {
        try {
            RecordStore var14 = RecordStore.openRecordStore((String)recordStoreName, (boolean)false);
            byte[] var2 = var14.getRecord(1);
            var14.closeRecordStore();
            return var2;
        }
        catch (Exception var12) {
            if (var12.getMessage() != null) {
                System.out.println(var12.getMessage());
            }
            return null;
        }
    }
}

