/*
 * Decompiled with CFR 0.152.
 */
package com.Rendering;

import com.Gameplay.Map.LightMapper;
import com.Math.MathUtils;
import com.Rendering.Graphics3D;
import com.Rendering.Texture;
import com.Rendering.Vertex;

public abstract class RenderObject {
    public int sz;
    public short nx;
    public short ny;
    public short nz;
    public static final int normal_fp = 12;

    public RenderObject() {
        this.nz = 0;
        this.ny = 0;
        this.nx = 0;
    }

    public RenderObject(Vertex ver1, Vertex ver2, Vertex ver3) {
        long x = (long)(ver1.y - ver2.y) * (long)(ver1.z - ver3.z) - (long)(ver1.z - ver2.z) * (long)(ver1.y - ver3.y);
        long y = (long)(ver1.z - ver2.z) * (long)(ver1.x - ver3.x) - (long)(ver1.x - ver2.x) * (long)(ver1.z - ver3.z);
        long z = (long)(ver1.x - ver2.x) * (long)(ver1.y - ver3.y) - (long)(ver1.y - ver2.y) * (long)(ver1.x - ver3.x);
        double sqrt = Math.sqrt(x * x + y * y + z * z) / 4096.0;
        this.nx = (short)((double)x / sqrt);
        this.ny = (short)((double)y / sqrt);
        this.nz = (short)((double)z / sqrt);
    }

    public void calculateNormals(Vertex ver1, Vertex ver2, Vertex ver3) {
        long x = (long)(ver1.y - ver2.y) * (long)(ver1.z - ver3.z) - (long)(ver1.z - ver2.z) * (long)(ver1.y - ver3.y);
        long y = (long)(ver1.z - ver2.z) * (long)(ver1.x - ver3.x) - (long)(ver1.x - ver2.x) * (long)(ver1.z - ver3.z);
        long z = (long)(ver1.x - ver2.x) * (long)(ver1.y - ver3.y) - (long)(ver1.y - ver2.y) * (long)(ver1.x - ver3.x);
        double sqrt = Math.sqrt(x * x + y * y + z * z) / 4096.0;
        this.nx = (short)((double)x / sqrt);
        this.ny = (short)((double)y / sqrt);
        this.nz = (short)((double)z / sqrt);
    }

    public abstract void render(Graphics3D var1, Texture var2);

    public abstract void renderFast(Graphics3D var1, Texture var2);

    public abstract boolean isVisible(int var1, int var2, int var3, int var4);

    public int getLight(Vertex a, int la, Graphics3D g3d) {
        int la2;
        int lita = -a.rz < Graphics3D.fDist || Graphics3D.fDist <= 1 ? 255 : 0;
        int fa = 0;
        int vec = 255;
        if (Graphics3D.fDist > 1 && LightMapper.cameraVectorLight || g3d.shootIntensity > 0) {
            vec = MathUtils.calcLight(this.nx, this.ny, this.nz, a.x - g3d.getCamera().m03, a.y - g3d.getCamera().m13, a.z - g3d.getCamera().m23);
        }
        if (Graphics3D.fDist > 1 && -a.rz < Graphics3D.fDist) {
            lita = 255 + a.rz * 255 / Graphics3D.fDist;
            if (LightMapper.cameraVectorLight) {
                lita = lita * vec / 255;
            }
            if (lita > 255) {
                lita = 255;
            }
            if (lita < 0) {
                lita = 0;
            }
        }
        if (g3d.shootIntensity > 0 && -a.rz < 5000) {
            fa = 255 + a.rz * 255 / 5000;
            if ((fa = fa * g3d.shootIntensity * vec / 255 / g3d.shootLength) > 255) {
                fa = 255;
            }
            if (fa < 0) {
                fa = 0;
            }
        }
        if ((la2 = (la + 128) * lita / 255 + fa) > 255) {
            return 255;
        }
        return la2;
    }
}

